const handleBrandsElement = function (params) {
    if (typeof window.Swiper != undefined) {
        let options = {
            slidesPerView: params.mobilePerView || 1,
            spaceBetween: 0,
            rtl: jQuery('body').hasClass('rtl'),
            breakpoints: {
                640: {
                    slidesPerView: params.mobilePerView || 1,
                },
                768: {
                    slidesPerView: params.tabletPerView || 3,
                },
                1024: {
                    slidesPerView: params.desktopPerView || 4,
                },
            },
        };

        if (params.pagination) {
            options.pagination = {
                el: '.swiper-pagination',
                clickable: true,
            };
        }

        if(params.observer === true){
            options.observer = true;
            options.observeParents = true;
        }

        let swiper = new Swiper(params.container, options);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/ahura_brands.default', function($scope, $) {
        let wrap = $scope.find('.ahura-brands-wrap'),
            params = wrap.data('settings');

        params.container = wrap.find('.brands-list-swiper');

        handleBrandsElement(params);
    });
});
