jQuery(document).ready(function($) {
    let containers = $('body').find('.ahura-image-before-after .cd-image-container');

    containers.each(function() {
        let actual = $(this);
        let dragElement = actual.find('.cd-handle');
        let resizeElement = actual.find('.cd-resize-img');
        let $scrollState = actual.closest('.ahura-image-before-after').data('scroll');
        
        if (typeof $scrollState !== 'undefined' && $scrollState) {
            scrollControl(dragElement, resizeElement, actual);
        } else {
            drags(dragElement, resizeElement, actual);
        }
    });
});

function drags(dragElement, resizeElement, container) {
    dragElement.on("mousedown vmousedown touchstart", function(e) {
        dragElement.addClass('draggable');
        resizeElement.addClass('resizable');

        let dragWidth = dragElement.outerWidth(),
            containerOffset = container.offset().left,
            containerWidth = container.outerWidth(),
            minLeft = containerOffset + 10,
            maxLeft = containerOffset + containerWidth - dragWidth - 10;

        let xPosition = (e.pageX || e.originalEvent.touches[0].pageX) + dragWidth - dragElement.offset().left;

        dragElement.parents().on("mousemove vmousemove touchmove", function(e) {
            let pageX = e.pageX || e.originalEvent.touches[0].pageX;
            let leftValue = pageX + xPosition - dragWidth;

            if (leftValue < minLeft) {
                leftValue = minLeft;
            } else if (leftValue > maxLeft) {
                leftValue = maxLeft;
            }

            let widthValue = (leftValue + dragWidth / 2 - containerOffset) * 100 / containerWidth + '%';

            jQuery('.draggable').css('left', widthValue).on("mouseup vmouseup touchend", function() {
                jQuery(this).removeClass('draggable');
                resizeElement.removeClass('resizable');
            });

            jQuery('.resizable').css('width', widthValue);
        }).on("mouseup vmouseup touchend", function(e) {
            dragElement.removeClass('draggable');
            resizeElement.removeClass('resizable');
        });

        e.preventDefault();
    }).on("mouseup vmouseup touchend", function(e) {
        dragElement.removeClass('draggable');
        resizeElement.removeClass('resizable');
    });
}

function scrollControl(dragElement, resizeElement, container) {
    let containerWidth = container.outerWidth();

    let initialLeftPixels = dragElement.position().left;
    let currentLeftPercentage = (initialLeftPixels / containerWidth) * 100;

    container.on('wheel', function(event) {
        event.preventDefault();

        let delta = event.originalEvent.deltaY > 0 ? 1 : -1;
        let sensitivity = 1;
        currentLeftPercentage += delta * sensitivity;

        if (currentLeftPercentage < 0) {
            currentLeftPercentage = 0;
        } else if (currentLeftPercentage > 100) {
            currentLeftPercentage = 100;
        }
        
        let widthValue = currentLeftPercentage + '%';

        dragElement.css('left', widthValue);
        resizeElement.css('width', widthValue);
    });
}
