const ahuraCountdown = function (params) {
    let second = 1000,
        minute = second * 60,
        hour = minute * 60,
        day = hour * 24,
        time, timer, wrap, target, targets, TargetDate;
    wrap = params.wrap;
    target = params.container || wrap.find('.countdown-tpl');
    time = params.time;
    targets = ['second', 'minute', 'hour', 'day'];

    if (time) {
        jQuery.each(targets, function (key, value) {
            target.append(
                jQuery('<div/>', {'class': 'time-down ' + value}).append(
                    jQuery('<div/>', {'class': 'num'}),
                    jQuery('<div/>', {'class': 'text', text: params.labels[value]}),
                ),
            );
        });

        TargetDate = Date.parse(time);
        timer = setInterval(function () {
            let now = Date.parse(new Date()),
                distance = TargetDate - now;
            target.find('.day .num').text(Math.floor(distance / (day)));
            target.find('.hour .num').text(Math.floor((distance % (day)) / (hour)));
            target.find('.minute .num').text(Math.floor((distance % (hour)) / (minute)));
            target.find('.second .num').text(Math.floor((distance % (minute)) / second));
            if (distance < 0) {
                clearInterval(timer);
                wrap.find('.buttons').remove();
                target.find('.time-down').remove();
                target.parent().find('.end-content').show();
            }
        }, second);
    }

    setTimeout(function () {
        wrap.find('.counter, .divider-wrap, .content').slideDown();
    }, 300);
}