<?php
require_once get_parent_theme_file_path('/app/mw_options.php');

// Woocommerce checkout extra settings
function ahura_override_checkout_fields( $fields ) {

    get_theme_mod( 'ahura_checkout_name_label' ) ? $fields[ 'billing' ][ 'billing_first_name'][ 'label' ] = get_theme_mod( 'ahura_checkout_name_label' ) : '';
    get_theme_mod( 'ahura_checkout_lastname_label' ) ? $fields[ 'billing' ][ 'billing_last_name'][ 'label' ] = get_theme_mod( 'ahura_checkout_lastname_label' ) : '';
    get_theme_mod( 'ahura_checkout_company_label' ) ? $fields[ 'billing' ][ 'billing_company'][ 'label' ] = get_theme_mod( 'ahura_checkout_company_label' ) : '';
    get_theme_mod( 'ahura_checkout_country_label' ) ? $fields[ 'billing' ][ 'billing_country'][ 'label' ] = get_theme_mod( 'ahura_checkout_country_label' ) : '';
    get_theme_mod( 'ahura_checkout_phone_label' ) ? $fields[ 'billing' ][ 'billing_phone'][ 'label' ] = get_theme_mod( 'ahura_checkout_phone_label' ) : '';
    get_theme_mod( 'ahura_checkout_email_label' ) ? $fields[ 'billing' ][ 'billing_email'][ 'label' ] = get_theme_mod( 'ahura_checkout_email_label' ) : '';
    get_theme_mod( 'ahura_checkout_comments_label' ) ? $fields['order']['order_comments']['label'] = get_theme_mod( 'ahura_checkout_comments_label' ) : '';

    switch ( get_theme_mod( 'woocommerce_checkout_billing_email' ) ) {
        case "hidden":
            unset( $fields[ 'billing' ][ 'billing_email' ] );
            break;
        case "optional":
            $fields[ 'billing' ][ 'billing_email'][ 'required' ] = false;
            break;
        case "required":
            $fields[ 'billing' ][ 'billing_email'][ 'required' ] = true;
            break;
    }

    switch ( get_theme_mod( 'woocommerce_checkout_order_comments' ) ) {
        case "hidden":
            unset( $fields[ 'order' ][ 'order_comments' ] );
            break;
        case "optional":
            $fields[ 'order' ][ 'order_comments' ][ 'required' ] = false;
            break;
        case "required":
            $fields[ 'order' ][ 'order_comments' ][ 'required' ] = true;
            break;
    }

	return $fields;
}
add_filter( 'woocommerce_checkout_fields', 'ahura_override_checkout_fields' );


function ahura_override_address_checkout_fields( $fields ) {
    
    get_theme_mod( 'ahura_checkout_address_label' ) ? $fields[ 'address_1' ][ 'label' ] = get_theme_mod( 'ahura_checkout_address_label' ) : '';
    get_theme_mod( 'ahura_checkout_city_label' ) ? $fields[ 'city' ][ 'label' ] = get_theme_mod( 'ahura_checkout_city_label' ) : '';
    get_theme_mod( 'ahura_checkout_state_label' ) ? $fields[ 'state' ][ 'label' ] = get_theme_mod( 'ahura_checkout_state_label' ) : '';
    get_theme_mod( 'ahura_checkout_postcode_label' ) ? $fields[ 'postcode' ][ 'label' ] = get_theme_mod( 'ahura_checkout_postcode_label' ) : '';

    switch ( get_theme_mod( 'woocommerce_checkout_country_field' ) ) {
        case "hidden":
            unset( $fields[ 'country' ] );
            break;
        case "optional":
            $fields[ 'country' ][ 'required' ] = false;
            break;
        case "required":
            $fields[ 'country' ][ 'required' ] = true;
            break;
    }
    switch ( get_theme_mod( 'woocommerce_checkout_billing_address_1' ) ) {
        case "hidden":
            unset( $fields[ 'address_1' ] );
            break;
        case "optional":
            $fields[ 'address_1' ][ 'required' ] = false;
            break;
        case "required":
            $fields[ 'address_1' ][ 'required' ] = true;
            break;
    }
    switch ( get_theme_mod( 'woocommerce_checkout_billing_city' ) ) {
        case "hidden":
            unset( $fields[ 'city' ] );
            break;
        case "optional":
            $fields[ 'city' ][ 'required' ] = false;
            break;
        case "required":
            $fields[ 'city' ][ 'required' ] = true;
            break;
    }
    switch ( get_theme_mod( 'woocommerce_checkout_billing_state' ) ) {
        case "hidden":
            unset( $fields[ 'state' ] );
            break;
        case "optional":
            $fields[ 'state' ][ 'required' ] = false;
            break;
        case "required":
            $fields[ 'state' ][ 'required' ] = true;
            break;
    }
    switch (get_theme_mod('woocommerce_checkout_billing_postcode')) {
        case "hidden":
            unset( $fields[ 'postcode' ] );
            break;
        case "optional":
            $fields[ 'postcode' ][ 'required' ] = false;
            break;
        case "required":
            $fields[ 'postcode' ][ 'required' ] = true;
            break;
    }

    return $fields;
}
add_filter( 'woocommerce_default_address_fields', 'ahura_override_address_checkout_fields', 1000, 1 );


function ahura_change_state_postcode_labels($locale){
    get_theme_mod( 'ahura_checkout_state_label' ) ? $locale[ 'US' ][ 'state' ][ 'label' ] = get_theme_mod( 'ahura_checkout_state_label' ) : '';
    get_theme_mod( 'ahura_checkout_state_label' ) ? $locale[ 'IR' ][ 'state' ][ 'label' ] = get_theme_mod( 'ahura_checkout_state_label' ) : '';
    get_theme_mod( 'ahura_checkout_postcode_label' ) ? $locale[ 'US' ][ 'postcode' ][ 'label' ] = get_theme_mod( 'ahura_checkout_postcode_label' ) : '';
    get_theme_mod( 'ahura_checkout_postcode_label' ) ? $locale[ 'IR' ][ 'postcode' ][ 'label' ] = get_theme_mod( 'ahura_checkout_postcode_label' ) : '';
    return $locale;
}
add_filter('woocommerce_get_country_locale', 'ahura_change_state_postcode_labels');


function ahura_get_product_rating_count($rate, $product){
    if (!is_object($product)) return false;

    $rating_counts = $product->get_rating_counts();

    return is_array($rating_counts) && isset($rating_counts[$rate]) ? $rating_counts[$rate] : 0;
}

function ahura_get_product_rating_counts($product){
    $counts = array_map(
        function ($rating) use ($product) {
            return ahura_get_product_rating_count($rating, $product);
        },
        [1, 2, 3, 4, 5]
    );
    return [1 => $counts[0] ,2 => $counts[0],3 => $counts[2],4 => $counts[3],5 => $counts[4]];
}

function ahura_get_product_rating_percentage($product){
    $rating_counts = ahura_get_product_rating_counts($product);
    $counts = array_map(
        function ($count) use ($product) {return $count ? ($count / $product->get_review_count()) * 100 : 0;},
        [$rating_counts[1], $rating_counts[2], $rating_counts[3], $rating_counts[4], $rating_counts[5]]
    );
    return [1 => $counts[0] ,2 => $counts[1],3 => $counts[2],4 => $counts[3],5 => $counts[4]];
}

function ahura_myaccount_remove_tabs( $tabs ) {
    if( get_theme_mod( 'ahura_myaccount_remove_orders_tab' ) ) unset( $tabs[ 'orders' ] );
    if( get_theme_mod( 'ahura_myaccount_remove_download_tab' ) ) unset( $tabs[ 'downloads' ] );
    if( get_theme_mod( 'ahura_myaccount_remove_address_tab' ) ) unset( $tabs[ 'edit-address' ] );
    if( get_theme_mod( 'ahura_myaccount_remove_account_tab' ) ) unset( $tabs[ 'edit-account' ] );
    if( get_theme_mod( 'ahura_myaccount_remove_logout_tab' ) ) unset( $tabs[ 'customer-logout' ] );
    return $tabs;
}
add_filter( 'woocommerce_account_menu_items', 'ahura_myaccount_remove_tabs' );

function ahura_custom_dashboard_content() {
    if( empty( get_theme_mod( 'ahura_myaccount_dashboard_extra_text' ) ) ) return;
    echo get_theme_mod( 'ahura_myaccount_dashboard_extra_text' );
}
add_action( 'woocommerce_account_dashboard', 'ahura_custom_dashboard_content' );



function ah_save_downloaded_product_count($email, $order_key, $product_id, $user_id, $download_id, $order_id) {
    $downloaded_product_count = get_post_meta($product_id, 'ah_downloaded_product_count', true);
    if (!$downloaded_product_count) $downloaded_product_count = 0;
    $downloaded_product_count = intval($downloaded_product_count);
    $downloaded_product_count++;
    get_post_meta($product_id, 'ah_downloaded_product_count', true) ? update_post_meta($product_id, 'ah_downloaded_product_count', $downloaded_product_count) : add_post_meta($product_id, 'ah_downloaded_product_count', $downloaded_product_count);
}

add_action('woocommerce_download_product', 'ah_save_downloaded_product_count', 10, 6);



function ah_save_initial_stock_for_all_products() {
    if (!class_exists('WooCommerce')) {
        return;
    }

    $save_initial_stock = get_theme_mod('ahura_shop_save_product_initial_stock', false);
    if (!$save_initial_stock) {
        return;
    }

    $products_query = new WP_Query(['post_type' => 'product', 'posts_per_page' => -1, 'post_status' => 'publish']);

    if ($products_query->have_posts()) {
        while ($products_query->have_posts()) {
            $products_query->the_post();
            $product_id = get_the_ID();
            $product = wc_get_product($product_id);

            if (!$product) continue;

            $initial_stock = get_post_meta($product_id, 'ah_initial_product_stock_quantity', true);

            if ($initial_stock === '') {
                update_post_meta($product_id, 'ah_initial_product_stock_quantity', $product->get_stock_quantity());
            }
        }
        wp_reset_postdata();
    }
}
add_action('init', 'ah_save_initial_stock_for_all_products');



function ah_remove_initial_stock_for_all_products() {
    if (!class_exists('WooCommerce')) {
        return;
    }

    $save_initial_stock = get_theme_mod('ahura_shop_save_product_initial_stock', false);
    $meta_key_exists = get_post_meta(0, 'ah_initial_product_stock_quantity', true);

    if ($save_initial_stock || $meta_key_exists) {
        return;
    }

    $products_query = new WP_Query(['post_type' => 'product', 'posts_per_page' => -1, 'post_status' => 'publish']);

    if ($products_query->have_posts()) {
        while ($products_query->have_posts()) {
            $products_query->the_post();
            $product_id = get_the_ID();
            delete_post_meta($product_id, 'ah_initial_product_stock_quantity');
        }
        wp_reset_postdata();
        update_post_meta(0, 'ah_initial_product_stock_quantity', true);
    }
}
add_action('init', 'ah_remove_initial_stock_for_all_products');


function ah_update_sales_tracking($order_id) {
    $order = wc_get_order($order_id);
    $save_initial_stock = get_theme_mod('ahura_shop_save_product_initial_stock', false);

    if (!$order || !$save_initial_stock) {
        return;
    }

    foreach ($order->get_items() as $item_id => $item) {
        $product_id = $item->get_product_id();
        $quantity = $item->get_quantity();

        $current_sales = get_post_meta($product_id, 'ah_product_sales', true);
        $current_sales = $current_sales ? $current_sales : 0;
        update_post_meta($product_id, 'ah_product_sales', $current_sales + $quantity);
    }
}
add_action('woocommerce_payment_complete', 'ah_update_sales_tracking');
add_action('woocommerce_order_status_changed', 'ah_update_sales_tracking');



function ah_remove_sales_tracking() {
    if (!class_exists('WooCommerce')) {
        return;
    }
    
    $products_query = new WP_Query(['post_type' => 'product', 'posts_per_page' => -1, 'post_status' => 'publish']);

    $save_initial_stock = get_theme_mod('ahura_shop_save_product_initial_stock', false);
    $meta_key_exists = get_post_meta(0, 'ah_product_sales', true);

    if ($save_initial_stock || $meta_key_exists) {
        return;
    }

    if ($products_query->have_posts()) {
        while ($products_query->have_posts()) {
            $products_query->the_post();
            $product_id = get_the_ID();
            delete_post_meta($product_id, 'ah_product_sales');
        }
        wp_reset_postdata();
        update_post_meta(0, 'ah_product_sales', true);
    }
}
add_action('init', 'ah_remove_sales_tracking');


if(class_exists('WooCommerce') && \ahura\app\mw_options::get_product_item_style() == 3) {
    function remove_default_shop_page_ah_woocommerce_hooks() {
        remove_action('woocommerce_before_shop_loop', 'woocommerce_result_count', 20);
        remove_action('woocommerce_after_shop_loop', 'woocommerce_pagination', 10);
    }
    add_action('init', 'remove_default_shop_page_ah_woocommerce_hooks');

    function add_custom_wrapper_pagination_and_result_count() {
        add_action('woocommerce_after_shop_loop', 'ah_shop_style3_wrapper_start', 5);
        add_action('woocommerce_after_shop_loop', 'woocommerce_result_count', 10);
        add_action('woocommerce_after_shop_loop', 'woocommerce_pagination', 15);
        add_action('woocommerce_after_shop_loop', 'ah_shop_style3_wrapper_end', 20);
    }
    add_action('init', 'add_custom_wrapper_pagination_and_result_count');

    function ah_shop_style3_wrapper_start() {
        echo '<div class="shop-style3-loop-wrapper">';
    }

    function ah_shop_style3_wrapper_end() {
        echo '</div>';
    }

    function ah_check_term_description_notempty() {
        if (is_product_category() || is_product_tag()) {
            $term = get_queried_object();
            if (!empty($term->description)) {
                add_filter('woocommerce_show_page_title', '__return_false');
            }
        }
    }
    add_action('wp', 'ah_check_term_description_notempty');
}

function ahura_wc_render_template($path, $params = [])
{
    wc_get_template($path, $params);
}

function ahura_wc_exists_template($path)
{
    return file_exists(get_template_directory() . '/woocommerce/' . $path);
}

function ahura_wc_render_cart_steps($params = [])
{
    ahura_wc_render_template('layouts/cart-steps.php', $params);
}

function ahura_before_shop_loop_counter() {
    
    global $product;

    if ($product->is_on_sale() && $product->get_date_on_sale_to() && \ahura\app\mw_options::get_mod_is_active_archive_sale_countdown_counter()) : ?>
        <div class="woocommerce-archive-shop-sale-countdown" data-sale-end="<?php echo esc_attr($product->get_date_on_sale_to()->getTimestamp()); ?>">
            <span class="countdown-timer">00:00:00:00</span>
        </div>
    <?php endif;

}
if(\ahura\app\mw_options::get_product_item_style() == 4) {
    add_action('woocommerce_after_shop_loop_item', 'ahura_before_shop_loop_counter');
} else {
    add_action('woocommerce_before_shop_loop_item', 'ahura_before_shop_loop_counter');
}

if(\ahura\app\mw_options::get_product_item_style() == 4) {
    if (!function_exists( 'woocommerce_template_loop_product_link_open')) {

        function woocommerce_template_loop_product_link_open() {
            global $product;

            $link = apply_filters('woocommerce_loop_product_link', get_the_permalink(), $product );

            echo '<div class="woocommerce-LoopProduct-link woocommerce-loop-product__link">';
        }
    }

    if (!function_exists('woocommerce_template_loop_product_link_close')) {
        function woocommerce_template_loop_product_link_close() {
            echo '</div>';
        }
    }

    if ( ! function_exists( 'woocommerce_template_loop_product_title' ) ) {
        function woocommerce_template_loop_product_title() {
            echo '<a href="' . get_the_permalink() . '" class="woocommerce-loop-product__title">' . get_the_title() . '</a>';
        }
    }
}

if(\ahura\app\mw_options::get_mod_disable_wctabs_inner_title()) {
    add_filter( 'woocommerce_product_description_heading', '__return_null' );
    add_filter( 'woocommerce_product_additional_information_heading', '__return_null' );
    add_filter( 'woocommerce_reviews_title', '__return_null' );
}

function ahura_get_applicable_coupons_for_product($product_id) {

    $applicable_coupons = [];
    $product = wc_get_product($product_id);

    if (!$product) return false;

    $args = [
        'post_type'      => 'shop_coupon',
        'post_status'    => 'publish',
        'posts_per_page' => -1
    ];

    $coupons_query = new WP_Query($args);

    if ($coupons_query->have_posts()) {
        while ($coupons_query->have_posts()) {
            $coupons_query->the_post();

            $coupon = new WC_Coupon(get_the_title() );

            if ($coupon->is_valid()) {
                if ($coupon->is_valid_for_product($product, '')) {
                    $applicable_coupons[] = $coupon->get_code();
                }
            }
        }
        wp_reset_postdata();
    }

    return !empty($applicable_coupons) ? $applicable_coupons : false;    
}