<?php
namespace ahura\inc\widgets;

// Block direct access to the main theme file.
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\mw_assets;

class video_carousel4 extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('video_carousel4_js', mw_assets::get_js('elementor.video_carousel4'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('video_carousel4_css', mw_assets::get_css('elementor.video_carousel4'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('video_carousel4_js')];
    }

    public function get_name()
    {
        return 'video_carousel4';
    }

    public function get_title()
    {
        return esc_html__('Video Carousel 4', 'ahura');
    }

    public function get_icon()
    {
        return 'aicon-svg-video-carousel-2';
    }

    public function get_categories()
    {
        return ['ahuraelements'];
    }

    public function get_keywords()
    {
        return ['ahura', 'video', 'video carousel 4', esc_html__('ahura', 'ahura'), esc_html__('Video Carousel 4', 'ahura')];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'content_settings',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'cover',
            [
                'label' => esc_html__( 'Choose Image', 'ahura' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'show_btn',
            [
                'label' => esc_html__('Button', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater->add_control(
            'btn_text',
            [
                'label' => esc_html__( 'Button Text', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Watch Tutorial', 'ahura' ),
                'condition' => ['show_btn' => 'yes']
            ]
        );

        $repeater->add_control(
            'btn_icon',
            [
                'label' => esc_html__( 'Button Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'default' => [
                    'value' => 'fas fa-play',
                    'library' => 'fa-solid',
                ],
                'condition' => ['show_btn' => 'yes']
            ]
        );

        $repeater->add_control(
            'btn_link',
            [
                'label' => esc_html__( 'Button link', 'ahura'),
                'type' => Controls_Manager::URL,
                'show_external' => true,
                'dynamic' => ['active' => true],
                'default' => [
                    'url' => '#',
                ],
                'condition' => ['show_btn' => 'yes']
            ]
        );

        $repeater->add_control(
            'show_tags',
            [
                'label' => esc_html__('Show Tags', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater->add_control(
            'tags_popover_toggle',
            [
                'label' => esc_html__( 'Tags', 'ahura' ),
                'type' => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label_off' => esc_html__( 'Show', 'ahura' ),
                'label_on' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['show_tags' => 'yes']
            ]
        );

        $repeater->start_popover();

        $repeater->add_control(
            'tag1_title',
            [
                'label' => esc_html__( 'Title Tag 1', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Marketing', 'ahura' ),
            ]
        );

        $repeater->add_control(
            'tag1_icon',
            [
                'label' => esc_html__( 'Icon Tag 1', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $repeater->add_control(
            'tag2_title',
            [
                'label' => esc_html__( 'Title Tag 2', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Seo', 'ahura' ),
            ]
        );

        $repeater->add_control(
            'tag2_icon',
            [
                'label' => esc_html__( 'Icon Tag 2', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $repeater->end_popover();

        $this->add_control(
            'items',
            [
                'label' => esc_html__( 'Items', 'ahura' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    ['cover' => ['url' => \Elementor\Utils::get_placeholder_image_src()]],
                    ['cover' => ['url' => \Elementor\Utils::get_placeholder_image_src()]],
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'item_settings',
            [
                'label' => esc_html__('Settings', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides per view', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'step' => 1,
                'min' => 1,
                'max' => 10,
                'default' => 2,
                'tablet_default' => 2,
                'mobile_default' => 1,
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'transition_duration',
            [
                'label' => esc_html__('Transition Duration', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 4000,
                'condition' => [
                    'autoplay' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label' => esc_html__('Infinite Loop', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();
        /**
         *
         *
         *
         * Styles
         *
         *
         *
         */

        $this->start_controls_section(
            'item_styles',
            [
                'label' => esc_html__('Item', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'img_height',
            [
                'label' => esc_html__('Cover Height', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'default' => [
                    'size' => 520,
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'size' => 340,
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'size' => 330,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .item-bg' => 'height: {{SIZE}}{{UNIT}}',
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'tags_styles',
            [
                'label' => esc_html__('Tags', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'tag_icon_color',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .v-tags .v-tag i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .v-tags .v-tag :is(svg, svg path)' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'tag_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .v-tags .v-tag' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Tag Typography', 'ahura'),
                'name' => 'tag_typo',
                'selector' => '{{WRAPPER}} .v-tags .v-tag',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17',
                        ]
                    ]
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'tag_bg',
                'selector' => '{{WRAPPER}} .v-tags .v-tag',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#fff']
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tag_border',
                'selector' => '{{WRAPPER}} .v-tags .v-tag',
            ]
        );

        $this->add_responsive_control(
            'tag_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .v-tags .v-tag' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'button_styles',
            [
                'label' => esc_html__('Button', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->start_controls_tabs('btn_style_tabs');
        $this->start_controls_tab('btn_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_control(
            'btn_icon_color',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .item-btn i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .item-btn :is(svg, svg path)' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .item-btn' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Button Typography', 'ahura'),
                'name' => 'btn_typo',
                'selector' => '{{WRAPPER}} .item-btn',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17',
                        ]
                    ]
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg',
                'selector' => '{{WRAPPER}} .item-btn',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#00FF7F']
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'selector' => '{{WRAPPER}} .item-btn',
            ]
        );

        $this->add_responsive_control(
            'btn_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .item-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('btn_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_control(
            'btn_icon_color_hover',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-btn:hover i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .item-btn:hover :is(svg, svg path)' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'btn_color_hover',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_hover',
                'selector' => '{{WRAPPER}} .item-btn:hover',
                'exclude' => ['image'],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border_hover',
                'selector' => '{{WRAPPER}} .item-btn:hover',
            ]
        );

        $this->add_responsive_control(
            'btn_border_radius_hover',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .item-btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    /**
     *
     * Render content for display
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();

        $slider_data = [
            'loop' => $settings['infinite_loop'] == 'yes',
            'autoPlay' => $settings['autoplay'] == 'yes',
            'transitionDuration' => (intval($settings['transition_duration'])) ? $settings['transition_duration'] : 4000,
            'slidesPerView' => (isset($settings['slides_per_view']) && intval($settings['slides_per_view'])) ? $settings['slides_per_view'] : 4,
            'tabletPerView' => (isset($settings['slides_per_view_tablet']) && intval($settings['slides_per_view_tablet'])) ? $settings['slides_per_view_tablet'] : 3,
            'mobilePerView' => (isset($settings['slides_per_view_mobile']) && intval($settings['slides_per_view_mobile'])) ? $settings['slides_per_view_mobile'] : 1,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];

        $items = $settings['items'];

        if (empty($items)){
            $this->renderElementorNotice(__('The element has no content.', 'ahura'));
            return false;
        }
        ?>
          <div class="video-carousel4-wrap">
              <div class="swiper carousel-wrap" data-slider='<?php echo json_encode($slider_data) ?>'>
                  <div class="swiper-wrapper">
                      <?php foreach ($items as $item): ?>
                          <div class="swiper-slide">
                              <div class="video-item">
                                  <?php if ($item['show_tags'] == 'yes'): ?>
                                      <div class="v-tags">
                                          <?php
                                          for($i = 1; $i <= 2; $i++):
                                              $tag_title = isset($item["tag{$i}_title"]) ? $item["tag{$i}_title"] : null;
                                              $tag_icon = isset($item["tag{$i}_icon"]) ? $item["tag{$i}_icon"] : null;
                                              if (empty($tag_title))
                                                  continue;
                                              ?>
                                            <span class="v-tag">
                                              <?php \Elementor\Icons_Manager::render_icon( $tag_icon, [ 'aria-hidden' => 'true' ] ); ?>
                                              <?php echo $tag_title ?>
                                            </span>
                                          <?php endfor; ?>
                                      </div>
                                  <?php endif; ?>
                                  <svg class="item-bg" width="659" height="519" viewBox="0 0 659 519" fill="none" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg">
                                      <mask id="cover-mask-<?php echo $wid; ?>" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="-1" width="659" height="520">
                                          <path d="M659 39.9998C659 17.9084 641.091 -0.000244141 619 -0.000244141L95.75 -0.000244141C78.4911 -0.000244141 64.5 13.9909 64.5 31.2498C64.5 48.5087 50.5089 62.4998 33.25 62.4998H32.5C14.8269 62.4998 0.500039 76.8266 0.500039 94.4998V411C0.500039 433.091 18.4087 451 40.5 451L219 451C237.778 451 253 466.222 253 485C253 503.777 268.222 519 287 519H619C641.091 519 659 501.091 659 479V39.9998Z" fill="#D6D6D6"/>
                                      </mask>
                                      <g mask="url(#cover-mask-<?php echo $wid; ?>)">
                                          <rect x="0.5" width="659" height="519" fill="url(#paint0_linear_224_37)" fill-opacity="0.1"/>
                                      </g>
                                      <defs>
                                          <linearGradient id="paint0_linear_224_37" x1="330" y1="0" x2="330" y2="519" gradientUnits="userSpaceOnUse">
                                              <stop/>
                                              <stop offset="1" stop-opacity="0"/>
                                          </linearGradient>
                                      </defs>
                                      <image xlink:href="<?php echo $item['cover']['url'] ?>" width="100%" height="100%" mask="url(#cover-mask-<?php echo $wid; ?>)" preserveAspectRatio="none"/>
                                  </svg>
                                  <?php
                                  if ($item['show_btn'] == 'yes'):
                                      if ( ! empty( $item['btn_link']['url'] ) ) {
                                          $this->add_link_attributes( 'btn_link_' . $item['_id'], $item['btn_link'] );
                                      }
                                      ?>
                                      <a <?php $this->print_render_attribute_string( 'btn_link_' . $item['_id'] ); ?> class="item-btn">
                                          <?php echo $item['btn_text'] ?>
                                          <?php \Elementor\Icons_Manager::render_icon( $item['btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                      </a>
                                  <?php endif; ?>
                              </div>
                          </div>
                      <?php endforeach; ?>
                  </div>
              </div>
          </div>
    <?php
    }
}
