<?php

namespace ahura\inc\widgets;

use Elementor\Controls_Manager;
use \ahura\app\mw_assets;

defined('ABSPATH') or die('no script kiddies please!');

class timeline_3 extends \ahura\app\elementor\Elementor_Widget_Base
{
    public function __register_assets()
    {
        $this->register_elementor_style('timeline3_css', mw_assets::get_css('elementor.timeline_3'));
    }

    public function get_icon()
    {
        return 'aicon-svg-timeline';
    }

    public function get_name()
    {
        return 'timeline3';
    }

    public function get_title()
    {
        return esc_html__('Timeline 3', 'ahura');
    }

    public function get_categories()
    {
        return ['ahuraelements'];
    }

    public function get_keywords()
    {
        return ['ahura', 'timeline', 'timeline 3', esc_html__('ahura', 'ahura'), esc_html__('Timeline 3', 'ahura')];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'timeline_title',
            [
                'label' => esc_html__('Title', 'ahura'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'timeline_text',
            [
                'label' => esc_html__('Text', 'ahura'),
                'type' => Controls_Manager::TEXTAREA,
                'rows' => 5
            ]
        );

        $repeater->add_control(
            'timeline_title2',
            [
                'label' => esc_html__('Title 2', 'ahura'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'timeline_title3',
            [
                'label' => esc_html__('Title 3', 'ahura'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'item_timeline_text_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-list {{CURRENT_ITEM}} .timeline-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_control(
            'item_timeline_text_bg_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-list {{CURRENT_ITEM}} .timeline-text' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_list',
            [
                'label' => esc_html__('Timeline List', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'timeline_title' => esc_html__('Intelligence Organization', 'ahura'),
                        'timeline_title2' => esc_html__('1998 until now', 'ahura'),
                        'timeline_title3' => esc_html__('Personal Activity', 'ahura'),
                        'timeline_text' => ahura_get_lorem_ipsum(),
                    ],
                    [
                        'timeline_title' => esc_html__('Intelligence Organization', 'ahura'),
                        'timeline_title2' => esc_html__('1998 until now', 'ahura'),
                        'timeline_title3' => esc_html__('Personal Activity', 'ahura'),
                        'timeline_text' => ahura_get_lorem_ipsum(),
                    ],
                    [
                        'timeline_title' => esc_html__('Intelligence Organization', 'ahura'),
                        'timeline_title2' => esc_html__('1998 until now', 'ahura'),
                        'timeline_title3' => esc_html__('Personal Activity', 'ahura'),
                        'timeline_text' => ahura_get_lorem_ipsum(),
                    ],
                ],
                'title_field' => '{{{timeline_title}}}',
            ]
        );

        $this->end_controls_section();

        /**
         *
         *
         *
         * Items style tab
         *
         *
         */
        $this->start_controls_section(
            'timeline_items_style',
            [
                'label' => esc_html__('Items', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->start_controls_tabs('timeline_items_style_tabs');

        $this->start_controls_tab(
            'timeline_items_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'ahura'),
            ]
        );

        $this->add_control(
            'timeline_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .timeline-list .timeline-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_title2_color',
            [
                'label' => esc_html__('Title 3 Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .timeline-list .timeline-title2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_title3_color',
            [
                'label' => esc_html__('Title 3 Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#7e7e7e',
                'selectors' => [
                    '{{WRAPPER}} .timeline-list .timeline-title3' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .timeline-list .timeline-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_text_bg_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-list .timeline-text' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_marker_bg_color',
            [
                'label' => esc_html__('Marker Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .timeline-list .timeline-marker:before' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'timeline_title_typo',
                'label' => esc_html__('Title Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .timeline-list .timeline-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15'
                        ]
                    ],
                    'font_weight' => [
                        'default' => 'bold'
                    ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'timeline_title2_typo',
                'label' => esc_html__('Title 2 Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .timeline-list .timeline-title2',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15'
                        ]
                    ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'timeline_title3_typo',
                'label' => esc_html__('Title 3 Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .timeline-list .timeline-title3',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '13'
                        ]
                    ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'timeline_text_typo',
                'label' => esc_html__('Content Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .timeline-list .timeline-text',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '300'
                    ],
                ]
            ]
        );

        $alignment = array(
            'right' => [
                'title' => esc_html__('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'left' => [
                'title' => esc_html__('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ]
        );

        $this->add_control(
            'timeline_text_align',
            [
                'label' => esc_html__('Text Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => (is_rtl()) ? $alignment : array_reverse($alignment),
                'default' => 'right',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .timeline-list .timeline-text' => 'text-align: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'timeline_item_content_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .timeline-list .timeline-text' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'timeline_item_content_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .timeline-list .timeline-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'timeline_item_content_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .timeline-list .timeline-text',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'timeline_items_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'ahura'),
            ]
        );

        $this->add_control(
            'timeline_text_color_hover',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-list .timeline-item:hover .timeline-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_text_bg_color_hover',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .timeline-list .timeline-item:hover .timeline-text' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'timeline_item_content_radius_hover',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .timeline-list .timeline-item:hover .timeline-text' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'timeline_item_content_shadow_hover',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .timeline-list .timeline-item:hover .timeline-text',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $items = $settings['timeline_list'];

        if ($items):
            ?>
            <div class="timeline3-wrap">
                <div class="timelines">
                    <ul class="timeline-list">
                        <?php foreach ($items as $item): ?>
                            <li class="timeline-item elementor-repeater-item-<?php echo $item['_id']; ?> clearfix">
                                <div class="timeline-info">
                                    <h4 class="timeline-title2"><?php echo $item['timeline_title2'] ?></h4>
                                    <span class="timeline-title3"><?php echo $item['timeline_title3'] ?></span>
                                </div>
                                <div class="timeline-marker"></div>
                                <div class="timeline-content">
                                    <h3 class="timeline-title"><?php echo $item['timeline_title'] ?></h3>
                                    <div class="timeline-text"><?php echo $item['timeline_text'] ?></div>
                                </div>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        <?php
        endif;
    }
}