<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use Elementor\Controls_Manager;
use ahura\app\mw_assets;

class text_highlighter extends \ahura\app\elementor\Elementor_Widget_Base {
    public function __register_assets()
    {
        $this->register_elementor_style('text_highlighter_css', mw_assets::get_css('elementor.text_highlighter'));
    }

    public function get_name() {
        return 'text_highlighter';
    }

    public function get_title() {
        return __( 'Text Highlighter', 'ahura' );
    }

    public function get_icon() {
        return 'aicon-svg-colorful-title';
    }

    public function get_categories() {
        return ['ahuraelements'];
    }
    function get_keywords()
    {
        return ['ahura', 'text', 'text highlighter', esc_html__('ahura', 'ahura'), esc_html__('Text highlighter', 'ahura')];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'ahura'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater =  new \Elementor\Repeater();

        $repeater->add_control(
            'item_text',
            [
                'label' => esc_html__('Text', 'ahura'),
                'type' => Controls_Manager::TEXTAREA,
            ]
        );

        $repeater->add_control(
            'item_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#212121',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.item-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_title_typography',
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}.item-title',
            ]
        );

        $repeater->add_control(
            'highlight',
            [
                'label' => esc_html__('Highlight', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater->add_control(
            'item_bg',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#f0f0f0',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}}.item-title' => 'background-color: {{VALUE}}',
                ],
                'condition' => ['highlight' => 'yes']
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    ['item_text' => esc_html__('Ahura', 'ahura'), 'highlight' => ['default' => 'no']],
                    ['item_text' => esc_html__('Power to change everything', 'ahura'),],
                ],
                'title_field' => '{{{item_text}}}',
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'settings_content_section',
            [
                'label' => __('Settings', 'ahura'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'text_html_tag',
            [
                'label' => esc_html__('Text Html Tag', 'ahura'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'div',
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'DIV',
                    'P' => 'P',
                ],
            ]
        );

        $this->end_controls_section();
        /**
         *
         *
         *  Styles
         *
         */
        $this->start_controls_section(
            'box_styles',
            [
                'label' => __('Box', 'ahura'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $alignment = [
            'left' => [
                'title' => __('Left', 'ahura'),
                'icon' => 'eicon-text-align-left'
            ],
            'center' => [
                'title' => __('Center', 'ahura'),
                'icon' => 'eicon-text-align-center'
            ],
            'right' => [
                'title' => __('Right', 'ahura'),
                'icon' => 'eicon-text-align-right'
            ]
        ];

        $this->add_responsive_control(
            'box_text_alignment',
            [
                'label' => esc_html__('Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $alignment : array_reverse($alignment),
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .hl-content' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'items_title_typography',
                'selector' => '{{WRAPPER}} .item-title',
                'fields_options' => [
                    'typography' => [
                        'default' => 'yes'
                    ],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '25'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '900'
                    ]
                ]
            ]
        );

        $this->end_controls_section();
    }
    protected function render() {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();

        $items = $settings['items'];
        $html_tag = $settings['text_html_tag'];
        $highlight_id = "text-highlighter-svg-{$wid}";

        if($items):
            ?>
            <div class="text-highlighter-element is-<?php echo is_rtl() ? 'rtl' : 'ltr' ?>">
                <div class="text-items">
                    <<?php echo $html_tag ?> class="hl-content">
                        <?php
                        foreach($items as $item):
                            $has_highlight = $item['highlight'] == 'yes';
                            $style = $has_highlight ? 'style="-webkit-filter:url(#'. $highlight_id .');filter:url(#'. $highlight_id .');"' : '';
                            ?>
                            <span class="item-title elementor-repeater-item-<?php echo $item['_id']; ?><?php echo $has_highlight ? ' with-highlight' : '' ?>" <?php echo $style ?>>
                                <?php echo $item['item_text']; ?>
                            </span>
                        <?php endforeach; ?>
                    </<?php echo $html_tag ?>>
                </div>
                <svg style="visibility:hidden;position:absolute;" width="0" height="0" xmlns="http://www.w3.org/2000/svg" version="1.1"> <defs> <filter id="<?php echo $highlight_id ?>"><feGaussianBlur in="SourceGraphic" stdDeviation="10" result="blur" /> <feColorMatrix in="blur" mode="matrix" values="1 0 0 0 0  0 1 0 0 0  0 0 1 0 0  0 0 0 19 -9" result="<?php echo $highlight_id ?>" /> <feComposite in="SourceGraphic" in2="<?php echo $highlight_id ?>" operator="atop"/> </filter> </defs> </svg>
            </div>
        <?php
        endif;
    }
}
