<?php
namespace ahura\inc\widgets;

// Die if is direct opened file
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\mw_assets;

class testimonial_carousel9 extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('testimonial_carousel9_js', mw_assets::get_js('elementor.testimonial_carousel9'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('testimonial_carousel9_css', mw_assets::get_css('elementor.testimonial_carousel9'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('testimonial_carousel9_js')];
    }

    /**
     *
     * Set element id
     *
     * @return string
     */
    public function get_name()
    {
        return 'testimonial_carousel9';
    }

    /**
     *
     * Set element widget
     *
     * @return mixed
     */
    public function get_title()
    {
        return esc_html__('Testimonial Carousel 9', 'ahura');
    }

    /**
     *
     * Set widget icon
     *
     */
    public function get_icon()
    {
        return 'eicon-testimonial-carousel';
    }

    /**
     *
     * Set element category
     *
     * @return string[]
     */
    public function get_categories()
    {
        return ['ahuraelements', 'ahuratestimonial'];
    }

    /**
     *
     * Keywords for search
     *
     * @return array
     */
    public function get_keywords()
    {
        return ['ahura', 'testimonial', 'testimonial carousel 9', esc_html__('ahura', 'ahura'), esc_html__('Testimonial Carousel 9', 'ahura')];
    }

    /**
     *
     * Element controls option
     *
     */
    public function register_controls()
    {
        /**
         *
         * Start content section
         *
         */
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'testimonial_bycat_byids',
            [
                'label' => esc_html__( 'Testimonial query by', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'byids',
                'options' => [
                    'byids' => esc_html__( 'By Ids', 'ahura' ),
                    'bycat' => esc_html__( 'By Category', 'ahura' ),
                ],
            ]
        );

        $testimonial_cats = get_categories(['taxonomy' => 'testimonial_cat', 'orderby' => 'name', 'order' => 'ASC']);

        $testimonial_cats_options = [];
        if ($testimonial_cats) {
            foreach ($testimonial_cats as $item) {
                $testimonial_cats_options[$item->term_id] = $item->cat_name;
            }
        }

        $this->add_control(
            'testimonial_bycat',
            [
                'label' => esc_html__( 'Select category', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $testimonial_cats_options,
                'condition' => [
                    'testimonial_bycat_byids' => 'bycat',
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $items = get_posts(['post_type' => 'testimonial', 'numberposts' => -1]);
        $options = [];
        if ($items) {
            foreach ($items as $item) {
                $options[$item->ID] = $item->post_title;
            }
        }

        $default = ($options && is_array($options)) ? key($options) : false;

        $repeater->add_control(
            'tst_id',
            [
                'type' => Controls_Manager::SELECT2,
                'label' => esc_html__('Select', 'ahura'),
                'label_block' => true,
                'options' => $options,
                'default' => $default
            ]
        );

        $repeater->add_control(
			'tst_rate',
			[
				'label' => esc_html__( 'User rate', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 5,
				'options' => [
					1 => esc_html__( '1', 'ahura' ),
					2  => esc_html__( '2', 'ahura' ),
					3 => esc_html__( '3', 'ahura' ),
					4 => esc_html__( '4', 'ahura' ),
					5 => esc_html__( '5', 'ahura' ),
				],
			]
		);

        $this->add_control(
            'testimonials',
            [
                'label' => esc_html__('Testimonial', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tst_id' => $default,
                        'tst_rate' => 5
                    ],
                ],
                'title_field' => '{{{tst_id}}}',
                'condition' => [
                    'testimonial_bycat_byids' => 'byids',
                ],
            ]
        );

		$this->add_control(
			'quote_icon',
			[
				'label' => esc_html__( 'Quote icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'general_styles',
            [
                'label' => esc_html__('General', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
			'avatars_width',
			[
				'label' => esc_html__( 'Avatars width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 400,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 144,
				],
				'selectors' => [
					'{{WRAPPER}} .item-avatar' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'avatars_margin',
			[
				'label' => esc_html__( 'Next/Prev avatars margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 100,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .item-avatar.item-avatar-next' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .item-avatar.item-avatar-prev' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'item_styles',
            [
                'label' => esc_html__('Item', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
			'item_avatar',
			[
				'label' => esc_html__( 'Avatar', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'avatar_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 400,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 224,
				],
				'selectors' => [
					'{{WRAPPER}} .item-avatar.item-avatar-current' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'avatar_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 400,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .item-avatar img' => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .item-avatar.item-avatar-current img' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'avatar_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 35,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .avatar-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'avatar_box_shadow',
			[
				'label' => esc_html__( 'Box Shadow', 'ahura' ),
				'type' => \Elementor\Controls_Manager::BOX_SHADOW,
                'fields_options' => [
                    'box_shadow_type' => ['default' => 'yes'],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical' => 70,
                            'blur' => 100,
                            'spread' => 0,
                            'color' => 'rgba(17, 12, 46, 0.15)'
                        ]
                    ]
                ],
				'selectors' => [
					'{{WRAPPER}} .item-avatar.item-avatar-current img' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
				],
			]
		);

        $this->add_control(
			'item_name',
			[
				'label' => esc_html__( 'Name', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_control(
			'name_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000000',
				'selectors' => [
					'{{WRAPPER}} .header-wrap .name' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'name_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '24'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '700',
                    ],
                ],
				'selector' => '{{WRAPPER}} .header-wrap .name',
			]
		);

        $this->add_control(
			'position_options',
			[
				'label' => esc_html__( 'Position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_control(
			'position_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-wrap .site-name' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'position_typography',
				'selector' => '{{WRAPPER}} .header-wrap .site-name',
			]
		);

        $this->add_responsive_control(
			'position_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 0,
					'bottom' => 20,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .header-wrap .site-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'rating_options',
			[
				'label' => esc_html__( 'Rating', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
        $this->add_control(
			'stars_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .user-rate svg path' => 'fill: {{VALUE}}',
				],
			]
		);
        
        $this->add_control(
			'stars_width',
			[
				'label' => esc_html__( 'Stars width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 25,
				],
				'selectors' => [
					'{{WRAPPER}} .header-wrap .user-rate > svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'stars_margin',
			[
				'label' => esc_html__( 'Stars margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 5,
					'bottom' => 0,
					'left' => 5,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .header-wrap .user-rate > svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'content_options',
			[
				'label' => esc_html__( 'Content', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'content_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#666666',
				'selectors' => [
					'{{WRAPPER}} .content-text' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '21'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '500',
                    ],
                    'line_height' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '40'
                        ]
                    ],
                ],
				'selector' => '{{WRAPPER}} .content-text',
			]
		);
        
        $this->add_control(
			'content_width',
			[
				'label' => esc_html__( 'Content width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 750,
				],
				'selectors' => [
					'{{WRAPPER}} .content-text' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'content_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 30,
					'right' => -60,
					'bottom' => 0,
					'left' => -60,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .content-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'marker_options',
			[
				'label' => esc_html__( 'Markers', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'marker_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-content > .quote-icon' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .item-content > svg path' => 'fill: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'first_marker_margin',
			[
				'label' => esc_html__( 'First marker margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 100,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .item-content > svg:first-child' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .item-content > .quote-icon:nth-child(1)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'second_marker_margin',
			[
				'label' => esc_html__( 'Second marker margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => -100,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .item-content > svg:last-child' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .item-content > .quote-icon:nth-child(3)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'custom_quote_size',
			[
				'label' => esc_html__( 'Custom quote width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .item-content > svg' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .item-content > .quote-icon' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_styles',
            [
                'label' => esc_html__('Slider', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
			'pagination_options',
			[
				'label' => esc_html__( 'Pagination', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'bullet_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#666666',
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'acive_bullet_color',
			[
				'label' => esc_html__( 'Active color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0166FF',
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'background-color: {{VALUE}}',
				],
			]
		);
        
        $this->add_control(
			'bullet_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'bullets_margin',
			[
				'label' => esc_html__( 'Bullets margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 3,
					'bottom' => 0,
					'left' => 3,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'active_bullet_radius',
			[
				'label' => esc_html__( 'Active bullet border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 50,
					'right' => 50,
					'bottom' => 50,
					'left' => 50,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'active_bullet_width',
			[
				'label' => esc_html__( 'Active bullet width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 40,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'bullets_container_margin',
			[
				'label' => esc_html__( 'Container margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 70,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->register_additional_controls();
    }

    /**
     *
     * Render element content (html)
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $items_byids = $settings['testimonials'];
        $rare_items_bycat = $settings['testimonial_bycat'];
        // $has_paginate = $settings['pagination'] == 'yes';
        $has_paginate = true;

        $items = null;
        $items_bycat = [];

        $posts_bycat = get_posts( [
            'posts_per_page'    => -1,
            'post_type'         => 'testimonial',
            'tax_query'         => [['taxonomy' => 'testimonial_cat', 'field' => 'term_id', 'terms' => $rare_items_bycat]]
        ]);

        if($items_byids) {
            $items = $items_byids;
        }

        if($rare_items_bycat){
            foreach($posts_bycat as $index => $post) {
                $items_bycat[$index]['tst_id'] = $post->ID;
                $items_bycat[$index]['show_rate'] = 'no';
                $items_bycat[$index]['rate'] = 5;
            }
            $items = $items_bycat;
        }

        $back_quote_svg = '<svg width="102" height="81" viewBox="0 0 102 81" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M41.4262 11.976V48.408C41.4262 55.5227 40.0769 61.4107 37.3782 66.072C32.2262 75.3947 23.1489 80.056 10.1462 80.056H6.83424L2.78625 79.32V66.44H3.52224C11.6182 66.44 15.6662 62.2693 15.6662 53.928V43.992H10.8822C4.25824 43.992 0.946239 40.5574 0.946239 33.688V11.976C0.946239 4.61601 4.25824 0.936004 10.8822 0.936004H31.4902C38.1142 0.936004 41.4262 4.61601 41.4262 11.976ZM68.2902 80.056C66.8182 80.056 64.9782 79.8107 62.7702 79.32V66.44H63.5062C71.3569 66.44 75.2822 62.2693 75.2822 53.928V43.992H70.8662C63.9969 43.992 60.5622 40.5574 60.5622 33.688V11.976C60.5622 4.61601 63.9969 0.936004 70.8662 0.936004H91.4742C97.8529 0.936004 101.042 4.61601 101.042 11.976V48.408C101.042 69.5067 90.1249 80.056 68.2902 80.056Z" fill="#F0F0F0"/>
                    </svg>';
        $star_svg = '<svg width="26" height="24" viewBox="0 0 26 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M20.3981 14.9002C20.0744 15.214 19.9256 15.6677 19.9994 16.1127L21.1106 22.2627C21.2044 22.784 20.9844 23.3115 20.5481 23.6127C20.1206 23.9252 19.5519 23.9627 19.0856 23.7127L13.5494 20.8252C13.3569 20.7227 13.1431 20.6677 12.9244 20.6615H12.5856C12.4681 20.679 12.3531 20.7165 12.2481 20.774L6.71061 23.6752C6.43686 23.8127 6.12686 23.8615 5.82311 23.8127C5.08311 23.6727 4.58936 22.9677 4.71061 22.224L5.82311 16.074C5.89686 15.6252 5.74811 15.169 5.42436 14.8502L0.910606 10.4752C0.533106 10.109 0.401856 9.55899 0.574356 9.06274C0.741856 8.56774 1.16936 8.20649 1.68561 8.12524L7.89811 7.22399C8.37061 7.17524 8.78561 6.88774 8.99811 6.46274L11.7356 0.850244C11.8006 0.725244 11.8844 0.610244 11.9856 0.512744L12.0981 0.425244C12.1569 0.360244 12.2244 0.306494 12.2994 0.262744L12.4356 0.212744L12.6481 0.125244H13.1744C13.6444 0.173994 14.0581 0.455244 14.2744 0.875244L17.0481 6.46274C17.2481 6.87149 17.6369 7.15524 18.0856 7.22399L24.2981 8.12524C24.8231 8.20024 25.2619 8.56274 25.4356 9.06274C25.5994 9.56399 25.4581 10.114 25.0731 10.4752L20.3981 14.9002Z" fill="#FFD05A"/>
                    </svg>';
        $quote_svg = '<svg width="102" height="81" viewBox="0 0 102 81" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M60.5738 69.024V32.592C60.5738 25.4773 61.9231 19.5893 64.6218 14.928C69.7738 5.60532 78.8511 0.943984 91.8538 0.943984H95.1658L99.2138 1.68V14.56H98.4778C90.3818 14.56 86.3338 18.7307 86.3338 27.072V37.008H91.1178C97.7418 37.008 101.054 40.4426 101.054 47.312V69.024C101.054 76.384 97.7418 80.064 91.1178 80.064H70.5098C63.8858 80.064 60.5738 76.384 60.5738 69.024ZM33.7098 0.943984C35.1818 0.943984 37.0218 1.18932 39.2298 1.68V14.56H38.4938C30.6431 14.56 26.7178 18.7307 26.7178 27.072V37.008H31.1338C38.0031 37.008 41.4378 40.4426 41.4378 47.312V69.024C41.4378 76.384 38.0031 80.064 31.1338 80.064H10.5258C4.14709 80.064 0.957752 76.384 0.957752 69.024V32.592C0.957752 11.4933 11.8751 0.943984 33.7098 0.943984Z" fill="#F0F0F0"/>
                    </svg>';

        if (!$items) {
            return false;
        }

        $slider_data = [
            'widgetID' => $wid,
            'pagination' => true,
            'arrows' => true,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];
        ?>
        <div class="testimonial-carousel">
            <div class="swiper carousel-wrap testimonial-carousel-9 testimonial-carousel-9-<?php echo $wid ?>" data-slider='<?php echo json_encode($slider_data) ?>'>
                <div class="swiper-wrapper">
                    <?php
                    foreach ($items as $key => $item):
                        $name = \ahura\app\mw_options::get_testimonial_username($item['tst_id']);
                        $site_name = \ahura\app\mw_options::get_testimonial_sitename($item['tst_id']);
                        $avatar_url = get_the_post_thumbnail_url($item['tst_id'], 'full');
                        $rate = $item['tst_rate'];
                        $content = get_post_field('post_content', $item['tst_id']); ?>
                        <div class="swiper-slide">
                            <div class="testimonial-carousel-item-wrap">
                                <div class="ahura-testimonial testimonial-carousel-item">
                                    <div class="d-flex flex-column justify-content-center align-items-center header-wrap">
                                        <div class="avatar-container">
                                            <div class="item-avatar item-avatar-prev">
                                                <?php if($key - 1 >= 0): ?>
                                                    <img src="<?php echo get_the_post_thumbnail_url($items[$key - 1]['tst_id'], 'full'); ?>" alt="">
                                                <?php endif; ?>
                                            </div>
                                            <div class="item-avatar item-avatar-current">
                                                <img src="<?php echo $avatar_url; ?>" alt="">
                                            </div>
                                            <div class="item-avatar item-avatar-next">
                                                <?php if($key + 1 < count($items)): ?>
                                                    <img src="<?php echo get_the_post_thumbnail_url($items[$key + 1]['tst_id'], 'full'); ?>" alt="">
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="name"><?php echo $name; ?></div>
                                        <div class="site-name"><?php echo $site_name; ?></div>
                                        <div class="user-rate">
                                            <?php for ($i = 1; $i <= $rate; $i++) {
                                                echo $star_svg;
                                            }; ?>
                                        </div>
                                    </div>
                                    <div class="content-wrap">
                                        <div class="d-flex justify-content-center align-items-center item-content">
											<?php if($settings['quote_icon']['value']): ?>
												<span class="quote-icon"><?php \Elementor\Icons_Manager::render_icon( $settings['quote_icon'], [ 'aria-hidden' => 'true' ] ); ?></span>
											<?php else: ?>
												<?php echo $back_quote_svg; ?>
											<?php endif; ?>
                                            <div class="content-text ah-has-text"><?php echo $content; ?></div>
											<?php if($settings['quote_icon']['value']): ?>
												<span class="quote-icon"><?php \Elementor\Icons_Manager::render_icon( $settings['quote_icon'], [ 'aria-hidden' => 'true' ] ); ?></span>
											<?php else: ?>
												<?php echo $quote_svg; ?>
											<?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <?php if($has_paginate): ?>
                    <div class="swiper-pagination w-100"></div>
                <?php endif; ?>
            </div>
        </div>
        <?php
    }
}