<?php
namespace ahura\inc\widgets;

// Die if is direct opened file
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\mw_assets;

class testimonial_carousel12 extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('testimonial_carousel12_js', mw_assets::get_js('elementor.testimonial_carousel12'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('testimonial_carousel12_css', mw_assets::get_css('elementor.testimonial_carousel12'));
        if(!is_rtl()){
            $this->register_elementor_style('testimonial_carousel12_ltr_css', mw_assets::get_css('elementor.ltr.testimonial_carousel12_ltr'));
        }
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('testimonial_carousel12_js')];
    }

    /**
     *
     * Set element id
     *
     * @return string
     */
    public function get_name()
    {
        return 'testimonial_carousel12';
    }

    /**
     *
     * Set element widget
     *
     * @return mixed
     */
    public function get_title()
    {
        return esc_html__('Testimonial Carousel 12', 'ahura');
    }

    /**
     *
     * Set widget icon
     *
     */
    public function get_icon()
    {
        return 'eicon-testimonial-carousel';
    }

    /**
     *
     * Set element category
     *
     * @return string[]
     */
    public function get_categories()
    {
        return ['ahuraelements', 'ahuratestimonial'];
    }

    /**
     *
     * Keywords for search
     *
     * @return array
     */
    public function get_keywords()
    {
        return ['ahura', 'testimonial', 'testimonial carousel 12', esc_html__('ahura', 'ahura'), esc_html__('Testimonial Carousel 12', 'ahura')];
    }

    /**
     *
     * Element controls option
     *
     */
    public function register_controls()
    {
        /**
         *
         * Start content section
         *
         */
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'testimonial_bycat_byids',
            [
                'label' => esc_html__( 'Testimonial query by', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'byids',
                'options' => [
                    'byids' => esc_html__( 'By Ids', 'ahura' ),
                    'bycat' => esc_html__( 'By Category', 'ahura' ),
                ],
            ]
        );

        $testimonial_cats = get_categories(['taxonomy' => 'testimonial_cat', 'orderby' => 'name', 'order' => 'ASC']);

        $testimonial_cats_options = [];
        if ($testimonial_cats) {
            foreach ($testimonial_cats as $item) {
                $testimonial_cats_options[$item->term_id] = $item->cat_name;
            }
        }

        $this->add_control(
            'testimonial_bycat',
            [
                'label' => esc_html__( 'Select category', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $testimonial_cats_options,
                'condition' => [
                    'testimonial_bycat_byids' => 'bycat',
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $items = get_posts(['post_type' => 'testimonial', 'numberposts' => -1]);
        $options = [];
        if ($items) {
            foreach ($items as $item) {
                $options[$item->ID] = $item->post_title;
            }
        }

        $default = ($options && is_array($options)) ? key($options) : false;

        $repeater->add_control(
            'tst_id',
            [
                'type' => Controls_Manager::SELECT2,
                'label' => esc_html__('Select', 'ahura'),
                'label_block' => true,
                'options' => $options,
                'default' => $default
            ]
        );

        $this->add_control(
            'testimonials',
            [
                'label' => esc_html__('Testimonial', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tst_id' => $default,
                        'rate' => 5
                    ],
                ],
                'title_field' => '{{{tst_id}}}',
                'condition' => [
                    'testimonial_bycat_byids' => 'byids',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_settings',
            [
                'label' => esc_html__('Settings', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'badge_title',
            [
                'label' => esc_html__( 'Badge Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Client Testimonial', 'ahura' ),
            ]
        );

        $this->add_control(
            'show_btn',
            [
                'label' => esc_html__('Button', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'btn_text',
            [
                'label' => esc_html__( 'Button Text', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'See more testimonial', 'ahura' ),
                'condition' => ['show_btn' => 'yes']
            ]
        );

        $this->add_control(
            'btn_icon',
            [
                'label' => esc_html__( 'Button Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'fa-solid',
                ],
                'condition' => ['show_btn' => 'yes']
            ]
        );

        $this->add_control(
            'btn_link',
            [
                'label' => esc_html__( 'Button link', 'ahura'),
                'type' => Controls_Manager::URL,
                'show_external' => true,
                'dynamic' => ['active' => true],
                'default' => [
                    'url' => '#',
                ],
                'condition' => ['show_btn' => 'yes']
            ]
        );

        $this->add_control('hr', ['type' => \Elementor\Controls_Manager::DIVIDER]);

        $this->add_control(
            'show_paginate',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'transition_duration',
            [
                'label' => esc_html__('Transition Duration', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 4000,
                'condition' => [
                    'autoplay' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label' => esc_html__('Infinite Loop', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();

        /**
         *
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('Item', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'item_bg',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => 'rgb(0, 255, 127)',
                'selectors' => [
                    '{{WRAPPER}} .content-text .bg-item path' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_badge_color',
            [
                'label' => esc_html__('Badge Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .t-badge' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Badge Typography', 'ahura'),
                'name' => 'item_badge_typo',
                'selector' => '{{WRAPPER}} .t-badge',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'item_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .t-details .name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'ahura'),
                'name' => 'item_title_typo',
                'selector' => '{{WRAPPER}} .t-details .name',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 'bold'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'item_subtitle_color',
            [
                'label' => esc_html__('Subtitle Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .t-details .site-name' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Subtitle Typography', 'ahura'),
                'name' => 'item_subtitle_typo',
                'selector' => '{{WRAPPER}} .t-details .site-name',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'item_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .t-text' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Text Typography', 'ahura'),
                'name' => 'item_text_typo',
                'selector' => '{{WRAPPER}} .t-text',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'btn_style_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_icon_color',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testimonial-footer .item-btn i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .testimonial-footer .item-btn :is(svg, path)' => 'fill: {{VALUE}}',
                ],
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'btn_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-footer .item-btn' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg',
                'selector' => '{{WRAPPER}} .testimonial-footer .item-btn',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#000']
                ],
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'selector' => '{{WRAPPER}} .testimonial-footer .item-btn',
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'btn_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-footer .item-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ],
                'condition' => [
                    'show_btn' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_paginate_style',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['show_paginate' => 'yes']
            ]
        );

        $this->add_control(
            'paginate_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .testimonial-footer .t-counter' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'ahura'),
                'name' => 'item_paginate_typo',
                'selector' => '{{WRAPPER}} .testimonial-footer .t-counter',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16',
                        ]
                    ]
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     *
     * Render element content (html)
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $items_byids = $settings['testimonials'];
        $rare_items_bycat = $settings['testimonial_bycat'];
        $has_btn = $settings['show_btn'] == 'yes';
        $has_paginate = $settings['show_paginate'] == 'yes';

        $slider_data = [
            'loop' => $settings['infinite_loop'] == 'yes',
            'autoPlay' => $settings['autoplay'] == 'yes',
            'transitionDuration' => (intval($settings['transition_duration'])) ? $settings['transition_duration'] : 4000,
            'showPagination' => $has_paginate,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];

        $items = null;
        $items_bycat = [];

        $posts_bycat = get_posts( [
            'posts_per_page'    => -1,
            'post_type'         => 'testimonial',
            'tax_query'         => [['taxonomy' => 'testimonial_cat', 'field' => 'term_id', 'terms' => $rare_items_bycat]]
        ]);

        if($items_byids) {
            $items = $items_byids;
        }

        if($rare_items_bycat){
            foreach($posts_bycat as $index => $post) {
                $items_bycat[$index]['tst_id'] = $post->ID;
                $items_bycat[$index]['show_rate'] = 'no';
                $items_bycat[$index]['rate'] = 5;
            }
            $items = $items_bycat;
        }

        if (!$items) {
            return false;
        }
        ?>
        <div class="testimonial-carousel testimonial-carousel-12">
            <div class="swiper carousel-wrap" data-slider='<?php echo json_encode($slider_data) ?>'>
                <div class="swiper-wrapper">
                    <?php
                    foreach($items as $item):
                        $name = \ahura\app\mw_options::get_testimonial_username($item['tst_id']);
                        $site_name = \ahura\app\mw_options::get_testimonial_sitename($item['tst_id']);
                        $avatar_url = get_the_post_thumbnail_url($item['tst_id'], 'full');
                        $content = get_post_field('post_content', $item['tst_id']);
                        ?>
                        <div class="swiper-slide">
                            <div class="testimonial-carousel-item-wrap">
                                <div class="ahura-testimonial testimonial-carousel-item">
                                    <div class="row">
                                        <div class="col-12 col-md-5">
                                            <div class="avatar-wrap">
                                                <div class="item-avatar">
													<svg width="559" height="534" viewBox="0 0 559 534" fill="none" preserveAspectRatio="none" xmlns="http://www.w3.org/2000/svg">
														<defs>
															<linearGradient id="gradient<?php echo $wid; ?>" x1="0%" y1="0%" x2="100%" y2="100%">
																<stop offset="0%" style="stop-color:rgba(0,0,0,0); stop-opacity:0"/>
																<stop offset="64%" style="stop-color:rgba(0,0,0,0.4); stop-opacity:1"/>
															</linearGradient>
														</defs>
														<mask id="avatar-mask-<?php echo $wid; ?>" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="559" height="534">
                                                            <?php if(is_rtl()): ?>
                                                                <path xmlns="http://www.w3.org/2000/svg" d="M559 100.29C559 78.1982 541.091 60.2896 519 60.2896H505.25C488.82 60.2896 475.5 46.97 475.5 30.5396C475.5 14.1091 462.18 0.789551 445.75 0.789551H40C17.9086 0.789551 0 18.6982 0 40.7896V203.79V387.29C0 409.381 17.9086 427.29 40 427.29H102C124.091 427.29 142 445.198 142 467.29V493.79C142 515.881 159.909 533.79 182 533.79H519C541.091 533.79 559 515.881 559 493.79V100.29Z" fill="white"/>
                                                            <?php else: ?>
                                                                <path xmlns="http://www.w3.org/2000/svg" d="M0 100.29C0 78.1982 17.9086 60.2896 40 60.2896H53.75C70.1805 60.2896 83.5 46.97 83.5 30.5396C83.5 14.1091 96.8195 0.789551 113.25 0.789551H519C541.091 0.789551 559 18.6982 559 40.7896V203.79V387.29C559 409.381 541.091 427.29 519 427.29H457C434.909 427.29 417 445.198 417 467.29V493.79C417 515.881 399.091 533.79 377 533.79H40C17.9086 533.79 0 515.881 0 493.79V100.29Z" fill="white"/>
                                                            <?php endif; ?>
														</mask>
														<image xlink:href="<?php echo $avatar_url ?>" width="100%" height="100%" mask="url(#avatar-mask-<?php echo $wid; ?>)" preserveAspectRatio="none"/>
														<rect width="559" height="534" fill-opacity="0.4"/>
													</svg>
                                                    <div class="t-details ah-has-text">
                                                        <div class="name"><?php echo $name ?></div>
                                                        <div class="site-name"><?php echo $site_name ?></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-7">
                                            <div class="content-wrap">
                                                <div class="item-content">
                                                    <div class="content-text ah-has-text">
                                                        <div class="t-badge">
                                                             <svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                                <circle cx="12" cy="12.2896" r="12" fill="#101010"/>
                                                                <path d="M16 16.7896C16.2652 16.7896 16.5196 16.6842 16.7071 16.4967C16.8946 16.3091 17 16.0548 17 15.7896V13.3476C17 13.0823 16.8946 12.828 16.7071 12.6404C16.5196 12.4529 16.2652 12.3476 16 12.3476H14.612C14.612 11.9966 14.633 11.6446 14.674 11.2936C14.736 10.9216 14.84 10.5906 14.984 10.3016C15.129 10.0116 15.315 9.78455 15.543 9.61855C15.77 9.43255 16.059 9.33955 16.411 9.33955V7.78955C15.832 7.78955 15.326 7.91355 14.891 8.16155C14.4598 8.40704 14.089 8.746 13.806 9.15355C13.5219 9.60287 13.3125 10.0952 13.186 10.6116C13.0585 11.1813 12.9961 11.7637 13 12.3476V15.7896C13 16.0548 13.1054 16.3091 13.2929 16.4967C13.4804 16.6842 13.7348 16.7896 14 16.7896H16ZM10 16.7896C10.2652 16.7896 10.5196 16.6842 10.7071 16.4967C10.8946 16.3091 11 16.0548 11 15.7896V13.3476C11 13.0823 10.8946 12.828 10.7071 12.6404C10.5196 12.4529 10.2652 12.3476 10 12.3476H8.612C8.612 11.9966 8.633 11.6446 8.674 11.2936C8.736 10.9216 8.84 10.5906 8.984 10.3016C9.129 10.0116 9.315 9.78455 9.543 9.61855C9.77 9.43255 10.059 9.33955 10.411 9.33955V7.78955C9.832 7.78955 9.326 7.91355 8.891 8.16155C8.45979 8.40704 8.08904 8.746 7.806 9.15355C7.52192 9.60287 7.31254 10.0952 7.186 10.6116C7.05849 11.1813 6.99609 11.7637 7 12.3476V15.7896C7 16.0548 7.10536 16.3091 7.29289 16.4967C7.48043 16.6842 7.73478 16.7896 8 16.7896H10Z" fill="white"/>
                                                            </svg>
                                                            <?php echo $settings['badge_title'] ?>
                                                        </div>
                                                        <div class="t-text"><?php echo $content ?></div>
														<svg class="bg-item" preserveAspectRatio="none" width="733" height="380" viewBox="0 0 733 380" fill="none" xmlns="http://www.w3.org/2000/svg">
														   <path d="M733 67.7896V21.7896C733 9.91543 723.374 0.289551 711.5 0.289551H466.75C448.11 0.289551 433 15.3999 433 34.0396C433 52.6792 417.89 67.7896 399.25 67.7896H344H40C17.9086 67.7896 0 85.6982 0 107.79V315.29C0 337.381 17.9086 355.29 40 355.29H331.75C338.516 355.29 344 360.774 344 367.54C344 374.305 349.485 379.79 356.25 379.79H693C715.091 379.79 733 361.881 733 339.79V67.7896Z" fill="#00FF7F"/>
														</svg>
                                                    </div>
                                                    <?php if ($has_btn || $has_paginate): ?>
                                                        <div class="testimonial-footer ah-has-text">
                                                            <?php if ($has_paginate): ?>
                                                                <span class="t-counter"><?php echo sprintf('%s / %d', 1, count($items)) ?></span>
                                                            <?php endif; ?>
                                                            <?php if ($has_btn):
                                                                if ( ! empty( $settings['btn_link']['url'] ) ) {
                                                                    $this->add_link_attributes( 'btn_link', $settings['btn_link'] );
                                                                }
                                                                ?>
                                                                <a <?php $this->print_render_attribute_string( 'btn_link' ); ?> class="item-btn">
                                                                    <?php echo $settings['btn_text'] ?>
                                                                    <?php \Elementor\Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                                </a>
                                                            <?php endif; ?>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php
    }
}