<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Typography;

class ahura_post_like_box extends \ahura\app\elementor\Elementor_Widget_Base {
    public function get_name() {
        return 'ahura_post_like_box';
    }

    public function get_title() {
        return esc_html__( 'Post Like Box', 'ahura' );
    }

    public function get_icon() {
        return 'eicon-heart-o';
    }

    public function get_categories() {
        return [ 'ahura_single' ];
    }

    public function get_keywords() {
        return [ 'ahura', 'post', 'like', esc_html__( 'ahura', 'ahura' ), esc_html__( 'post', 'ahura' ), esc_html__( 'like', 'ahura' ) ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'ahura' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->register_notice_control('important_notice', __('To use this element, you must enable it from Customizer > Blog > Single Post.', 'ahura'));

        $this->add_control(
			'post_like_style',
			[
				'label' => esc_html__( 'Style', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'Default', 'ahura' ),
					'style1' => esc_html__( 'Style 1', 'ahura' ),
				],
			]
		);

        $this->add_control(
            'box_title',
            [
                'label' => esc_html__( 'Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Was this post helpful to you?', 'ahura' ),
                'condition' => [ 'post_like_style' => 'default' ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__( 'Style', 'ahura' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => esc_html__( 'Text Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'global' => [
                    'default' => Global_Colors::COLOR_TEXT,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-like-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography',
                'global' => [
                    'default' => Global_Typography::TYPOGRAPHY_TEXT,
                ],
                'selector' => '{{WRAPPER}} .post-like-title',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'main_box_bg_color',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => [ 'classic', 'gradient' ],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .ahura-post-like',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'main_box_border',
                'selector' => '{{WRAPPER}} .ahura-post-like',
                'fields_options' => [
                    'width' => [
                        'label' => esc_html__('Border width', 'ahura'),
                    ],
                    'color' => [
                        'label' => esc_html__('Border color', 'ahura'),
                    ],
                ],
            ]
        );

        $this->add_control(
            'main_box_border_radius',
            [
                'label' => esc_html__( 'Border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 10,
                    'unit' => 'px'
                ],
                'selectors' => [
                    '{{WRAPPER}} .ahura-post-like' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'main_box_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .ahura-post-like' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 17,
                    'right' => 15,
                    'bottom' => 17,
                    'left' => 15,
                    'unit' => 'px'
                ]
            ]
        );

        $this->end_controls_section();

        $this->register_additional_controls();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="ah-post-like-box-element">
            <?php ahura_single_post_like_template(get_the_ID(), $settings['box_title'], $settings['post_like_style']); ?>
        </div>
        <?php
    }
}