<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.

defined('ABSPATH') or die('No script kiddies please!');

use ahura\app\mw_assets;
use ahura\app\woocommerce;
use Elementor\Controls_Manager;

class shop_category1 extends \ahura\app\elementor\Elementor_Widget_Base
{
    public function __register_assets()
    {
        $this->register_elementor_style('shop_category1', mw_assets::get_css('elementor.shop_category1'));
    }

    public function get_name()
	{
		return 'shopcategory1';
	}

	public function get_title()
	{
		return __('Products Category 1', 'ahura');
	}

	public function get_icon()
	{
		return 'aicon-svg-shop-category-1';
	}

	public function get_categories()
	{
		return ['ahuraelements','ahura_woocommerce'];
	}
	function get_keywords()
	{
        return ['ahura', 'category', 'category', 'products category 1', esc_html__('ahura', 'ahura'), esc_html__('Category', 'ahura'), esc_html__('Products Category 1', 'ahura')];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'content_section',
			[
				'label' => __('Content', 'ahura'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$categories = get_terms(array(
			'taxonomy' => 'product_cat',
			'hide_empty' => false,
		));

        $cats = [];
        if (\ahura\app\woocommerce::is_active()) {
            $cats       = array();
            if($categories){
                foreach ($categories as $category) {
                    $cats[$category->slug] = $category->name;
                }
            }
        }

		$default = key($cats);
		$this->add_control(
			'catsid',
			[
				'label'    => __('Categories', 'ahura'),
				'type'     => \Elementor\Controls_Manager::SELECT2,
				'options'  => $cats,
				'label_block' => true,
				'multiple' => false,
				'default' => $default
			]
		);

        $this->add_control(
            'show_box_title',
            [
                'label'   => __('Show Title', 'ahura'),
                'type'    => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'yes' => ['title' => __('Yes', 'ahura'), 'icon' => 'eicon-check'],
                    'no'  => ['title' => __('No', 'ahura'), 'icon' => 'eicon-close']
                ],
                'default' => 'yes'
            ]
        );

		$this->add_control(
			'price',
			[
				'label'   => __('Show Price', 'ahura'),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => ['title' => __('Yes', 'ahura'), 'icon' => 'eicon-check'],
					'no'  => ['title' => __('No', 'ahura'), 'icon' => 'eicon-close']
				],
				'default' => 'yes'
			]
		);

        $this->add_control(
			'show_most_discounted',
			[
				'label' => esc_html__( 'Show most discounted price', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
			'show_available_colors',
			[
				'label' => esc_html__( 'Show available colors', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
            'show_discount_star',
            [
                'label' => esc_html__('Discount star', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_buy_btn',
            [
                'label' => esc_html__('Product Button', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'buy_button_text',
            [
                'label'      => __('Button Text', 'ahura'),
                'type'       => \Elementor\Controls_Manager::TEXT,
                'default'    => __('Buy Product', 'ahura'),
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

		$this->add_control(
			'count',
			[
				'label'      => __('Number of posts', 'ahura'),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'default'    => 8
			]
		);

		$this->add_control(
			'product_order',
			[
				'label' => __('Sort', 'ahura'),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'default' => 'DESC',
				'options' => [
					'ASC' => [
						'title' => __('Ascending', 'ahura'),
						'icon' => 'eicon-sort-up'
					],
					'DESC' => [
						'title' => __('Descending', 'ahura'),
						'icon' => 'eicon-sort-down'
					],
				],
				'toggle' => true
			]
		);

		$this->add_control(
			'stock_status',
			[
				'label'   => __( 'Show product stock status', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-close' ]
				],
				'default' => 'yes'
			]
		);

		$this->add_control(
			'outofstock_text',
			[
				'label' => __( 'Out of stock text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'out of stock', 'ahura' ),
			]
		);

        $this->add_responsive_control(
            'object_fit',
            [
                'label' => esc_html__( 'Aspect ratio', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'contain',
                'options' => [
                    'fill' => esc_html__( 'Default', 'ahura' ),
                    'contain' => esc_html__( 'Contain', 'ahura' ),
                    'cover'  => esc_html__( 'Cover', 'ahura' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .p-item img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_section();
        $this->start_controls_section(
            'cover_styles',
            [
                'label' => __( 'Cover', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'cover_width',
            [
                'label' => esc_html__('Width', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%', 'px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100
                ],
                'selectors' => [
                    '{{WRAPPER}} .p-item img' => 'width: {{SIZE}}{{UNIT}}'
                ]
            ]
        );

        $this->add_responsive_control(
            'cover_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%', 'px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 260
                ],
                'selectors' => [
                    '{{WRAPPER}} .p-item img' => 'height: {{SIZE}}{{UNIT}}'
                ]
            ]
        );

        $this->add_control(
            'cover_radius',
            [
                'label' => esc_html__( 'Image border radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .mw_shop_cat_item_pic' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 7,
                    'right' => 7,
                    'bottom' => 7,
                    'left' => 7,
                ]
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'item_styles',
            [
                'label' => __( 'Item', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_background',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .p-item',
            ]
        );

        $this->add_control(
            'title-color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .p-item h3' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'ahura'),
                'name' => 'item_title_typography',
                'selector' => '{{WRAPPER}} .p-item h3',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '19',
                        ]
                    ]
                ]
            ]
        );

        $this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__( 'Title padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .p-item h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control('div1', ['type' => Controls_Manager::DIVIDER]);

        $this->add_control(
            'image_backcolor',
            [
                'label' => esc_html__('Image background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff00',
                'selectors' => [
                    '{{WRAPPER}} .mw_shop_cat_item_pic' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'pro_box_price_color',
            [
                'label' => esc_html__('Price Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#01b369',
                'selectors' => [
                    '{{WRAPPER}} .price' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .price ins' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .mw_shop_cat_item_price.regular-price' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'pro_box_dis_price_color',
            [
                'label' => esc_html__('Price by Discount Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#cdcdcd',
                'selectors' => [
                    '{{WRAPPER}} .price del' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .mw_shop_cat_item_price.sale-price' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Price Typography', 'ahura'),
                'name' => 'item_price_typography',
                'selector' => '{{WRAPPER}} .price, {{WRAPPER}} .price span, {{WRAPPER}} .mw_shop_cat_item_price.regular-price',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17',
                        ]
                    ]
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Dicounted price typography', 'ahura'),
                'name' => 'discounted_price_typography',
                'selector' => '{{WRAPPER}} .price del, {{WRAPPER}} .mw_shop_cat_item_price.sale-price',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17',
                        ]
                    ]
                ],
            ]
        );
        
        $this->add_responsive_control(
			'price_padding',
			[
				'label' => esc_html__( 'price padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .mw_shop_cat_item_price.regular-price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control('div2', ['type' => Controls_Manager::DIVIDER]);

        $this->add_control(
            'outofstock_background_color',
            [
                'label' => esc_html__( 'Of of stock background color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'red',
                'selectors' => [
                    '{{WRAPPER}} .out-of-stock' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'outofstock_color',
            [
                'label' => esc_html__( 'Of of stock color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'white',
                'selectors' => [
                    '{{WRAPPER}} .out-of-stock' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(), [
                'label' => esc_html__( 'Out of Stock typography', 'ahura' ),
                'name' => 'outofstock_text_typography',
                'selector' => '{{WRAPPER}} .out-of-stock',
            ]
        );

        $this->add_control('div3', ['type' => Controls_Manager::DIVIDER]);

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'items_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .p-item',
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => esc_html__( 'Box border radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .p-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 7,
                    'right' => 7,
                    'bottom' => 7,
                    'left' => 7,
                ]
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .p-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control('div4', ['type' => Controls_Manager::DIVIDER, 'condition' => [ 'show_available_colors' => 'yes' ]]);

        $this->add_responsive_control(
			'variations_list_hr',
			[
				'label' => esc_html__( 'Color variations HR position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -50,
						'max' => 500,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .color-variations-list' => 'right: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_available_colors' => 'yes' ]
			]
		);
        
        $this->add_responsive_control(
			'variations_list_vr',
			[
				'label' => esc_html__( 'Color variations VR position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -50,
						'max' => 500,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .color-variations-list' => 'top: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_available_colors' => 'yes' ]
			]
		);

        $this->add_control('div5', ['type' => Controls_Manager::DIVIDER, 'condition' => [ 'show_most_discounted' => 'yes' ]]);

        $this->add_control(
            'discounted_price_color',
            [
                'label' => esc_html__('Discounted price color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .most-disounted-price' => 'color: {{VALUE}}',
                ],
                'condition' => [ 'show_most_discounted' => 'yes' ]
            ]
        );

        $this->add_control(
            'discounted_price_backcolor',
            [
                'label' => esc_html__('Discounted price background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .most-disounted-price' => 'background-color: {{VALUE}}',
                ],
                'condition' => [ 'show_most_discounted' => 'yes' ]
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'most_discounted_price_typography',
				'selector' => '{{WRAPPER}} .most-disounted-price',
                'condition' => [ 'show_most_discounted' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'discounted_list_hr',
			[
				'label' => esc_html__( 'Color variations HR position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -50,
						'max' => 500,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .most-disounted-price' => 'left: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_most_discounted' => 'yes' ]
			]
		);
        
        $this->add_responsive_control(
			'discounted_list_vr',
			[
				'label' => esc_html__( 'Color variations VR position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -50,
						'max' => 500,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .most-disounted-price' => 'top: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_most_discounted' => 'yes' ]
			]
		);

        $this->add_control(
            'discounted_price_radius',
            [
                'label' => esc_html__( 'Dicsounted price radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'selectors' => [
                    '{{WRAPPER}} .most-disounted-price' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [ 'show_most_discounted' => 'yes' ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_tab_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .p-item',
            ]
        );

        $this->add_control(
            'buy_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs('buy_style_tabs');
        $this->start_controls_tab('buy_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_control(
            'buy_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#505050',
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'buy_typography',
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '400'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16',
                        ]
                    ]
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'buy_bg',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => [ 'classic', 'gradient' ],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
                'fields_options' => [
                    'background' =>
                        [
                            'default' => 'classic'
                        ],
                    'color' =>
                        [
                            'default' => '#fff'
                        ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'buy_border',
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
                'fields_options' => [
                    'border' => ['default' => 'solid'],
                    'width' => [
                        'default' => [
                            'unit' => 'px',
                            'top' => 1,
                            'bottom' => 1,
                            'right' => 1,
                            'left' => 1,
                        ]
                    ],
                    'color' => [
                        'default' => '#7e7e7e',
                    ],
                ],
            ]
        );

        $this->add_control(
            'buy_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'buy_box_shadow',
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('buy_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_control(
            'buy_text_color_hover',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'buy_bg_hover',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => [ 'classic', 'gradient' ],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .add-to-cart-btn:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'buy_border_hover',
                'selector' => '{{WRAPPER}} .add-to-cart-btn:hover',
            ]
        );

        $this->add_control(
            'buy_border_radius_hover',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'buy_box_shadow_hover',
                'selector' => '{{WRAPPER}} .add-to-cart-btn:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'box_styles',
            [
                'label' => __( 'Box', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'border_color',
            [
                'label'      => __('Border Color', 'ahura'),
                'type'       => \Elementor\Controls_Manager::COLOR,
                'default'    => '#444',
                'selectors' => [
                    '{{WRAPPER}} .mw_shop_cat_title_box b' => 'background-color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'box_title_color',
            [
                'label'      => __('Title Color', 'ahura'),
                'type'       => \Elementor\Controls_Manager::COLOR,
                'default'    => '#000',
                'selectors' => [
                    '{{WRAPPER}} .mw_shop_cat h2' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'box_title_typography',
                'selector' => '{{WRAPPER}} .mw_shop_cat h2',
            ]
        );

        $this->end_controls_section();

        $this->register_additional_controls();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
        $wid = $this->get_id();

		if (class_exists('WooCommerce')) {
			$field_is_term = (is_array($settings['catsid']) && is_numeric($settings['catsid'][0])) || is_int($settings['catsid']);
			$wc_query = new \WP_Query(array(
				'post_type'      => 'product',
				'post_status'    => 'publish',
				'posts_per_page' => $settings['count'],
				'tax_query' => array(
					array(
						'taxonomy' => 'product_cat',
						'field' => $field_is_term ? 'term_id' : 'slug',
						'terms' => $settings['catsid'],
					)
				),
				'order'         =>  $settings['product_order']
			));
			$first_cat_id = is_array($settings['catsid']) ? $settings['catsid'][0] : $settings['catsid'];
			if ($wc_query->have_posts()) : ?>
				<div class="mw_shop_cat mw-shop-cat-<?php echo $wid; ?>">
                    <?php if($settings['show_box_title'] === 'yes'): ?>
					<div class="mw_shop_cat_title_box mb-2">
						<b></b>
						<h2 class="ah-has-text"><?php $term = get_term_by( $field_is_term ? 'id' : 'slug', $first_cat_id, 'product_cat' );echo $term->name; ?></h2>
						<b></b>
					</div>
                    <?php endif; ?>
					<?php while ($wc_query->have_posts()) : $wc_query->the_post(); 
                        global $product, $wpdb;
                        $max_discount_percentage = null;
                        $simple_regular_price = get_post_meta(get_the_ID(), '_regular_price', true);
                        $simple_sale_price = get_post_meta(get_the_ID(), '_sale_price', true); ?>
						<div class="mw_shop_cat_item p-item ah-has-bg" <?php if($settings['count'] == 1) echo 'style=width:100%'; ?>>
                            <a href="<?php the_permalink(); ?>">
                                <?php if($simple_sale_price != null && $settings['show_discount_star'] === 'yes') : ?>
                                    <div class="mw_shop_cat_item_off_over">
                                        <i class="fa fa-star"></i>
                                    </div>
                                <?php endif; ?>
                                <div class="d-flex flex-column-reverse mw-shop-product-details">
                                    <div class="mw_shop_cat_item_data">
                                        <h3 class="ah-has-text"><?php the_title(); ?></h3>
                                        <?php if ($settings['price'] == 'yes') : ?>
                                            <div class="mw_shop_cat_item_price ah-has-text">
                                                <?php
                                                if ($settings['show_most_discounted'] === 'yes' && $product->is_type('variable')) {
                                                    $variations = $product->get_available_variations();
                                                    $most_discounted_variation = null;
                                                    foreach ($variations as $variation) {
                                                        $regular_price = $variation['display_regular_price'];
                                                        $sale_price = $variation['display_price'];
                                                        $discount_percentage = (($regular_price - $sale_price) / $regular_price) * 100;
                                                        if ($max_discount_percentage === null || $discount_percentage > $max_discount_percentage) {
                                                            $max_discount_percentage = $discount_percentage;
                                                            $most_discounted_variation = $variation;
                                                        }
                                                    }
                                                    if ($most_discounted_variation) {
                                                        echo "<p class='mw_shop_cat_item_price regular-price'>" . wc_price($most_discounted_variation['display_regular_price']) . "</p>";
                                                        echo "<p class='mw_shop_cat_item_price sale-price'>" . wc_price($most_discounted_variation['display_price']) . "</p>"; 
                                                    }                                               
                                                } else {
                                                    $price = woocommerce_template_single_price();
                                                    echo '<span class="mw_shop_cat_item_price">'.$price.'</span>';
                                                }
                                                ?>
                                            </div>
                                        <?php endif;
                                        if (($settings['stock_status'] === 'yes' && wc_get_product(get_the_ID())-> get_stock_status() == "outofstock")) {
                                            echo '<p class="out-of-stock">'.$settings['outofstock_text'].'</p>';
                                        }
                                        ?>
                                    </div>
                                    <div class="mw_shop_cat_item_pic">
                                        <?php if ($settings['show_most_discounted'] === 'yes' && $max_discount_percentage): ?>
                                            <h4 class="most-disounted-price">
                                                <?php echo '%' . round($max_discount_percentage); ?>
                                            </h4>
                                        <?php elseif($simple_sale_price != null && $settings['show_discount_star'] !== 'yes' && $product->is_type('simple') && ((is_numeric($simple_regular_price) && is_numeric($simple_sale_price) && $simple_regular_price > 0))):
                                            $discount_percentage = round((($simple_regular_price - $simple_sale_price) / $simple_regular_price) * 100); ?>
                                            <?php if (isset($discount_percentage)) : ?>
                                            <div class="mw_shop_cat_item_off_over">
                                                <span class="discount-percentage"><?php echo esc_html($discount_percentage); ?>%</span>
                                            <?php endif; ?>
                                        </div>
                                        <?php endif; ?>
                                        <?php
                                        $variation_list_colors = [];
                                        if ($settings['show_available_colors'] === 'yes' && $product->is_type('variable')) {
                                            $variations = $product->get_available_variations();
                                            foreach ($variations as $variation) {
                                                foreach (wc_get_product($variation['variation_id'])->get_variation_attributes() as $attribute_name => $attribute_value) {
                                                    $term_id = $wpdb->get_var($wpdb->prepare("SELECT term_id FROM $wpdb->terms WHERE slug = %s", $attribute_value));
                                                    $term_meta_value = get_term_meta($term_id, '_product_attribute_color', true);
                                                    if ($term_meta_value) {
                                                        array_push($variation_list_colors, $term_meta_value);
                                                    }
                                                }
                                            }
                                        }
                                        if($variation_list_colors): ?>
                                            <ul class="color-variations-list">
                                                <?php foreach($variation_list_colors as $color_hex): ?>
                                                    <li style="background-color:<?php echo $color_hex; ?>;"></li>
                                                <?php endforeach; ?>
                                            </ul>
                                        <?php endif; ?>
                                        <?php the_post_thumbnail('woocommerce_thumbnail'); ?>
                                    </div>
                                </div>
                            </a>
                            <?php if ($settings['show_buy_btn'] == 'yes'): ?>
                                <div class="item-buttons">
                                    <a href="<?php the_permalink(); ?>?add-to-cart=<?php the_ID(); ?>" class="add-to-cart-btn ah-is-button">
                                        <?php echo $settings['buy_button_text'] ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
					<?php endwhile; ?>
				</div>
				<?php wp_reset_postdata(); ?>
				<?php else:?>
					<div class="mw_element_error">
						<?php echo __('Nothing found. Edit the page with Elementor and select a category for this section.','ahura');?>
					</div>
			<?php endif; ?>
			<div class="clear"></div>
<?php
		}
	}
}
