<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.

use ahura\app\mw_tools;
use ahura\app\traits\WoocommerceMethods;
use ahura\app\woocommerce;
use Elementor\Controls_Manager;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\mw_assets;

class shop_carousel8 extends \ahura\app\elementor\Elementor_Widget_Base {
    use WoocommerceMethods;

    /**
     * shop_carousel4 constructor.
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('shop_carousel8_js', mw_assets::get_js('elementor.shop_carousel8'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('shop_carousel8_css', mw_assets::get_css('elementor.shop_carousel8'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('shop_carousel8_js')];
    }

    public function get_name() {
        return 'shopcarousel8';
    }

    public function get_title() {
        return __( 'Products Carousel 8', 'ahura' );
    }

    public function get_icon() {
        return 'aicon-svg-shop-carousel';
    }

    public function get_categories() {
        return [ 'ahuraelements','ahura_woocommerce' ];
    }
    function get_keywords()
    {
		return ['ahura', 'shop', 'product', 'products carousel', 'shop carousel 8', esc_html__( 'ahura' , 'ahura'), esc_html__( 'Products' , 'ahura'), esc_html__( 'Shop Carousel 8' , 'ahura')];
    }

    protected function register_controls() {
        if(!woocommerce::is_active())
        {
            return false;
        }

        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'ahura' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $categories = get_terms( array(
            'taxonomy' => 'product_cat',
            'hide_empty' => false,
        ));
        $cats       = array();
        if($categories){
            foreach ( $categories as $category ) {
                $cats[ $category->slug ] = $category->name;
            }
        }

        $this->add_control(
            'catsid',
            [
                'label'    => __( 'Categories', 'ahura' ),
                'type'     => Controls_Manager::SELECT2,
                'options'  => array_merge(
                    [ 'allproducts'  => esc_html__( 'All Products', 'ahura' ) ],
                    [ 'discountedproducts'  => esc_html__( 'Discounted Products', 'ahura' ) ],
                    [ 'randomproducts'  => esc_html__( 'Random Products', 'ahura' ) ],
                    $cats ),
                'label_block' => true,
                'multiple' => true,
                'default' => 'allproducts'
            ]
        );

        $this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides per view', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    1 => '1',
                    2 => '2',
                    3 => '3',
                    4 => '4',
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => 3,
				'tablet_default' => 2,
				'mobile_default' => 1,
            ]
        );

        $this->add_control(
			'price_prefix',
			[
				'label' => esc_html__( 'Price prefix', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Price', 'ahura' ),
			]
		);

        $this->add_control(
			'addcart_btn_text',
			[
				'label' => esc_html__( 'Add to cart button text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Buy', 'ahura' ),
			]
		);

		$this->add_control(
			'price_in_millions',
			[
				'label' => esc_html__( 'Price in millions', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_dt',
			[
				'label' => esc_html__( 'Show duration time', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_control(
			'learning_duration_time',
			[
				'label' => esc_html__( 'Default learning duration time', 'ahura' ),
                'description' => esc_html__( 'Actual learning duration time comes from a product Meta Key value named "learning_duration_time"', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '2 hours', 'ahura' ),
				'condition' => [ 'show_dt' => 'yes' ]
			]
		);

		$this->add_control(
			'show_author',
			[
				'label' => esc_html__( 'Show author', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'slider_section',
            [
                'label' => __( 'Slider', 'ahura' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_arrows',
            [
                'label' => esc_html__('Arrows', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'item_styles',
            [
                'label' => esc_html__('Item', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
			'box_style_option',
			[
				'label' => esc_html__( 'Box', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'box_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 16,
					'right' => 16,
					'bottom' => 16,
					'left' => 16,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'box_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 20,
					'right' => 3,
					'bottom' => 20,
					'left' => 3,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .swiper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'content_style_option',
			[
				'label' => esc_html__( 'Content area', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'content_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-content-area' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'content_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 140,
					'right' => 20,
					'bottom' => 20,
					'left' => 20,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-content-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'content_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 15,
					'right' => 15,
					'bottom' => 15,
					'left' => 15,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-content-area' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'content_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => -110,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-content-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'content_box_shadow',
			[
				'label' => esc_html__( 'Box Shadow', 'ahura' ),
				'type' => \Elementor\Controls_Manager::BOX_SHADOW,
                'fields_options' => [
                    'box_shadow_type' => ['default' => 'yes'],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical' => 2.5,
                            'blur' => 22,
                            'spread' => 0,
                            'color' => '#00000008'
                        ]
                    ]
                ],
				'selectors' => [
					'{{SELECTOR}}' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
				],
			]
		);
        
        $this->add_control(
			'image_style_option',
			[
				'label' => esc_html__( 'Image', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'image_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 40,
					'right' => 40,
					'bottom' => 40,
					'left' => 40,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .img-container, {{WRAPPER}} .shop-carousel8-wrap .img-container img, {{WRAPPER}} .shop-carousel8-wrap .img-container .image-border' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'image_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#e9e6ed',
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .img-container img' => 'background-color: {{VALUE}}',
				],
			]
		);
        
        $this->add_control(
			'cat_style_option',
			[
				'label' => esc_html__( 'Category', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'cat_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#666666',
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-cats' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'category_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15'
                        ]
                    ],
                ],
				'selector' => '{{WRAPPER}} .shop-carousel8-wrap .product-cats',
			]
		);

        $this->add_responsive_control(
			'cat_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 15,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-cats' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'title_style_option',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000000',
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-title' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '20'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '600'
                    ]
                ],
				'selector' => '{{WRAPPER}} .shop-carousel8-wrap .product-title',
			]
		);

        $this->add_responsive_control(
			'title_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 55,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-title' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'meta_style_option',
			[
				'label' => esc_html__( 'Meta', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'meta_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '14'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '600'
                    ]
                ],
				'selector' => '{{WRAPPER}} .shop-carousel8-wrap .product-meta .time, {{WRAPPER}} .shop-carousel8-wrap .product-meta .product-author span ',
			]
		);

        $this->add_responsive_control(
			'meta_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 20,
					'right' => 0,
					'bottom' => 35,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'author_name_margin',
			[
				'label' => esc_html__( 'Name margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 5,
					'bottom' => 5,
					'left' => 5,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-meta .product-author span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'show_author' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'author_image_margin',
			[
				'label' => esc_html__( 'Author name border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 100,
					'right' => 100,
					'bottom' => 100,
					'left' => 100,
					'unit' => '%',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-meta .product-author img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'show_author' => 'yes' ]
			]
		);
        
        $this->add_control(
			'button_style_option',
			[
				'label' => esc_html__( 'Button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-button-area' => 'color: {{VALUE}}',
				],
			]
		);

        $button_botder_side = is_rtl() ? 'border-right' : 'border-left';

        $this->add_control(
			'button_border_color',
			[
				'label' => esc_html__( 'Border color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#83B4FF',
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .add-cart-btn' => $button_botder_side . ': 1px solid {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'button_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#0166FF',
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-button-area' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'button_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-button-area' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'button_padding',
			[
				'label' => esc_html__( 'Button padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 10,
					'bottom' => 5,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-button-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'button_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .product-button-area' => 'min-height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'slider_styles',
            [
                'label' => esc_html__('Slider', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );
        
        $this->add_control(
			'pagination_style_option',
			[
				'label' => esc_html__( 'Pagination', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [ 'show_pagination' => 'yes' ]
			]
		);

        $pagination_style_default = 'border-radius: 100%';
        $pagination_style1 = 'border-radius: 5px;';

        $this->add_control(
			'pagination_styles',
			[
				'label' => esc_html__( 'Active pagination style', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => $pagination_style_default,
				'options' => [
					$pagination_style_default => esc_html__( 'Default', 'ahura' ),
					$pagination_style1 => esc_html__( 'Style 1', 'ahura' ),
				],
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => '{{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_style1_width',
			[
				'label' => esc_html__( 'Style1 width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 100,
						'step' => 1,
					],
				],
				'condition' => [ 'show_pagination' => 'yes', 'pagination_styles' => $pagination_style1 ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_vertical_position',
			[
				'label' => esc_html__( 'Pagination vertical position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -50,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_width',
			[
				'label' => esc_html__( 'Pagination size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 50,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'active_pagination_color',
			[
				'label' => esc_html__( 'Active pagination color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'background-color:{{VALUE}};color:{{VALUE}}',
				],
			]
		);
        
        $this->add_control(
			'notactive_pagination_color',
			[
				'label' => esc_html__( 'Not-Active pagination color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet' => 'background-color:{{VALUE}};opacity:1',
				],
			]
		);

        $this->add_control(
			'arrow_style_option',
			[
				'label' => esc_html__( 'Arrows', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [ 'show_arrows' => 'yes' ]
			]
		);

        $this->add_control(
			'arrow_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#464646',
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .swiper-nav-button' => 'color: {{VALUE}}',
				],
                'condition' => [ 'show_arrows' => 'yes' ]
			]
		);

        $this->add_control(
			'arrow_backcolor',
			[
				'label' => esc_html__( 'Background-color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .swiper-nav-button' => 'background-color: {{VALUE}}',
				],
                'condition' => [ 'show_arrows' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'arrow_size',
			[
				'label' => esc_html__( 'Size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 120,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .swiper-nav-button' => 'font-size: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_arrows' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'arrow_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 120,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .swiper-nav-button' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_arrows' => 'yes' ]
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'arrow_border',
                'fields_options' => [
                    'border' => [
                        'default' => 'solid',
                    ],
                    'width' => [
                        'label' => esc_html__('Border width', 'ahura'),
                        'default' => [
                            'unit' => 'px',
                            'top' => 1,
                            'bottom' => 1,
                            'right' => 1,
                            'left' => 1,
                        ]
                    ],
                    'color' => [
                        'label' => esc_html__('Border color', 'ahura'),
                        'default' => '#b1b1b1',
                    ],
                ],
				'selector' => '{{WRAPPER}} .shop-carousel8-wrap .swiper-nav-button',
                'condition' => [ 'show_arrows' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'arrow_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 50,
					'right' => 50,
					'bottom' => 50,
					'left' => 50,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel8-wrap .swiper-nav-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [ 'show_arrows' => 'yes' ]
			]
		);

        $this->end_controls_section();

        $this->register_additional_controls();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $has_paginate = ($settings['show_pagination'] == 'yes');
        $has_arrows = ($settings['show_arrows'] == 'yes');

        if ( class_exists( 'WooCommerce' ) ) {

            $field_is_term = (is_array($settings['catsid']) && is_numeric($settings['catsid'][0])) || is_int($settings['catsid']);
            $current_currency_symbol = get_woocommerce_currency_symbol();
            $cats_id = $settings['catsid'];

            $args = [
                'post_type'		 => 'product',
                'post_status'	 => 'publish',
            ];

            if($cats_id == 'allproducts' || ($cats_id[0] == 'allproducts') || $cats_id[0] == 'randomproducts') {
                $args = array_merge($args, [
                    'orderby' => $cats_id[0] == 'randomproducts' ? 'rand' : 'ASC'
                ]);
            } elseif($cats_id[0] == 'discountedproducts') {
                $args = array_merge($args, [
                    'meta_key' 		 => '_sale_price',
                    'meta_value' 	 => '0',
                    'meta_compare'   => '>='
                ]);
            } else {
                $args = array_merge($args, [
                    'tax_query'		 => [[
                        'taxonomy'   => 'product_cat',
                        'field'		 => $field_is_term ? 'term_id' : 'slug',
                        'terms'		 => $cats_id,
                    ]],
                ]);
            }

            $slider_data = [
                'desktopPerView' => (isset($settings['slides_per_view']) && intval($settings['slides_per_view'])) ? $settings['slides_per_view'] : 3,
                'tabletPerView' => (isset($settings['slides_per_view_tablet']) && intval($settings['slides_per_view_tablet'])) ? $settings['slides_per_view_tablet'] : 2,
                'mobilePerView' => (isset($settings['slides_per_view_mobile']) && intval($settings['slides_per_view_mobile'])) ? $settings['slides_per_view_mobile'] : 1,
                'pagination' => $has_paginate,
                'arrows' => $has_arrows,
                'observer' => $settings['use_observer_slider'] == 'yes'
            ];

            $wc_query = new \WP_Query($args);
            if ($wc_query->have_posts()) : ?>
                <div class="shop-carousel8-wrap">
                    <div class="swiper swiper-shop-carousel8 swiper-shop-carousel8-<?php echo $wid; ?>" data-slider='<?php echo json_encode($slider_data) ?>'>
                        <div class="swiper-wrapper">
                            <?php while ( $wc_query->have_posts() ) : $wc_query->the_post();
                                $author_id = get_post_field('post_author', get_the_ID());
                                $product_image_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
                                $categories = get_the_terms(get_the_ID(), 'product_cat'); 
								$learning_time_duration = get_post_meta(get_the_ID(), 'learning_duration_time', true) ? get_post_meta(get_the_ID(), 'learning_duration_time', true) : $settings['learning_duration_time']; ?>
                                <div class="swiper-slide">
                                    <div class="sc-item-content">
                                        <div class="img-container">
                                            <img src="<?php echo esc_url($product_image_url); ?>" alt="<?php echo __('Product Image', 'ahura'); ?>">
                                            <div class="image-border"></div>
                                        </div>
                                        <div class="product-content-area">
                                            <div class="product-content-header">
                                                <div class="product-cats">
                                                    <?php if ($categories) {
                                                        $category_count = count($categories);
                                                        $i = 0;
                                                        foreach ($categories as $category) {
                                                            $i++;
                                                            echo '<a href="' . get_term_link($category) . '">' . $category->name . '</a>';
                                                            if ($i < $category_count) {
                                                                echo ' / ';
                                                            }
                                                        }
                                                    } ?>
                                                </div>
                                                <a href="<?php echo esc_url(get_permalink()); ?>" class="product-title"><?php echo get_the_title(); ?></a>
                                            </div>
                                            <div class="product-meta">
												<?php if(!empty($learning_time_duration) && $settings['show_dt'] === 'yes'): ?>
													<div class="product-time-duration">
														<div class="icon-container <?php echo is_rtl() ? 'ml-1' : 'mr-1'; ?>">
															<svg width="28" height="28" viewBox="0 0 28 28" fill="none" xmlns="http://www.w3.org/2000/svg">
																<path opacity="0.4" d="M27.0938 14.2037C27.0938 21.5493 21.1405 27.5013 13.7962 27.5013C6.45199 27.5013 0.498657 21.5493 0.498657 14.2037C0.498657 6.86079 6.45199 0.906128 13.7962 0.906128C21.1405 0.906128 27.0938 6.86079 27.0938 14.2037Z" fill="#83B4FF"/>
																<path d="M18.5484 19.276C18.3742 19.276 18.1987 19.2308 18.0378 19.1363L12.8171 16.0221C12.5166 15.8412 12.3318 15.5154 12.3318 15.1644V8.45307C12.3318 7.90255 12.7786 7.45575 13.3291 7.45575C13.8796 7.45575 14.3264 7.90255 14.3264 8.45307V14.5979L19.0604 17.421C19.5324 17.7042 19.688 18.3159 19.4061 18.7893C19.2186 19.1018 18.8875 19.276 18.5484 19.276Z" fill="#83B4FF"/>
															</svg>
														</div>
														<span class="time"><?php echo $learning_time_duration; ?></span>
													</div>
												<?php endif; ?>
												<?php if($settings['show_author'] === 'yes'): ?>
													<div class="product-author">
														<img src="<?php echo get_avatar_url($author_id, ['size' => 26]); ?>" alt="<?php echo __('Author Avatar', 'ahura'); ?>">
														<span><?php echo esc_html(get_the_author_meta('display_name', $author_id)); ?></span>
													</div>
												<?php endif; ?>
                                            </div>
                                            <div class="product-button-area">
                                                <div class="product-price">
                                                    <?php if(isset($settings['price_prefix'])): ?>
                                                        <span class="price-prefix <?php echo is_rtl() ? 'ml-2' : 'mr-2'; ?>">
                                                            <?php echo $settings['price_prefix']; ?>
                                                        </span>
                                                    <?php endif; ?>
                                                    <?php $product_id = get_the_ID();
                                                    Global $product;
                                                    if ( $product->is_type('variable') ) {
                                                        $variation_ids = $product->get_children();
                                                        $min_variation_price = PHP_INT_MAX;
                                                        foreach( $variation_ids as $variation_id ) {
                                                            $variation = wc_get_product( $variation_id );
                                                            $variation_price = $variation->get_price();
                                                            $min_variation_price = min( $min_variation_price, $variation_price );
                                                        }
                                                        $settings['price_in_millions'] === 'yes' ? $formatted_price = $min_variation_price / 1000 : $formatted_price = $min_variation_price;
                                                        echo wc_price($formatted_price);
                                                    } else {
                                                        $regular_price = get_post_meta($product_id, '_regular_price', true);
                                                        if ($regular_price > 0) {
                                                            $settings['price_in_millions'] === 'yes' ? $formatted_price = $regular_price / 1000 : $formatted_price = $regular_price;
                                                            echo wc_price($formatted_price);
                                                        } else {
                                                            echo wc_price($regular_price);
                                                        }
                                                    }
                                                    ?>
                                                </div>
                                                <?php if(isset($settings['addcart_btn_text'])): ?>
                                                    <a href="<?php echo esc_url(get_permalink()); ?>" class="add-cart-btn"><?php echo $settings['addcart_btn_text']; ?></a>
                                                <?php endif; ?>
                                            </div>
                                            <?php
                                            ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        </div>
                        <?php if($has_arrows): ?>
                            <div class="swiper-nav-button swiper-btn-prev"><i class="fas fa-angle-right"></i></div>
                            <div class="swiper-nav-button swiper-btn-next"><i class="fas fa-angle-left"></i></div>
                        <?php endif; ?>
                        <?php if($has_paginate): ?>
                            <div class="swiper-pagination w-100"></div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php wp_reset_postdata(); ?>
            <?php else: ?>
                <div class="mw_element_error">
                    <?php echo __('Nothing found. Edit the page with Elementor and select a category for this section.','ahura');?>
                </div>
            <?php endif; ?>
            <div class="clear"></div>
            <?php
        }
    }
}