<?php
namespace ahura\inc\widgets;

use ahura\app\mw_assets;
use ahura\app\traits\WoocommerceMethods;
use ahura\app\woocommerce;
use Elementor\Controls_Manager;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class shop_carousel6 extends \ahura\app\elementor\Elementor_Widget_Base {
    use WoocommerceMethods;

    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('shop_carousel6_js', mw_assets::get_js('elementor.shop_carousel6'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('shop_carousel6_css', mw_assets::get_css('elementor.shop_carousel6'));
        if(!is_rtl()){
            $this->register_elementor_style('shop_carousel6_ltr_css', mw_assets::get_css('elementor.ltr.shop_carousel6_ltr'));
        }
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('shop_carousel6_js')];
    }

    public function get_name() {
        return 'shop_carousel6';
    }

    public function get_title() {
        return __( 'Shop Carousel6', 'ahura' );
    }

    public function get_icon() {
        return 'eicon-form-vertical';
    }

    public function get_categories() {
        return [ 'ahuraelements','ahura_woocommerce' ];
    }
    function get_keywords()
    {
		return ['ahura', 'shop', 'product', 'products carousel', 'shop carousel 6', esc_html__( 'ahura' , 'ahura'), esc_html__( 'Products' , 'ahura'), esc_html__( 'Shop Carousel 6' , 'ahura')];
    }

    protected function register_controls() {
        if(!woocommerce::is_active())
            return false;

        $this->start_controls_section(
            'content_section', [
                'label' => __( 'Content', 'ahura' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Our shop best products', 'ahura' ),
			]
		);

        $this->add_control(
            'type',
            [
                'label' => esc_html__( 'Type', 'ahura' ),
                'label_block' => true,
                'type' => Controls_Manager::SELECT,
                'options' => [
                        'all' => esc_html__('All Products', 'ahura'),
                        'top' => esc_html__('Best selling products', 'ahura'),
                        'offer' => esc_html__('Discounted products', 'ahura'),
                ],
                'default' => 'top',
            ]
        );
        if (\ahura\app\woocommerce::is_active()) {
            $categories = get_terms( array(
                'taxonomy' => 'product_cat',
                'hide_empty' => false,
            ));
            $cats       = array();
            if($categories){
                foreach ( $categories as $category ) {
                    $cats[ $category->slug ] = $category->name;
                }
            }
        }

        $this->add_control(
            'catsid',
            [
                'label'    => __( 'Categories', 'ahura' ),
                'type'     => Controls_Manager::SELECT2,
                'options'  => $cats,
                'label_block' => true,
                'multiple' => true,
            ]
        );

        $stock_options = (function_exists('wc_get_product_stock_status_options')) ? wc_get_product_stock_status_options() : [];

        $this->add_control(
            'products_stock_status',
            [
                'label'   => esc_html__('Stock status of products', 'ahura'),
                'type'    => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => array_merge(['none'  => esc_html__('None', 'ahura')], $stock_options),
                'default' => 'instock'
            ]
        );

        $this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides per view', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    1 => '1',
                    2 => '2',
                    3 => '3',
                    4 => '4',
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => 2,
				'tablet_default' => 2,
				'mobile_default' => 1,
            ]
        );

        $this->add_control(
            'count',
            [
                'label' => esc_html__( 'Number of posts', 'ahura' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'step' => 1,
                'default' => 18,
            ]
        );

        $this->add_control(
			'price_prefix_text',
			[
				'label' => esc_html__( 'Price prefix text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Price', 'ahura' ),
			]
		);

        $this->add_control(
			'add_cart_text',
			[
				'label' => esc_html__( 'Button text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Add to Cart', 'ahura' ),
			]
		);

        $this->add_control(
            'show_meta_seperator',
            [
                'label' => esc_html__( 'Meta separator', 'ahura' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_product_meta',
            [
                'label' => esc_html__( 'Product meta', 'ahura' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
			'product_meta_first',
			[
				'label' => esc_html__( 'First product meta icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-heart',
					'library' => 'fa-solid',
				],
                'condition' => [ 'show_product_meta' => 'yes' ]
			]
		);

        $this->add_control(
			'meta_link_first',
			[
				'label' => esc_html__( 'First meta url', 'ahura' ),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'label_block' => true,
                'condition' => [ 'show_product_meta' => 'yes' ]
			]
		);

        $this->add_control(
			'product_meta_second',
			[
				'label' => esc_html__( 'Second product meta icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-comment',
					'library' => 'fa-solid',
				],
                'condition' => [ 'show_product_meta' => 'yes' ]
			]
		);

        $this->add_control(
			'meta_link_second',
			[
				'label' => esc_html__( 'Second meta url', 'ahura' ),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'label_block' => true,
                'condition' => [ 'show_product_meta' => 'yes' ]
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_section',
            [
                'label' => __( 'Slider', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__( 'Show paginations', 'ahura' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        
        $this->add_control(
            'show_arrows',
            [
                'label' => esc_html__( 'Show Arrows', 'ahura' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
			'arrow_prev_icon',
			[
				'label' => esc_html__( 'Previous icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-angle-left',
					'library' => 'fa-solid',
				],
                'condition' => [ 'show_arrows' => 'yes' ]
			]
		);

        $this->add_control(
			'arrow_next_icon',
			[
				'label' => esc_html__( 'Next icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-angle-right',
					'library' => 'fa-solid',
				],
                'condition' => [ 'show_arrows' => 'yes' ]
			]
		);

        $this->add_control(
			'autoplay',
			[
				'label' => esc_html__( 'Autoplay', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
			'autoplay_delay',
			[
				'label' => esc_html__( 'Autoplay delay', 'ahura' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 100,
				'max' => 10000,
				'step' => 1,
				'default' => 2500,
                'condition' => ['autoplay' => 'yes']
			]
		);

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();
        /**
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'header_style_section',
            [
                'label' => __( 'Header', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'title_align',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => is_rtl() ? 'right' : 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .box-title' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'border_color',
			[
				'label' => esc_html__( 'Border color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .box-head' => 'border-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'title_second_color',
			[
				'label' => esc_html__( 'Title second color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .box-title' => 'border-color: {{VALUE}}',
				],
                'default' => '#0063D1'
			]
		);

        $this->add_responsive_control(
			'title_width',
			[
				'label' => esc_html__( 'Title width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 100,
						'max' => 1000,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .box-title' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
		$this->end_controls_section();

        $this->start_controls_section(
            'item_style_section',
            [
                'label' => __( 'Item', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
			'general_item_style',
			[
				'label' => esc_html__( 'General', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'wrap_backcolor',
			[
				'label' => esc_html__( 'Item backgrund-color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product-item-wrap' => 'background-color: {{VALUE}}',
				],
                'default' => '#ffffff'
			]
		);

        $this->add_control(
			'wrap_padding',
			[
				'label' => esc_html__( 'Item padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 20,
					'right' => 20,
					'bottom' => 20,
					'left' => 20,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .product-item-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'wrap_margin',
			[
				'label' => esc_html__( 'Item margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 5,
					'bottom' => 5,
					'left' => 5,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .product-item-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'wrap_radius',
			[
				'label' => esc_html__( 'Item border-radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .product-item-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'wrap_height',
			[
				'label' => esc_html__( 'Item height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 230,
				],
				'selectors' => [
					'{{WRAPPER}} .product-item-wrap' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'category_item_style',
			[
				'label' => esc_html__( 'Category', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'category_typography',
				'selector' => '{{WRAPPER}} .item-cat .category',
			]
		);

        $this->add_control(
			'category_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-cat' => 'color: {{VALUE}}',
				],
			]
		);
        
        $this->add_control(
			'image_item_style',
			[
				'label' => esc_html__( 'Image', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'image_width',
			[
				'label' => esc_html__( 'Image width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 86,
				],
				'selectors' => [
					'{{WRAPPER}} .product-img-container' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'image_thumbnail',
				'exclude' => [ 'custom' ],
				'include' => [],
				'default' => 'large',
			]
		);
        
        $this->add_control(
			'title_item_style',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ]
                ],
				'selector' => '{{WRAPPER}} .product-item-details .title',
			]
		);

        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Title color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product-item-details .title' => 'color: {{VALUE}}',
				],
                'default' => '#222222'
			]
		);
        
        $this->add_control(
			'meta_item_style',
			[
				'label' => esc_html__( 'Meta', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_responsive_control(
			'meta_svg_size',
			[
				'label' => esc_html__( 'Meta icon size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 100,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .product-footer-meta svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'meta_svg_color',
			[
				'label' => esc_html__( 'Meta svg color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product-footer-meta i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .product-footer-meta svg' => 'fill: {{VALUE}}',
				],
                'default' => '#999999'
			]
		);

        $this->add_control(
			'meta_margin',
			[
				'label' => esc_html__( 'Meta margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => is_rtl() ? 0 : 20,
					'bottom' => 0,
					'left' => is_rtl() ? 20 : 0,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .product-footer-meta > div' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'meta_separator_color',
			[
				'label' => esc_html__( 'Meta separator color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product-item-footer' => 'border-top: 1px solid {{VALUE}}',
				],
                'default' => '#E3E3E3',
                'condition' => [ 'show_meta_seperator' => 'yes' ]
			]
		);

        $this->add_control(
			'meta_separator_padding',
			[
				'label' => esc_html__( 'Meta separator padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 20,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => false,
				],
                'condition' => [ 'show_meta_seperator' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .product-item-footer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'price_item_style',
			[
				'label' => esc_html__( 'Price', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'price_color',
			[
				'label' => esc_html__( 'Price color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product-item-details .price' => 'color: {{VALUE}}',
				],
                'default' => '#099809'
			]
		);

        $this->add_control(
			'price_margin',
			[
				'label' => esc_html__( 'Price margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .product-item-content .product-item-details .price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ]
                ],
				'selector' => '{{WRAPPER}} .product-item-content .product-item-details .price *',
			]
		);
        
        $this->add_control(
			'button_item_style',
			[
				'label' => esc_html__( 'Button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} .add-button',
			]
		);

        $this->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Button color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .add-button' => 'color: {{VALUE}}',
				],
                'default' => '#ffffff'
			]
		);

        $this->add_control(
			'button_backcolor',
			[
				'label' => esc_html__( 'Button background-color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .add-button' => 'background-color: {{VALUE}}',
				],
                'default' => '#0063D1'
			]
		);
        
        
        $this->add_control(
			'button_width',
			[
				'label' => esc_html__( 'Button width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 100,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .product-item-footer > a' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'button_padding',
			[
				'label' => esc_html__( 'Button padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 0,
					'bottom' => 10,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .product-item-footer > a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'button_radius',
			[
				'label' => esc_html__( 'Button border-radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 5,
					'bottom' => 5,
					'left' => 5,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .product-item-footer > a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_style_section',
            [
                'label' => __( 'Slider', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
			'arrow',
			[
				'label' => esc_html__( 'Arrow', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'arrow_size',
			[
				'label' => esc_html__( 'Arrow font-size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 21,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-nav-button-group i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .swiper-nav-button-group svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'arrow_h_position',
			[
				'label' => esc_html__( 'Arrow horizontal position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => -150,
						'max' => 1000,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-nav-button-group' => (is_rtl() ? 'left: {{SIZE}}{{UNIT}};' : 'right: {{SIZE}}{{UNIT}};'),
				],
			]
		);

        $this->add_responsive_control(
			'arrow_v_position',
			[
				'label' => esc_html__( 'Arrow vertical position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => -150,
						'max' => 1000,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-nav-button-group' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'arrow_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-nav-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'arrow_color',
			[
				'label' => esc_html__( 'Icon color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-nav-button i' => 'color: {{VALUE}}',
					'{{WRAPPER}} .swiper-nav-button svg' => 'fill: {{VALUE}}',
				],
			]
		);
        
        $this->add_control(
			'pagination',
			[
				'label' => esc_html__( 'Pagination', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $pagination_style_default = 'border-radius: 100%';
        $pagination_style1 = 'border-radius: 5px;';

        $this->add_control(
			'pagination_styles',
			[
				'label' => esc_html__( 'Active pagination style', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => $pagination_style_default,
				'options' => [
					$pagination_style_default => esc_html__( 'Default', 'ahura' ),
					$pagination_style1 => esc_html__( 'Style 1', 'ahura' ),
				],
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => '{{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_style1_width',
			[
				'label' => esc_html__( 'Style1 width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 100,
						'step' => 1,
					],
				],
				'condition' => [ 'show_pagination' => 'yes', 'pagination_styles' => $pagination_style1 ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_vertical_position',
			[
				'label' => esc_html__( 'Pagination vertical position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -50,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_width',
			[
				'label' => esc_html__( 'Pagination size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 50,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'padgination_margin',
			[
				'label' => esc_html__( 'Pagination margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 5,
					'bottom' => 0,
					'left' => 5,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'active_pagination_color',
			[
				'label' => esc_html__( 'Active pagination color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'background-color:{{VALUE}};color:{{VALUE}}',
				],
			]
		);
        
        $this->add_control(
			'notactive_pagination_color',
			[
				'label' => esc_html__( 'Not-Active pagination color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet' => 'background-color:{{VALUE}};opacity:1',
				],
			]
		);

        $this->end_controls_section();

        $this->register_additional_controls();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $wid = $this->get_id();

        if (!\ahura\app\woocommerce::is_active()) {
            if(is_admin()) {
                ?>
                <div class="productcategorybox mw_elem_empty_box"><h3><?php _e('To use this element you must install or activate woocommerce plugin.', 'ahura'); ?></h3></div>
                <?php
            }
            return false;
        }

		if ( ! empty( $settings['meta_link_first']['url'] ) ) {
			$this->add_link_attributes( 'meta_link_first', $settings['meta_link_first'] );
		}

        if ( ! empty( $settings['meta_link_second']['url'] ) ) {
			$this->add_link_attributes( 'meta_link_second', $settings['meta_link_second'] );
		}

        $has_arrows = isset($settings['show_arrows']) && $settings['show_arrows'] == 'yes';
        $has_pagination = isset($settings['show_pagination']) && $settings['show_pagination'] == 'yes';
        $type = $settings['type'];

        $cats = $settings['catsid'];
        $field_is_term = (is_array($cats) && isset($cats[0]) && is_numeric($cats[0])) || is_int($cats);

        $args = [
            'post_type'		 => 'product',
            'post_status'	 => 'publish',
            'posts_per_page' => isset($settings['count']) ? $settings['count'] : 18,
        ];

        if($type === 'top'){
            $args['meta_key'] = 'total_sales';
            $args['orderby'] = 'meta_value_num';
            $args['order'] = 'DESC';
        } elseif($type === 'offer') {
            $args['meta_key'] = '_sale_price';
            $args['meta_value'] = '0';
            $args['meta_compare'] = '>';
        }

        if(!empty($cats)){
            $args['tax_query'][] = [
                'taxonomy'   => 'product_cat',
                'field'		 => $field_is_term ? 'term_id' : 'slug',
                'terms'		 => $cats,
            ];
        }

        $products_stock_status = isset($settings['products_stock_status']) ? $settings['products_stock_status'] : 'instock';

        if ($products_stock_status && $products_stock_status !== 'none') {
            $args['meta_query'] = array(array(
                'key' => '_stock_status',
                'value' => $products_stock_status,
                'compare' => '==',
            ));
        }

        $query = new \WP_Query($args);

        $ids = [];
        $counter = 0;
        $current_group = [];

        if($query->have_posts()){
            while ($query->have_posts()) {
                $query->the_post();
                $current_group[] = get_post(get_the_ID());
                $counter++;

                if ($counter % 2 === 0) {
                    $ids[] = $current_group;
                    $current_group = [];
                }
            }

            if (!empty($current_group)) {
                $ids[] = $current_group;
            }
            wp_reset_postdata();
        }

        $slider_data = [
            'widgetID' => '<?php echo $wid; ?>',
            'desktopPerView' => (isset($settings['slides_per_view']) && intval($settings['slides_per_view'])) ? $settings['slides_per_view'] : 3,
            'tabletPerView' => (isset($settings['slides_per_view_tablet']) && intval($settings['slides_per_view_tablet'])) ? $settings['slides_per_view_tablet'] : 2,
            'mobilePerView' => (isset($settings['slides_per_view_mobile']) && intval($settings['slides_per_view_mobile'])) ? $settings['slides_per_view_mobile'] : 1,
            'pagination' => $has_pagination,
            'arrows' => $has_arrows,
            'loop' => true,
            'autoplay' => $settings['autoplay'] == 'yes',
            'autoplayTimeout' => $settings['autoplay_delay'] ? $settings['autoplay_delay'] : 0,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];
        ?>
        <div class="shop-carousel6-wrap shop-carousel6-wrap-<?php echo $wid; ?>">
            <?php if ($settings['title']): ?>
            <div class="box-head">
                <div class="box-title">
                    <?php echo $settings['title']; ?>
                </div>
            </div>
            <?php endif; ?>
            <div class="products-list">
                <?php if (!empty($ids)): ?>
                <div class="swiper shop-carousel6-swiper" data-slider='<?php echo json_encode($slider_data) ?>'>
                    <?php if ($has_arrows): ?>
                        <div class="swiper-nav-button-group">
                            <div class="swiper-nav-button swiper-btn-prev">
                                <?php if($settings['arrow_prev_icon']): ?>
                                    <?php \Elementor\Icons_Manager::render_icon( $settings['arrow_prev_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                <?php else: ?>
                                    <i class="fas fa-angle-right"></i>
                                <?php endif; ?>
                            </div>
                            <div class="swiper-nav-button swiper-btn-next">
                                <?php if($settings['arrow_next_icon']): ?>
                                    <?php \Elementor\Icons_Manager::render_icon( $settings['arrow_next_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                <?php else: ?>
                                    <i class="fas fa-angle-left"></i>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="swiper-wrapper">
                        <?php foreach ($ids as $items): ?>
                            <div class="swiper-slide">
                                <?php foreach($items as $product): ?>
                                    <div class="product-item-wrap">
                                        <?php $product_object = wc_get_product($product->ID);
                                        if ($product_object):
                                            $categories = get_the_terms($product_object->get_id(), 'product_cat'); ?>
                                                <a href="<?php echo get_the_permalink($product_object->get_id()) ?>" class="product-item">
                                                    <div class="product-item-header">
                                                        <div class="item-cat">
                                                            <?php if ($categories && !is_wp_error($categories)) {
                                                                $i = 1;
                                                                foreach ($categories as $category) {
                                                                    echo '<span class="category">' . $category->name . '</span>';
                                                                    echo count($categories) === $i ? '' : ' / ';
                                                                    $i++;
                                                                }
                                                            } ?>
                                                        </div>
                                                    </div>
                                                </a>
                                                <div class="product-item-content">
                                                    <div class="product-img-container">
                                                        <?php echo wp_get_attachment_image(get_post_thumbnail_id($product_object->get_id()), $settings['image_thumbnail_size']); ?>
                                                    </div>
                                                    <div class="product-item-details">
                                                        <h2 class="title">
															<a href="<?php echo get_permalink($product_object->get_id()); ?>">
																<?php echo $product_object->get_title(); ?>
															</a>
                                                        </h2>
                                                        <p class="price">
                                                            <?php if($settings['price_prefix_text']): ?>
                                                                <span class="price-prefix">
                                                                    <?php echo $settings['price_prefix_text']; ?>
                                                                </span>
                                                            <?php endif; ?>
                                                            <?php echo wc_price($product_object->get_price()); ?>
                                                        </p>
                                                    </div>
                                                </div>
                                                <div class="product-item-footer">
                                                    <a href="<?php echo get_the_permalink($product_object->get_id()); ?>" class="add-button" role="button">
                                                        <?php echo $settings['add_cart_text']; ?>
                                                    </a>
                                                    <?php if($settings['show_product_meta'] == 'yes'): ?>
                                                        <div class="product-footer-meta">
                                                            <div class="meta-first">
                                                                <a <?php if(empty( $settings['meta_link_first']['url'] )) {
																		echo 'href="'.get_permalink($product_object->get_id()).'#tab-reviews'.'"';
																	} else {
																		echo $this->get_render_attribute_string( 'meta_link_first' );
																	}; ?>>
                                                                    <?php \Elementor\Icons_Manager::render_icon( $settings['product_meta_first'], [ 'aria-hidden' => 'true' ] ); ?>
                                                                </a>
                                                            </div>
                                                            <div class="meta-second">
																<a <?php if(empty( $settings['meta_link_second']['url'] )) {
																		echo 'href="'.get_permalink($product_object->get_id()).'#tab-reviews'.'"';
																	} else {
																		echo $this->get_render_attribute_string( 'meta_link_second' );
																	}; ?>>
                                                                    <?php \Elementor\Icons_Manager::render_icon( $settings['product_meta_second'], [ 'aria-hidden' => 'true' ] ); ?>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <?php if($has_pagination): ?>
                        <div class="swiper-pagination w-100"></div>
                    <?php endif; ?>
                </div>
                <?php else: ?>
                    <div class="ahura-element-not-found-msg">
                        <?php echo __('Sorry, no products found.', 'ahura') ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <?php
    }
}
