<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.

use ahura\app\traits\WoocommerceMethods;
use ahura\app\woocommerce;
use Elementor\Controls_Manager;
use ahura\app\mw_options;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\mw_assets;

class shop_carousel14 extends \ahura\app\elementor\Elementor_Widget_Base {
    use WoocommerceMethods;

    /**
     * shop_carousel4 constructor.
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('shop_carousel14_js', mw_assets::get_js('elementor.shop_carousel14'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('shop_carousel14_css', mw_assets::get_css('elementor.shop_carousel14'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('shop_carousel14_js')];
    }

    public function get_name() {
        return 'shopcarousel14';
    }

    public function get_title() {
        return __( 'Products Carousel 14', 'ahura' );
    }

    public function get_icon() {
        return 'aicon-svg-shop-carousel';
    }

    public function get_categories() {
        return [ 'ahuraelements','ahura_woocommerce' ];
    }
    function get_keywords()
    {
		return ['ahura', 'shop', 'product', 'products carousel', 'shop carousel 14', esc_html__( 'ahura' , 'ahura'), esc_html__( 'Products' , 'ahura'), esc_html__( 'Shop Carousel 14' , 'ahura')];
    }

    protected function register_controls() {
        if(!woocommerce::is_active())
        {
            return false;
        }

        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'ahura' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $categories = get_terms( array(
            'taxonomy' => 'product_cat',
            'hide_empty' => false,
        ));
        $cats       = array();
        if($categories){
            foreach ( $categories as $category ) {
                $cats[ $category->slug ] = $category->name;
            }
        }

        $this->add_control(
            'catsid',
            [
                'label'    => __( 'Categories', 'ahura' ),
                'type'     => Controls_Manager::SELECT2,
                'options'  => array_merge(
                    [ 'allproducts'  => esc_html__( 'All Products', 'ahura' ) ],
                    [ 'discountedproducts'  => esc_html__( 'Discounted Products', 'ahura' ) ],
                    [ 'randomproducts'  => esc_html__( 'Random Products', 'ahura' ) ],
                    $cats ),
                'label_block' => true,
                'multiple' => true,
                'default' => 'allproducts'
            ]
        );

		$this->add_control(
			'show_progress_bar',
			[
				'label' => esc_html__('Show progress bar', 'ahura'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Yes', 'ahura'),
				'label_off' => esc_html__('no', 'ahura'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        if(!mw_options::get_mod_is_active_save_product_initial_stock()) {
            $this->add_control(
                'sale_progress_notice',
                [
                    'type' => \Elementor\Controls_Manager::NOTICE,
                    'notice_type' => 'info',
                    'dismissible' => true,
                    'heading' => esc_html__( 'Sale Progress Notice', 'ahura' ),
                    'content' => esc_html__( 'Please consider: if you want to keep track of sales progress then should save the initial product stock quantity on Customization > WooCommerce > "Save/Remove product stock as initial stock" option.', 'ahura' ),
					'condition' => [ 'show_progress_bar' => 'yes' ]
                ]
            );
			
            $this->add_control(
                'label_remain_text',
                [
                    'label' => esc_html__( 'Remain text', 'ahura' ),
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => esc_html__( 'Remained', 'ahura' ),
					'condition' => [ 'show_progress_bar' => 'yes' ]
                ]
            );

            $this->add_control(
                'move_progress_label_end',
                [
                    'label' => esc_html__('Move progress label end', 'ahura'),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__('Yes', 'ahura'),
                    'label_off' => esc_html__('no', 'ahura'),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
        }

        $this->add_control(
            'read_more_text',
            [
                'label' => esc_html__( 'Read more text', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'View more', 'ahura' ),
            ]
        );

        $this->add_control(
            'move_price_first',
            [
                'label' => esc_html__('Move price first', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('no', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'show_rating',
            [
                'label' => esc_html__('Show rating', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('no', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        
        $this->add_control(
            'widget_title',
            [
                'label' => esc_html__( 'Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
			'title_icon',
			[
				'label' => esc_html__( 'Icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

        $this->add_control(
            'btn_text',
            [
                'label' => esc_html__( 'Button text', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'slider_section',
            [
                'label' => __( 'Slider', 'ahura' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides per view', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    1 => '1',
                    2 => '2',
                    3 => '3',
                    4 => '4',
                    5 => '5',
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => 3,
				'tablet_default' => 2,
				'mobile_default' => 1,
            ]
        );

        $this->add_control(
            'show_arrows',
            [
                'label' => esc_html__('Arrows', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'item_styles',
            [
                'label' => esc_html__('Item', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
			'item_general_options',
			[
				'label' => esc_html__( 'General', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'item_background_color',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .sc-item-content' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'item_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 10,
                    'bottom' => 10,
                    'right' => 10,
                    'left' => 10,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
				'selectors' => [
					'{{WRAPPER}} .sc-item-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'item_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 15,
                    'bottom' => 15,
                    'right' => 15,
                    'left' => 15,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
				'selectors' => [
					'{{WRAPPER}} .sc-item-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .sc-item-content',
            ]
        );

        $this->add_responsive_control(
			'content_direction',
			[
				'label' => esc_html__( 'Direction', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'row' => [
						'title' => esc_html__( 'Row', 'ahura' ),
						'icon' => 'eicon-arrow-left',
					],
					'column' => [
						'title' => esc_html__( 'Column', 'ahura' ),
						'icon' => 'eicon-arrow-up',
					],
					'row-reverse' => [
						'title' => esc_html__( 'Row reverse', 'ahura' ),
						'icon' => 'eicon-arrow-right',
					],
					'column-reverse' => [
						'title' => esc_html__( 'Column reverse', 'ahura' ),
						'icon' => 'eicon-arrow-down',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .sc-item-content' => 'flex-direction: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'content_width',
			[
				'label' => esc_html__( 'Content width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 70,
				],
				'selectors' => [
					'{{WRAPPER}} .product-content-area' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'thumbnail_options',
			[
				'label' => esc_html__( 'Thumbnail', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'thumbnail_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .img-container' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
        $this->add_responsive_control(
			'thumbnail_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .img-container' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'thumbnail_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 0,
                    'bottom' => 0,
                    'right' => is_rtl() ? 0 : 20,
                    'left' => is_rtl() ? 20 : 0,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
				'selectors' => [
					'{{WRAPPER}} .img-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'thumbnail_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 15,
                    'bottom' => 15,
                    'right' => 15,
                    'left' => 15,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
				'selectors' => [
					'{{WRAPPER}} .img-container img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'title_options',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'title_alignment',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .title-area h2' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .title-area h2' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .title-area h2',
                'fields_options' =>
				[
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '14'
						]
                    ],
                    'font_weight' => [
                        'default' => 'normal'
                    ]
				]
			]
		);
        
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 0,
                    'bottom' => 40,
                    'right' => 0,
                    'left' => 0,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
				'selectors' => [
					'{{WRAPPER}} .title-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'price_options',
			[
				'label' => esc_html__( 'price', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'price_alignment',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .price-wrap' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'price_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF7020',
				'selectors' => [
					'{{WRAPPER}} .price-wrap' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'sale_price_color',
			[
				'label' => esc_html__( 'Sale price color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#A7A7A7',
				'selectors' => [
					'{{WRAPPER}} .price-wrap del' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .price-wrap',
                'fields_options' =>
				[
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '14'
						]
                    ],
                    'font_weight' => [
                        'default' => 'bold'
                    ]
				]
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'sale_price_typography',
                'label' => esc_html__('Sale price typography', 'ahura'),
				'selector' => '{{WRAPPER}} .price-wrap del',
                'fields_options' =>
				[
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '13'
						]
                    ],
                    'font_weight' => [
                        'default' => 'normal'
                    ]
				]
			]
		);
        
        $this->add_responsive_control(
			'price_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .price-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'rating_options',
			[
				'label' => esc_html__( 'Rating', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'rate_color',
			[
				'label' => esc_html__( 'Star color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF7020',
				'selectors' => [
					'{{WRAPPER}} .rating i' => 'color: {{VALUE}}',
				],
			]
		);
        
        $this->add_responsive_control(
			'rate_margin',
			[
				'label' => esc_html__( 'Star margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .rating i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'rate_text_color',
			[
				'label' => esc_html__( 'Text color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rating .voted' => 'color: {{VALUE}}',
				],
			]
		);
        
        $this->add_responsive_control(
			'rate_text_margin',
			[
				'label' => esc_html__( 'Text margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .rating .voted' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'rate_text_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .rating .voted',
			]
		);

        $this->add_control(
			'btn_options',
			[
				'label' => esc_html__( 'Button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'btn_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF7020',
				'selectors' => [
					'{{WRAPPER}} .btn-wrapper a' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'btn_background_color',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
				'selectors' => [
					'{{WRAPPER}} .btn-wrapper' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'btn_border_color',
			[
				'label' => esc_html__( 'Border color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF7020',
				'selectors' => [
					'{{WRAPPER}} .btn-wrapper' => 'border: 1px solid {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'btn_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .btn-wrapper a',
			]
		);
        
        $this->add_responsive_control(
			'btn_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .btn-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'btn_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .btn-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'btn_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .btn-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'progress_label_options',
			[
				'label' => esc_html__( 'Progress label', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'progress_label_alignment',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Start', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
					'space-between' => [
						'title' => esc_html__( 'Space between', 'ahura' ),
						'icon' => 'eicon-text-align-justify',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'end' => [
						'title' => esc_html__( 'End', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
                'default' => 'space-between',
				'selectors' => [
					'{{WRAPPER}} .progress-label' => 'justify-content: {{VALUE}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'progress_label_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 0,
                    'bottom' => 10,
                    'right' => 0,
                    'left' => 0,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
				'selectors' => [
					'{{WRAPPER}} .progress-label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'current_stock_color',
			[
				'label' => esc_html__( 'Stock color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#A7A7A7',
				'selectors' => [
					'{{WRAPPER}} .current-stock' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'current_stock_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .current-stock',
                'fields_options' =>
				[
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '15'
						]
                    ],
                    'font_weight' => [
                        'default' => 'normal'
                    ]
				]
			]
		);

        $this->add_control(
			'progress_bar_options',
			[
				'label' => esc_html__( 'Progress bar', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'progress_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF7020',
				'selectors' => [
					'{{WRAPPER}} .progress_bar' => 'background-color: {{VALUE}}',
				],
			]
		);
        
        $this->add_control(
			'progress_background_color',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFD6BE',
				'selectors' => [
					'{{WRAPPER}} .progress_bar-wrapper' => 'background-color: {{VALUE}}',
				],
			]
		);
        
        $this->add_responsive_control(
			'bar_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 40,
                    'bottom' => 40,
                    'right' => 40,
                    'left' => 40,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
				'selectors' => [
					'{{WRAPPER}} .progress_bar-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'bar_height',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .progress_bar-wrapper' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'heading_styles',
            [
                'label' => esc_html__('Heading', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
			'heading_general_option',
			[
				'label' => esc_html__( 'General', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_responsive_control(
			'heading_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 0,
                    'bottom' => 20,
                    'right' => 0,
                    'left' => 0,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
				'selectors' => [
					'{{WRAPPER}} .shop-carousel14-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'heading_title_option',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_control(
			'heading_title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slider-title h2' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'heading_title_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .slider-title h2',
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'read_more_styles',
            [
                'label' => esc_html__('Read more', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );
        
        $this->add_control(
			'read_more_color',
			[
				'label' => esc_html__( 'Stock color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .read-more' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'read_more_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .read-more',
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'slider_styles',
            [
                'label' => esc_html__('Slider', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
			'pagination_option',
			[
				'label' => esc_html__( 'Pagination', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'dot_color',
			[
				'label' => esc_html__( 'Dot color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'dot_size',
			[
				'label' => esc_html__( 'Dot size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'dot_radius',
			[
				'label' => esc_html__( 'Dot border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'active_dot_color',
			[
				'label' => esc_html__( 'Active dot color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'active_dot_size',
			[
				'label' => esc_html__( 'Active dot width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'active_dot_radius',
			[
				'label' => esc_html__( 'Active dot radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 5,
                    'bottom' => 5,
                    'right' => 5,
                    'left' => 5,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'dot_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 5,
                    'bottom' => 5,
                    'right' => 5,
                    'left' => 5,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'nav_option',
			[
				'label' => esc_html__( 'Navigation', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_control(
			'nav_border_color',
			[
				'label' => esc_html__( 'Border color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-nav-button' => 'border: 1px solid {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'nav_btn_size',
			[
				'label' => esc_html__( 'Button size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
                        'step' => 1
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-nav-button' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'nav_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 100,
                    'bottom' => 100,
                    'right' => 100,
                    'left' => 100,
                    'unit' => '%',
                    'isLinked' => true,
                ],
				'selectors' => [
					'{{WRAPPER}} .swiper-nav-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'nav_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 10,
                    'bottom' => 10,
                    'right' => 10,
                    'left' => 10,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
				'selectors' => [
					'{{WRAPPER}} .swiper-nav-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'nav_icon_color',
			[
				'label' => esc_html__( 'Icon color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-nav-button i' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'nav_icon_size',
			[
				'label' => esc_html__( 'Icon size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
                        'step' => 1
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-nav-button i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->register_additional_controls();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $has_paginate = ($settings['show_pagination'] == 'yes');
        $has_arrows = ($settings['show_arrows'] == 'yes');
    
        if ( class_exists( 'WooCommerce' ) ) {
    
            $field_is_term = (is_array($settings['catsid']) && is_numeric($settings['catsid'][0])) || is_int($settings['catsid']);
            $cats_id = $settings['catsid'];
    
            $args = [
                'post_type'      => 'product',
                'post_status'    => 'publish',
                'tax_query'      => [[
                    'taxonomy' => 'product_type',
                    'field'    => 'slug',
                    'terms'    => 'simple',
                ]],
            ];
    
            if($cats_id == 'allproducts' || ($cats_id[0] == 'allproducts') || $cats_id[0] == 'randomproducts') {
                $args = array_merge($args, [
                    'orderby' => $cats_id[0] == 'randomproducts' ? 'rand' : 'ASC'
                ]);
            } elseif($cats_id[0] == 'discountedproducts') {
                $args = array_merge($args, [
                    'meta_key'       => '_sale_price',
                    'meta_value'     => '0',
                    'meta_compare'   => '>='
                ]);
            } else {
                $args = array_merge($args, [
                    'tax_query'      => [[
                        'taxonomy'   => 'product_cat',
                        'field'      => $field_is_term ? 'term_id' : 'slug',
                        'terms'      => $cats_id,
                    ]],
                ]);
            }
    
            $slider_data = [
                'desktopPerView' => (isset($settings['slides_per_view']) && intval($settings['slides_per_view'])) ? $settings['slides_per_view'] : 3,
                'tabletPerView' => (isset($settings['slides_per_view_tablet']) && intval($settings['slides_per_view_tablet'])) ? $settings['slides_per_view_tablet'] : 2,
                'mobilePerView' => (isset($settings['slides_per_view_mobile']) && intval($settings['slides_per_view_mobile'])) ? $settings['slides_per_view_mobile'] : 1,
                'pagination' => $has_paginate,
                'arrows' => $has_arrows,
                'observer' => $settings['use_observer_slider'] == 'yes',
                'widgetID' => $wid
            ];            
    
            $wc_query = new \WP_Query($args);
            if ($wc_query->have_posts()) : ?>
                <div class="shop-carousel14-wrap">
                    <div class="swiper swiper-shop-carousel14 swiper-shop-carousel14-<?php echo $wid; ?>" data-slider='<?php echo json_encode($slider_data) ?>'>
                        <div class="d-flex justify-content-between align-items-center shop-carousel14-heading">
                            <?php if(!empty($settings['widget_title'])): ?>
                                <div class="d-flex align-items-center slider-title">
                                    <?php if(!empty($settings['title_icon']['value'])): ?>
                                        <span>
                                            <?php \Elementor\Icons_Manager::render_icon( $settings['title_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        </span>
                                    <?php endif; ?>
                                    <h2 class="<?php echo is_rtl() ? ' mr-2' : ' ml-2'; ?>"><?php echo $settings['widget_title']; ?></h2>
                                </div>
                            <?php endif; ?>
                            <?php if($has_arrows): ?>
                                <div class="d-flex justify-content-center align-items-center swiper-nav-area">
                                    <div class="d-flex justify-content-center align-items-center swiper-nav-button swiper-btn-prev"><i class="fas fa-angle-right"></i></div>
                                    <div class="d-flex justify-content-center align-items-center swiper-nav-button swiper-btn-next"><i class="fas fa-angle-left"></i></div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="swiper-wrapper">
                            <?php while ( $wc_query->have_posts() ) : $wc_query->the_post();
                                $product = wc_get_product(get_the_ID());
                                $product_image_url = get_the_post_thumbnail_url(get_the_ID(), 'full'); ?>
                                <div class="swiper-slide">
                                    <div class="d-flex justify-content-center align-items-center sc-item-content">
                                        <div class="img-container">
                                            <img class="d-flex justify-content-center align-content-center" src="<?php echo esc_url($product_image_url); ?>" alt="<?php echo __('Product Image', 'ahura'); ?>">
                                        </div>
                                        <div class="product-content-area">
                                            <?php if($settings['move_price_first'] === 'yes'): ?>
                                                <div class="price-wrap">
                                                    <?php echo $product->get_price_html(); ?>
                                                </div>
                                            <?php endif; ?>
                                            <div class="title-area">
                                                <a href="<?php echo esc_url(get_permalink()); ?>">
                                                    <h2><?php echo $product->get_title(); ?></h2>
                                                </a>
                                            </div>
                                            <?php if(mw_options::get_mod_is_active_save_product_initial_stock() && $settings['show_progress_bar'] === 'yes'): ?>
                                                <div class="sale-progress<?php echo isset($settings['move_progress_label_end']) && $settings['move_progress_label_end'] === 'yes' ? ' d-flex flex-column-reverse' : ''; ?>">
                                                    <?php
                                                    $initial_stock = get_post_meta(get_the_ID(), 'ah_initial_product_stock_quantity', true);
                                                    $sales = get_post_meta(get_the_ID(), 'ah_product_sales', true);
                                                    $current_stock = $product->get_stock_quantity() !== null ? $product->get_stock_quantity() : null;
                                                    ?>
                                                    <div class="d-flex align-items-center progress-label">
                                                        <?php if($settings['move_price_first'] !== 'yes'): ?>
                                                            <div class="price-wrap">
                                                                <?php echo $product->get_price_html(); ?>
                                                            </div>
                                                        <?php endif; ?>
                                                        <?php if(!empty($current_stock)): ?>
                                                            <span class="current-stock">
                                                                <span class="current-stock-label"><?php echo $current_stock; ?></span>
                                                                <span class="current-stock-value"><?php echo $settings['label_remain_text'] ? $settings['label_remain_text'] : ''; ?></span>
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                    <?php
                                                    if($initial_stock !== '' && $current_stock > 0):
                                                        $sales = (int)$sales;
                                                        $initial_stock = (int)$initial_stock; ?>
                                                        <?php if($sales === 0): ?>
                                                            <div class="progress_bar-wrapper">
                                                                <div class="progress_bar" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width:0%">
                                                                </div>
                                                            </div>
                                                        <?php else: ?>
                                                            <?php $progressed = (($initial_stock - $current_stock) * 100) / $initial_stock; ?>
                                                            <div class="progress_bar-wrapper">
                                                                <div class="progress_bar" role="progressbar" aria-valuenow="<?php echo $progressed; ?>" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo $progressed; ?>%">
                                                                </div>
                                                            </div>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>
                                            <?php else: ?>
                                                <div class="d-flex flex-column-reverse price-wrap">
                                                    <?php echo $product->get_price_html(); ?>
                                                </div>
                                            <?php endif; ?>
											<?php if($settings['show_rating'] === 'yes'):
												$average_rating = $product->get_average_rating(); ?>
												<div class="d-flex align-items-center rating m-0" title="<?php echo sprintf(__('Rated %s out of 5', 'ahura'), $average_rating); ?>">
													<span>
														<?php
														$full_stars = floor($average_rating);

														for ($i = 0; $i < $full_stars; $i++) {
															echo '<i class="fas fa-star"></i>';
														}
														?>
													</span>
													<?php if($product->get_rating_count() > 0): ?>
														<span class="voted">
															<?php echo '(' . $product->get_rating_count() . ')'; ?>
														</span>
													<?php endif; ?>
												</div>
											<?php endif; ?>
                                            <?php if(!empty($settings['btn_text'])): ?>
                                                <div class="btn-wrapper">
                                                    <a href="<?php echo esc_url(get_permalink()); ?>">
                                                        <?php echo $settings['btn_text']; ?>
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile; ?>
                        </div>
                        <?php if(!empty($settings['read_more_text'])): ?><div class="d-flex justify-content-between align-items-center foot-area"><?php endif; ?>
                        <?php if($has_paginate): ?>
                            <div class="swiper-pagination"></div>
                        <?php endif; ?>
                        <?php if(!empty($settings['read_more_text'])): ?>
                                <span class="read-more">
                                        <?php echo $settings['read_more_text']; ?>
                                </span>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php wp_reset_postdata(); ?>
            <?php else: ?>
                <div class="mw_element_error">
                    <?php echo __('Nothing found. Edit the page with Elementor and select a category for this section.','ahura');?>
                </div>
            <?php endif; ?>
            <div class="clear"></div>
            <?php
        }
    }    
    
}