<?php
namespace ahura\inc\widgets;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

class search_input extends \ahura\app\elementor\Elementor_Widget_Base {
    public function __register_assets()
    {
        $this->register_elementor_style('search_input', mw_assets::get_css('elementor.search_input'));
    }

    public function get_name() {
		return 'search_input';
	}

	public function get_title() {
		return __( 'Search Input', 'ahura' );
	}

	public function get_icon() {
		return 'aicon-svg-search-input';
	}

	public function get_categories() {
		return [ 'ahuraelements' ];
	}
	function get_keywords()
	{
		return ['ahura', 'search', 'search input', esc_html__('ahura', 'ahura'), esc_html__('search', 'ahura'), esc_html__( 'Search Input' , 'ahura')];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
        );
        
		$this->add_control(
			'button_text',
			[
				'label'    => __( 'Button Text', 'ahura' ),
				'type'     => \Elementor\Controls_Manager::TEXT,
				'default' => __("Search", 'ahura')
			]
		);

        $this->add_control(
			'icon',
			[
				'label' => esc_html__( 'Icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

		$this->add_control(
			'input_placeholder',
			[
				'label'   => __( 'Placeholder', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => __('e.g. Best burger in this city', 'ahura')
			]
		);

        $post_types = get_post_types(array('public' => true), 'objects');
        unset($post_types['attachment']);
        $types = array('all' => __('All', 'ahura'));
        foreach ($post_types as $post_type) {
            $types[$post_type->name] = $post_type->labels->singular_name;
        }

        $this->add_control(
            'post_type',
            [
                'label' => esc_html__('Post Type', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'default' => 'all',
                'options' => $types,
            ]
        );

        $this->add_control(
            'show_category',
            [
                'label' => esc_html__( 'Show Categories', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'ahura' ),
                'label_off' => esc_html__( 'No', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['post_type' => 'product']
            ]
        );

        $this->add_control(
			'input_icon',
			[
				'label' => esc_html__( 'Input icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

        $this->add_control(
			'responsive_nowrap',
			[
				'label' => esc_html__( 'No wrap on responsive', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'ahura' ),
				'label_off' => esc_html__( 'No', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
			'show_description_icon',
			[
				'label' => esc_html__( 'Description icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'desc_icon',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );

        $this->add_control(
            'icon_list',
            [
                'label' => esc_html__('Icon list', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'condition' => [ 'show_description_icon' => 'yes' ],
            ]
        );
		
		$this->end_controls_section();
        /**
         *
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'btn_styles',
            [
                'label' => __( 'Button', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
			'button_width',
			[
				'label' => esc_html__( 'Button width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 300,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .search_elem button' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} .search_elem_btn',
			]
		);

        $this->add_control(
            'button_color',
            [
                'label'   => __( 'Button color', 'ahura' ),
                'type'    => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    "{{WRAPPER}} .search_elem_btn" => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'button_background',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .search_elem_btn',
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#61ce70'],
                ]
            ]
        );

        $this->add_responsive_control(
            'btn_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .search_elem_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 5,
                    'right' => 5,
                    'bottom' => 5,
                    'left' => 5,
                ]
            ]
        );

        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .search_elem_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 20,
                    'right' => 40,
                    'bottom' => 20,
                    'left' => 40,
                ]
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label'   => __( 'Icon color', 'ahura' ),
                'type'    => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    "{{WRAPPER}} .search_elem_btn svg" => 'color: {{VALUE}}',
                    "{{WRAPPER}} .search_elem_btn svg" => 'fill: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
			'icon_width',
			[
				'label' => esc_html__( 'Icon width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .search_elem_btn svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .search_elem_btn',
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'box_styles',
            [
                'label' => __( 'Box', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'input_typography',
				'selector' => '{{WRAPPER}} .search_elem input',
			]
		);

        $this->add_control(
            'box_text_color',
            [
                'label'   => __( 'Text color', 'ahura' ),
                'type'    => \Elementor\Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    "{{WRAPPER}} .search_elem input" => 'color: {{VALUE}}'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'box_background',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .search_elem',
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#fff'],
                ]
            ]
        );

        $this->add_control(
            'box_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .search_elem' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 5,
                    'right' => 5,
                    'bottom' => 5,
                    'left' => 5,
                ]
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .search_elem' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 10,
                    'right' => 15,
                    'bottom' => 10,
                    'left' => 15,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'wrap_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .search_elem',
                'fields_options' => [
                    'box_shadow_type' => ['default' => 'yes'],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical' => 0,
                            'blur' => 20,
                            'spread' => 0,
                            'color' => '#0000000f'
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'box_border_color',
            [
                'label'   => __( 'Box border color', 'ahura' ),
                'type'    => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff00',
                'selectors' => [
                    "{{WRAPPER}} .search_elem" => 'border-style: solid; border-color: {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
			'border_width',
			[
				'label' => esc_html__( 'Box border width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .search_elem' => 'border-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'categories_area_width',
			[
				'label' => esc_html__( 'Categories width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 400,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 140,
				],
				'selectors' => [
					'{{WRAPPER}} .categories-selector select' => 'width: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'post_type' => 'product' ]
			]
		);

        $this->add_control(
			'description_icon_options',
			[
				'label' => esc_html__( 'Description icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [ 'show_description_icon' => 'yes' ],
			]
		);

        $this->add_control(
			'desc_icon_size',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
                'condition' => [ 'show_description_icon' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .description-icon-container svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'desc_icon_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [ 'show_description_icon' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .description-icon-container svg' => 'color: {{VALUE}}',
					'{{WRAPPER}} .description-icon-container svg' => 'fill: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'desc_icon_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => is_rtl() ? 0 : 5,
					'bottom' => 0,
					'left' => is_rtl() ? 5 : 0,
					'unit' => 'px',
					'isLinked' => false,
				],
                'condition' => [ 'show_description_icon' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .description-icon-container svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->register_additional_controls();
	}

	protected function render() {
        $settings = $this->get_settings_for_display();
        $btn_text = $settings['button_text'];
		$place_holder = $settings['input_placeholder'];
        $post_type = $settings['post_type'];
        $description_icon_exist = $settings['show_description_icon'] && $settings['icon_list'] ? true : false;
        ?>
        <div class="search_elem ah-has-bg">
            <form <?php echo $settings['responsive_nowrap'] === 'yes' ? 'class="no-wrap"' : ''; ?> action="<?php echo home_url() ?>" method="get"<?php echo $description_icon_exist ? ' class="flex-column align-items-start"' : ''; ?>>
                <?php if ($post_type == 'product' && $settings['show_category'] == 'yes'): ?>
                    <div class="categories-selector">
                        <select name="product_cat">
                            <option value=""><?php echo __('All Categories', 'ahura'); ?></option>
                            <?php if(\ahura\app\woocommerce::is_active()): ?>
                                <?php $product_categories = get_terms( [ 'taxonomy' => 'product_cat', 'hide_empty' => true ] );
                                foreach ($product_categories as $category) {
                                    echo '<option value="' . esc_attr($category->slug) . '">' . esc_html($category->name) . '</option>';
                                } ?>
                            <?php endif; ?>
                        </select>
                    </div>
                <?php endif; ?>
                <?php if($settings['input_icon']['value']): ?>
                    <div class="d-flex justify-content-center align-items-center input-icon-wrapper">
                        <?php \Elementor\Icons_Manager::render_icon( $settings['input_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    </div>
                <?php endif; ?>
                <input type="text" name="s" placeholder="<?php echo $place_holder; ?>" class="ah-has-text" />
                <?php if($description_icon_exist): ?>
                    <div class="d-flex justify-content-between align-items-center description-container mt-5 w-100">
                        <div class="d-flex description-icon-container">
                            <?php foreach ( $settings['icon_list'] as $item ): ?>
                                <li class="elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?>">
                                    <?php \Elementor\Icons_Manager::render_icon( $item['desc_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                </li>
                            <?php endforeach; ?>
                        </div>
                <?php endif; ?>
                    <button type="submit" class="d-flex justify-content-center align-items-center search_elem_btn ah-is-button">
                        <?php if($settings['icon']['value']): ?>
                            <?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        <?php else: ?>
                            <?php echo $btn_text?>
                        <?php endif; ?>
                    </button>
                <?php if($description_icon_exist): ?></div><?php endif; ?>
                <?php if (!empty($post_type) && $post_type !== 'all'): ?>
                    <input type="hidden" name="post_type" value="<?php echo $settings['post_type'] ?>">
                <?php endif; ?>
            </form>
        </div>
        <?php
	}

}
