<?php
namespace ahura\inc\widgets;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

class progress_bar extends \ahura\app\elementor\Elementor_Widget_Base {
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_script('progress_bar_js', mw_assets::get_js('elementor.progress_bar'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('progress_bar', mw_assets::get_css('elementor.progress_bar'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('progress_bar_js')];
    }

    public function get_name() {
        return 'ah_progress_bar';
    }

    public function get_title() {
        return __( 'Progress Bar', 'ahura' );
    }

    public function get_icon() {
        return 'eicon-skill-bar';
    }

    public function get_categories() {
        return [ 'ahuraelements' ];
    }
    function get_keywords()
    {
        return ['ahura', 'progress bar', esc_html__('ahura', 'ahura'), esc_html__('progress', 'ahura'), esc_html__('progress bar', 'ahura')];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'progress_percent',
            [
                'label'    => __( 'Progress Percent', 'ahura' ),
                'type'     => \Elementor\Controls_Manager::NUMBER,
                'default' => 35,
                'min' => 0,
                'max' => 100
            ]
        );

        $this->add_control(
            'show_dot',
            [
                'label' => esc_html__('Show Dot', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();
        /**
         *
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'bar_style_section',
            [
                'label' => __( 'Progress Bar', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'bar_bg',
                'selector' => '{{WRAPPER}} .p-bar-line',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#555']
                ]
            ]
        );

        $this->add_control(
            'dot_color',
            [
                'label' => esc_html__('Dot Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#555',
                'selectors' => [
                    '{{WRAPPER}} .bar-dot' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'show_dot' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'bar_wrap_border',
                'selector' => '{{WRAPPER}} .p-bar',
                'fields_options' => [
                    'border' => ['default' => 'solid'],
                    'width' => ['default' =>
                        [
                            'unit' => 'px',
                            'top' => 2,
                            'right' => 2,
                            'bottom' => 2,
                            'left' => 2,
                        ]
                    ],
                    'color' => ['default' => '#555']
                ]
            ]
        );

        $this->add_responsive_control(
            'bar_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50
                ],
                'selectors' => [
                    '{{WRAPPER}} :is(.p-bar, .p-bar-line)' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'bar_wrap_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .p-bar' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 4,
                    'right' => 4,
                    'bottom' => 4,
                    'left' => 4,
                    'unit' => 'px'
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        ?>
        <div class="ah-progress-bar-element">
            <div class="p-bar">
                <div class="p-bar-line" data-progress-percent="<?php echo $settings['progress_percent'] ?? 0 ?>">
                    <?php if ($settings['show_dot'] == 'yes'): ?>
                        <span class="bar-dot"></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
    }
}
