<?php
namespace ahura\inc\widgets;

// Die if is direct opened file
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use \ahura\app\mw_assets;

class product_tab4 extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_script('product_tab4_js', mw_assets::get_js('elementor.product_tab4'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('product_tab4_css', mw_assets::get_css('elementor.product_tab4'));
        if(!is_rtl()){
            $this->register_elementor_style('product_tab4_ltr_css', mw_assets::get_css('elementor.ltr.product_tab4_ltr'));
        }
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('product_tab4_js')];
    }

    /**
     *
     * Set element id
     *
     * @return string
     */
    public function get_name()
    {
        return 'product_tab4';
    }

    /**
     *
     * Set element widget
     *
     * @return mixed
     */
    public function get_title()
    {
        return esc_html__('Product Tab 4', 'ahura');
    }

    /**
     *
     * Set widget icon
     *
     */
    public function get_icon()
    {
        return 'aicon-svg-product-tab';
    }

    /**
     *
     * Set element category
     *
     * @return string[]
     */
    public function get_categories()
    {
        return ['ahuraelements','ahura_woocommerce'];
    }

    /**
     *
     * Keywords for search
     *
     * @return array
     */
    function get_keywords()
    {
        return ['ahura', 'product', 'product tab 4', esc_html__('ahura', 'ahura'), esc_html__('product', 'ahura'), esc_html__('Product tab 4', 'ahura')];
    }

    /**
     *
     * Element controls option
     *
     */
    public function register_controls()
    {
        /**
         *
         *
         * Start content
         *
         */
        $this->start_controls_section(
            'tabs_content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'item_title',
            [
                'label' => esc_html__('Title', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Tab Title', 'ahura'),
            ]
        );

        $taxonomies = get_taxonomies([
            'public' => true,
            'name' => 'product_cat',
        ], 'objects');

        $cats = array();
        if ($taxonomies) {
            foreach ($taxonomies as $key => $taxonomy) {
                if ($term_object = get_terms($key)) {
                    if($term_object){
                        foreach ($term_object as $term) {
                            $cats[$term->term_id] = "{$term->name} - {$taxonomy->labels->name}";
                        }
                    }
                }
            }
        }
        $repeater->add_control(
            'cat_id',
            [
                'label' => esc_html__('Category', 'ahura'),
                'type' => Controls_Manager::SELECT2,
                'options' => $cats,
                'label_block' => true,
                'multiple' => false,
            ]
        );

        $repeater->add_control(
            'per_page',
            [
                'label' => esc_html__('Products Count', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 8,
                'min' => 1,
            ]
        );

        $this->add_control(
            'tab_items',
            [
                'label' => esc_html__('Items', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{item_title}}}',
                'default' => [
                    [
                        'item_title' => esc_html__('All', 'ahura'),
                    ]
                ]
            ]
        );

        $this->add_control('divider1', ['type' => Controls_Manager::DIVIDER]);

        $this->add_responsive_control(
            'layout_col',
            [
                'label' => esc_html__('Columns', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'default' => 3,
                'options' => [
                    '12' => 1,
                    '6' => 2,
                    '4' => 3,
                    '3' => 4,
                ]
            ]
        );

        $this->add_control(
            'item_btn_icon',
            [
                'label' => esc_html__( 'Button Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'skin' => 'inline',
                'default' => [
                    'value' => 'fas fa-angle-right',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'item_cover',
                'default' => 'full',
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
		
		$this->add_control(
            'show_excerpt',
            [
                'label' => esc_html__('Show Excerpt', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'only_in_stock',
            [
                'label' => esc_html__('Only instock products', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();
        /**
         *
         *
         * Start Styles
         *
         */
        $this->start_controls_section(
            'items_style',
            [
                'label' => esc_html__('Item', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_img_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 400
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-cover' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .product-cover img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
		
		$this->add_control(
            'item_shadow_color',
            [
                'label' => esc_html__('Shadow Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => 'rgba(0,0,0, 0.5)',
                'selectors' => [
                    '{{WRAPPER}} .product-item .pt-overly' => 'background: linear-gradient(180deg, rgba(0, 0, 0, 0) 0%, {{VALUE}} 60%)',
                ],
            ]
        );

        $this->add_control(
            'item_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .product-item .p-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_title_typo',
                'selector' => '{{WRAPPER}} .product-item .p-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '20'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '600'
                    ],
                ]
            ]
        );

        $this->add_control(
            'item_price_color',
            [
                'label' => esc_html__('Price Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .product-item .p-item-price' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_price_typo',
                'selector' => '{{WRAPPER}} .product-item .p-item-price *',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '400'
                    ],
                ]
            ]
        );

        $this->add_control(
            'item_excerpt_color',
            [
                'label' => esc_html__('Excerpt Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .product-item .p-excerpt p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_excerpt_typo',
                'selector' => '{{WRAPPER}} .product-item .p-excerpt p',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '14'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '400'
                    ],
                ]
            ]
        );

        $this->add_responsive_control(
            'item_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .product-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 35,
                    'right' => 35,
                    'bottom' => 35,
                    'left' => 35,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .product-item',
            ]
        );

        $this->add_control(
            'btn_style_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'item_btn_icon_size',
            [
                'label' => esc_html__('Icon Size', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 150
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 25
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-item .item-main-btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .product-item .item-main-btn svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_btn_icon_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .product-item .item-main-btn i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .product-item .item-main-btn :is(svg, svg path)' => 'fill: {{VALUE}};stroke: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_btn_color',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .product-item .item-main-btn',
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#8b8a34']
                ]
            ]
        );

        $this->add_responsive_control(
            'item_btn_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .product-item .item-main-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'tab_items_style',
            [
                'label' => esc_html__('Tabs', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('style_tabs');
        $this->start_controls_tab('style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_control(
            'item_tab_title_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#7e7e7e',
                'selectors' => [
                    '{{WRAPPER}} .pt-tab-items ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_tab_typo',
                'selector' => '{{WRAPPER}} .pt-tab-items ul li a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '400'
                    ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_tab_title_bg_color',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .pt-tab-items ul li a',
            ]
        );

        $this->add_responsive_control(
            'item_tab_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .pt-tab-items ul li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_tab_border',
                'selector' => '{{WRAPPER}} .pt-tab-items ul li a',
                'fields_options' => [
                    'border' => ['default' => 'solid'],
                    'width' => ['default' =>
                        [
                            'unit' => 'px',
                            'top' => 1,
                            'right' => 1,
                            'bottom' => 1,
                            'left' => 1,
                        ]
                    ],
                    'color' => ['default' => '#7e7e7e']
                ]
            ]
        );

        $this->add_responsive_control(
            'item_tab_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .pt-tab-items ul li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => false,
                    'top' => 8,
                    'right' => 20,
                    'bottom' => 8,
                    'left' => 20,
                ]
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('style_active_tab', ['label' => esc_html__( 'Active', 'ahura' )]);

        $this->add_control(
            'item_tab_title_color_active',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .pt-tab-items ul .active a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_tab_title_bg_color_active',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .pt-tab-items ul .active a',
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#8b8a34']
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_tab_border_active',
                'selector' => '{{WRAPPER}} .pt-tab-items ul .active a',
                'fields_options' => [
                    'border' => ['default' => 'solid'],
                    'width' => ['default' =>
                        [
                            'unit' => 'px',
                            'top' => 1,
                            'right' => 1,
                            'bottom' => 1,
                            'left' => 1,
                        ]
                    ],
                    'color' => ['default' => '#8b8a34']
                ]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'search_style',
            [
                'label' => esc_html__('Search', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'search_icon_color',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .box-search i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .box-search :is(svg, svg path)' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'search_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#7e7e7e',
                'selectors' => [
                    '{{WRAPPER}} .box-search input' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'search_typo',
                'selector' => '{{WRAPPER}} .box-search input',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '400'
                    ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'search_bg_color',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .box-search input',
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#ffffff']
                ]
            ]
        );

        $this->add_responsive_control(
            'search_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .box-search input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'search_border',
                'selector' => '{{WRAPPER}} .box-search input',
                'fields_options' => [
                    'border' => ['default' => 'solid'],
                    'width' => ['default' =>
                        [
                            'unit' => 'px',
                            'top' => 1,
                            'right' => 1,
                            'bottom' => 1,
                            'left' => 1,
                        ]
                    ],
                    'color' => ['default' => '#7e7e7e']
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'sort_filter_style',
            [
                'label' => esc_html__('Filter', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'filter_icon_color',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .box-sort i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .box-sort :is(svg, svg path)' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'filter_text_color',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#8b8a34',
                'selectors' => [
                    '{{WRAPPER}} .box-sort select' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'filter_typo',
                'selector' => '{{WRAPPER}} .box-sort select',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '400'
                    ],
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'paginate_styles',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['show_pagination' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'paginate_bg',
                'selector' => '{{WRAPPER}} .element-pagination',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#e7e7e7']
                ]
            ]
        );

        $this->start_controls_tabs('paginate_style_tabs');
        $this->start_controls_tab('paginate_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' ),]);

        $this->add_control(
            'paginate_item_color',
            [
                'label' => esc_html__( 'Item Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .element-pagination :is(a, span)' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'paginate_item_bg',
                'selector' => '{{WRAPPER}} .element-pagination :is(a, span)',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => 'rgba(251, 193, 81, 1)']
                ]
            ]
        );

        $this->add_responsive_control(
            'paginate_item_radius',
            [
                'label' => esc_html__( 'Border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'default' => [
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .element-pagination :is(a, span)' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('paginate_style_active_tab', ['label' => esc_html__( 'Active', 'ahura' ),]);

        $this->add_control(
            'paginate_item_active_color',
            [
                'label' => esc_html__( 'Active Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .element-pagination span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'paginate_item_active_bg',
                'selector' => '{{WRAPPER}} .element-pagination span',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => 'rgba(139, 138, 52, 1)']
                ]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    /**
     *
     * Render element content (html)
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $items = $settings['tab_items'];

        if(!\ahura\app\woocommerce::is_active()){
            return false;
        }

        $tab = isset($_GET['current_tab']) && intval($_GET['current_tab']) ? sanitize_text_field($_GET['current_tab']) : null;
        $page = isset($_GET['page_num']) && $_GET['page_num'] > 1 ? sanitize_text_field($_GET['page_num']) : 1;
        $sort = isset($_GET['sort']) && !empty($_GET['sort']) && intval($_GET['sort']) ? sanitize_text_field($_GET['sort']) : 1;
        $cat = isset($_GET['tab_cat']) && !empty($_GET['tab_cat']) && $_GET['tab_cat'] != 'all' ? sanitize_text_field($_GET['tab_cat']) : null;
        $search_param = isset($_GET['s_param']) && !empty($_GET['s_param']) ? sanitize_text_field($_GET['s_param']) : null;

        $cols = isset($settings['layout_col']) && !empty($settings['layout_col']) ? $settings['layout_col'] : 3;
        $tablet_cols = isset($settings['layout_col_tablet']) && !empty($settings['layout_col_tablet']) ? $settings['layout_col_tablet'] : 4;
        $mobile_cols = isset($settings['layout_col_mobile']) && !empty($settings['layout_col_mobile']) ? $settings['layout_col_mobile'] : 12;

        if ($items):
            ?>
            <div class="product-tab-4-wrap">
                <div class="product-tab-4">
                    <div class="box-head">
                        <div class="row align-items-center">
                            <div class="col-12 col-sm-12 col-md-2 col-lg-2">
                                <div class="box-sort">
                                    <svg width="20" height="18" viewBox="0 0 20 18" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M15.75 17.25C14.7 17.25 13.8125 16.8875 13.0875 16.1625C12.3625 15.4375 12 14.55 12 13.5C12 12.45 12.3625 11.5625 13.0875 10.8375C13.8125 10.1125 14.7 9.75 15.75 9.75C16.8 9.75 17.6875 10.1125 18.4125 10.8375C19.1375 11.5625 19.5 12.45 19.5 13.5C19.5 14.55 19.1375 15.4375 18.4125 16.1625C17.6875 16.8875 16.8 17.25 15.75 17.25ZM2 14.5V12.5H10V14.5H2ZM4.25 8.25C3.2 8.25 2.3125 7.8875 1.5875 7.1625C0.8625 6.4375 0.5 5.55 0.5 4.5C0.5 3.45 0.8625 2.5625 1.5875 1.8375C2.3125 1.1125 3.2 0.75 4.25 0.75C5.3 0.75 6.1875 1.1125 6.9125 1.8375C7.6375 2.5625 8 3.45 8 4.5C8 5.55 7.6375 6.4375 6.9125 7.1625C6.1875 7.8875 5.3 8.25 4.25 8.25ZM10 5.5V3.5H18V5.5H10Z" fill="#8B8A34"/> </svg>
                                    <select name="sort">
                                        <option <?php selected($sort, 1) ?> value="1"><?php echo __('New', 'ahura') ?></option>
                                        <option <?php selected($sort, 2) ?> value="2"><?php echo __('Best Sellers', 'ahura') ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-7 col-lg-7">
                                <div class="pt-tab-items">
                                    <ul>
                                        <?php
                                        $i = 0;
                                        foreach ($items as $item):
                                            $first = ($i === 0);
                                            $activeCls = (!isset($_GET['current_tab']) && $first) || (isset($_GET['current_tab']) && $_GET['current_tab'] == $item['_id']) ? 'active' : '';
                                            $i++;
                                            ?>
                                            <li class="elementor-repeater-item-<?php echo $item['_id'] . ' ' . $activeCls; ?>">
                                                <a href="?current_tab=<?php echo esc_attr($item['_id']) ?>&tab_cat=<?php echo !empty($item['cat_id']) ? esc_attr($item['cat_id']) : 'all' ?>&sort=<?php echo esc_attr($sort) ?>" class="pt-item-btn ah-has-bg ah-has-text" id="tab-item-<?php echo $item['_id'] ?>" data-wid="<?php echo $wid ?>" data-tab="#tab-content-<?php echo $item['_id'] ?>">
                                                    <?php echo $item['item_title'] ?>
                                                </a>
                                            </li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                            <div class="col-12 col-sm-12 col-md-3 col-lg-3">
                                <div class="box-search">
                                    <form method="get">
                                        <button type="submit" class="s-btn">
                                            <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M16.6 18L10.3 11.7C9.8 12.1 9.225 12.4167 8.575 12.65C7.925 12.8833 7.23333 13 6.5 13C4.68333 13 3.14583 12.3708 1.8875 11.1125C0.629167 9.85417 0 8.31667 0 6.5C0 4.68333 0.629167 3.14583 1.8875 1.8875C3.14583 0.629167 4.68333 0 6.5 0C8.31667 0 9.85417 0.629167 11.1125 1.8875C12.3708 3.14583 13 4.68333 13 6.5C13 7.23333 12.8833 7.925 12.65 8.575C12.4167 9.225 12.1 9.8 11.7 10.3L18 16.6L16.6 18ZM6.5 11C7.75 11 8.8125 10.5625 9.6875 9.6875C10.5625 8.8125 11 7.75 11 6.5C11 5.25 10.5625 4.1875 9.6875 3.3125C8.8125 2.4375 7.75 2 6.5 2C5.25 2 4.1875 2.4375 3.3125 3.3125C2.4375 4.1875 2 5.25 2 6.5C2 7.75 2.4375 8.8125 3.3125 9.6875C4.1875 10.5625 5.25 11 6.5 11Z" fill="#1C1C25"/> </svg>
                                        </button>
                                        <input type="text" name="s_param" value="<?php echo esc_attr($search_param) ?>" placeholder="<?php echo __('Search', 'ahura') ?>" autocomplete="off">
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="pt-tabs-content">
                        <?php
                        $i = 0;
                        foreach ($items as $item):
                            $firstWrap = ($i === 0);
                            $activeCls = $firstWrap || (isset($_GET['current_tab']) && $_GET['current_tab'] == $item['_id']) ? 'active' : '';
                            $i++;
                            ?>
                            <div class="pt-tab-content-wrap elementor-repeater-item-<?php echo $item['_id'] . ' ' . $activeCls; ?>" id="tab-content-<?php echo $item['_id'] ?>" style="display:<?php echo $firstWrap ? 'block' : 'none' ?>">
                                <div class="row pt-tab-content">
                                    <?php
                                    if ($firstWrap):
                                        $per_page = $item['per_page'];

                                        $args = array(
                                            'post_type' => 'product',
                                            'posts_per_page' => $per_page,
                                            'post_status' => 'publish',
                                        );

                                        if($settings['only_in_stock'] == 'yes'){
                                            $args['meta_query'] = array(
                                                array(
                                                    'key' => '_stock_status',
                                                    'value' => 'instock',
                                                    'compare' => '='
                                                )
                                            );
                                        }

                                        if ($item['cat_id'] || !empty($cat)) {
                                            $args['tax_query'] = array(
                                                'tax_query' => [
                                                    'relation' => 'OR',
                                                    [
                                                        'taxonomy' => 'product_cat',
                                                        'field' => 'term_id',
                                                        'terms' => [(!empty($cat) ? $cat : $item['cat_id'])],
                                                    ]
                                                ]
                                            );
                                        }

                                        if($sort == 2){
                                            $args = array_merge($args, [
                                                'meta_key' => 'total_sales',
                                                'orderby' => 'meta_value_num',
                                                'order' => 'DESC',
                                            ]);
                                        }

                                        if($search_param){
                                            $args = array_merge($args, [
                                                's' => $search_param,
                                            ]);
                                        }

                                        if($page > 1){
                                            $args = array_merge($args, [
                                                'paged' => $page,
                                            ]);
                                        }

                                        $products = new \WP_Query($args);

                                        if ($products->have_posts()):
                                            while ($products->have_posts()): $products->the_post();
                                                global $product;
                                                ?>
                                                <div class="<?php echo sprintf('col-%s col-sm-%1$s col-md-%s col-lg-%s', $mobile_cols, $tablet_cols, $cols) ?>">
                                                    <div class="p-item-wrap">
                                                        <a href="<?php echo get_the_permalink() ?>" <?php wc_product_class('product-item ah-has-bg', $product) ?>>
                                                            <div class="product-cover">
                                                                <?php echo wp_get_attachment_image(get_post_thumbnail_id(), isset($settings['item_cover_size']) ? $settings['item_cover_size'] : 'full') ?>
                                                            </div>
                                                            <div class="pt-overly ah-has-bg">
                                                                <h3 class="p-title"><?php the_title() ?></h3>
                                                                <?php if ($product->get_price()): ?>
                                                                    <div class="p-item-price">
                                                                        <?php echo wc_price($product->get_price()) ?>
                                                                    </div>
                                                                <?php endif; ?>
                                                                <?php if ($settings['show_excerpt'] == 'yes' && has_excerpt()): ?>
                                                                    <div class="p-excerpt"><p><?php echo wp_trim_words(get_the_excerpt(), 15, '...') ?></p></div>
                                                                <?php endif; ?>
                                                                <?php if(isset($settings['item_btn_icon']) && !empty($settings['item_btn_icon']['value'])): ?>
                                                                    <span class="item-main-btn">
                                                                        <?php \Elementor\Icons_Manager::render_icon( $settings['item_btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                                    </span>
                                                                <?php endif; ?>
                                                            </div>
                                                        </a>
                                                    </div>
                                                </div>
                                            <?php
                                            endwhile;
                                            wp_reset_query();
                                            wp_reset_postdata();
                                            ?>
                                            <?php if(isset($settings['show_pagination']) && $settings['show_pagination'] == 'yes'): ?>
                                            <div class="tab-foot">
                                                <div class="element-pagination">
                                                    <?php ahura_custom_pagination($products->found_posts, $per_page, $page); ?>
                                                </div>
                                            </div>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <div class="col-12">
                                                <div class="mw_element_error">
                                                    <?php echo esc_html__('Sorry,no products were found for display.', 'ahura'); ?>
                                                </div>
                                            </div>
                                        <?php
                                        endif;
                                    endif;
                                    ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php
        endif;
    }
}
