<?php
namespace ahura\inc\widgets;

// Die if is direct opened file
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use \ahura\app\mw_assets;

class post_tab2 extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * product_tab constructor.
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('post_tab2_carousel', mw_assets::get_js('elementor.post_tab2_carousel'));
        mw_assets::register_script('post_tab2_js', mw_assets::get_js('elementor.post_tab2'));
        wp_localize_script(mw_assets::get_handle_name('post_tab2_js'), 'ahura_data', [
            'ajax_url' => admin_url('admin-ajax.php'),
        ]);
    }

    public function __register_assets()
    {
        $this->register_elementor_style('post_tab2_css', mw_assets::get_css('elementor.post_tab2'));
    }

    public function get_script_depends()
    {
        return [ mw_assets::get_handle_name('post_tab2_carousel'), mw_assets::get_handle_name('post_tab2_js') ];
    }
    
    /**
     *
     * Set element id
     *
     * @return string
     */
    public function get_name()
    {
        return 'post_tab2';
    }

    /**
     *
     * Set element widget
     *
     * @return mixed
     */
    public function get_title()
    {
        return esc_html__('Post Tab 2', 'ahura');
    }

    /**
     *
     * Set widget icon
     *
     */
    public function get_icon()
    {
        return 'aicon-svg-product-tab';
    }

    /**
     *
     * Set element category
     *
     * @return string[]
     */
    public function get_categories()
    {
        return ['ahuraelements','ahura_woocommerce'];
    }

    /**
     *
     * Keywords for search
     *
     * @return array
     */
    function get_keywords()
    {
        return ['ahura', 'post tab 2', 'post', 'tab', esc_html__('ahura', 'ahura'), esc_html__('Post', 'ahura'), esc_html__('Post Tab 2', 'ahura')];
    }

    /**
     *
     * Element controls option
     *
     */
    public function register_controls()
    {
        /**
         *
         *
         * Start content
         *
         */
        $this->start_controls_section(
            'tabs_content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'item_title',
            [
                'label' => esc_html__('Title', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Tab Title', 'ahura'),
            ]
        );

		$repeater->add_control(
			'item_icon',
			[
				'label' => esc_html__( 'Icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

		$repeater->add_control(
			'active_item_icon',
			[
				'label' => esc_html__( 'Active icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

        $taxonomies = get_taxonomies([
            'public' => true,
            'name' => 'category',
        ], 'objects');

        $cats = array();
        if ($taxonomies) {
            foreach ($taxonomies as $key => $taxonomy) {
                if ($term_object = get_terms($key)) {
                    if($term_object){
                        foreach ($term_object as $term) {
                            $cats[$term->term_id] = "{$term->name} - {$taxonomy->labels->name}";
                        }
                    }
                }
            }
        }
        $repeater->add_control(
            'cat_id',
            [
                'label' => esc_html__('Categories', 'ahura'),
                'type' => Controls_Manager::SELECT2,
                'options' => $cats,
                'label_block' => true,
                'multiple' => true,
            ]
        );

        $repeater->add_control(
            'cat_type',
            [
                'label' => esc_html__('Categories type', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'newest' => esc_html__('Newest', 'ahura'),
                    'popular' => esc_html__('Most Popular', 'ahura'),
                ],
                'default' => 'newest'
            ]
        );

        $repeater->add_control(
            'per_page',
            [
                'label' => esc_html__('Count', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 8,
                'min' => 1,
            ]
        );

        $this->add_control(
            'tab_items',
            [
                'label' => esc_html__('Items', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{item_title}}}',
                'default' => [
                    [
                        'item_title' => esc_html__('All', 'ahura'),
                        'item_archive_link' => ['url' => site_url()],
                    ]
                ]
            ]
        );
		
        $this->end_controls_section();
        
        $this->start_controls_section(
            'slider_section',
            [
                'label' => esc_html__('Slider', 'ahura'),
            ]
        );
        
        $this->add_control(
			'auto_play',
			[
				'label' => esc_html__( 'Auto Play', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
			'auto_play_speed',
			[
				'label' => esc_html__( 'Auto Play Speed', 'ahura' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 10000,
				'step' => 1,
				'default' => 1000,
                'condition' => ['auto_play' => 'yes']
			]
		);

        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('Arrows', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();

        /**
         *
         *
         * Start Styles
         *
         */

        $this->start_controls_section(
            'header_style',
            [
                'label' => esc_html__('Header', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'head_options',
			[
				'label' => esc_html__( 'Head', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'head_margin',
			[
				'label' => esc_html__( 'Header margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => is_rtl() ? 0 : 10,
					'bottom' => 80,
					'left' => is_rtl() ? 10 : 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .box-head' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'head_padding',
			[
				'label' => esc_html__( 'Header padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'icon_options',
			[
				'label' => esc_html__( 'Icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#111111',
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul li svg' => 'color: {{VALUE}}',
					'{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul li svg' => 'fill: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'icon_active_color',
			[
				'label' => esc_html__( 'Active icon color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#111111',
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul li.active svg' => 'color: {{VALUE}}',
					'{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul li.active svg' => 'fill: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'icon_width',
			[
				'label' => esc_html__( 'Icon width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul li svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'icon_margin',
			[
				'label' => esc_html__( 'Icon margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => is_rtl() ? 0 : 3,
					'bottom' => 0,
					'left' => is_rtl() ? 3 : 0,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'tab_options',
			[
				'label' => esc_html__( 'Tabs', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'tab_item_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '400'
                    ]
                ],
				'selector' => '{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul li a',
			]
		);

        $this->add_control(
			'head_tab_color',
			[
				'label' => esc_html__( 'Item color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#111111',
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul li a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'active_tab_background_color',
				'types' => [ 'classic', 'gradient' ],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#F1E5E5'],
					],
				'selector' => '{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul li.active',
			]
		);

        $this->add_control(
			'active_tab_color',
			[
				'label' => esc_html__( 'Active item color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#e01d4e',
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul li.active a' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'tab_margin',
			[
				'label' => esc_html__( 'Tab margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'tab_item_padding',
			[
				'label' => esc_html__( 'Tab item padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 35,
					'bottom' => 10,
					'left' => 30,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'tab_item_radius',
			[
				'label' => esc_html__( 'Tab item border-radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 5,
					'bottom' => 5,
					'left' => 5,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'item_width',
			[
				'label' => esc_html__( 'Item width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'default' => [
					'size' => 12,
					'unit' => '%',
				],
				'tablet_default' => [
					'size' => 30,
					'unit' => '%',
				],
				'mobile_default' => [
					'size' => 100,
					'unit' => '%',
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .box-head' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'item_vertical_space',
			[
				'label' => esc_html__( 'Item vertical space', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul li:not(:last-child)' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'scroll_options',
			[
				'label' => esc_html__( 'Scroll-bar', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'scrollbar_notice',
			[
				'type' => \Elementor\Controls_Manager::NOTICE,
				'notice_type' => 'warning',
				'dismissible' => true,
				'heading' => esc_html__( 'Compatibility Notice', 'ahura' ),
				'content' => esc_html__( 'Please notice this feature not fully supported on Firefox browsers.', 'ahura' ),
			]
		);

        $this->add_control(
			'scrollbar_active_color',
			[
				'label' => esc_html__( 'Scrollbar active color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#D72121',
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap ::-webkit-scrollbar-thumb' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'scrollbar_color',
			[
				'label' => esc_html__( 'Scrollbar color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#D6D6D6',
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap ::-webkit-scrollbar-track' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'scrollbar_width',
			[
				'label' => esc_html__( 'Item width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 1,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap ::-webkit-scrollbar' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();
        
        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('Item', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$alignmentOptions = [
			'right' => [
				'title' => esc_html__( 'Right', 'ahura' ),
				'icon' => 'eicon-text-align-right',
			],
			'center' => [
				'title' => esc_html__( 'Center', 'ahura' ),
				'icon' => 'eicon-text-align-center',
			],
			'left' => [
				'title' => esc_html__( 'Left', 'ahura' ),
				'icon' => 'eicon-text-align-left',
			],
		];

		if (!is_rtl()) {
			$alignmentOptions = array_reverse($alignmentOptions);
		}

		$this->add_responsive_control(
			'title_alignment',
			[
				'label' => esc_html__( 'Title alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => $alignmentOptions,
				'default' => is_rtl() ? 'right' : 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .post-title-container .post-title' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'item_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'default' => [
					'size' => 510,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 400,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 300,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .post-item2 .post-container' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul' => 'max-height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'post_footer_background_color',
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .post-tab2-wrap .post-title-container',
			]
		);

        $this->add_responsive_control(
			'post_footer_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 20,
					'right' => 20,
					'bottom' => 20,
					'left' => 20,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .post-title-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'footer_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .post-title-container' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'slide_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .pt-tabs2-content' => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .post-tab2-wrap .post-title-container' => 'border-radius: 0 0 {{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'post_footer_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .post-title-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'post_title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .post-title-container .post-title' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'post_title_typography',
				'selector' => '{{WRAPPER}} .post-tab2-wrap .post-title-container .post-title',
			]
		);
        
        $this->end_controls_section();

        $this->start_controls_section(
            'slider_style',
            [
                'label' => esc_html__('Slider', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'general_options',
			[
				'label' => esc_html__( 'General', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'slider_padding',
			[
				'label' => esc_html__( 'Slider padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 100,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .swiper.post-tab2-swiper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'controllers_options',
			[
				'label' => esc_html__( 'Controllers', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'arrow_v_position',
			[
				'label' => esc_html__( 'Arrow vertical position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap div[class^="items-carousel-button-"]' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'next_arrow_h_position',
			[
				'label' => esc_html__( 'Next arrow h-position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 25,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .items-carousel-button-next' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'prev_arrow_v_position',
			[
				'label' => esc_html__( 'Previous arrow v-position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 25,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .items-carousel-button-prev' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'arrow_color',
			[
				'label' => esc_html__( 'Arrow color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap div[class^="items-carousel-button-"] i' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'arrow_background_color',
			[
				'label' => esc_html__( 'Arrow background-color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#444BFF80',
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap div[class^="items-carousel-button-"] i' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'arrow_width',
			[
				'label' => esc_html__( 'Arrow width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 35,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap div[class^="items-carousel-button-"] i' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'arrow_border_radius',
			[
				'label' => esc_html__( 'Arrow border-radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap div[class^="items-carousel-button-"] i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'overlay_options',
			[
				'label' => esc_html__( 'Overlay', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'overlay_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 110,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab2-wrap .pt-tab2-items ul li:nth-child(5)~ :nth-last-child(2):after' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'overlay_height_notice',
			[
				'type' => \Elementor\Controls_Manager::NOTICE,
				'notice_type' => 'warning',
				'dismissible' => true,
				'heading' => esc_html__( 'Notice', 'ahura' ),
				'content' => esc_html__( 'Please set Height option accourding to "Item vertical space" adjusment.', 'ahura' ),
			]
		);
        
        $this->end_controls_section();

        $this->register_additional_controls();
    }

    protected function render_link_attrs($url_data, $status)
    {
        if($status == 'yes') {
            $target = $url_data['is_external'] ? 'target="_blank"' : '';
            $nofollow = $url_data['nofollow'] ? 'rel="nofollow"' : '';
            $cu_attr = $url_data['custom_attributes'] ? $url_data['custom_attributes'] : false;
            $data = 'href="' . $url_data['url'] . '" ' . $target . ' ' . $nofollow . ' ' . $cu_attr;
            echo $data;
        } else {
            echo 'href="#"';
        }
    }

    /**
     *
     * Render element content (html)
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $items = $settings['tab_items'];
        $has_arrows = ($settings['show_arrow'] == 'yes');

        $slider_data = [
            'widgetID' => $wid,
            'autoPlayStatus' => $settings['auto_play'] === 'yes',
            'playDelay' => $settings['auto_play'] === 'yes' ? $settings['auto_play_speed'] : 99999,
            'arrows' => $has_arrows,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];

        if ($items): ?>
            <div class="post-tab2-wrap post-tab2-wrap-<?php echo $wid ?>" data-slider='<?php echo json_encode($slider_data) ?>'>
                <div class="d-flex post-tab2">
                    <div class="box-head">
                        <div class="d-flex justify-content-center pt-tab2-items w-100">
                            <ul class="d-flex flex-column">
                                <?php $i = 0;
                                foreach ($items as $item):
                                    $first = ($i === 0);
                                    $activeCls = $first ? 'active' : '';
                                    $data = array('category' => $item['cat_id'], 'num' => $item['per_page']);
                                    $i++;
                                    ?>
                                    <li class="d-flex justify-content-center align-items-center elementor-repeater-item-<?php echo $item['_id'] . '-' . $wid . ' ' . $activeCls; ?>">
                                        <a href="#" class="d-flex align-items-center justify-content-start w-100 pt-item-btn ah-has-bg ah-has-text" id="tab-item-<?php echo $item['_id'] . '-' . $wid ?>" data-wid="<?php echo $wid ?>" data-tab="#tab-content-<?php echo $item['_id'] . '-' . $wid ?>" data-settings="<?php echo base64_encode(json_encode($data)) ?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $item['item_icon'], [ 'aria-hidden' => 'true' ] ); ?>
											<?php \Elementor\Icons_Manager::render_icon( $item['active_item_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                            <span><?php echo $item['item_title'] ?></span>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
					<div class="pt-tabs2-content">
						<?php $i = 0;
						foreach ($items as $item):
							$firstWrap = ($i === 0);
							$activeCls = $firstWrap ? 'active' : '';
							$i++; ?>
							<div class="pt-tab2-content-wrap elementor-repeater-item-<?php echo $item['_id'] . '-' . $wid . ' ' . $activeCls; ?>" id="tab-content-<?php echo $item['_id'] . '-' . $wid ?>" style="display:<?php echo $firstWrap ? 'block' : 'none' ?>">
								<div class="row pt-tab2-content w-100">
										<?php $args = [
											'post_type' => 'post',
											'posts_per_page' => $item['per_page'],
											'post_status' => 'publish'
										];
										if ($item['cat_id']) {
											$args['tax_query'] = array(
												'tax_query' => [
													'relation' => 'OR',
													[
														'taxonomy' => 'category',
														'field' => 'term_id',
														'terms' => $item['cat_id'],
													]
												]
											);
										}
									$post = new \WP_Query($args); ?>
									<div class="swiper swiper-post-tab2 post-tab-swiper post-tab-swiper-<?php echo $wid; ?> w-100">
										<div class="swiper-wrapper">
											<?php while ( $post->have_posts() ) : $post->the_post(); ?>
												<div class="swiper-slide elementor-repeater-item-<?php echo $wid; ?>">
													<div class="items-carousel-content">
													<?php
													include get_template_directory() .'/template-parts/loop/elementor/post-tab2-load-ajax.php'; ?>
													</div>
												</div>
											<?php endwhile; ?>
											<?php wp_reset_query(); ?>
											<?php wp_reset_postdata(); ?>
										</div>
										<?php if($has_arrows): ?>
											<div class="items-carousel-button-prev"><i class="fa fa-chevron-left d-flex justify-content-center align-items-center "></i></div>
											<div class="items-carousel-button-next"><i class="fa fa-chevron-right d-flex justify-content-center align-items-center "></i></div>
										<?php endif; ?>
									</div>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
                </div>
            </div>
        <?php
        endif;
    }
}
