<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\mw_assets;
use ahura\app\Post_Meta;
use Elementor\Controls_Manager;

class post_carousel7 extends \ahura\app\elementor\Elementor_Widget_Base {
    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('post_carousel7_js', mw_assets::get_js('elementor.post_carousel7'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('post_carousel7_css', mw_assets::get_css('elementor.post_carousel7'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('post_carousel7_js')];
    }

    public function get_name() {
        return 'post_carousel7';
    }

    public function get_title() {
        return __( 'Post Carousel 7', 'ahura' );
    }

    public function get_icon() {
        return 'eicon-posts-carousel';
    }

    public function get_categories() {
        return [ 'ahuraelements', 'ahura_posts' ];
    }
    function get_keywords()
    {
        return ['ahura', 'post', 'post carousel 7', esc_html__('ahura', 'ahura'), esc_html__( 'Post Carousel 7' , 'ahura')];
    }

    public function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $categories = get_categories();
        $cats       = array();
        foreach ( $categories as $category ) {
            $cats[ $category->term_id ] = $category->name;
        }
        $default = key($cats);
        $this->add_control(
            'catsid',
            [
                'label'    => __( 'Categories', 'ahura' ),
                'type'     => \Elementor\Controls_Manager::SELECT2,
                'options'  => $cats,
                'label_block' => true,
                'multiple' => true,
                'default'	=>	$default
            ]
        );

        $this->add_control(
            'count',
            [
                'label'      => __( 'Number of posts', 'ahura' ),
                'type'       => \Elementor\Controls_Manager::NUMBER,
                'default'    => 8
            ]
        );

        $this->add_control(
            'post_order',
            [
                'label' => __('Sort', 'ahura'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'default' => 'DESC',
                'options' => [
                    'ASC' => [
                        'title' => __('Ascending', 'ahura'),
                        'icon' => 'eicon-sort-up'
                    ],
                    'DESC' => [
                        'title' => __('Descending', 'ahura'),
                        'icon' => 'eicon-sort-down'
                    ],
                ],
                'toggle' => true
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'item_cover',
                'default' => 'full',
            ]
        );

        $this->add_control(
            'hover_icon_options',
            [
                'label' => esc_html__( 'Hover Mode Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'show_hover_icon',
            [
                'label' => esc_html__('Show Hover Icon', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'hover_icon',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-play',
                    'library' => 'fa-solid',
                ],
                'condition' => ['show_hover_icon' => 'yes']
            ]
        );

        $this->add_control(
            'slider_options',
            [
                'label' => esc_html__( 'Slider', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slides_per_view',
            [
                'label'      => __( 'Slides Per View', 'ahura' ),
                'type'       => \Elementor\Controls_Manager::NUMBER,
                'default'    => 5
            ]
        );

        $this->add_control(
            'slides_margin',
            [
                'label'      => __( 'Slides Spacing', 'ahura' ),
                'type'       => \Elementor\Controls_Manager::NUMBER,
                'default'    => 0
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'show_slider_btn',
            [
                'label' => esc_html__('Slider Button', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_slider_pagination',
            [
                'label' => esc_html__('Slider Pagination', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();
        /**
         *
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'items_styles',
            [
                'label' => __( 'Items', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'box_img_height',
            [
                'label' => esc_html__('Item Height', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'default' => [
                  'unit' => 'px',
                  'size' => 550
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'selectors' => [
                    '{{WRAPPER}} .post-item img' => 'height: {{SIZE}}{{UNIT}}',
                ]
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .post-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_cover_color',
            [
                'label' => esc_html__( 'Cover Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#FF29429E',
                'selectors' => [
                    '{{WRAPPER}} .post-item .post-overlay' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control('hr1', ['type' => \Elementor\Controls_Manager::DIVIDER]);

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .details .post-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('Title Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .details .post-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '600'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '20',
                        ]
                    ]
                ]
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => esc_html__( 'Subtitle Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .details .subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'label' => esc_html__('Subtitle Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .details .subtitle',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '300'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '14',
                        ]
                    ]
                ]
            ]
        );

        $this->add_control(
            'hover_icon_style_options',
            [
                'label' => esc_html__( 'Hover Mode Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'hover_icon_color',
            [
                'label' => esc_html__( 'Icon Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .post-item .icon-button i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .post-item .icon-button :is(svg, path)' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'hover_icon_bg',
                'selector' => '{{WRAPPER}} .post-item .icon-button',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => [
                        'default' => 'classic'
                    ],
                    'color' => [
                        'default' => '#FF2942'
                    ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'hover_icon_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .post-item .icon-button',
                'fields_options' => [
                    'box_shadow_type' => ['default' => 'yes'],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical' => 0,
                            'blur' => 0,
                            'spread' => 7,
                            'color' => '#FF294252'
                        ]
                    ]
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_navigation_style',
            [
                'label' => esc_html__('Navigation', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'nav_options',
            [
                'label' => esc_html__('Navigation', 'ahura'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs('slider_nav_style_tabs');
        $this->start_controls_tab('slider_nav_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_control(
            'box_nav_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .slider-buttons-wrap .swiper-btn-next, {{WRAPPER}} .slider-buttons-wrap .swiper-btn-prev' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'box_nav_bg_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-buttons-wrap .swiper-btn-next, {{WRAPPER}} .slider-buttons-wrap .swiper-btn-prev' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('slider_nav_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_control(
            'box_nav_color_hover',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .slider-buttons-wrap .swiper-btn-next:hover, {{WRAPPER}} .slider-buttons-wrap .swiper-btn-prev:hover' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'box_nav_bg_color_hover',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ff2942',
                'selectors' => [
                    '{{WRAPPER}} .slider-buttons-wrap .swiper-btn-next:hover, {{WRAPPER}} .slider-buttons-wrap .swiper-btn-prev:hover' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'paginate_options',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'box_paginate_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .slider-buttons-wrap .swiper-pagination-bullets .swiper-pagination-bullet' => 'background: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'box_paginate_active_color',
            [
                'label' => esc_html__('Active Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#FF2942',
                'selectors' => [
                    '{{WRAPPER}} .slider-buttons-wrap .swiper-pagination-bullets .swiper-pagination-bullet-active' => 'background: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_section();
    }

    public function render() {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $show_slides_nav = $settings['show_slider_btn'] == 'yes';
        $show_slides_dots = $settings['show_slider_pagination'] == 'yes';

        $sliderData = [
            'widgetID' => $wid,
            'autoplay' => $settings['autoplay'] == 'yes',
            'slidesPerView' => $settings['slides_per_view'],
            'margin' => $settings['slides_margin'],
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];

        $posts = new \WP_Query (array(
            'posts_per_page' => $settings['count'],
            'cat'            => ahura_sanitize_categories($settings['catsid']),
            'order'         =>  $settings['post_order']
        ));

        if ( $posts->have_posts() ) : ?>
            <div class="ah-slider-post-7 post-carousel7">
                <div dir="<?php echo is_rtl() ? 'rtl' : 'ltr' ?>" class="swiper posts-carousel" data-slider='<?php echo json_encode($sliderData) ?>'>
                    <div class="swiper-wrapper">
                        <?php
                        while ( $posts->have_posts() ) : $posts->the_post();
                            $subtitle = Post_Meta::get_post_subtitle(get_the_ID());
                            ?>
                            <div class="swiper-slide">
                                <div class="post-item">
                                    <a href="<?php the_permalink(); ?>">
                                        <div class="post-overlay"></div>
                                        <?php the_post_thumbnail() ?>
                                        <div class="details">
                                            <?php
                                            if ($settings['show_hover_icon'] == 'yes'):
                                                $hover_icon = $settings['hover_icon'];
                                                ?>
                                                <div class="icon-button-wrap">
                                                    <div class="icon-button">
                                                        <?php \Elementor\Icons_Manager::render_icon( $hover_icon, [ 'aria-hidden' => 'true' ] ) ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <h2 class="post-title"><?php the_title(); ?></h2>
                                            <?php if (!empty($subtitle)): ?>
                                                <div class="subtitle">
                                                    <span><?php echo $subtitle ?></span>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                    <?php if ($show_slides_nav || $show_slides_dots): ?>
                    <div class="slider-buttons-wrap">
                        <div class="slider-buttons <?php echo !$show_slides_nav ? 'without-nav' : '' ?>">
                            <?php if ($show_slides_nav): ?>
                                <div class="swiper-btn-next"><i class="fas fa-angle-<?php echo is_rtl() ? 'right' : 'left' ?>"></i></div>
                            <?php endif; ?>
                            <?php if ($show_slides_dots): ?>
                                <div class="swiper-pagination"></div>
                            <?php endif; ?>
                            <?php if ($show_slides_nav): ?>
                                <div class="swiper-btn-prev"><i class="fas fa-angle-<?php echo is_rtl() ? 'left' : 'right' ?>"></i></div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php wp_reset_postdata(); ?>
        <?php endif; ?>
        <div class="clear"></div>
        <?php
    }
}
