<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.
defined('ABSPATH') or die('No script kiddies please!');

use ahura\app\mw_assets;
use ahura\app\Post_Meta;
use Elementor\Controls_Manager;

class post_carousel6 extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('post_carousel6_js', mw_assets::get_js('elementor.post_carousel6'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('post_carousel6_css', mw_assets::get_css('elementor.post_carousel6'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('post_carousel6_js')];
    }

    public function get_name()
    {
        return 'ahura_post_carousel_6';
    }

    public function get_title()
    {
        return __('Post Carousel 6', 'ahura');
    }

    public function get_icon() {
        return 'eicon-posts-carousel';
    }

    public function get_categories()
    {
        return ['ahuraelements', 'ahura_posts'];
    }

    public function get_keywords()
    {
        return ['ahura', 'post', 'post carousel 6', esc_html__('ahura', 'ahura'), esc_html__( 'Post Carousel 6' , 'ahura')];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'ahura'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_type',
            [
                'label'    => __('Show Type', 'ahura'),
                'type'     => \Elementor\Controls_Manager::SELECT,
                'options'  => [
                    'latest' => __('Latest Posts', 'ahura'),
                    'category' => __('Categories', 'ahura'),
                ],
                'label_block' => true,
                'default' => 'latest'
            ]
        );

        $categories = get_categories();
        $cats       = array();
        if ($categories){
            foreach ($categories as $category) {
                $cats[$category->term_id] = $category->name;
            }
        }
        $default = key($cats);

        $this->add_control(
            'cat_ids',
            [
                'label'    => __('Categories', 'ahura'),
                'type'     => \Elementor\Controls_Manager::SELECT2,
                'options'  => $cats,
                'label_block' => true,
                'multiple' => true,
                'default' => $default,
                'condition' => ['show_type' => 'category']
            ]
        );

        $this->add_control(
            'show_popular',
            [
                'label' => esc_html__('Show Popular Posts', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'show_random',
            [
                'label' => esc_html__('Show Random', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => ['show_popular!' => 'yes']
            ]
        );

        $this->add_control(
            'posts_order',
            [
                'label' => __('Sort', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'default' => 'DESC',
                'options' => [
                    'ASC' => [
                        'title' => __('Ascending', 'ahura'),
                        'icon' => 'eicon-sort-up'
                    ],
                    'DESC' => [
                        'title' => __('Descending', 'ahura'),
                        'icon' => 'eicon-sort-down'
                    ],
                ],
                'toggle' => true,
                'condition' => ['show_random!' => 'yes', 'show_popular!' => 'yes']
            ]
        );

        $this->add_control(
            'post_count',
            [
                'label'      => __('Number of posts', 'ahura'),
                'type'       => \Elementor\Controls_Manager::NUMBER,
                'default'    => 4
            ]
        );

        $this->add_control(
            'show_post_title',
            [
                'label' => esc_html__('Show Post Title', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_post_details',
            [
                'label' => esc_html__('Show Post Details', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_responsive_control(
            'object_fit',
            [
                'label' => esc_html__( 'Aspect ratio', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill' => esc_html__( 'Default', 'ahura' ),
                    'contain' => esc_html__( 'Contain', 'ahura' ),
                    'cover'  => esc_html__( 'Cover', 'ahura' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-thumbnail-wrap img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'header_section',
            [
                'label' => __( 'Header', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_header',
            [
                'label' => esc_html__('Show Header', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_box_title',
            [
                'label' => esc_html__('Show Title', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['show_header' => 'yes']
            ]
        );

        $this->add_control(
            'box_title',
            [
                'label'      => __('Title', 'ahura'),
                'type'       => \Elementor\Controls_Manager::TEXT,
                'default'    => __('Latest Posts', 'ahura'),
                'condition' => ['show_header' => 'yes', 'show_box_title' => 'yes']
            ]
        );

        $this->add_control(
            'show_box_btn',
            [
                'label' => esc_html__('Show Button', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['show_header' => 'yes']
            ]
        );

        $this->add_control(
            'box_btn_link',
            [
                'label' => esc_html__( 'Link', 'ahura' ),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => ['url', 'is_external', 'nofollow'],
                'dynamic' => ['active' => true],
                'default' => [
                    'url' => '#',
                ],
                'label_block' => true,
                'condition' => ['show_header' => 'yes', 'show_box_btn' => 'yes']
            ]
        );

        $this->add_control(
            'box_btn_title',
            [
                'label'      => __('Button Text', 'ahura'),
                'type'       => \Elementor\Controls_Manager::TEXT,
                'default'    => __('View All', 'ahura'),
                'condition' => ['show_header' => 'yes', 'show_box_btn' => 'yes']
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_section',
            [
                'label' => __( 'Slider', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides Per View', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'default' => 4,
                'tablet_default' => 3,
                'mobile_default' => 1,
                'options' => [
                    '1' => 1,
                    '2' => 2,
                    '3' => 3,
                    '4' => 4,
                    '5' => 5,
                    '6' => 6,
                    '7' => 7,
                    '8' => 8,
                ]
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__( 'Autoplay', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'autoplay_delay',
            [
                'label' => esc_html__( 'Autoplay delay', 'ahura' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 10000,
                'step' => 1,
                'default' => 4000,
                'condition' => ['autoplay' => 'yes']
            ]
        );

        $this->add_control(
            'slide_margin',
            [
                'label' => esc_html__( 'Slides Space', 'ahura' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 200,
                'step' => 1,
                'default' => 25,
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();
        /**
         *
         *
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'header_styles',
            [
                'label' => __( 'Header', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['show_header' => 'yes']
            ]
        );

        $this->add_responsive_control(
            'heading_margin',
            [
                'label' => esc_html__( 'Margin', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 25,
                    'left' => 0,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'allowed_dimensions' => ['top', 'bottom'],
                'selectors' => [
                    '{{WRAPPER}} .box-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'box_title_styles',
            [
                'label' => esc_html__( 'Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'box_title_color',
            [
                'label' => esc_html__( 'Text Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .box-heading .box-title' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .box-heading .box-title span:after' => 'background-color: {{VALUE}}1c',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Title Typography', 'ahura'),
                'name' => 'box_title_typography',
                'selector' => '{{WRAPPER}} .box-heading .box-title',
                'fields_options' =>
                    [
                        'typography' => [
                            'default' => 'yes'
                        ],
                        'font_size' => [
                            'default' => [
                                'unit' => 'px',
                                'size' => '21',
                            ]
                        ],
                        'font_weight' => [
                            'default' => '600'
                        ],
                    ],
            ]
        );

        $this->add_control(
            'box_btn_styles',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'box_link_color',
            [
                'label' => esc_html__( 'Text Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .box-buttons a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .box-buttons :is(svg,path)' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Button Typography', 'ahura'),
                'name' => 'box_link_typography',
                'selector' => '{{WRAPPER}} .box-buttons a',
                'fields_options' =>
                    [
                        'typography' => [
                            'default' => 'yes'
                        ],
                        'font_size' => [
                            'default' => [
                                'unit' => 'px',
                                'size' => '21',
                            ]
                        ],
                        'font_weight' => [
                            'default' => '600'
                        ],
                    ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => esc_html__( 'Icon Size', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 21,
                ],
                'selectors' => [
                    '{{WRAPPER}} .box-buttons a i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .box-buttons a svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'items_styles',
            [
                'label' => __( 'Item', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'item_more_options',
            [
                'label' => esc_html__( 'Item', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $alignment = array(
            'right' => [
                'title' => esc_html__('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'left' => [
                'title' => esc_html__('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ]
        );

        $this->add_responsive_control(
            'item_text_alignment',
            [
                'label' => esc_html__('Title Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $alignment : array_reverse($alignment),
                'default' => is_rtl() ? 'right' : 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .post-title' => 'text-align: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .post-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typo',
                'label' => esc_html__('Title Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .post-title, {{WRAPPER}} .post-title h3',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '21'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '300'
                    ],
                ]
            ]
        );

        $this->add_control(
            'img_more_options',
            [
                'label' => esc_html__( 'Image', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'item_img_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'default' => [
                    'size' => 420,
                    'unit' => 'px',
                ],
                'tablet_default' => [
                    'size' => 350,
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'size' => 250,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-thumbnail-wrap img' => 'height: {{SIZE}}{{UNIT}}'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'selector' => '{{WRAPPER}} .post-thumbnail-wrap',
            ]
        );

        $this->add_control(
            'item_img_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .post-thumbnail-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .post-thumbnail-wrap',
            ]
        );

        $this->add_control(
            'details_more_options',
            [
                'label' => esc_html__( 'Details Box', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => ['show_post_details' => 'yes']
            ]
        );

        $this->add_control(
            'item_details_color',
            [
                'label' => esc_html__( 'Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-details' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .post-details .meta' => 'color: {{VALUE}}',
                ],
                'condition' => ['show_post_details' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_details_background',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .post-item .post-details',
                'fields_options' => [
                    'background' => [
                        'default' => 'classic'
                    ],
                    'color' => [
                        'default' => '#00000094'
                    ]
                ],
                'condition' => ['show_post_details' => 'yes']
            ]
        );

        $this->add_control(
            'item_details_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'top' => 20,
                    'right' => 20,
                    'bottom' => 20,
                    'left' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-item .post-details' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['show_post_details' => 'yes']
            ]
        );

        $this->end_controls_section();

        $this->register_additional_controls();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $cat_ids   = $settings['cat_ids'];
        $show_post_title = $settings['show_post_title'] == 'yes';
        $show_type = $settings['show_type'];

        $sliderData = [
            'autoplay' => $settings['autoplay'] == 'yes',
            'delay' => $settings['autoplay_delay'] ?? 4000,
            'margin' => $settings['slide_margin'],
            'perView' => $settings['slides_per_view'] ?? 4,
            'tabletPerView' => $settings['slides_per_view_tablet'] ?? 3,
            'mobilePerView' => $settings['slides_per_view_mobile'] ?? 1,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];

        $args = array(
            'posts_per_page' => $settings['post_count'],
            'post_status' => 'publish',
            'order' => $settings['posts_order'] ?? 'DESC'
        );

        if($show_type == 'category'){
            $args['cat'] = ahura_sanitize_categories($cat_ids);
        }

        if($settings['show_random'] == 'yes'){
            $args['orderby'] = 'rand';
        }

        if($settings['show_popular'] == 'yes'){
            $args = array_merge($args, array(
                'meta_key' => 'views',
                'orderby' => 'meta_value_num',
                'order' => 'DESC'
            ));
        }

        $posts = new \WP_Query($args);

        if (!$posts->have_posts())
            return false;
        ?>
        <div class="post-carousel-6 is-<?php echo is_rtl() ? 'rtl' : 'ltr' ?>">
            <?php if ($settings['show_header'] == 'yes'): ?>
                <div class="box-heading">
                    <div class="box-title has-text">
                        <?php if ($settings['show_box_title'] == 'yes'): ?>
                            <span><?php echo $settings['box_title'] ?></span>
                        <?php endif; ?>
                    </div>
                    <div class="box-buttons has-text has-icon">
                        <?php
                        if ($settings['show_box_btn'] == 'yes'):
                            if ( ! empty( $settings['box_btn_link']['url'] ) ) {
                                $this->add_link_attributes( 'box_btn_link', $settings['box_btn_link'] );
                            }
                            ?>
                            <a <?php echo $this->get_render_attribute_string( 'box_btn_link' ); ?>>
                                <span><?php echo $settings['box_btn_title'] ?></span>
                                <svg width="25" height="21" viewBox="0 0 25 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M25 10.4114C25 10.981 24.5768 11.4517 24.0277 11.5262L23.875 11.5364L4.099 11.5355L11.2435 18.6508C11.6838 19.0892 11.6853 19.8015 11.2469 20.2418C10.8484 20.6421 10.2235 20.6797 9.78233 20.3539L9.65592 20.2452L0.580921 11.2092C0.522884 11.1515 0.472475 11.0889 0.429691 11.0229C0.417608 11.003 0.405308 10.9827 0.393646 10.9619C0.382919 10.9441 0.373228 10.9257 0.364082 10.907C0.351383 10.8798 0.338974 10.8518 0.327709 10.8231C0.318554 10.801 0.310911 10.7796 0.30394 10.7579C0.29565 10.7311 0.287598 10.7025 0.28067 10.6734C0.27552 10.6532 0.271442 10.6337 0.267883 10.6141C0.262882 10.5849 0.258623 10.5548 0.255585 10.5242C0.252962 10.501 0.251383 10.4779 0.250509 10.4548C0.250284 10.4408 0.25 10.4262 0.25 10.4114L0.250565 10.3679C0.251427 10.3458 0.252934 10.3237 0.255089 10.3017L0.25 10.4114C0.25 10.3404 0.256577 10.271 0.269152 10.2036C0.272068 10.1876 0.275543 10.1711 0.279392 10.1546C0.287382 10.1207 0.296618 10.0881 0.307251 10.0562C0.312471 10.0403 0.318552 10.0233 0.32505 10.0065C0.338198 9.9726 0.352486 9.94033 0.368206 9.9089C0.375509 9.89412 0.383688 9.87865 0.392254 9.86333C0.406311 9.83834 0.420795 9.8146 0.43611 9.79145C0.446915 9.77507 0.458879 9.75802 0.471375 9.74124L0.48111 9.72827C0.511419 9.68868 0.5443 9.65115 0.579504 9.61595L0.580854 9.6149L9.65585 0.577402C10.0961 0.138973 10.8084 0.140447 11.2468 0.580696C11.6454 0.980922 11.6804 1.60599 11.3527 2.04573L11.2435 2.17168L4.102 9.28554L23.875 9.28644C24.4963 9.28644 25 9.79012 25 10.4114Z" fill="#FF5023"/>
                                </svg>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>
            <div class="carousel-items">
                <div class="swiper items-slider" data-slider='<?php echo json_encode($sliderData) ?>' dir="<?php echo is_rtl() ? 'rtl' : 'ltr' ?>">
                    <div class="swiper-wrapper">
                        <?php
                        while ($posts->have_posts()) : $posts->the_post();
                            $likes_percent = ahura_get_post_likes_percent(get_the_ID());
                            $categories = Post_Meta::get_category_names(get_the_ID());
                        ?>
                            <div class="swiper-slide">
                                <a href="<?php the_permalink(); ?>" class="post-item <?php echo !$show_post_title ? ' without-title' : '' ?>">
                                    <div class="post-thumbnail-wrap">
                                        <?php the_post_thumbnail('full') ?>
                                        <?php if ($settings['show_post_details'] == 'yes'): ?>
                                        <div class="post-details-wrap">
                                            <div class="post-details">
                                                <?php if ($likes_percent): ?>
                                                    <span class="post-votes"><i class="fas fa-thumbs-up"></i><?php echo $likes_percent ?>%</span>
                                                <?php endif; ?>
                                                <?php if (!empty($categories)): ?>
                                                    <div class="post-categories meta"><?php echo implode((is_rtl() ? '، ' : ', '), $categories) ?></div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                    <?php if($show_post_title): ?>
                                        <div class="post-title ah-has-text">
                                            <h3><?php the_title(); ?></h3>
                                        </div>
                                    <?php endif; ?>
                                </a>
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php wp_reset_postdata(); ?>
        <?php
    }
}
