<?php
namespace ahura\inc\widgets;

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

defined('ABSPATH') or die('No script kiddies please!');

class post_carousel5 extends \ahura\app\elementor\Elementor_Widget_Base
{
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('post_carousel5', mw_assets::get_js('elementor.post_carousel5'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('post_carousel5', mw_assets::get_css('elementor.post_carousel5'));
        if(!is_rtl()){
            $this->register_elementor_style('post_carousel5_ltr', mw_assets::get_css('elementor.ltr.post_carousel5_ltr'));
        }
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('post_carousel5')];
    }

    public function get_name()
    {
        return 'ahura_post_carousel_5';
    }

    public function get_title()
    {
        return esc_html__('Post Carousel 5', 'ahura');
    }

    public function get_icon()
    {
        return 'aicon-svg-post-carousel-4';
    }

    public function get_categories()
    {
        return ['ahuraelements', 'ahura_posts'];
    }

    public function get_keywords()
    {
        return ['ahura', 'post', 'post carousel 5', esc_html__('ahura', 'ahura'), esc_html__( 'Post Carousel 5' , 'ahura')];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'show_type',
            [
                'label' => __('Show Type', 'ahura'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'latest' => __('Latest Posts', 'ahura'),
                    'category' => __('Categories', 'ahura'),
                    'custom' => __('Select Post', 'ahura')
                ],
                'default' => 'latest',
            ]
        );

        $categories = get_categories(['fields' => 'id=>name']);

        $this->add_control(
            'post_categories',
            [
                'label' => __('Categories', 'ahura'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $categories,
                'default' => key($categories),
                'condition' => ['show_type' => 'category']
            ]
        );

        $posts_list = [];
        $posts = get_posts(['numberposts' => -1]);

        if(!empty($posts)){
            foreach ($posts as $post){
                $posts_list[$post->ID] = $post->post_title;
            }
        }

        $this->add_control(
            'selected_posts',
            [
                'label' => __('Posts', 'ahura'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $posts_list,
                'default' => key($posts_list),
                'condition' => ['show_type' => 'custom']
            ]
        );

        $this->add_control(
            'btn_text',
            [
                'label' => __('Button Title', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Movie Download', 'ahura')
            ]
        );

        $this->add_control(
            'btn_icon',
            [
                'label' => esc_html__( 'Button Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-play',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $this->add_control(
            'slider_count',
            [
                'label' => __('Slides count', 'ahura'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 3,
                'condition' => ['show_type!' => 'custom']
            ]
        );

        $this->add_control(
            'show_new_tag',
            [
                'label' => __('New tag', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
			'new_tag',
			[
				'label' => esc_html__( 'Tag', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'New tag', 'ahura' ),
                'condition' => [ 'show_new_tag' => 'yes' ]
			]
		);

        $this->add_control(
            'show_comments',
            [
                'label' => __('Comments', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );

        $this->add_control(
            'show_cats',
            [
                'label' => __('Categories', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [ 'content_style' => 'default' ]
            ]
        );

        $this->add_control(
            'slide_fade',
            [
                'label' => __('Slide fade', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'auto_play',
            [
                'label' => __('Auto play', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_arrow_thumbs',
            [
                'label' => __('Arrow on thumbs', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'play_delay',
            [
                'label' => __('Delay', 'ahura'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 4000,
                'condition' => ['auto_play' => 'yes']
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->add_control(
			'readmore_dots',
			[
				'label' => esc_html__( 'Readmore dots', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '...', 'ahura' ),
                'condition' => [ 'content_style' => 'style1' ]
			]
		);

        $this->add_control(
            'readmore_words',
            [
                'label' => __('Readmore words', 'ahura'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 40,
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );

        $this->end_controls_section();
        /**
         *
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'general_style_section',
            [
                'label' => __('General', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
			'content_style',
			[
				'label' => esc_html__( 'Content box style', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default'  => esc_html__( 'Default', 'ahura' ),
					'style1' => esc_html__( 'Style 1', 'ahura' ),
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'content_style_section',
            [
                'label' => __('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_box_more_options',
            [
                'label' => esc_html__( 'Content box', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );
        
        $this->add_responsive_control(
            'content_box_back_blur',
            [
                'label' => esc_html__('Icon Size', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-content-style1' => 'backdrop-filter: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );

        $this->add_responsive_control(
            'content_box_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .carousel-content-style1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );

        $this->add_responsive_control(
            'content_box_radius',
            [
                'label' => esc_html__('Border radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .carousel-content-style1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );
        
        $this->add_responsive_control(
            'content_box_width',
            [
                'label' => esc_html__('Width', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-content-style1' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );
        
        $this->add_responsive_control(
            'content_box_vertical_position',
            [
                'label' => esc_html__('Vertical position', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => -800,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-content-style1' => 'top: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );

        $this->add_responsive_control(
			'content_box',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'end' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'start',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .post-carousel-5 .carousel-content.content-style1-wrapper ' => 'justify-content: {{VALUE}};',
				],
                'condition' => [ 'content_style' => 'style1' ]
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'content_box_border',
				'selector' => '{{WRAPPER}} .carousel-content-style1',
                'condition' => [ 'content_style' => 'style1' ]
			]
		);

        $this->add_control(
            'title_more_options',
            [
                'label' => esc_html__( 'Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .carousel-content .item-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typo',
                'label' => esc_html__('Title Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .carousel-content .item-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '30'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '600'
                    ],
                ]
            ]
        );

        $this->add_control(
            'subtitle_more_options',
            [
                'label' => esc_html__( 'Subtitle', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [ 'content_style' => 'default' ]
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => esc_html__( 'Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .carousel-content .subtitle' => 'color: {{VALUE}}',
                ],
                'condition' => [ 'content_style' => 'default' ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typo',
                'label' => esc_html__('Subtitle Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .carousel-content .subtitle',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '25'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '300'
                    ],
                    'condition' => [ 'content_style' => 'default' ]
                ]
            ]
        );

        $this->add_control(
            'desc_more_options',
            [
                'label' => esc_html__( 'Description', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );

        $this->add_control(
            'desc_color',
            [
                'label' => esc_html__( 'Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-post-content' => 'color: {{VALUE}}',
                ],
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typo',
                'label' => esc_html__('Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .carousel-post-content',
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );
        
        $this->add_responsive_control(
            'desc_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .carousel-post-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );
        
        $this->add_control(
            'comments_more_options',
            [
                'label' => esc_html__( 'Comment', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'after',
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );

        $this->add_control(
            'comment_color',
            [
                'label' => esc_html__( 'Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons .post-comments' => 'color: {{VALUE}}',
                ],
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );

        $this->add_control(
            'comment_backcolor',
            [
                'label' => esc_html__( 'Background color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons .post-comments' => 'background-color: {{VALUE}}',
                ],
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'comment_typo',
                'label' => esc_html__('Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .carousel-buttons .post-comments',
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );
        
        $this->add_responsive_control(
            'comment_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons .post-comments' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );
        
        $this->add_responsive_control(
            'comment_radius',
            [
                'label' => esc_html__('Border radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons .post-comments' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [ 'content_style' => 'style1' ]
            ]
        );

        $this->add_control(
            'meta_more_options',
            [
                'label' => esc_html__( 'Meta', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'meta_color',
            [
                'label' => esc_html__( 'Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .carousel-content .metas .meta' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'meta_backcolor',
            [
                'label' => esc_html__( 'Background color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-content .metas .meta' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'meta_typo',
                'label' => esc_html__('Meta Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .carousel-content .metas .meta',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '600'
                    ],
                ]
            ]
        );

        $this->add_responsive_control(
            'meta_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .carousel-content .metas .meta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'meta_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .carousel-content .metas' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'meta_radius_hover',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .carousel-content .metas .meta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'btn_more_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs('btn_style_tabs');
        $this->start_controls_tab('btn_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_responsive_control(
            'btn_icon_size',
            [
                'label' => esc_html__('Icon Size', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 5,
                        'max' => 60,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 17,
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons a i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .carousel-buttons a svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'btn_icon_color',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons a i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .carousel-buttons a :is(svg, path)' => 'fill: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'btn_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons a' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'btn_typo',
                'label' => esc_html__('Button Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .carousel-buttons a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '21'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '600'
                    ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg',
                'selector' => '{{WRAPPER}} .carousel-buttons a',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => [
                        'default' => 'classic'
                    ],
                    'color' => [
                        'default' => '#FF2942'
                    ],
                ]
            ]
        );

        $this->add_responsive_control(
            'btn_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 8,
                    'right' => 8,
                    'bottom' => 8,
                    'left' => 8,
                ]
            ]
        );

        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'btn_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'selector' => '{{WRAPPER}} .carousel-buttons a',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_shadow',
                'selector' => '{{WRAPPER}} .carousel-buttons a',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('btn_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_control(
            'btn_icon_color_hover',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons a:hover i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .carousel-buttons a:hover :is(svg, path)' => 'fill: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'btn_text_color_hover',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons a:hover' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_hover',
                'selector' => '{{WRAPPER}} .carousel-buttons a:hover',
                'exclude' => ['image'],
            ]
        );

        $this->add_responsive_control(
            'btn_border_radius_hover',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .carousel-buttons a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border_hover',
                'selector' => '{{WRAPPER}} .carousel-buttons a:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_shadow_hover',
                'selector' => '{{WRAPPER}} .carousel-buttons a:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'box_style_section',
            [
                'label' => __('Box', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'box_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'rem', 'em'],
                'range' => [
                    'px' => [
                        'min' => 250,
                        'max' => 2000,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 800,
                ],
                'tablet_default' => [
                    'unit' => 'px',
                    'size' => 500,
                ],
                'mobile_default' => [
                    'unit' => 'px',
                    'size' => 300,
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-item' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'wrap_top_shadow_color',
            [
                'label' => esc_html__('Top Shadow Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .carousel-item:before' => 'background:{{VALUE}};background:linear-gradient(0deg, rgba(255,255,255,0) 5%, {{VALUE}} 90%)',
                ]
            ]
        );

        $this->add_control(
            'wrap_bottom_shadow_color',
            [
                'label' => esc_html__('Bottom Shadow Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .carousel-item:after' => 'background:{{VALUE}};background:linear-gradient(180deg, rgba(255,255,255,0) 5%, {{VALUE}} 90%)',
                ]
            ]
        );

        $this->add_responsive_control(
            'wrap_padding',
            [
                'label' => esc_html__('Item padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'top' => 3,
                    'right' => 2,
                    'bottom' => 3,
                    'left' => 2,
                ],
                'mobile_default' => [
                    'unit' => 'rem',
                    'top' => 1,
                    'right' => 1,
                    'bottom' => 1,
                    'left' => 1,
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'widget_padding',
            [
                'label' => esc_html__('Box padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-5 .large-slider .swiper-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'wrap_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .carousel-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'thumb_style_options',
            [
                'label' => esc_html__( 'Thumbnails', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'thumb_positions',
            [
                'type' => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label' => esc_html__( 'Position', 'ahura' ),
                'label_off' => esc_html__( 'Active', 'ahura' ),
                'label_on' => esc_html__( 'Inactive', 'ahura' ),
                'return_value' => 'yes',
            ]
        );
        $this->start_popover();

        $this->add_control(
            'thumb_left_position',
            [
                'label' => esc_html__( 'Left', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem', 'em', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-thumbs' => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'thumb_right_position',
            [
                'label' => esc_html__( 'Right', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem', 'em', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-thumbs' => 'right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'thumb_bottom_position',
            [
                'label' => esc_html__( 'Bottom', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem', 'em', '%'],
                'range' => [
                    'px' => [
                        'min' => -500,
                        'max' => 1000,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .carousel-thumbs' => 'bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_popover();

        $this->add_control(
            'wrapper_thumb_width',
            [
                'label' => esc_html__( 'Wrap width', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem', 'em', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 800,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-5 .carousel-thumbs' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'thumb_width',
            [
                'label' => esc_html__( 'Width', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem', 'em', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-5 .carousel-thumbs img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'thumb_height',
            [
                'label' => esc_html__( 'Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'rem', 'em', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-5 .carousel-thumbs img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'thumbs_border_tabs'
        );
        
        $this->start_controls_tab(
            'thumbs_normal_border_tab',
            [
                'label' => esc_html__( 'Normal', 'ahura' ),
            ]
        );
        
        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'thumbs_border',
				'selector' => '{{WRAPPER}} .post-carousel-5 .carousel-thumbs img',
			]
		);
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'thumbs_active_border_tab',
            [
                'label' => esc_html__( 'Active', 'ahura' ),
            ]
        );
        
        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'thumbs_active_border',
				'selector' => '{{WRAPPER}} .post-carousel-5 .thumbs-slider .swiper-slide.swiper-slide-thumb-active img',
			]
		);
        
        $this->end_controls_tab();
        
        $this->end_controls_tabs();

        $this->add_control(
            'thumb_scale',
            [
                'label' => esc_html__( 'Scale', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-5 .thumbs-slider .swiper-slide:not(.swiper-slide-thumb-active)' => 'transform: scale({{SIZE}});',
                ],
            ]
        );

        $this->add_control(
            'thumbs_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .thumbs-slider' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
			'thumb_box_shadow',
			[
				'label' => esc_html__( 'Active item box shadow', 'ahura' ),
				'type' => \Elementor\Controls_Manager::BOX_SHADOW,
				'selectors' => [
					'{{SELECTOR}} .post-carousel-5 .thumbs-slider .swiper-slide-thumb-active img' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
				],
			]
		);
        
        $this->add_control(
			'arrows_options',
			[
				'label' => esc_html__( 'Arrows', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'arrow_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-carousel5-arrow i' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'arrow_backgroundcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-carousel5-arrow i' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
            'thumb_top_position',
            [
                'label' => esc_html__( 'Top position', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => -300,
                        'max' => 500,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel5-arrow' => 'top: {{SIZE}}px;',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $show_type = $settings['show_type'];
        $readmore_words = $settings['readmore_words'] ? $settings['readmore_words'] : 40;
        $empty_button = empty($settings['btn_icon']['value']) && empty($settings['btn_text']);

        $sliderData = [
            'autoplay' => $settings['auto_play'] == 'yes',
            'effect' => $settings['slide_fade'] == 'yes' ? 'fade' : null,
            'delay' => $settings['play_delay'],
            'slidesPerView' => $settings['slider_count'],
            'arrows' => $settings['show_arrow_thumbs'] === 'yes',
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];

        $posts_args = [
            'posts_per_page' => $settings['slider_count'],
        ];

        if($show_type == 'category' && !empty($settings['post_categories'])){
            $posts_args['cat'] = $settings['post_categories'];
        }

        if($show_type == 'custom'){
            $selected_posts = $settings['selected_posts'];
            $selected_posts = ahura_sanitize_posts((!is_array($selected_posts) ? [$selected_posts] : $selected_posts));
            $posts_args['post__in'] = $selected_posts;
            if($selected_posts){
                unset($posts_args['posts_per_page']);
            } else {
                $posts_args['posts_per_page'] = $selected_posts;
            }
        }

        $posts = new \WP_Query($posts_args);

        if (!$posts->have_posts())
            return false;
        ?>
        <div class="post-carousel-5">
            <div class="swiper large-slider" data-slider='<?php echo json_encode($sliderData) ?>' dir="<?php echo is_rtl() ? 'rtl' : 'ltr' ?>">
                <div class="swiper-wrapper">
                    <?php
                    while ($posts->have_posts()): $posts->the_post();
                        $large_cover = get_post_meta(get_the_ID(), '_large_cover', true);
                        $cover = !empty($large_cover) ? $large_cover : get_the_post_thumbnail_url(get_the_ID(),'full');
                        $subtitle = get_post_meta(get_the_ID(), '_subtitle', true);
                        $likes = ahura_get_post_likes_percent(get_the_ID()); ?>
                        <div class="swiper-slide">
                            <div class="carousel-item" style="background-image:url(<?php echo $cover ?>)">
                            <?php if($settings['content_style'] === 'default'): ?>
                                <div class="carousel-content carousel-content-default">
                                    <h4 class="item-title"><?php the_title() ?></h4>
                                    <?php if (!empty($subtitle)): ?>
                                        <div class="subtitle"><?php echo $subtitle ?></div>
                                    <?php endif; ?>
                                    <div class="metas">
                                        <?php if (!empty($likes)): ?>
                                            <span class="movie-rate"><i class="fas fa-thumbs-up"></i>%<?php echo $likes ?> <?php echo __('User Satisfaction', 'ahura') ?></span>
                                        <?php endif; ?>
                                        <?php if($settings['show_cats'] === 'yes'): ?>
                                            <span class="meta">
                                                <?php echo __('Category:', 'ahura') ?> <?php the_category((is_rtl() ? '، ' : ', ')) ?>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <?php if(!$empty_button): ?>
                                        <div class="carousel-buttons">
                                            <a href="<?php the_permalink() ?>">
                                                <?php \Elementor\Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                <?php echo $settings['btn_text'] ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php elseif($settings['content_style'] === 'style1'): ?>
                                <div class="carousel-content content-style1-wrapper">
                                    <div class="carousel-content-style1">
                                        <?php if(!empty($settings['new_tag'])): ?>
                                            <div class="metas">
                                                <span class="meta tag"><?php echo $settings['new_tag']; ?></span>
                                            </div>
                                        <?php endif; ?>
                                        <h4 class="item-title">
                                            <a href="<?php the_permalink() ?>">
                                                <?php the_title() ?>
                                            </a>
                                        </h4>
                                        <div class="carousel-post-content">
                                            <?php echo wp_trim_words(get_the_excerpt(), $readmore_words, $settings['readmore_dots']); ?>
                                        </div>
                                        <div class="carousel-buttons">
                                            <?php if($settings['show_comments'] === 'yes' && get_comments_number() > 0): ?>
                                                <?php $comment_prefix = get_comments_number() == 1 ? __(' Comment', 'ahura') : __(' Comments', 'ahura'); ?>
                                                <div class="post-comments">
                                                    <svg width="26" height="26" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <g clip-path="url(#clip0_1_204)">
                                                        <path d="M26 13C26 5.8203 20.1797 0 13 0C5.8203 0 0 5.8203 0 13C0 20.1797 5.8203 26 13 26C20.1797 26 26 20.1797 26 13Z" fill="white"/>
                                                        <path opacity="0.4" d="M6.33331 13.6467V9.66003C6.33331 7.82003 7.82665 6.33337 9.66665 6.33337H16.3333C18.1733 6.33337 19.6666 7.82003 19.6666 9.66003V14.3133C19.6666 16.1467 18.1733 17.6333 16.3333 17.6333H15.3333C15.1266 17.6333 14.9266 17.7333 14.8 17.9L13.8 19.2267C13.36 19.8133 12.64 19.8133 12.2 19.2267L11.2 17.9C11.0933 17.7533 10.8533 17.6333 10.6666 17.6333H9.66665C7.82665 17.6333 6.33331 16.1467 6.33331 14.3133V13.6467Z" fill="#6C5DD3"/>
                                                        <path d="M16.3334 10.8333H9.66669C9.39335 10.8333 9.16669 10.6067 9.16669 10.3333C9.16669 10.06 9.39335 9.83337 9.66669 9.83337H16.3334C16.6067 9.83337 16.8334 10.06 16.8334 10.3333C16.8334 10.6067 16.6067 10.8333 16.3334 10.8333Z" fill="#6C5DD3"/>
                                                        <path d="M13.6667 14.1667H9.66669C9.39335 14.1667 9.16669 13.94 9.16669 13.6667C9.16669 13.3933 9.39335 13.1667 9.66669 13.1667H13.6667C13.94 13.1667 14.1667 13.3933 14.1667 13.6667C14.1667 13.94 13.94 14.1667 13.6667 14.1667Z" fill="#6C5DD3"/>
                                                        </g>
                                                        <defs>
                                                        <clipPath id="clip0_1_204">
                                                        <rect width="26" height="26" fill="white"/>
                                                        </clipPath>
                                                        </defs>
                                                    </svg>
                                                    <span class="<?php echo is_rtl() ? 'mr-1' : 'ml-1'; ?>">
                                                        <?php echo get_comments_number(); ?>
                                                        <?php echo $comment_prefix; ?>
                                                    </span>
                                                </div>
                                            <?php endif; ?>
                                            <?php if(!$empty_button): ?>
                                                <a href="<?php the_permalink() ?>">
                                                    <?php \Elementor\Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                    <?php echo $settings['btn_text'] ?>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            </div>
                        </div>
                    <?php
                    endwhile;
                    wp_reset_query();
                    ?>
                </div>
            </div>
            <div class="carousel-thumbs">
                <div thumbsSlider class="swiper thumbs-slider" dir="<?php echo is_rtl() ? 'rtl' : 'ltr' ?>">
                    <div class="swiper-wrapper">
                        <?php while ($posts->have_posts()): $posts->the_post(); ?>
                            <div class="swiper-slide">
                                <?php echo get_the_post_thumbnail() ?>
                            </div>
                        <?php
                        endwhile;
                        wp_reset_query();
                        ?>
                    </div>
                    <?php if($settings['show_arrow_thumbs'] === 'yes'): ?>
                        <div class="post-carousel5-arrow post-carousel5-button-prev"><i class="fa fa-chevron-left"></i></div>
                        <div class="post-carousel5-arrow post-carousel5-button-next"><i class="fa fa-chevron-right"></i></div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
    }
}
