<?php

namespace ahura\inc\widgets;

use ahura\app\mw_assets;
use ahura\app\Post_Meta;
use Elementor\Controls_Manager;

defined('ABSPATH') or die('No script kiddies please!');

class portfolio5 extends \ahura\app\elementor\Elementor_Widget_Base
{

    public function get_name()
    {
        return 'portfolio5';
    }

    public function get_title()
    {
        return __('Portfolio 5', 'ahura');
    }

    public function get_icon()
    {
        return 'aicon-svg-item-portfolio';
    }

    public function get_categories()
    {
        return ['ahuraelements', 'ahuraportfolio'];
    }
    function get_keywords()
    {
        return ['ahura', 'portfolio 5', esc_html__('ahura', 'ahura'), esc_html__('Portfolio 5', 'ahura')];
    }

    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_script('portfolio5_script', mw_assets::get_js('elementor.portfolio5'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('portfolio5_style', mw_assets::get_css('elementor.portfolio5'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('portfolio5_script')];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'ahura'),
                'tab'     => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'tab_title',
            [
                'label' => esc_html__('Tab Title', 'ahura'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('Default title', 'ahura'),
            ]
        );

        $terms = get_terms(array(
            'taxonomy'   => 'portfolio_cat',
            'hide_empty' => false,
        ));

        $categories = [];

        if (!empty($terms) && !is_wp_error($terms)) {
            foreach ($terms as $term) {
                $categories[$term->term_id] = $term->name;
            }
        }

        $repeater->add_control(
            'cat_id',
            [
                'label' => esc_html__('Category', 'ahura'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'options' => $categories,
            ]
        );

        $repeater->add_control(
            'items_count',
            [
                'label' => esc_html__('Count', 'ahura'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 6,
                'min' => 1,
                'step' => 1
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'ahura'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ tab_title }}}',
                'default' => [
                    ['tab_title' => __('All', 'ahura')]
                ]
            ]
        );

        $this->add_control(
			'read_more_text',
			[
				'label' => esc_html__( 'Read more text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'See Details', 'ahura' ),
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'slider_section',
            [
                'label' => __('Slider', 'ahura'),
                'tab'     => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides per view', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    1 => '1',
                    2 => '2',
                    3 => '3',
                    4 => '4',
                    5 => '5',
                    6 => '6',
                ],
                'default' => 4,
            ]
        );

        $this->add_control(
			'autoplay_status',
			[
				'label' => esc_html__( 'Autoplay', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'ahura' ),
				'label_off' => esc_html__( 'No', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'transition_duration',
			[
				'label' => esc_html__( 'Transition duration', 'ahura' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 500,
				'max' => 10000,
				'step' => 1,
				'default' => 2400,
			]
		);
        
        $this->end_controls_section();
        
        $this->start_controls_section(
            'tabs_style_section',
            [
                'label' => __('Tabs', 'ahura'),
                'tab'     => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
			'tabs_margin',
			[
				'label' => esc_html__( 'Tabs wrapper margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 20,
					'right' => 0,
					'bottom' => 60,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .tabs-list' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'tab_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .tabs-list a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'tab_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 7,
					'right' => 10,
					'bottom' => 7,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .tabs-list a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'tab_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tabs-list a' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'tab_active_color',
			[
				'label' => esc_html__( 'Active color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000000',
				'selectors' => [
					'{{WRAPPER}} .tabs-list a.active' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'tab_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tabs-list a' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'tab_active_backcolor',
			[
				'label' => esc_html__( 'Active background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#99CF63',
				'selectors' => [
					'{{WRAPPER}} .tabs-list a.active' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'tab_border_color',
			[
				'label' => esc_html__( 'Border color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000000',
				'selectors' => [
					'{{WRAPPER}} .tabs-list a' => 'border: 1px solid {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'tab_active_border_color',
			[
				'label' => esc_html__( 'Active border color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#99CF63',
				'selectors' => [
					'{{WRAPPER}} .tabs-list a.active' => 'Border: 1px solid {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'tab_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 100,
					'right' => 100,
					'bottom' => 100,
					'left' => 100,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .tabs-list a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'tab_width',
			[
				'label' => esc_html__( 'Min width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 120,
				],
				'selectors' => [
					'{{WRAPPER}} .tabs-list a' => 'min-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();
        
        $this->start_controls_section(
            'items_style_section',
            [
                'label' => __('Item', 'ahura'),
                'tab'     => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'item_general_options',
			[
				'label' => esc_html__( 'General', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'item_general_margin',
			[
				'label' => esc_html__( 'Wrapper margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .tabs-content-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'img_options',
			[
				'label' => esc_html__( 'Image', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'image_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 15,
					'right' => 15,
					'bottom' => 15,
					'left' => 15,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .item-cover img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'image_radius_onhover',
			[
				'label' => esc_html__( 'Border radius on hover', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 100,
					'right' => 100,
					'bottom' => 100,
					'left' => 100,
					'unit' => '%',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .portfolio-item:hover .item-cover img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'image_border',
				'selector' => '{{WRAPPER}} .item-cover img',
			]
		);

        $this->add_control(
			'title_options',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'title_prefix_color',
			[
				'label' => esc_html__( 'Prefix color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-title:before' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'title_prefix_margin',
			[
				'label' => esc_html__( 'Prefix margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => is_rtl() ? 0 : 10,
					'bottom' => 0,
					'left' => is_rtl() ? 10 : 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .item-title:before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'title_prefix_width',
			[
				'label' => esc_html__( 'Prefix width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .item-title:before' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-title' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .item-title',
			]
		);

        $this->add_control(
			'desc_options',
			[
				'label' => esc_html__( 'Description', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'desc_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .item-desc' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
				'selector' => '{{WRAPPER}} .item-desc',
			]
		);

        $this->add_control(
			'details_options',
			[
				'label' => esc_html__( 'Details', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'details_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FFFFFF',
				'selectors' => [
					'{{WRAPPER}} .item-details-onhover span' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'details_back_color',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#99CF63',
				'selectors' => [
					'{{WRAPPER}} .item-details-onhover span' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'details_typography',
				'selector' => '{{WRAPPER}} .item-details-onhover span',
			]
		);
        
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $items = $settings['items'];
        $autoplay_status = isset($settings['autoplay_status']) && $settings['autoplay_status'] === 'yes';
        $read_more_text = isset($settings['read_more_text']) ? $settings['read_more_text'] : null;

        if (empty($items))
            return false;
        
        $slider_data = [
            'widgetID' => $wid,
            'autoPlay' => $autoplay_status,
            'transitionDuration' => (isset($settings['transition_duration']) && intval($settings['transition_duration'])) ? $settings['transition_duration'] : 4500,
            'slidesPerView' => (isset($settings['slides_per_view']) && intval($settings['slides_per_view'])) ? $settings['slides_per_view'] : 3,
            'tabletPerView' => (isset($settings['slides_per_view_tablet']) && intval($settings['slides_per_view_tablet'])) ? $settings['slides_per_view_tablet'] : 2,
            'mobilePerView' => (isset($settings['slides_per_view_mobile']) && intval($settings['slides_per_view_mobile'])) ? $settings['slides_per_view_mobile'] : 1,
            'observer' => true
        ]; ?>
        <div class="portfolio5-element portfolio5-element-<?php echo $wid; ?>">
            <div class="d-flex justify-content-center align-items-center flex-wrap tabs-list">
                <?php $i = 0;
                foreach ($items as $item) :
                    $args = ['post_type' => 'portfolio', 'posts_per_page' => $item['items_count']];
                    if (!empty($item['cat_id'])) $args['tax_query'] = [ [ 'taxonomy' => 'portfolio_cat', 'field' => 'term_id', 'terms' => $item['cat_id'] ] ];
                    $query = new \WP_Query($args);
                    $items_number = $query->post_count; ?>

                    <a href="#" class="tab-item <?php echo $i === 0 ? 'active' : '' ?>" data-tab="#tab-content-<?php echo $item['_id'] ?>" rel="nofollow noopener">
                        <?php echo $item['tab_title'] ?>
                        <span class="items-number"><?php echo '[' . $items_number . ']'; ?></span>
                    </a>
                <?php $i++;
                endforeach; ?>
            </div>

            <div class="tabs-content-wrap">
                <?php $i = 0;
                foreach ($items as $item) :
                    $category = $item['cat_id'];
                    $args = ['post_type' => 'portfolio', 'posts_per_page' => $item['items_count']];
                    if (!empty($category)) {
                        $args['tax_query'] = [
                            [
                                'taxonomy' => 'portfolio_cat',
                                'field' => 'term_id',
                                'terms' => $category,
                            ],
                        ];
                    }
                    $query = new \WP_Query($args); ?>
                    <div class="tab-content-wrap" id="tab-content-<?php echo $item['_id'] ?>" style="display:<?php echo $i === 0 ? 'block' : 'none' ?>">
                        <?php if ($query->have_posts()) : ?>
                            <div class="swiper posts-carousel" data-slider='<?php echo json_encode($slider_data) ?>'>
                                <div class="swiper-wrapper">
                                    <?php while ($query->have_posts()) : $query->the_post();
                                    $customer_name = Post_Meta::get_portfolio_customer_name(); ?>
                                        <div class="swiper-slide">
                                            <div class="portfolio-item">
                                                <a href="<?php the_permalink() ?>">
                                                    <div class="d-flex justify-content-center align-items-center item-cover"><?php the_post_thumbnail() ?></div>
                                                    <div class="item-details-wrapper">
                                                        <div class="d-flex flex-column justify-content-between item-details">
                                                            <h3 class="d-flex align-items-center item-title"><?php echo the_title() ?></h3>
                                                            <?php if ($customer_name) : ?>
                                                                <div class="item-desc"><?php echo $customer_name ?></div>
                                                            <?php endif; ?>
                                                        </div>
                                                        <?php if(!is_null($read_more_text)): ?>
                                                            <div class="item-details-onhover">
                                                                <span><?php echo $read_more_text; ?></span>
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                </div>
                            </div>
                            <?php wp_reset_query(); ?>
                        <?php else :
                            $this->renderElementorNotice(__('Sorry, no items were found to display.', 'ahura'));
                        endif; ?>
                    </div>
                <?php $i++;
                endforeach; ?>
            </div>
        </div>
    <?php
    }
}
