<?php

namespace ahura\inc\widgets;

// Block direct access to the main plugin file.

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

defined('ABSPATH') or die('No script kiddies please!');

class portfolio4 extends \ahura\app\elementor\Elementor_Widget_Base
{
    use \ahura\app\traits\mw_elementor;
    function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('elementor_portfolio4', mw_assets::get_js('elementor.portfolio4'));
    }
    public function __register_assets()
    {
        $this->register_elementor_style('elementor_portfolio4', mw_assets::get_css('elementor.portfolio4'));
    }

    function get_script_depends()
    {
        return [mw_assets::get_handle_name('elementor_portfolio4')];
    }
    public function get_name()
    {
        return 'ahura_portfolio4';
    }
    function get_title()
    {
        return esc_html__('Portfolio 4', 'ahura');
    }
    function get_categories()
    {
        return ['ahuraelements', 'ahuraportfolio'];
    }
    function get_keywords()
    {
        return ['ahura', 'work', 'portfolio 4', 'portfolio', esc_html__('ahura', 'ahura'), esc_html__('Portfolio 3', 'ahura')];
    }
    protected function register_controls()
    {
        $this->start_controls_section(
            'items_content',
            [
                'label' => esc_html__('Items', 'ahura'),
            ]
        );

		$terms = get_terms(array(
            'taxonomy'   => 'portfolio_cat',
            'hide_empty' => false,
        ));

        $categories = [];

        if(!empty($terms) && !is_wp_error($terms)){
            foreach ($terms as $term){
                $categories[$term->term_id] = $term->name;
            }
        }

        $this->add_control(
            'cat_id',
            [
                'label' => esc_html__( 'Category', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'options' => $categories,
            ]
        );

        $this->add_control(
            'items_count',
            [
                'label' => esc_html__( 'Count', 'ahura' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 6,
                'min' => 1,
                'step' => 1
            ]
        );

        $this->end_controls_section();
		
        $this->start_controls_section(
            'slider_content',
            [
                'label' => esc_html__('Slider', 'ahura'),
            ]
        );

		$this->add_control(
			'loop_status',
			[
				'label' => esc_html__( 'Loop', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'autoplay_status',
			[
				'label' => esc_html__( 'Autoplay', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'nav_status',
			[
				'label' => esc_html__( 'Navigation', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'observer_status',
			[
				'label' => esc_html__( 'Inner Slider', 'ahura' ),
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'transition_duration',
			[
				'label' => esc_html__( 'Price', 'ahura' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 500,
				'max' => 10000,
				'step' => 1,
				'default' => 2400,
			]
		);

		$this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides per view', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    1 => '1',
                    2 => '2',
                    3 => '3',
                    4 => '4',
                    5 => '5',
                    6 => '6',
                ],
                'default' => 4,
            ]
        );

        $this->end_controls_section();

        
        $this->start_controls_section(
            'general_style',
            [
                'label' => esc_html__('General', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
			'box_button_padding',
			[
				'label' => esc_html__( 'margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'default' => [
					'top' => 0,
                    'right' => is_rtl() ? -100 : 0,
                    'bottom' => 0,
                    'left' => is_rtl() ? 0 : -100,
                    'unit' => 'px',
                    'isLinked' => true,
				],
				'tablet_default' => [
					'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                    'unit' => 'px',
                    'isLinked' => true,
				],
				'mobile_default' => [
					'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                    'unit' => 'px',
                    'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .items-slider' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        
        $this->start_controls_section(
            'image_style',
            [
                'label' => esc_html__('image', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_responsive_control(
			'image_height',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 400,
				],
				'selectors' => [
					'{{WRAPPER}} .portfolio-thumbnail' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'image_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 20,
					'right' => 20,
					'bottom' => 20,
					'left' => 20,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .portfolio-thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        
        $this->start_controls_section(
            'title_style',
            [
                'label' => esc_html__('Title', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .post-item .post-title',
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#000000',
				'selectors' => [
					'{{WRAPPER}} .post-item .post-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'title_background_color',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#D3FD06',
				'selectors' => [
					'{{WRAPPER}} .post-item .post-title' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'title_height',
			[
				'label' => esc_html__( 'Min height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'selectors' => [
					'{{WRAPPER}} .post-item .post-title' => 'min-height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 20,
					'right' => 20,
					'bottom' => 20,
					'left' => 20,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-item .post-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'title_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 20,
					'right' => 20,
					'bottom' => 20,
					'left' => 20,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-item .post-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        
        $this->start_controls_section(
            'nav_style',
            [
                'label' => esc_html__('Nav', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
			'nav_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#D3FD06',
				'selectors' => [
					'{{WRAPPER}} .swiper-navigation-btns .swiper-nav-button' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'nav_background_color',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => 'transparent',
				'selectors' => [
					'{{WRAPPER}} .swiper-navigation-btns .swiper-nav-button' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'nav_border_color',
			[
				'label' => esc_html__( 'Border color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#D3FD06',
				'selectors' => [
					'{{WRAPPER}} .swiper-navigation-btns .swiper-nav-button' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'nav_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 96,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-navigation-btns .swiper-nav-button' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'nav_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 96,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-navigation-btns .swiper-nav-button' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'nav_vertical_position',
			[
				'label' => esc_html__( 'Vertical position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => -700,
						'max' => 700,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => -240,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-navigation-btns' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'nav_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 15,
					'right' => 25,
					'bottom' => 15,
					'left' => 25,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-navigation-btns' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'nav_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 15,
					'right' => 15,
					'bottom' => 15,
					'left' => 15,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-navigation-btns .swiper-nav-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'nav_next_margin',
			[
				'label' => esc_html__( 'Next margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => is_rtl() ? 40 : 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-navigation-btns .swiper-btn-next' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'nav_pev_margin',
			[
				'label' => esc_html__( 'Previous margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => is_rtl() ? 0 : 40,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-navigation-btns .swiper-btn-prev' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
		$wid = $this->get_id();

		$slider_data = [
            'widgetID' => $wid,
            'autoPlay' => $settings['autoplay_status'] === 'yes' ? true : false,
            'transitionDuration' => !empty($settings['transition_duration']) ? $settings['transition_duration'] : 2500,
            'loop' => $settings['loop_status'] === 'yes' ? true : false,
            'desktopPerView'=> (isset($settings['slides_per_view']) && intval($settings['slides_per_view'])) ? $settings['slides_per_view'] : '',
            'tabletPerView'=> (isset($settings['slides_per_view_tablet']) && intval($settings['slides_per_view_tablet'])) ? $settings['slides_per_view_tablet'] : '',
            'mobilePerView'=> (isset($settings['slides_per_view_mobile']) && intval($settings['slides_per_view_mobile'])) ? $settings['slides_per_view_mobile'] : '',
            'navigation' => $settings['nav_status'] === 'yes' ? true : false,
            'observer' => $settings['observer_status'] === 'yes' ? true : false
        ];

		$args = [
			'post_type' => 'portfolio',
			'posts_per_page' => $settings['items_count'] ? $settings['items_count'] : 10,
			'order' => 'DESC',
			'orderby' => 'date'
		];

		if(!empty($category)){
			$args['tax_query'] = [
				[
					'taxonomy' => 'portfolio_cat',
					'field' => 'term_id',
					'terms' => $category,
				],
			];
		}

		$query = new \WP_Query( $args );

		if (!$query->have_posts()) return false; ?>

		<div class="ahura-portfolio4 ahura-portfolio4-<?php echo $wid; ?>">
			<div class="swiper items-slider" data-slider='<?php echo json_encode($slider_data) ?>' dir="<?php echo is_rtl() ? 'rtl' : 'ltr' ?>">
				<div class="swiper-wrapper">
					<?php if ($query->have_posts()) : ?>
						<?php while ($query->have_posts()) : $query->the_post(); ?>
							<div class="swiper-slide">
								<a href="<?php the_permalink(); ?>" class="post-item">
									<?php if (has_post_thumbnail()) : ?>
										<div class="portfolio-thumbnail">
											<?php the_post_thumbnail('full'); ?>
										</div>
									<?php endif; ?>
									<div class="post-title">
										<h3><?php the_title(); ?></h3>
									</div>
								</a>
							</div>
						<?php endwhile; ?>
					<?php endif; ?>
					<?php wp_reset_postdata(); ?>
				</div>
			</div>
			<div class="swiper-navigation-btns">
				<div class="swiper-nav-button swiper-btn-prev">
					<svg width="23" height="40" viewBox="0 0 23 40" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M2.00003 2.12402L20.8572 20.124L2.00003 38.124" stroke="#D3FD06" stroke-width="2.3" stroke-linecap="round"/>
					</svg>
				</div>
				<div class="swiper-nav-button swiper-btn-next">
					<svg width="23" height="40" viewBox="0 0 23 40" fill="none" xmlns="http://www.w3.org/2000/svg">
						<path d="M21 2.12402L2.1428 20.124L21 38.124" stroke="#D3FD06" stroke-width="2.3" stroke-linecap="round"/>
					</svg>
				</div>
			</div>
		</div>
<?php
    }
}
