<?php

namespace ahura\inc\widgets;

// Block direct access to the main plugin file.

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

defined('ABSPATH') or die('No script kiddies please!');

class portfolio3 extends \ahura\app\elementor\Elementor_Widget_Base
{
    use \ahura\app\traits\mw_elementor;
    function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_script('elementor_portfolio3', mw_assets::get_js('elementor.portfolio3'));
    }
    public function __register_assets()
    {
        $this->register_elementor_style('elementor_portfolio3', mw_assets::get_css('elementor.portfolio3'));
    }

    function get_script_depends()
    {
        return [mw_assets::get_handle_name('elementor_portfolio3')];
    }
    public function get_name()
    {
        return 'ahura_portfolio3';
    }
    function get_title()
    {
        return esc_html__('Portfolio 3', 'ahura');
    }
    function get_categories()
    {
        return ['ahuraelements', 'ahuraportfolio'];
    }
    function get_keywords()
    {
        return ['ahura', 'work', 'portfolio 3', 'portfolio', esc_html__('ahura', 'ahura'), esc_html__('Portfolio 3', 'ahura')];
    }
    protected function register_controls()
    {
        $this->start_controls_section(
            'items_content',
            [
                'label' => esc_html__('Items', 'ahura'),
            ]
        );

        $items = new \Elementor\Repeater();

        $items->add_control(
            'item_title',
            [
                'label' => esc_html__('Title', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__('ex. Support in ticket system', 'ahura'),
                'default' => esc_html__('How can i submit new ticket?', 'ahura'),
            ]
        );

        $items->add_control(
			'item_image',
			[
				'label' => esc_html__( 'Choose Image', 'ahura' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        
        $items->add_control(
			'item_link',
			[
				'label' => esc_html__( 'Link', 'ahura' ),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => 'https://mihanwp.com/ahura/',
					'is_external' => true,
					'nofollow' => true,
				],
				'label_block' => true,
			]
		);

        $this->add_control(
            'items',
            [
                'type' => Controls_Manager::REPEATER,
                'label' => esc_html__('Items', 'ahura'),
                'title_field' => '{{{item_title}}}',
                'fields' => $items->get_controls(),
                'default' => [
                    [
                        'item_title' => esc_html__('UI/UX Design', 'ahura'),
                    ],
                    [
                        'item_title' => esc_html__('Graphic Design', 'ahura'),
                    ],
                    [
                        'item_title' => esc_html__('Illustration', 'ahura'),
                    ],
                    [
                        'item_title' => esc_html__('Logo & Branding', 'ahura'),
                    ],
                    [
                        'item_title' => esc_html__('Development', 'ahura'),
                    ],
                ],
            ]
        );
        $this->end_controls_section();

        // ICONS
        $this->start_controls_section(
            'icons_content',
            [
                'label' => esc_html__('Icons', 'ahura'),
            ]
        );
        $this->add_control(
            'item_icon_for_open',
            [
                'label' => esc_html__('Open icon', 'ahura'),
                'type' => Controls_Manager::ICONS,
            ]
        );

        $this->add_control(
            'item_icon_for_close',
            [
                'label' => esc_html__('Close icon', 'ahura'),
                'type' => Controls_Manager::ICONS,
            ]
        );

		$this->add_control(
			'icon_rotation_state',
			[
				'label' => esc_html__( 'Icon rotation', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->end_controls_section();

        // STYLES
        
        $this->start_controls_section(
            'box_style',
            [
                'label' => esc_html__('Box', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
			'title_area_margin',
			[
				'label' => esc_html__( 'Title area margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 30,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .ahura-portfolio3 .ah-items .ah-item .ah-title-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->add_responsive_control(
			'item_margin',
			[
				'label' => esc_html__( 'Iten margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 40,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .ahura-portfolio3 .ah-items .ah-item:not(:last-child)' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'item_border',
				'fields_options' => [
					'border' => [
						'default' => 'solid',
					],
					'width' => [
						'default' => [
							'top' => '0',
							'right' => '0',
							'bottom' => '1',
							'left' => '0',
							'isLinked' => true,
						],
					],
					'color' => [
						'default' => '#222222',
					],
				],
				'selector' => '{{WRAPPER}} .ahura-portfolio3 .ah-items .ah-item:not(:last-child)',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'title_style',
            [
                'label' => esc_html__('Title', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .ahura-portfolio3 .ah-item .ah-title .ah-title-value' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'title_active_color',
			[
				'label' => esc_html__( 'Active color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF8132',
				'selectors' => [
					'{{WRAPPER}} .ahura-portfolio3 .ah-item.ah-open .ah-title .ah-title-value' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .ahura-portfolio3 .ah-item .ah-title .ah-title-value',
                'fields_options' =>
				[
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '50'
						]
                    ],
                    'font_weight' => [
                        'default' => 800
                    ]
				]
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'number_style',
            [
                'label' => esc_html__('Number', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'number_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .ahura-portfolio3 .ah-item .ah-number' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'number_active_color',
			[
				'label' => esc_html__( 'Active color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF8132',
				'selectors' => [
					'{{WRAPPER}} .ahura-portfolio3 .ah-item.ah-open .ah-number' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'number_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .ahura-portfolio3 .ah-item .ah-number',
                'fields_options' =>
				[
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '35'
						]
                    ],
				]
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'icon_style',
            [
                'label' => esc_html__('Icon', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#222222',
				'selectors' => [
					'{{WRAPPER}} .ahura-portfolio3 .ah-items .ah-icon svg path' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .ahura-portfolio3 .ah-items .ah-icon svg' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'icon_active_color',
			[
				'label' => esc_html__( 'Active color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF8132',
				'selectors' => [
					'{{WRAPPER}} .ahura-portfolio3 .ah-items .ah-icon.ah-for-close svg path' => 'fill: {{VALUE}}',
					'{{WRAPPER}} .ahura-portfolio3 .ah-items .ah-icon.ah-for-close svg' => 'color: {{VALUE}}',
				],
			]
		);

        $icon_margin_side = is_rtl() ? 'margin-right' : 'margin-left';

        $this->add_responsive_control(
			'icon_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 70,
				],
				'selectors' => [
					'{{WRAPPER}} .ahura-portfolio3 .ah-items .ah-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .ahura-portfolio3 .ah-items .ah-icon' => $icon_margin_side . ': -{{SIZE}}{{UNIT}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'icon_border',
				'fields_options' => [
					'border' => [
						'default' => 'solid',
					],
					'width' => [
						'default' => [
							'top' => '1',
							'right' => '1',
							'bottom' => '1',
							'left' => '1',
							'isLinked' => true,
						],
					],
					'color' => [
						'default' => '#222222',
					],
				],
				'selector' => '{{WRAPPER}} .ahura-portfolio3 .ah-items .ah-icon',
			]
		);

        $this->add_responsive_control(
			'icon_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .ahura-portfolio3 .ah-items .ah-icon' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'icon_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 2,
					'right' => 2,
					'bottom' => 2,
					'left' => 2,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .ahura-portfolio3 .ah-items .ah-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'icon_rotation',
			[
				'label' => esc_html__( 'Rotation', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'deg' ],
				'range' => [
					'deg' => [
						'min' => -360,
						'max' => 360,
					],
				],
				'default' => [
					'unit' => 'deg',
					'size' => 45,
				],
				'selectors' => [
					'{{WRAPPER}} .ahura-portfolio3 .ah-items .ah-icon.ah-icon-rotate' => 'transform: rotate({{SIZE}}deg);',
				],
				'condition' => [ 'icon_rotation_state' => 'yes' ]
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'image_style',
            [
                'label' => esc_html__('Image', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
			'image_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .ahura-portfolio3 .ah-item .ah-image img' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $icon_margin_side = is_rtl() ? 'margin-right' : 'margin-left'; ?>
        <div class="ahura-portfolio3<?php echo $settings['icon_rotation_state'] !== 'yes' ? ' no-rotation' : ''; ?>">
            <div class="ah-items">
                <?php $counter = 1;
                foreach ($settings['items'] as $item) : ?>
                    <div class="ah-item <?php printf('elementor-repeater-item-%s', $item['_id']) ?> <?php echo 'portfolio-item-'.$counter; ?>">
                        <div class="d-flex justify-content-between align-items-center ah-title-section">
                            <?php if(!empty($item['item_title'])): ?>
                                <div class="d-flex align-items-center ah-title">
                                    <div class="ah-number <?php echo is_rtl() ? 'ml-4' : 'mr-4'; ?>"><?php printf("%02d", $counter); ?></div>
                                    <div class="ah-title-value"><?php echo $item['item_title']; ?></div>
                                </div>
                            <?php endif; ?>
                            <div class="justify-content-center align-items-center ah-icon ah-for-open" <?php echo 'style="'.$icon_margin_side.':-'.$settings['icon_width']['size'].'px"'; ?>>
                                <?php if(!empty($settings['item_icon_for_open']['value'])): ?>
                                    <?php \Elementor\Icons_Manager::render_icon($settings['item_icon_for_open']) ?>
                                <?php else: ?>
									<?php if(is_rtl()): ?>
										<svg xmlns="http://www.w3.org/2000/svg" height="54" viewBox="0 -960 960 960" width="54"><path d="m313-440 224 224-57 56-320-320 320-320 57 56-224 224h487v80H313Z"/></svg>
									<?php else: ?>
										<svg xmlns="http://www.w3.org/2000/svg" height="54" viewBox="0 -960 960 960" width="54">
										<path d="m647-440-224 224 57 56 320-320-320-320-57 56 224 224h-487v80h487Z"/>
										</svg>
									<?php endif; ?>
                                <?php endif; ?>
                            </div>

                            <div class="justify-content-center align-items-center ah-icon ah-for-close" <?php echo 'style="'.$icon_margin_side.':-'.$settings['icon_width']['size'].'px"'; ?>>
                                <?php if(!empty($settings['item_icon_for_close']['value'])): ?>
                                    <?php \Elementor\Icons_Manager::render_icon($settings['item_icon_for_close']) ?>
                                <?php else: ?>
									<?php if($settings['icon_rotation_state'] === 'yes'): ?>
										<?php if(is_rtl()): ?>
											<svg xmlns="http://www.w3.org/2000/svg" height="54" viewBox="0 -960 960 960" width="54"><path d="m313-440 224 224-57 56-320-320 320-320 57 56-224 224h487v80H313Z"/></svg>
										<?php else: ?>
											<svg xmlns="http://www.w3.org/2000/svg" height="54" viewBox="0 -960 960 960" width="54">
											<path d="m647-440-224 224 57 56 320-320-320-320-57 56 224 224h-487v80h487Z"/>
											</svg>
										<?php endif; ?>
									<?php else: ?>
										<?php if(is_rtl()): ?>
											<svg xmlns="http://www.w3.org/2000/svg" height="54" viewBox="0 -960 960 960" width="54"><path d="M704-240 320-624v344h-80v-480h480v80H376l384 384-56 56Z"/></svg>
										<?php else: ?>
											<svg xmlns="http://www.w3.org/2000/svg" height="54" viewBox="0 -960 960 960" width="54">
											<path d="M256-240 640-624v344h80v-480h-480v80h328l-384 384 56 56Z"/>
											</svg>
										<?php endif; ?>
									<?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if (!empty($item['item_image']['url'])): ?>
                            <div class="ah-image">
                                <a href="<?php echo $item['item_link']['url']; ?>">
                                    <img src="<?php echo $item['item_image']['url']; ?>">
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php $counter++;
                endforeach; ?>
            </div>
        </div>
<?php
    }
}
