<?php
namespace ahura\inc\widgets;

// Die if is direct opened file
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\mw_assets;
use Elementor\Utils;

class image_slider6 extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('image_slider6_js', mw_assets::get_js('elementor.image_slider6'), false);
    }

    public function __register_assets()
    {
        $this->register_elementor_style('image_slider6_css', mw_assets::get_css('elementor.image_slider6'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('image_slider6_js')];
    }

    /**
     *
     * Set element id
     *
     * @return string
     */
    public function get_name()
    {
        return 'image_slider6';
    }

    /**
     *
     * Set element widget
     *
     * @return mixed
     */
    public function get_title()
    {
        return esc_html__('Image Slider 6', 'ahura');
    }

    /**
     *
     * Set widget icon
     *
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     *
     * Set element category
     *
     * @return string[]
     */
    public function get_categories()
    {
        return ['ahuraelements'];
    }

    /**
     *
     * Keywords for search
     *
     * @return array
     */
    public function get_keywords()
    {
        return ['ahura', 'image', 'slider', 'image slider 6', esc_html__('ahura', 'ahura'), esc_html__('Image slider 6', 'ahura')];
    }

    /**
     *
     * Element controls option
     *
     */
    public function register_controls()
    {

        /**
         *
         * Start content section
         *
         */
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__( 'Choose Image', 'ahura' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'slides',
            [
                'label' => esc_html__('Slides', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    ['image' => ['url' => \Elementor\Utils::get_placeholder_image_src()]],
                    ['image' => ['url' => \Elementor\Utils::get_placeholder_image_src()]],
                    ['image' => ['url' => \Elementor\Utils::get_placeholder_image_src()]],
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'content_settings',
            [
                'label' => esc_html__('Settings', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'transition_duration',
            [
                'label' => esc_html__('Transition Duration', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 4500,
                'condition' => [
                    'autoplay' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label' => esc_html__('Infinite Loop', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();
        /**
         *
         * Styles
         *
         */
        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('Item', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'top_shadow_color',
            [
                'label' => esc_html__('Top Shadow Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => 'rgb(248 247 243)',
                'selectors' => [
                    '{{WRAPPER}} .image-slider-slides:after' => 'background: transparent linear-gradient(0deg, rgba(0, 0, 0, 0) 0%, {{VALUE}} 64%)',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_image_height',
            [
                'label' => esc_html__('Cover Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['%', 'px', 'rem', 'em'],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'px' => [
                        'min' => 0,
                        'max' => 3000
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 700
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 700
                    ],
                ],
                'default' => ['size' => 550, 'unit' => 'px'],
                'selectors' => [
                    '{{WRAPPER}} .slide-wrap img' => 'height: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'item_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .image-slider-slides' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .image-slider-slides :is(.slide-wrap, .slide-wrap img)' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 25,
                    'right' => 25,
                    'bottom' => 25,
                    'left' => 25,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .image-slider-slides .slide-wrap img',
            ]
        );

        $this->end_controls_section();
    }

    /**
     *
     * Render element content (html)
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $slides = $settings['slides'];

        $slider_data = [
            'autoPlay' => $settings['autoplay'] == 'yes',
            'transitionDuration' => (intval($settings['transition_duration'])) ? $settings['transition_duration'] : 4500,
            'loop' => $settings['infinite_loop'] == 'yes',
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];
        ?>
        <div class="image-slider-6">
            <div class="swiper image-slider-slides" data-slider='<?php echo json_encode($slider_data) ?>'>
                <div class="swiper-wrapper">
                    <?php
                    if($slides):
                        foreach($slides as $slide):
                            ?>
                            <div class="swiper-slide slide-item">
                                <div class="slide-wrap">
                                    <?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html($slide, 'full', 'image'); ?>
                                </div>
                            </div>
                        <?php
                        endforeach;
                    endif;
                    ?>
                </div>
            </div>
            <div class="swiper image-slider-thumbs" thumbsSlider>
                <div class="swiper-wrapper">
                    <?php
                    if($slides):
                        foreach($slides as $slide):
                            ?>
                            <div class="swiper-slide slide-item">
                                <?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html($slide, 'thumbnail', 'image'); ?>
                            </div>
                        <?php
                        endforeach;
                    endif;
                    ?>
                </div>
            </div>
        </div>
        <?php
    }
}
