<?php
namespace ahura\inc\widgets;

// Die if is direct opened file
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\mw_assets;
use Elementor\Utils;

class image_slider4 extends \ahura\app\elementor\Elementor_Widget_Base
{
    use \ahura\app\traits\link_utilities;

    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('image_slider4_js', mw_assets::get_js('elementor.image_slider4'), false);
    }

    public function __register_assets()
    {
        $this->register_elementor_style('image_slider4_css', mw_assets::get_css('elementor.image_slider4'));
        if(!is_rtl()){
            $this->register_elementor_style('image_slider4_ltr_css', mw_assets::get_css('elementor.ltr.image_slider4_ltr'));
        }
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('image_slider4_js')];
    }

    /**
     *
     * Set element id
     *
     * @return string
     */
    public function get_name()
    {
        return 'image_slider4';
    }

    /**
     *
     * Set element widget
     *
     * @return mixed
     */
    public function get_title()
    {
        return esc_html__('Image Slider 4', 'ahura');
    }

    /**
     *
     * Set widget icon
     *
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     *
     * Set element category
     *
     * @return string[]
     */
    public function get_categories()
    {
        return ['ahuraelements'];
    }

    /**
     *
     * Keywords for search
     *
     * @return array
     */
    public function get_keywords()
    {
        return ['ahura', 'image', 'slider', 'image slider 4', esc_html__('ahura', 'ahura'), esc_html__('Image Slider 4', 'ahura')];
    }

    /**
     *
     * Element controls option
     *
     */
    public function register_controls()
    {

        /**
         *
         * Start content section
         *
         */
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'item_image',
            [
                'label' => esc_html__('Image', 'ahura'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'ahura' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Rechargeable drills', 'ahura' ),
            ]
        );

        $repeater->add_control(
            'subtitle',
            [
                'label' => esc_html__( 'Sub Title', 'ahura' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'With brushless motor technology', 'ahura' ),
            ]
        );

        $repeater->add_control(
            'item_link',
            [
                'label' => esc_html__('Link', 'ahura'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                ],
            ]
        );

        $this->add_control(
            'slides',
            [
                'label' => esc_html__('Slides', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    ['item_image' => ['url' => Utils::get_placeholder_image_src()]],
                    ['item_image' => ['url' => Utils::get_placeholder_image_src()]],
                    ['item_image' => ['url' => Utils::get_placeholder_image_src()]]
                ]
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'content_settings',
            [
                'label' => esc_html__('Settings', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_arrows',
            [
                'label' => esc_html__('Arrows', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'transition_duration',
            [
                'label' => esc_html__('Transition Duration', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 2500,
                'condition' => [
                    'autoplay' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();
        /**
         *
         * Styles
         *
         */
        $alignment_option = [
            'right' => [
                'title' => __('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => __('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'left' => [
                'title' => __('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ]
        ];

        $this->start_controls_section(
            'slide_style',
            [
                'label' => esc_html__('Slide', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'img_height',
            [
                'label' => esc_html__( 'Image Height', 'ahura' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 400,
                ],
                'mobile_default' => [
                    'unit' => 'px',
                    'size' => 250,
                ],
                'selectors' => [
                    '{{WRAPPER}} .ah-image-box img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label' => __('Alignment', 'ahura'),
                'type'	=>	Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $alignment_option : array_reverse($alignment_option),
                'toggle' => false,
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .ah-details' => 'text-align: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .ah-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('Title Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .ah-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '800'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'em',
                            'size' => '3',
                        ]
                    ]
                ]
            ]
        );

        $this->add_control(
            'subtitle_color',
            [
                'label' => esc_html__( 'Subtitle Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .ah-subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typography',
                'label' => esc_html__('Subtitle Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .ah-subtitle',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '400'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'em',
                            'size' => '2',
                        ]
                    ]
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .ah-details-box',
            ]
        );

        $this->add_control(
            'box_shadow_color',
            [
                'label' => esc_html__( 'Shadow Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#2121210f',
                'selectors' => [
                    '{{WRAPPER}} .ah-details-box' => 'box-shadow: 0 0 0 10px {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'btn_more_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'btn_alignment',
            [
                'label' => __('Alignment', 'ahura'),
                'type'	=>	Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $alignment_option : array_reverse($alignment_option),
                'toggle' => false,
                'default' => is_rtl() ? 'left' : 'right',
                'selectors' => [
                    '{{WRAPPER}} .ah-buttons' => 'text-align: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_background',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .ah-buttons a',
            ]
        );

        $this->add_control(
            'btn_text_color',
            [
                'label' => esc_html__( 'Text Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .ah-buttons a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .ah-buttons a :is(svg, path)' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'selector' => '{{WRAPPER}} .ah-buttons a',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .ah-buttons a',
                'fields_options' => [
                    'box_shadow_type' => ['default' => 'yes'],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical' => 0,
                            'blur' => 0,
                            'spread' => 5,
                            'color' => '#fff3'
                        ]
                    ]
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_navigation_style',
            [
                'label' => esc_html__('Navigation', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'nav_options',
            [
                'label' => esc_html__('Navigation', 'ahura'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'box_nav_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#464646',
                'selectors' => [
                    '{{WRAPPER}} .swiper-nav-btn' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'box_nav_bg_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .swiper-nav-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_nav_border',
                'selector' => '{{WRAPPER}} .swiper-nav-btn',
                'fields_options' => [
                    'border' => [
                        'default' => 'solid'
                    ],
                    'width' => [
                        'default' => [
                            'unit' => 'px',
                            'top' => '1',
                            'right' => '1',
                            'bottom' => '1',
                            'left' => '1',
                        ]
                    ],
                    'color' => [
                        'default' => '#b1b1b1'
                    ]
                ]
            ]
        );

        $this->add_responsive_control(
            'nav_border_radius',
            [
                'label' => esc_html__('Border radius', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['%', 'px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-nav-btn' => 'border-radius: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_control(
            'paginate_options',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'box_paginate_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ff5023',
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'box_paginate_active_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ff5023',
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination-bullet-active' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .swiper-pagination-bullet-active:before' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     *
     * Render element content (html)
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $slides = $settings['slides'];

        $has_navigate = ($settings['show_arrows'] == 'yes');
        $has_paginate = ($settings['show_pagination'] == 'yes');

        $slider_data = [
            'autoplay' => $settings['autoplay'] == 'yes',
            'delay' => $settings['transition_duration'],
            'observer' => $settings['use_observer_slider'] == 'yes',
        ];
        ?>
        <div class="ahura-image-slider-4 <?php echo $has_paginate ? ' has-paginate' : '' ?><?php echo $has_navigate ? ' has-navigate' : '' ?>">
            <?php if (!empty($slides)): ?>
            <div class="ah-slider-wrap">
                <div dir="<?php echo is_rtl() ? 'rtl' : 'ltr' ?>" class="swiper ah-image-slider-4-swiper" data-slider='<?php echo json_encode($slider_data)?>'>
                    <div class="swiper-wrapper">
                        <?php
                        foreach($slides as $slide):
                            if ( ! empty( $slide['item_link']['url'] ) ) {
                                $this->add_link_attributes( 'item_link_' . $slide['_id'], $slide['item_link'] );
                            }
                            ?>
                            <div class="swiper-slide">
                                <div class="ah-item">
                                    <div class="ah-image-box">
                                        <?php
                                        if (!empty($slide['item_image']['id'])){
                                            echo wp_get_attachment_image( $slide['item_image']['id'], 'full' );
                                        } else {
                                            echo '<a ' . $this->get_render_attribute_string("item_link_" . $slide["_id"]) . '><img src="' . $slide['item_image']['url'] . '" alt="cover"></a>';
                                        }
                                        ?>
                                    </div>
                                    <div class="ah-details-box">
                                        <div class="ah-details">
                                            <div class="ah-title"><a <?php echo $this->get_render_attribute_string('item_link_' . $slide['_id']); ?>><?php echo $slide['title'] ?></a></div>
                                            <?php if(!empty($slide['subtitle'])): ?>
                                                <div class="ah-subtitle"><?php echo $slide['subtitle'] ?></div>
                                            <?php endif; ?>
                                            <?php if (!empty( $slide['item_link']['url'] )): ?>
                                                <div class="ah-buttons">
                                                    <a <?php echo $this->get_render_attribute_string('item_link_' . $slide['_id']); ?>>
                                                        <svg width="800px" height="800px" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"> <g id="icomoon-ignore"> </g> <path d="M12.792 15.233l-0.754 0.754 6.035 6.035 0.754-0.754-5.281-5.281 5.256-5.256-0.754-0.754-3.013 3.013z" fill="#000000"> </path> </svg>
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <?php if ($has_paginate): ?>
                        <div class="swiper-pagination"></div>
                    <?php endif; ?>
                    <?php if ($has_navigate): ?>
                        <div class="swiper-nav-btn swiper-button-next"></div>
                        <div class="swiper-nav-btn swiper-button-prev"></div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        </div>
        <?php
    }
}
