<?php
// Block direct access to the main plugin file.
defined('ABSPATH') or die('No script kiddies please!');

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

class Ahura_Popup_Login2 extends \ahura\app\elementor\Elementor_Widget_Base
{
    function __construct($data=[], $args=null)
    {
        parent::__construct($data, $args);
        $this->register_elementor_script('popup_login2_js', mw_assets::get_js('elementor.popup_login2'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('popup_login2_css', mw_assets::get_css('elementor.popup_login2'));
    }

    function get_script_depends()
    {
        return [$this->get_asset_handle_name('popup_login2_js')];
    }

    public function get_name()
    {
        return 'popup_login2';
    }

    public function get_title()
    {
        return esc_html__('Popup Login 2', 'ahura');
    }

    public function get_icon()
    {
        return 'eicon-user-circle-o';
    }

    public function get_categories()
    {
        return ['ahuraheader'];
    }

    public function get_keywords()
    {
        return ['ahura', 'popup', 'login', esc_html__('ahura' , 'ahura'), esc_html__('popup' , 'ahura'), esc_html__('login' , 'ahura'), esc_html__('Popup login 2', 'ahura')];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'btn_section',
            [
                'label' => esc_html__('Button', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_icon',
            [
                'label' => esc_html__('Show Icon', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'btn_icon',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );

        $this->add_control(
            'show_text',
            [
                'label' => esc_html__('Show Text', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'btn_text',
            [
                'label' => esc_html__('Login Button Text', 'ahura'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Login/Register', 'ahura'),
                'condition' => ['show_text' => 'yes']
            ]
        );

        $this->add_control(
            'user_btn_text',
            [
                'label' => esc_html__('After Login Button Text', 'ahura'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Account', 'ahura'),
                'condition' => ['show_text' => 'yes']
            ]
        );

        $this->add_control('hr3', ['type' => \Elementor\Controls_Manager::DIVIDER]);

        $this->add_control(
            'hide_in_scroll',
            [
                'label' => esc_html__('Hide in scroll', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'ahura' ),
                'label_off' => esc_html__( 'No', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Settings', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_register_btn',
            [
                'label' => esc_html__('Show Register Button', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['use_custom_form!' => 'yes']
            ]
        );

        $this->add_control(
            'register_box_icon',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'condition' => [
                    'show_register_btn' => 'yes',
                    'use_custom_form!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'register_text',
            [
                'label' => esc_html__('Register Text', 'ahura'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Don`t have an account?', 'ahura'),
                'condition' => [
                    'show_register_btn' => 'yes',
                    'use_custom_form!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'register_btn_text',
            [
                'label' => esc_html__('Register Button Text', 'ahura'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Create Account', 'ahura'),
                'condition' => [
                    'show_register_btn' => 'yes',
                    'use_custom_form!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'register_btn_link',
            [
                'label' => esc_html__( 'Button Link', 'ahura' ),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => [ 'url', 'is_external', 'nofollow' ],
                'label_block' => true,
                'dynamic' => ['active' => true],
                'condition' => [
                    'show_register_btn' => 'yes',
                    'use_custom_form!' => 'yes'
                ]
            ]
        );

        $this->add_control('hr2', ['type' => \Elementor\Controls_Manager::DIVIDER]);

        $this->add_control(
            'use_shortcode',
            [
                'label' => esc_html__('Use Shortcode', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'ahura' ),
                'label_off' => esc_html__( 'No', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => ['use_custom_form!' => 'yes']
            ]
        );

        $this->add_control(
            'form_shortcode',
            [
                'label' => esc_html__('Shortcode', 'ahura'),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'condition' => ['use_shortcode' => 'yes']
            ]
        );

        $this->add_control(
            'use_custom_form',
            [
                'label' => esc_html__('Use Custom Login Form', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'ahura' ),
                'label_off' => esc_html__( 'No', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => ['use_shortcode!' => 'yes']
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'after_login_section',
            [
                'label' => esc_html__('After Login', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'after_login_image',
            [
                'label' => esc_html__( 'Choose Image', 'ahura' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => mw_assets::get_img('crocodile-char', 'webp'),
                ],
            ]
        );

        $this->add_control(
            'after_login_text',
            [
                'label' => esc_html__( 'Text', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 5,
                'default' => esc_html__( 'Hello dear friend, you are a user of this website and you are logged in.', 'ahura' ),
            ]
        );

        $this->add_control(
            'after_login_btn_text',
            [
                'label' => esc_html__( 'Button Text', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Your Account', 'ahura' ),
            ]
        );

        $this->add_control(
            'after_login_btn_link',
            [
                'label' => esc_html__( 'Button Link', 'ahura' ),
                'type' => \Elementor\Controls_Manager::URL,
                'options' => [ 'url', 'is_external', 'nofollow' ],
                'label_block' => true,
                'dynamic' => ['active' => true]
            ]
        );

        $this->end_controls_section();

        /**
         *
         *
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'btn_style_section',
            [
                'label' => __( 'Button', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('btn_style_tabs');

        $this->start_controls_tab(
            'btn_style_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'ahura' ),
            ]
        );

        $alignment = array(
            'start' => [
                'title' => esc_html__('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'end' => [
                'title' => esc_html__('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ]
        );

        $this->add_control(
            'btn_text_align',
            [
                'label' => esc_html__('Text Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => (is_rtl()) ? $alignment : array_reverse($alignment),
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .toggle-login-btn' => 'justify-content: {{VALUE}}',
                ]
            ]
        );

        $this->add_responsive_control(
            'btn_width',
            [
                'label' => esc_html__('Width', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'rem', 'em'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 45
                ],
                'selectors' => [
                    '{{WRAPPER}} .toggle-login-btn' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'btn_icon_size',
            [
                'label' => esc_html__('Icon Size', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'rem', 'em'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 24
                ],
                'selectors' => [
                    '{{WRAPPER}} .toggle-login-btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .toggle-login-btn svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => ['show_icon' => 'yes']
            ]
        );

        $this->add_control(
            'btn_icon_color',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .toggle-login-btn i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .toggle-login-btn svg path' => 'fill: {{VALUE}}',
                ],
                'condition' => ['show_icon' => 'yes']
            ]
        );

        $this->add_control(
            'btn_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .toggle-login-btn span' => 'color: {{VALUE}}',
                ],
                'condition' => ['show_text' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Text Typography', 'ahura'),
                'name' => 'btn_text_typo',
                'selector' => '{{WRAPPER}} .toggle-login-btn span',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17',
                        ]
                    ]
                ],
                'condition' => [
                    'show_text' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg',
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .toggle-login-btn',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border',
                'selector' => '{{WRAPPER}} .toggle-login-btn',
            ]
        );

        $this->add_control(
            'btn_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .toggle-login-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .toggle-login-btn',
            ]
        );

        $this->add_control(
            'btn_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .toggle-login-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'btn_style_hover_tab',
            [
                'label' => esc_html__( 'Hover', 'ahura' ),
            ]
        );

        $this->add_control(
            'btn_icon_color_hover',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .toggle-login-btn:hover i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .toggle-login-btn:hover svg path' => 'fill: {{VALUE}}',
                ],
                'condition' => ['show_icon' => 'yes']
            ]
        );

        $this->add_control(
            'btn_text_color_hover',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .toggle-login-btn:hover span' => 'color: {{VALUE}}',
                ],
                'condition' => ['show_text' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'btn_bg_hover',
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .toggle-login-btn:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'btn_border_hover',
                'selector' => '{{WRAPPER}} .toggle-login-btn:hover',
            ]
        );

        $this->add_control(
            'btn_border_radius_hover',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .toggle-login-btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'btn_shadow_hover',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .toggle-login-btn:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'form_section',
            [
                'label' => __( 'Form', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'labels_options',
            [
                'label' => esc_html__( 'Labels', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'form_label_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#7e7e7e',
                'selectors' => [
                    '{{WRAPPER}} .login-fields-wrap label' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'ahura'),
                'name' => 'form_label_typo',
                'selector' => '{{WRAPPER}} .login-fields-wrap label',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'inputs_options',
            [
                'label' => esc_html__( 'Inputs', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'form_input_title_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} form input:not([type="radio"], [type="checkbox"], [type="submit"])' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'form_input_bg',
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} form input:not([type="radio"], [type="checkbox"], [type="submit"])',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'form_input_border',
                'selector' => '{{WRAPPER}} form input:not([type="radio"], [type="checkbox"], [type="submit"])',
            ]
        );

        $this->add_control(
            'form_input_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} form input:not([type="radio"], [type="checkbox"], [type="submit"])' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                    'unit' => 'px'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'form_input_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} form input:not([type="radio"], [type="checkbox"], [type="submit"])',
            ]
        );

        $this->add_control(
            'form_input_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} form input:not([type="radio"], [type="checkbox"], [type="submit"])' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 12,
                    'right' => 12,
                    'bottom' => 12,
                    'left' => 12,
                    'unit' => 'px'
                ]
            ]
        );

        $this->add_control(
            'buttons_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'form_btn_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} form :is(button[type="submit"], input[type=submit])' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'form_btn_bg',
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} form :is(button[type="submit"], input[type=submit])',
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#59b738']
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'form_btn_border',
                'selector' => '{{WRAPPER}} form :is(button[type="submit"], input[type=submit])',
            ]
        );

        $this->add_control(
            'form_btn_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} form :is(button[type="submit"], input[type=submit])' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                    'unit' => 'px'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'form_btn_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} form :is(button[type="submit"], input[type=submit])',
            ]
        );

        $this->add_control(
            'form_btn_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'selectors' => [
                    '{{WRAPPER}} form :is(button[type="submit"], input[type=submit])' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'cf_tabs_section',
            [
                'label' => __( 'Tabs', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => ['use_custom_form' => 'yes']
            ]
        );

        $this->start_controls_tabs('style_tabs');
        $this->start_controls_tab('style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_control(
            'tab_item_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .ahura-tabs .tab-item' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'tab_item_bg',
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .ahura-tabs .tab-item',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tab_item_border',
                'selector' => '{{WRAPPER}} .ahura-tabs .tab-item',
            ]
        );

        $this->add_control(
            'tab_item_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .ahura-tabs .tab-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 5,
                    'right' => 5,
                    'bottom' => 5,
                    'left' => 5,
                    'unit' => 'px'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tab_item_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .ahura-tabs .tab-item',
            ]
        );

        $this->add_control(
            'tab_item_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'selectors' => [
                    '{{WRAPPER}} .ahura-tabs .tab-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_control(
            'tab_item_color_hover',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ahura-tabs .tab-item:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'tab_item_bg_hover',
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .ahura-tabs .tab-item:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tab_item_border_hover',
                'selector' => '{{WRAPPER}} .ahura-tabs .tab-item:hover',
            ]
        );

        $this->add_control(
            'tab_item_radius_hover',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .ahura-tabs .tab-item:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tab_item_shadow_hover',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .ahura-tabs .tab-item:hover',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('style_active_tab', ['label' => esc_html__( 'Active', 'ahura' )]);

        $this->add_control(
            'tab_item_color_active',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '5b439b',
                'selectors' => [
                    '{{WRAPPER}} .ahura-tabs .tab-item.active' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'tab_item_bg_active',
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .ahura-tabs .tab-item.active',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'tab_item_border_active',
                'selector' => '{{WRAPPER}} .ahura-tabs .tab-item.active',
            ]
        );

        $this->add_control(
            'tab_item_radius_active',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .ahura-tabs .tab-item.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tab_item_shadow_active',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .ahura-tabs .tab-item.active',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'after_login_style_section',
            [
                'label' => __( 'After Login', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'afl_text_options',
            [
                'label' => esc_html__( 'Text', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'afl_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#5e5e5e',
                'selectors' => [
                    '{{WRAPPER}} .is-logged-wrap p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Text Typography', 'ahura'),
                'name' => 'afl_text_typo',
                'selector' => '{{WRAPPER}} .is-logged-wrap p',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'afl_btn_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'afl_btn_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .is-logged-wrap .afl-btn' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'afl_btn_bg',
                'selector' => '{{WRAPPER}} .is-logged-wrap .afl-btn',
                'exclude' => ['image'],
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#97cc00']
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'afl_btn_border',
                'selector' => '{{WRAPPER}} .is-logged-wrap .afl-btn',
            ]
        );

        $this->add_control(
            'afl_btn_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .is-logged-wrap .afl-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 5,
                    'right' => 5,
                    'bottom' => 5,
                    'left' => 5,
                    'unit' => 'px'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'afl_btn_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .is-logged-wrap .afl-btn',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'reg_box_section',
            [
                'label' => __( 'Register Box', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_register_btn' => 'yes',
                    'use_custom_form!' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'reg_icon_size',
            [
                'label' => esc_html__('Icon Size', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'rem', 'em'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 45
                ],
                'selectors' => [
                    '{{WRAPPER}} .user-register-box i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .user-register-box svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'reg_icon_color',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .user-register-box i' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .user-register-box svg path' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'reg_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#7e7e7e',
                'selectors' => [
                    '{{WRAPPER}} .user-register-box p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Text Typography', 'ahura'),
                'name' => 'reg_text_typo',
                'selector' => '{{WRAPPER}} .user-register-box p',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'reg_btn_style_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'reg_btn_color',
            [
                'label' => esc_html__('Button Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#6016b9',
                'selectors' => [
                    '{{WRAPPER}} .user-register-box .user-reg-btn' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'reg_btn_bg',
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .user-register-box .user-reg-btn',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'reg_btn_border',
                'selector' => '{{WRAPPER}} .user-register-box .user-reg-btn',
            ]
        );

        $this->add_control(
            'reg_btn_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .user-register-box .user-reg-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'reg_btn_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .user-register-box .user-reg-btn',
            ]
        );

        $this->add_control(
            'reg_btn_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .user-register-box .user-reg-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'reg_box_style_options',
            [
                'label' => esc_html__( 'Box', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'reg_box_bg',
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .user-register-box',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'reg_box_border',
                'selector' => '{{WRAPPER}} .user-register-box',
            ]
        );

        $this->add_control(
            'reg_box_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .user-register-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'reg_wrap_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .user-register-box',
            ]
        );

        $this->add_control(
            'reg_box_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .user-register-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_section',
            [
                'label' => __( 'Box', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'box_title_options',
            [
                'label' => esc_html__( 'Box Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'box_title_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .form-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'ahura'),
                'name' => 'box_title_typo',
                'selector' => '{{WRAPPER}} .form-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 700],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '20',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'box_more_options',
            [
                'label' => esc_html__( 'Box', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'box_bg',
                'selector' => '{{WRAPPER}} .login-element-content',
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#fff']
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'selector' => '{{WRAPPER}} .login-element-content',
            ]
        );

        $this->add_control(
            'box_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .login-element-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                    'unit' => 'px'
                ]
            ]
        );

        $this->add_control(
            'box_cover_options',
            [
                'label' => esc_html__( 'Box Cover', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'box_cover_bg',
                'selector' => '{{WRAPPER}} .login-bg-wrap',
                'fields_options' => [
                    'background' => ['default' => 'classic'],
                    'color' => ['default' => '#6016b9']
                ]
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();

        $hide_in_scroll = $settings['hide_in_scroll'] == 'yes';
        $use_shortcode = $settings['use_shortcode'] == 'yes';
        $use_custom_login = $settings['use_custom_form'] == 'yes';
        ?>
        <div class="popup-login2-element is-element-<?php echo is_rtl() ? 'rtl' : 'ltr' ?><?php echo is_user_logged_in() ? ' logged-in' : ''; ?>">
            <div class="toggle-login-btn ah-is-button ah-has-text ah-has-icon<?php echo $hide_in_scroll ? ' hide_in_scroll' : ''; ?>">
                <?php if ($settings['show_icon'] == 'yes'): ?>
                    <?php if (!empty($settings['btn_icon']['value'])): ?>
                        <?php \Elementor\Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    <?php else: ?>
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"> <path opacity="0.4" d="M12.1207 12.78C12.0507 12.77 11.9607 12.77 11.8807 12.78C10.1207 12.72 8.7207 11.28 8.7207 9.50998C8.7207 7.69998 10.1807 6.22998 12.0007 6.22998C13.8107 6.22998 15.2807 7.69998 15.2807 9.50998C15.2707 11.28 13.8807 12.72 12.1207 12.78Z" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.34" d="M18.7398 19.3801C16.9598 21.0101 14.5998 22.0001 11.9998 22.0001C9.39977 22.0001 7.03977 21.0101 5.25977 19.3801C5.35977 18.4401 5.95977 17.5201 7.02977 16.8001C9.76977 14.9801 14.2498 14.9801 16.9698 16.8001C18.0398 17.5201 18.6398 18.4401 18.7398 19.3801Z" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path d="M12 22C17.5228 22 22 17.5228 22 12C22 6.47715 17.5228 2 12 2C6.47715 2 2 6.47715 2 12C2 17.5228 6.47715 22 12 22Z" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if ($settings['show_text'] == 'yes'): ?>
                    <span><?php
                        if(is_user_logged_in()){
                            echo $settings['user_btn_text'];
                        } else {
                            echo $settings['btn_text'];
                        }
                        ?></span>
                <?php endif; ?>
            </div>
            <div class="login-element-container">
                <div class="login-element-wrap">
                    <div class="login-element-overlay"></div>
                    <div class="login-element-content">
                        <div class="is-close-btn">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"> <g opacity="1"> <path d="M9.16992 14.8299L14.8299 9.16992" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path d="M14.8299 14.8299L9.16992 9.16992" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </g> </svg>
                        </div>
                        <div class="login-fields-wrap <?php echo $use_custom_login ? 'is-custom-login' : ($use_shortcode ? 'is-shortcode-form' : '') ?>">
                            <?php
                            if(is_user_logged_in()):
                                if ( ! empty( $settings['after_login_btn_link']['url'] ) ) {
                                    $this->add_link_attributes( 'after_login_btn_link', $settings['after_login_btn_link'] );
                                }
                                ?>
                                <div class="is-logged-wrap">
                                    <?php if (!empty($settings['after_login_image']['url'])): ?>
                                        <img src="<?php echo $settings['after_login_image']['url'] ?>" alt="loggedin">
                                    <?php endif; ?>
                                    <p><?php echo $settings['after_login_text'] ?></p>
                                    <a class="afl-btn" <?php echo $this->get_render_attribute_string( 'after_login_btn_link' ); ?>>
                                        <?php echo $settings['after_login_btn_text'] ?>
                                    </a>
                                </div>
                            <?php else: ?>
                                <h3 class="form-title"><?php echo __('Account', 'ahura') ?></h3>
                                <?php
                                if($use_shortcode){
                                    echo do_shortcode($settings['form_shortcode']);
                                } elseif($use_custom_login){
                                    \ahura\app\header\PopupLogin::render_custom_login_template();
                                } elseif(\ahura\app\woocommerce::is_active()) {
                                    wc_get_template('ahura-form-login.php', [
                                        'lost_pass' => false,
                                        'remember_me' => true,
                                    ]);
                                } else {
                                    wp_login_form();
                                }
                                ?>
                            <?php endif; ?>
                        </div>
                        <div class="login-bg-wrap">
                            <?php if (!is_user_logged_in() && $settings['show_register_btn'] == 'yes'): ?>
                                <?php if ( ! empty( $settings['register_btn_link']['url'] ) ) {
                                    $this->add_link_attributes( 'register_btn_link', $settings['register_btn_link'] );
                                } ?>
                                <div class="user-register-wrap">
                                    <div class="user-register-box">
                                        <?php if (!empty($settings['register_box_icon']['value'])): ?>
                                            <?php \Elementor\Icons_Manager::render_icon( $settings['register_box_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                        <?php else: ?>
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none"> <g opacity="0.4"> <path d="M18.5 19.5H14.5" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path d="M16.5 21.5V17.5" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </g> <path opacity="0.4" d="M12.1606 10.87C12.0606 10.86 11.9406 10.86 11.8306 10.87C9.45058 10.79 7.56058 8.84 7.56058 6.44C7.55058 3.99 9.54058 2 11.9906 2C14.4406 2 16.4306 3.99 16.4306 6.44C16.4306 8.84 14.5306 10.79 12.1606 10.87Z" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> <path d="M11.9891 21.8102C10.1691 21.8102 8.35906 21.3502 6.97906 20.4302C4.55906 18.8102 4.55906 16.1702 6.97906 14.5602C9.72906 12.7202 14.2391 12.7202 16.9891 14.5602" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>
                                        <?php endif; ?>
                                        <?php if (!empty($settings['register_text'])): ?>
                                            <p><?php echo $settings['register_text'] ?></p>
                                        <?php endif; ?>
                                        <a <?php echo $this->get_render_attribute_string( 'register_btn_link' ); ?> class="user-reg-btn"><?php echo $settings['register_btn_text'] ?></a>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
