<?php
// Block direct access to the main plugin file.
defined('ABSPATH') or die('No script kiddies please!');

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

class Ahura_Mega_Menu extends \ahura\app\elementor\Elementor_Widget_Base
{
    public function __register_assets(){
        $this->register_elementor_style('mega_menu_css', mw_assets::get_css('elementor.mega_menu'));
    }

    public function get_name()
    {
        return 'megamenu';
    }

    public function get_title()
    {
        return esc_html__('Mega Menu', 'ahura');
    }

    public function get_icon()
    {
        return 'eicon-nav-menu';
    }

    public function get_categories()
    {
        return ['ahuraheader'];
    }
    public function get_keywords()
    {
        return ['ahura', 'menu', 'mega menu', esc_html__('ahura' , 'ahura'), esc_html__('menu' , 'ahura'), esc_html__('Mega menu', 'ahura')];
    }
    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'megamenu_title',
			[
				'label' => __("Megamenu Title", 'ahura'),
				'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Product Category', 'ahura' ),
			]
		);

        $this->add_control(
            'btn_icon',
            [
                'label' => esc_html__( 'Button Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
            ]
        );

        $this->add_control(
            'open_menu',
            [
                'label' => esc_html__('Open in Front Page', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'hide_in_scroll',
            [
                'label' => __('Hide in scroll', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'default' => false
            ]
        );

        $this->end_controls_section();
        /**
         *
         *
         *
         * Styles
         *
         */
        $this->start_controls_section(
            'content_styles_section',
            [
                'label' => esc_html__('Button', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('style_tabs');
        $this->start_controls_tab('style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $alignment = array(
            'start' => [
                'title' => esc_html__('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'end' => [
                'title' => esc_html__('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ]
        );

        $this->add_responsive_control(
            'btn_text_align',
            [
                'label' => esc_html__('Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => (is_rtl()) ? $alignment : array_reverse($alignment),
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .cats-list-title' => 'justify-content: {{VALUE}}',
                ]
            ]
        );

        $this->add_responsive_control(
            'btn_width',
            [
                'label' => esc_html__('Width', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 270
                ],
                'mobile_default' => [
                    'unit' => '%',
                    'size' => 100
                ],
                'tablet_default' => [
                    'unit' => '%',
                    'size' => 100
                ],
                'selectors' => [
                    '{{WRAPPER}} .cats-list' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'btn_icon_size',
            [
                'label' => esc_html__('Icon Size', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20
                ],
                'selectors' => [
                    '{{WRAPPER}} .cats-list-title i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .cats-list-title svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' =>
                    [
                        '{{WRAPPER}} .cats-list-title i' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .cats-list-title svg' => 'fill: {{VALUE}}',
                    ]
            ]
        );

        $this->add_control(
            'background_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' =>
                    [
                        '{{WRAPPER}} .cats-list-title' => 'background-color: {{VALUE}}',
                    ]
            ]
        );

        $this->add_control(
            'color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' =>
                    [
                        '{{WRAPPER}} .cats-list-title' => 'color: {{VALUE}}',
                    ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_fontsize',
                'label' => esc_html__('Title Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .cats-list-title',
                'fields_options' =>
                    [
                        'font_size' => [
                            'default' => [
                                'unit' => 'px',
                                'size' => '16'
                            ]
                        ]
                    ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .cats-list-title',
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .cats-list-title' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .cats-list-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' =>
                    [
                        '{{WRAPPER}} .cats-list-title:hover i' => 'color: {{VALUE}}',
                        '{{WRAPPER}} .cats-list-title:hover svg' => 'fill: {{VALUE}}',
                    ]
            ]
        );

        $this->add_control(
            'color_hover',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' =>
                    [
                        '{{WRAPPER}} .cats-list-title:hover' => 'color: {{VALUE}}',
                    ]
            ]
        );

        $this->add_control(
            'background_color_hover',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' =>
                    [
                        '{{WRAPPER}} .cats-list-title:hover' => 'background-color: {{VALUE}}',
                    ]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'submenu_section',
            [
                'label' => esc_html__('Submenu', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('submenu_style_tabs');
        $this->start_controls_tab('submenu_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_control(
            'wrap_line_color_hover',
            [
                'label' => esc_html__('Line Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#00b0ff',
                'selectors' => [
                    '{{WRAPPER}} .cats-list .menu > li > a::before' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'list_background_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' =>
                    [
                        '{{WRAPPER}} .cats-list .menu' => 'background-color: {{VALUE}}',
                        '{{WRAPPER}} .cats-list ul.menu > li > a::after' => 'opacity: 0',
                        '{{WRAPPER}} .cats-list ul.menu > li > a::before' => 'opacity: 0',
                        '{{WRAPPER}} .cats-list .menu li ul' => 'background-color: {{VALUE}}',
                    ]
            ]
        );

        $this->add_control(
            'list_color',
            [
                'label' => esc_html__('List Items Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                        '{{WRAPPER}} .cats-list .menu li a' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'items_typo',
                'label' => esc_html__('Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .cats-list .menu li a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '300'
                    ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'list_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .cats-list > div ul',
            ]
        );

        $this->add_control(
            'list_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .cats-list > div ul' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'items_wrap_box_shadow',
                'selector' => '{{WRAPPER}} .cats-list .menu',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('submenu_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_control(
            'list_color_hover',
            [
                'label' => esc_html__('List Items Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#00b0ff',
                'selectors' => [
                        '{{WRAPPER}} .cats-list .menu li a:hover' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->register_additional_controls();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $open_menu = !is_front_page() || $settings['open_menu'] != 'yes';
        $hide_in_scroll = ($settings['hide_in_scroll']) ? ' hide_in_scroll' : '';
        ?>
        <div class="ahura-mega-menu-element">
            <div class="cats-list <?php echo $open_menu ? ' isnotfront' : '' ?> in_custom_header<?php echo $hide_in_scroll ?>">
                <span class="cats-list-title in_custom_header ah-is-button">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    <?php echo $settings['megamenu_title']; ?>
                </span>
                <?php render_mega_menu(); ?>
            </div>
        </div>
        <?php
    }
}
