<?php

namespace ahura\inc\widgets;

// Block direct access to the main theme file.
defined('ABSPATH') or die('No script kiddies please!');

use ahura\app\mw_assets;
use Elementor\Controls_Manager;
use ahura\app\mw_options;
use ahura\app\Post_Meta;

class grid_products6 extends \ahura\app\elementor\Elementor_Widget_Base
{
    public function __register_assets()
    {
        $this->register_elementor_style('grid_products6_css', mw_assets::get_css('elementor.grid_products6'));
    }

    public function get_name()
    {
        return 'grid_products6';
    }

    public function get_title()
    {
        return esc_html__('Grid Products 6', 'ahura');
    }

    public function get_icon()
    {
        return 'eicon-posts-grid';
    }

    public function get_categories()
    {
        return ['ahuraelements', 'ahura_woocommerce'];
    }

    public function get_keywords()
    {
        return ['ahura', 'gird products 6', 'products', esc_html__('ahura', 'ahura'), esc_html__('Grid Products 6', 'ahura')];
    }


    public function register_controls()
    {
        $this->start_controls_section(
            'general_content_settings',
            [
                'label' => esc_html__('General', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );

        $categories = get_terms( array(
            'taxonomy' => 'product_cat',
            'hide_empty' => false,
        ));
        $cats = [];
        if (\ahura\app\woocommerce::is_active()) {
            if($categories){
                foreach ( $categories as $category ) {
                    $cats[ $category->slug ] = $category->name;
                }
            }
        }

        $this->add_control(
            'catsid',
            [
                'label'    => __( 'Categories', 'ahura' ),
                'type'     => Controls_Manager::SELECT2,
                'options'  => array_merge(
                    [ 'allproducts'  => esc_html__( 'All Products', 'ahura' ) ],
                    $cats ),
                'label_block' => true,
                'multiple' => true,
                'default' => 'allproducts'
            ]
        );

        $this->add_control(
            'per_page',
            [
                'label' => esc_html__('Number of Per Page', 'ahura'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'default' => 12
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__('Show Pagination', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

		if(mw_options::is_download_theme_mode()){
			$this->add_control(
				'show_total_downloads',
				[
					'label' => esc_html__( 'Total downloads', 'ahura' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ahura' ),
					'label_off' => esc_html__( 'Hide', 'ahura' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'show_last_update',
				[
					'label' => esc_html__( 'Last update', 'ahura' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'ahura' ),
					'label_off' => esc_html__( 'Hide', 'ahura' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);
		}

        $this->add_control(
			'show_button',
			[
				'label' => esc_html__( 'Show button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_control(
			'show_add_wishlist',
			[
				'label' => esc_html__( 'Show add wishlist button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
			'add_wishlist_notice',
			[
				'type' => \Elementor\Controls_Manager::NOTICE,
				'notice_type' => 'warning',
				'dismissible' => true,
				'heading' => esc_html__( 'Add to Wishlist Notice', 'ahura' ),
				'content' => esc_html__( 'To show wishlist button you need install and enable Yith WooCommerce Wishlist plugin.', 'ahura' ),
                'condition' => [ 'show_add_wishlist' => 'yes' ]
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'description_settings',
            [
                'label' => esc_html__('Description', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
			'description_words',
			[
				'label' => esc_html__( 'Words limitation', 'ahura' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 33,
				'max' => 500,
				'step' => 1,
				'default' => 66,
			]
		);
        
        $this->add_control(
			'description_separator',
			[
				'label' => esc_html__( 'Separator', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '...', 'ahura' ),
			]
		);

        $this->end_controls_section();
        
		if(mw_options::is_download_theme_mode()) {
			$this->start_controls_section(
				'meta_content_settings',
				[
					'label' => esc_html__('Meta', 'ahura'),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT
				]
			);

			$this->add_control(
				'total_downloads_options',
				[
					'label' => esc_html__( 'Total downloads', 'ahura' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
					'condition' => [ 'show_total_downloads' => 'yes' ]
				]
			);

			$this->add_control(
				'total_downloads_icon',
				[
					'label' => esc_html__( 'Icon', 'ahura' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					'condition' => [ 'show_total_downloads' => 'yes' ]
				]
			);

			$this->add_control(
				'total_downloads_label',
				[
					'label' => esc_html__( 'Label', 'ahura' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Total downloads', 'ahura' ),
					'condition' => [ 'show_total_downloads' => 'yes' ]
				]
			);

			$this->add_control(
				'total_downloads_postfix',
				[
					'label' => esc_html__( 'Postfix', 'ahura' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'times', 'ahura' ),
					'condition' => [ 'show_total_downloads' => 'yes' ]
				]
			);

			$this->add_control(
				'custom_meta_options',
				[
					'label' => esc_html__( 'Custom meta', 'ahura' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_control(
				'custom_meta_icon',
				[
					'label' => esc_html__( 'Icon', 'ahura' ),
					'type' => \Elementor\Controls_Manager::ICONS,
				]
			);

			$this->add_control(
				'custom_meta_label',
				[
					'label' => esc_html__( 'Label', 'ahura' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Latest version', 'ahura' ),
				]
			);

			$this->add_control(
				'custom_meta_postfix',
				[
					'label' => esc_html__( 'Postfix', 'ahura' ),
					'type' => \Elementor\Controls_Manager::TEXT,
				]
			);

			$this->add_control(
				'last_update_options',
				[
					'label' => esc_html__( 'Last update', 'ahura' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
					'condition' => [ 'show_last_update' => 'yes' ]
				]
			);

			$this->add_control(
				'last_update_icon',
				[
					'label' => esc_html__( 'Icon', 'ahura' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					'condition' => [ 'show_last_update' => 'yes' ]
				]
			);

			$this->add_control(
				'last_update_label',
				[
					'label' => esc_html__( 'Label', 'ahura' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Latest update', 'ahura' ),
					'condition' => [ 'show_last_update' => 'yes' ]
				]
			);

			$this->add_control(
				'last_update_postfix',
				[
					'label' => esc_html__( 'Postfix', 'ahura' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'ago', 'ahura' ),
					'condition' => [ 'show_last_update' => 'yes' ]
				]
			);

			$this->end_controls_section();
		}
        
        $this->start_controls_section(
            'button_content_settings',
            [
                'label' => esc_html__('Button', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [ 'show_button' => 'yes' ],
            ]
        );

        $this->add_control(
			'button_text',
			[
				'label' => esc_html__( 'Text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Download Now!', 'ahura' ),
                'condition' => [ 'show_button' => 'yes' ]
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'box_styles',
            [
                'label' => esc_html__('Box', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );
        
        $this->add_control(
			'box_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .product-box article' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'box_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 15,
					'right' => 30,
					'bottom' => 15,
					'left' => 30,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .product-box article' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'box_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 20,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .product-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'main_box_shadow',
			[
				'label' => esc_html__( 'Box Shadow', 'ahura' ),
				'type' => \Elementor\Controls_Manager::BOX_SHADOW,
                'fields_options' => [
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical' => 4,
                            'blur' => 13,
                            'spread' => 0,
                            'color' => '#00000026'
                        ]
                    ]
                ],
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .product-box article' => 'box-shadow: {{HORIZONTAL}}px {{VERTICAL}}px {{BLUR}}px {{SPREAD}}px {{COLOR}};',
				],
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'title_styles',
            [
                'label' => esc_html__('Title', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
			'title_align',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .product-title' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .product-title' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .grid-products6 .product-title',
                'fields_options' =>
				[
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '18'
						]
                    ],
                    'font_weight' => [
                        'default' => 'bold'
                    ]
				]
			]
		);
        
        $this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 27,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .product-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        $this->end_controls_section();
        
        $this->start_controls_section(
            'description_styles',
            [
                'label' => esc_html__('Description', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
			'desc_align',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .product-description' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'desc_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .product-description' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .grid-products6 .product-description',
                'fields_options' =>
				[
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '14'
						]
                    ],
					'line_height' => [
						'default' => [
							'unit' => 'px',
							'size' => '22'
						]
                    ],
                    'font_weight' => [
                        'default' => 'bold'
                    ]
				]
			]
		);
        
        $this->add_responsive_control(
			'desc_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .product-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

		if(mw_options::is_download_theme_mode()) {
        
			$this->start_controls_section(
				'meta_styles',
				[
					'label' => esc_html__('Meta', 'ahura'),
					'tab' => \Elementor\Controls_Manager::TAB_STYLE
				]
			);
			
			$this->add_control(
				'meta_general_options',
				[
					'label' => esc_html__( 'General', 'ahura' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			
			$this->add_control(
				'meta_bar_margin',
				[
					'label' => esc_html__( 'Section margin', 'ahura' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem' ],
					'default' => [
						'top' => 0,
						'right' => 0,
						'bottom' => 27,
						'left' => 0,
						'unit' => 'px',
						'isLinked' => true,
					],
					'selectors' => [
						'{{WRAPPER}} .grid-products6 .product-meta-bar' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_responsive_control(
				'meta_box_margin',
				[
					'label' => esc_html__( 'Box margin', 'ahura' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem' ],
					'default' => [
						'top' => 0,
						'right' => is_rtl() ? 20 : 0,
						'bottom' => 0,
						'left' => is_rtl() ? 0 : 20,
						'unit' => 'px',
						'isLinked' => true,
					],
					'selectors' => [
						'{{WRAPPER}} .grid-products6 .meta-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_control(
				'icon_options',
				[
					'label' => esc_html__( 'Icon', 'ahura' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			
			$this->add_responsive_control(
				'meta_icon_margin',
				[
					'label' => esc_html__( 'Icon margin', 'ahura' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem' ],
					'default' => [
						'top' => 0,
						'right' => is_rtl() ? 0 : 10,
						'bottom' => 0,
						'left' => is_rtl() ? 10 : 0,
						'unit' => 'px',
						'isLinked' => true,
					],
					'selectors' => [
						'{{WRAPPER}} .grid-products6 .meta-box .meta-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_control(
				'label_options',
				[
					'label' => esc_html__( 'Label', 'ahura' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_control(
				'meta_label_color',
				[
					'label' => esc_html__( 'label', 'ahura' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'default' => '#798592',
					'selectors' => [
						'{{WRAPPER}} .grid-products6 .meta-box .meta-data .label' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'label_typography',
					'label' => esc_html__('Typography', 'ahura'),
					'selector' => '{{WRAPPER}} .grid-products6 .meta-box .meta-data .label',
					'fields_options' =>
					[
						'typography' => [
							'default' => 'yes'
						],
						'font_size' => [
							'default' => [
								'unit' => 'px',
								'size' => '14'
							]
						],
						'font_weight' => [
							'default' => 'bold'
						]
					]
				]
			);
			
			$this->add_responsive_control(
				'meta_label_margin',
				[
					'label' => esc_html__( 'Label margin', 'ahura' ),
					'type' => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em', 'rem' ],
					'default' => [
						'top' => 0,
						'right' => is_rtl() ? 0 : 10,
						'bottom' => 0,
						'left' => is_rtl() ? 10 : 0,
						'unit' => 'px',
						'isLinked' => true,
					],
					'selectors' => [
						'{{WRAPPER}} .grid-products6 .meta-box .meta-data .label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			
			$this->add_control(
				'data_options',
				[
					'label' => esc_html__( 'Data', 'ahura' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_control(
				'meta_data_color',
				[
					'label' => esc_html__( 'Data', 'ahura' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .grid-products6 .meta-box .meta-data .data' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'meta_data_typography',
					'label' => esc_html__('Typography', 'ahura'),
					'selector' => '{{WRAPPER}} .grid-products6 .meta-box .meta-data .data',
					'fields_options' =>
					[
						'typography' => [
							'default' => 'yes'
						],
						'font_size' => [
							'default' => [
								'unit' => 'px',
								'size' => '14'
							]
						],
						'font_weight' => [
							'default' => 'bold'
						]
					]
				]
			);
			
			$this->add_control(
				'postfix_options',
				[
					'label' => esc_html__( 'Postfix', 'ahura' ),
					'type' => \Elementor\Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);

			$this->add_control(
				'meta_postfix_color',
				[
					'label' => esc_html__( 'Postfix', 'ahura' ),
					'type' => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .grid-products6 .meta-box .meta-data .postfix' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name' => 'meta_postfix_typography',
					'label' => esc_html__('Typography', 'ahura'),
					'selector' => '{{WRAPPER}} .grid-products6 .meta-box .meta-data .postfix',
					'fields_options' =>
					[
						'typography' => [
							'default' => 'yes'
						],
						'font_size' => [
							'default' => [
								'unit' => 'px',
								'size' => '14'
							]
						],
						'font_weight' => [
							'default' => 'bold'
						]
					]
				]
			);

			$this->end_controls_section();
		}
        
        $this->start_controls_section(
            'thumbnail_styles',
            [
                'label' => esc_html__('Thumbnail', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
			'thumbnail_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .thumbnail-container' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'footer_styles',
            [
                'label' => esc_html__('Footer', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );
        
        $this->add_control(
			'footer_general_options',
			[
				'label' => esc_html__( 'General', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_responsive_control(
			'footer_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 30,
					'right' => 0,
					'bottom' => 5,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .product-foot' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'wishlist_options',
			[
				'label' => esc_html__( 'Wishlist', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [ 'show_add_wishlist' => 'yes' ]
			]
		);
        
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'wishlist_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .grid-products6 .yith-wcwl-add-button',
                'fields_options' =>
				[
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '14'
						]
                    ],
                    'font_weight' => [
                        'default' => 'bold'
                    ]
                ],
                'condition' => [ 'show_add_wishlist' => 'yes' ]
			]
		);
        
        $this->add_control(
			'button_options',
			[
				'label' => esc_html__( 'Button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#323232',
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .product-foot a.product-btn' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'button_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#A3DC2F',
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .product-foot a.product-btn' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .grid-products6 .product-foot a.product-btn',
                'fields_options' =>
				[
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '14'
						]
                    ],
                    'font_weight' => [
                        'default' => 'bold'
                    ]
				]
			]
		);
        
        $this->add_control(
			'button_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 5,
					'bottom' => 5,
					'left' => 5,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .product-foot a.product-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'button_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 8,
					'right' => 15,
					'bottom' => 8,
					'left' => 15,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .product-foot a.product-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'pagination_styles',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [ 'show_pagination' => 'yes' ]
            ]
        );
        
        $this->add_control(
			'pagination_general_options',
			[
				'label' => esc_html__( 'General', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [ 'show_pagination' => 'yes' ]
			]
		);
        
        $this->add_responsive_control(
			'pagination_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 45,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .ahura-pagination' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [ 'show_pagination' => 'yes' ]
			]
		);
        
        $this->add_control(
			'numbers_options',
			[
				'label' => esc_html__( 'Numbers', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [ 'show_pagination' => 'yes' ]
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'numbers_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .grid-products6 .ahura-pagination .page-numbers',
                'condition' => [ 'show_pagination' => 'yes' ]
			]
		);
        
        $this->add_control(
			'numbers_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#464646',
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .ahura-pagination .page-numbers' => 'color: {{VALUE}}',
				],
                'condition' => [ 'show_pagination' => 'yes' ]
			]
		);
        
        $this->add_control(
			'numbers_active_color',
			[
				'label' => esc_html__( 'Active color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#464646',
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .ahura-pagination .page-numbers.current' => 'color: {{VALUE}}',
				],
                'condition' => [ 'show_pagination' => 'yes' ]
			]
		);
        
        $this->add_control(
			'numbers_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#D9D9D942',
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .ahura-pagination .page-numbers' => 'background-color: {{VALUE}}',
				],
                'condition' => [ 'show_pagination' => 'yes' ]
			]
		);
        
        $this->add_control(
			'numbers_active_backcolor',
			[
				'label' => esc_html__( 'Active background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#75A31724',
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .ahura-pagination .page-numbers.current' => 'background-color: {{VALUE}}',
				],
                'condition' => [ 'show_pagination' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'number_area_size',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .ahura-pagination .page-numbers' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_pagination' => 'yes' ]
			]
		);
        
        $this->add_responsive_control(
			'numbers_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .ahura-pagination .page-numbers' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [ 'show_pagination' => 'yes' ]
			]
		);
        
        $this->add_control(
			'next_prev_options',
			[
				'label' => esc_html__( 'Next/Prev', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [ 'show_pagination' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'next_prev_size',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 60,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products6 .ahura-pagination a.next' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .grid-products6 .ahura-pagination a.prev' => 'width: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_pagination' => 'yes' ]
			]
		);

        $this->end_controls_section();
    }

    /**
     *
     * Get products result
     *
     * @param array $params
     * @return false
     */
    public function get_products($params = [])
    {
        $settings = $this->get_settings_for_display();
        $field_is_term = !empty($settings[ 'catsid' ]) && (is_array($settings['catsid']) && is_numeric($settings['catsid'][0])) || is_int($settings['catsid']);

        if( empty($settings[ 'catsid' ]) || $settings[ 'catsid' ] == 'allproducts' || ( $settings[ 'catsid' ][ 0 ] == 'allproducts' ) ) {
            $args = array(
                'post_type' => 'product',
                'posts_per_page' => $settings['per_page'],
                'post_status' => 'publish',
            );

        } else {
            $args = array(
                'post_type' => 'product',
                'posts_per_page' => $settings['per_page'],
                'post_status' => 'publish',
                'tax_query'		 => [ [
                    'taxonomy'   => 'product_cat',
                    'field'		 => $field_is_term ? 'term_id' : 'slug',
                    'terms'		 => $settings[ 'catsid' ],
                ] ],
            );
        }

        $term = (array) get_queried_object();

        if (is_array($term) && isset($term['term_id']) && isset($term['slug'])) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => $term['taxonomy'],
                    'field'    => 'slug',
                    'terms'    => $term['slug'],
                ),
            );
        }

        $products = new \WP_Query(array_merge($args, $params));
        return ($products->have_posts()) ? $products : false;
    }

    /**
     *
     * Render content for display
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $page = $_GET['page_num'] ?? false;
        $current_page = ($page == 0) ? 1 : $page;
        $args = [];
        if ($settings['show_pagination'] === 'yes') {
            $args['paged'] = $current_page;
        }

        $description_words = !empty($settings['description_words']) ? $settings['description_words'] : 66;
        $description_separator = !empty($settings['description_separator']) ? $settings['description_separator'] : '...';

        if (!\ahura\app\woocommerce::is_active()) {
            if(is_admin()) {
                ?>
                <div class="productcategorybox mw_elem_empty_box"><h3><?php _e('To use this element you must install woocommerce plugin.', 'ahura'); ?></h3></div>
                <?php
            }
            return false;
        }

        $products = $this->get_products($args);
        
        if ($products) : ?>
            <div class="grid-products6 grid-products6-<?php echo $wid ?>">
                <div class="products-list">
                        <?php while ($products->have_posts()) : $products->the_post();
                            global $product;

                            $product_version = Post_Meta::show_ah_product_version();
                            $product_total_downloads = Post_Meta::show_ah_downloaded_product_count();
                            $product_update_date = Post_Meta::show_ah_product_update_date();
							$product_update_date = strtotime($product_update_date);

                            $current_time = current_time('U');
                            $time_diff = human_time_diff($product_update_date, $current_time); ?>
                            <div class="product-box">
                                <article <?php wc_product_class('ah-has-bg', $product) ?>>
                                    <h3 class="product-title">
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </h3>
                                    <div class="d-flex flex-wrap align-items-center product-meta-bar">
                                        <a class="d-flex thumbnail-container" href="<?php the_permalink(); ?>">
                                            <?php the_post_thumbnail( 'woocommerce_thumbnail' ); ?>
                                        </a>
										<?php if (mw_options::is_download_theme_mode()): ?>
											<?php if($settings['show_total_downloads'] === 'yes' && !empty($product_total_downloads)) :?>
												<div class="d-flex justify-content-center align-items-center meta-box total-sales">
													<?php if(!empty($settings['total_downloads_icon']['value'])): ?>
														<div class="d-flex justify-content-center align-items-center meta-icon">
															<?php \Elementor\Icons_Manager::render_icon( $settings['total_downloads_icon'], [ 'aria-hidden' => 'true' ] ); ?>
														</div>
													<?php endif; ?>
													<div class="meta-data">
														<?php if(!empty($settings['total_downloads_label'])): ?>
															<span class="label"><?php echo $settings['total_downloads_label'] ?></span>
														<?php endif; ?>
														<span class="data"><?php echo $product_total_downloads; ?></span>
														<?php if(!empty($settings['total_downloads_postfix'])): ?>
															<span class="postfix"><?php echo $settings['total_downloads_postfix'] ?></span>
														<?php endif; ?>
													</div>
												</div>
											<?php endif; ?>
											<?php if(!empty($product_version)): ?>
												<div class="d-flex justify-content-center align-items-center meta-box product-meta">
													<?php if(!empty($settings['custom_meta_icon']['value'])): ?>
														<div class="d-flex justify-content-center align-items-center meta-icon">
															<?php \Elementor\Icons_Manager::render_icon( $settings['custom_meta_icon'], [ 'aria-hidden' => 'true' ] ); ?>
														</div>
													<?php endif; ?>
													<div class="meta-data">
														<?php if(!empty($settings['custom_meta_label'])): ?>
															<span class="label"><?php echo $settings['custom_meta_label'] ?></span>
														<?php endif; ?>
														<span class="data"><?php echo $product_version; ?></span>
														<?php if(!empty($settings['custom_meta_postfix'])): ?>
															<span class="postfix"><?php echo $settings['custom_meta_postfix']; ?></span>
														<?php endif; ?>
													</div>
												</div>
											<?php endif; ?>
											<?php if($settings['show_last_update'] === 'yes' && !empty($time_diff) && !empty($product_update_date)): ?>
												<div class="d-flex justify-content-center align-items-center meta-box product-update">
													<?php if(!empty($settings['last_update_icon']['value'])): ?>
														<div class="d-flex justify-content-center align-items-center meta-icon">
															<?php \Elementor\Icons_Manager::render_icon( $settings['last_update_icon'], [ 'aria-hidden' => 'true' ] ); ?>
														</div>
													<?php endif; ?>
													<div class="meta-data">
														<?php if(!empty($settings['last_update_label'])): ?>
															<span class="label"><?php echo $settings['last_update_label']; ?></span>
														<?php endif; ?>
														<span class="data"><?php echo $time_diff; ?></span>
														<?php if(!empty($settings['last_update_postfix'])): ?>
															<span class="postfix"><?php echo $settings['last_update_postfix']; ?></span>
														<?php endif; ?>
													</div>
												</div>
											<?php endif; ?>
										<?php endif; ?>
                                    </div>
                                    <div class="product-description">
                                        <?php echo wp_trim_words( get_the_content(), $description_words, $description_separator ); ?>
                                    </div>
                                    <?php if ($settings['show_add_wishlist'] === 'yes' || $settings['show_button'] === 'yes'): ?>
                                        <div class="d-flex justify-content-between align-items-center product-foot">
                                            <?php if ($settings['show_add_wishlist'] === 'yes' && in_array('yith-woocommerce-wishlist/init.php', apply_filters('active_plugins', get_option('active_plugins')))): ?>
                                                <div class="d-flex align-content-center add-wishlist">
                                                    <?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
                                                </div>
                                            <?php endif; ?>
                                            <?php if(!empty($settings['button_text']) && $settings['show_button'] === 'yes'): ?>
                                                <a href="<?php the_permalink(); ?>" class="product-btn">
                                                    <?php echo $settings['button_text']; ?>
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </article>
                            </div>
                        <?php
                        endwhile;
                        wp_reset_query();
                        wp_reset_postdata();
                        ?>
                </div>
                <?php if ($settings['show_pagination'] === 'yes') : ?>
                    <div class="d-flex justify-content-center flex-row-reverse ahura-pagination">
                        <?php ahura_custom_pagination($products->found_posts, $settings['per_page'], $current_page); ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php else : ?>
            <div class="mw_element_error">
                <?php echo esc_html__('Sorry, no products were found for display.', 'ahura'); ?>
            </div>
<?php
        endif;
    }
}
