<?php

namespace ahura\inc\widgets;

// Block direct access to the main theme file.
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\mw_assets;

class grid_products5 extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * grid_posts10 constructor.
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_script('grid_products5_js', mw_assets::get_js('elementor.grid_products5'));
        mw_assets::localize('grid_products5_js', 'gpr5', [
            'ajax_url' => admin_url('admin-ajax.php')
        ]);
    }

    public function __register_assets()
    {
        $this->register_elementor_style('grid_products5_css', mw_assets::get_css('elementor.grid_products5'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('grid_products5_js')];
    }

    public function get_name()
    {
        return 'grid_products5';
    }

    public function get_title()
    {
        return esc_html__('Grid Products 5', 'ahura');
    }

    public function get_icon() {
        return 'eicon-posts-grid';
    }

    public function get_categories()
    {
        return ['ahuraelements', 'ahura_posts'];
    }

    public function get_keywords()
    {
        return ['ahura', 'grid', 'product', 'grid products 5', esc_html__('ahura', 'ahura'), esc_html__('Grid products 5', 'ahura')];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'display_settings',
            [
                'label' => esc_html__('Layout', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'per_page',
            [
                'label' => esc_html__('Number of Per Page', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 9,
                'default' => 4,
            ]
        );

        $this->add_control(
            'layout_col',
            [
                'label' => esc_html__('Columns', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'default' => 4,
                'options' => [
                    '12' => 1,
                    '2' => 2,
                    '4' => 3,
                    '3' => 4,
                ]
            ]
        );

		$this->add_control(
			'cat_filter',
			[
				'label' => esc_html__( 'Category based', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$categories = get_terms( array(
            'taxonomy' => 'product_cat',
            'hide_empty' => false,
        ));
        $cats = [];
        if (\ahura\app\woocommerce::is_active()) {
            if($categories){
                foreach ( $categories as $category ) {
                    $cats[ $category->slug ] = $category->name;
                }
            }
        }

        $this->add_control(
            'catsid',
            [
                'label'    => __( 'Categories', 'ahura' ),
                'type'     => Controls_Manager::SELECT2,
                'options'  => array_merge(
                    [ 'allproducts'  => esc_html__( 'All Products', 'ahura' ) ],
                    $cats ),
                'label_block' => true,
                'multiple' => true,
                'default' => 'allproducts',
				'condition' => [ 'cat_filter' => 'yes' ]
            ]
        );

        $this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Newest Products', 'ahura' ),
			]
		);

        $this->add_control(
			'button_text',
			[
				'label' => esc_html__( 'Button text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Buy', 'ahura' ),
			]
		);

        $this->add_control(
			'show_sale_stats',
			[
				'label' => esc_html__( 'Show sale stats', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_control(
			'sale_stats_postfix',
			[
				'label' => esc_html__( 'Sale stats postfix', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'person bought.', 'ahura' ),
                'condition' => [ 'show_sale_stats' => 'yes' ]
			]
		);

        $this->add_control(
			'no_sell_stats',
			[
				'label' => esc_html__( 'No sale text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'No sales', 'ahura' ),
                'condition' => [ 'show_sale_stats' => 'yes' ]
			]
		);

        $this->add_control(
			'show_sale_dot',
			[
				'label' => esc_html__( 'Show sale dot', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
                'condition' => [ 'show_sale_stats' => 'yes' ]
			]
		);

        $this->add_control(
			'show_price_prefix',
			[
				'label' => esc_html__( 'Show price prefix', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_control(
			'price_prefix',
			[
				'label' => esc_html__( 'Price prefix', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Price', 'ahura' ),
                'condition' => [ 'show_price_prefix' => 'yes' ]
			]
		);

        $this->add_control(
			'show_in_thousands',
			[
				'label' => esc_html__( 'Show price in thousands', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'header_styles',
            [
                'label' => esc_html__('Header', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
			'general_header_options',
			[
				'label' => esc_html__( 'General', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'header_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 40,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .grid-products5-header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'widget_title_options',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '28'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '700'
                    ]
                ],
				'selector' => '{{WRAPPER}} .grid-products-5 .grid-products5-title h2',
			]
		);

        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .grid-products5-title h2' => 'color: {{VALUE}}',
				],
			]
		);
        
        $this->add_control(
			'select_options',
			[
				'label' => esc_html__( 'Select box', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'select_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#808191',
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .products-filter select' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'select_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#222128',
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .products-filter .select-box' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .grid-products-5 .products-filter select' => 'background-color: {{VALUE}}'
				],
			]
		);

        $this->add_responsive_control(
			'select_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 10,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .products-filter select' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'select_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 15,
					'right' => 15,
					'bottom' => 15,
					'left' => 15,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .products-filter select' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .grid-products-5 .products-filter .select-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'select_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 180,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .products-filter select' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'select_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .products-filter select' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'item_styles',
            [
                'label' => esc_html__('Item', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
			'image_options',
			[
				'label' => esc_html__( 'Image', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_responsive_control(
			'image_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 230,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .product-thumbnail' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'image_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 30,
					'right' => 30,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .product-thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'fields_options' => [
                    'box_shadow_type' => ['default' => 'yes'],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical' => 10,
                            'blur' => 87,
                            'spread' => 17,
                            'color' => '#47446e'
                        ]
                    ]
                ],
                'selector' => '{{WRAPPER}} .grid-products-5 .product-item-wrapper:hover img',
            ]
        );

        $this->add_control(
			'content_options',
			[
				'label' => esc_html__( 'Content', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'content_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#242731',
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .grid-products5-content' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'content_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 30,
					'left' => 30,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .grid-products5-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'title_options',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'item_title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .grid-products5-content h3' => 'color: {{VALUE}}',
				],
			]
		);
        
        $this->add_responsive_control(
			'item_title_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .product-title' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'item_title_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '20'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '300'
                    ]
                ],
				'selector' => '{{WRAPPER}} .grid-products-5 .grid-products5-content h3',
			]
		);

        $this->add_responsive_control(
			'item_title_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 20,
					'right' => 25,
					'bottom' => 20,
					'left' => 25,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .product-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'price_options',
			[
				'label' => esc_html__( 'Price', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'price_align',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .product-price-wrapper' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'price_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF754C',
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .product-price-wrapper' => 'color: {{VALUE}}',
				],
			]
		);
        
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '23'
                        ]
                    ],
                ],
				'selector' => '{{WRAPPER}} .grid-products-5 .product-price-wrapper',
			]
		);

        $this->add_responsive_control(
			'price_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 20,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .product-price-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'price_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .grid-products-5 .product-price-wrapper',
			]
		);

        $this->add_control(
			'meta_options',
			[
				'label' => esc_html__( 'Meta', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'meta_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 20,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .product-meta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'button_options',
			[
				'label' => esc_html__( 'Button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} .grid-products-5 .product-meta a.product-link',
			]
		);

        $this->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .product-meta a.product-link' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'button_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF754C2B',
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .product-meta a.product-link' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'button_hovercolor',
			[
				'label' => esc_html__( 'Hover color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .product-item-wrapper:hover a.product-link' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'button_hoverbackcolor',
			[
				'label' => esc_html__( 'Hover background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF754C',
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .product-item-wrapper:hover a.product-link' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 10,
					'bottom' => 10,
					'left' => 30,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .product-meta a.product-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'button_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 22,
					'right' => 20,
					'bottom' => 27,
					'left' => 20,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .product-meta a.product-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'sale_stats_options',
			[
				'label' => esc_html__( 'Sale stats', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [ 'show_sale_stats' => 'yes' ]
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'sale_stats_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '14'
                        ]
                    ],
                ],
				'selector' => '{{WRAPPER}} .grid-products-5 .total-sale-wrapper',
                'condition' => [ 'show_sale_stats' => 'yes' ]
			]
		);

        $this->add_control(
			'sale_stats_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#808191',
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .total-sale-wrapper' => 'color: {{VALUE}}',
				],
                'condition' => [ 'show_sale_stats' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'sale_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 25,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .total-sale-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [ 'show_sale_stats' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'sale_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => -20,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .total-sale-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [ 'show_sale_stats' => 'yes' ]
			]
		);
        
        $this->add_responsive_control(
			'sale_dot_width',
			[
				'label' => esc_html__( 'Dot width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 50,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .total-sale-wrapper .dot' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_sale_stats' => 'yes' ]
			]
		);

        $this->add_control(
			'sale_dot_color',
			[
				'label' => esc_html__( 'Dot color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#6C5DD3',
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .total-sale-wrapper .dot' => 'background-color: {{VALUE}}',
				],
                'condition' => [ 'show_sale_stats' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'sale_dot_radius',
			[
				'label' => esc_html__( 'Dot border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 100,
					'right' => 100,
					'bottom' => 100,
					'left' => 100,
					'unit' => '%',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-products-5 .total-sale-wrapper .dot' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [ 'show_sale_stats' => 'yes' ]
			]
		);

        $this->end_controls_section();

        $this->register_additional_controls();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();

        if ( class_exists( 'WooCommerce' ) ) {
			$field_is_term = !empty($settings[ 'catsid' ]) && (is_array($settings['catsid']) && is_numeric($settings['catsid'][0])) || is_int($settings['catsid']);

			if( $settings[ 'cat_filter' ] != 'yes' || empty($settings[ 'catsid' ]) || $settings[ 'catsid' ] == 'allproducts' || ( $settings[ 'catsid' ][ 0 ] == 'allproducts' ) ) {
				$args = array(
					'post_type' => 'product',
					'posts_per_page' => $settings['per_page'],
					'post_status' => 'publish',
				);

			} else {
				$args = array(
					'post_type' => 'product',
					'posts_per_page' => $settings['per_page'],
					'post_status' => 'publish',
					'tax_query'		 => [ [
						'taxonomy'   => 'product_cat',
						'field'		 => $field_is_term ? 'term_id' : 'slug',
						'terms'		 => $settings[ 'catsid' ],
					] ],
				);
			}

            $wc_query = new \WP_Query($args);
            if ($wc_query): ?>
                <div class="grid-products-5 grid-products-5-<?php echo $wid ?>" data-wid="<?php echo $wid; ?>">
                    <div class="d-flex justify-content-between align-items-center grid-products5-header">
                        <?php if($settings['title']): ?>
                            <div class="grid-products5-title">
                                <h2><?php echo sanitize_text_field($settings['title']); ?></h2>
                            </div>
                        <?php endif; ?>
						<?php if($settings[ 'cat_filter' ] != 'yes'): ?>
							<div class="products-filter">
								<div class="select-box <?php echo is_rtl() ? 'pl-2' : 'pr-2'; ?>">
									<select class="ah-has-bg ah-has-text ah-has-border" name="product_filter_cat_<?php echo $wid ?>" data-before-val="0" id="products-filter-<?php echo $wid ?>" data-wid="<?php echo $wid ?>" data-settings="<?php echo base64_encode(json_encode(array_merge($args, $settings))) ?>">
										<option value="newest" data-order="descorder"><?php echo esc_html__('Newest', 'ahura'); ?></option>
										<option value="oldest" data-order="ascorder"><?php echo esc_html__('Oldest', 'ahura'); ?></option>
										<option value="topsold" data-order="topsold"><?php echo esc_html__('Top-sold', 'ahura'); ?></option>
										<option value="toprating" data-order="toprating"><?php echo esc_html__('Top-rating', 'ahura'); ?></option>
										<option value="highestprice" data-order="highestprice"><?php echo esc_html__('Highest Price', 'ahura'); ?></option>
										<option value="lowestprice" data-order="lowestprice"><?php echo esc_html__('Lowest Price', 'ahura'); ?></option>
									</select>
								</div>
							</div>
						<?php endif; ?>
                    </div>
                    <div class="grid-products5-body">
                        <div class="products-list">
                            <div class="row">
                                <?php include get_template_directory() . '/template-parts/loop/elementor/grid-products5-load-ajax.php'; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <div class="mw_element_error">
                    <?php echo esc_html__('Sorry, no products were found for display.', 'ahura'); ?>
                </div>
            <?php
            endif;
        }
    }
}