<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.

use ahura\app\mw_tools;
use ahura\app\traits\WoocommerceMethods;
use ahura\app\woocommerce;
use Elementor\Controls_Manager;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\mw_assets;

class grid_products4 extends \ahura\app\elementor\Elementor_Widget_Base {
    use WoocommerceMethods;

    public function __register_assets()
    {
        $this->register_elementor_style('grid_products4_css', mw_assets::get_css('elementor.grid_products4'));
        if(!is_rtl()){
            $this->register_elementor_style('grid_products4_ltr_css', mw_assets::get_css('elementor.ltr.grid_products4_ltr'));
        }
    }

    public function get_name() {
        return 'grid_products4';
    }

    public function get_title() {
        return __( 'Grid Products 4', 'ahura' );
    }

    public function get_icon() {
        return 'aicon-svg-grid-products';
    }

    public function get_categories() {
        return [ 'ahuraelements','ahura_woocommerce' ];
    }

    function get_keywords()
    {
        return ['ahura', 'products', 'grid products 4', esc_html__('ahura', 'ahura'), esc_html__( 'Grid Products 4' , 'ahura')];
    }

    protected function register_controls() {
        if(!woocommerce::is_active())
            return false;

        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'ahura' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_type',
            [
                'label'    => __( 'Show Type', 'ahura' ),
                'type'     => Controls_Manager::SELECT2,
                'options'  => [
                    'latest' => __('Latest Products', 'ahura'),
                    'discounted' => __('Discounted Products', 'ahura'),
                    'random' => __('Random Products', 'ahura'),
                    'custom' => __('Custom', 'ahura'),
                ],
                'label_block' => true,
                'default' => 'latest'
            ]
        );

        $categories = get_terms( array(
            'taxonomy' => 'product_cat',
            'hide_empty' => false,
        ));
        $cats = array();
        if($categories){
            foreach ( $categories as $category ) {
                $cats[$category->slug] = $category->name;
            }
        }

        $this->add_control(
            'catsid',
            [
                'label'    => __( 'Categories', 'ahura' ),
                'type'     => Controls_Manager::SELECT2,
                'options'  => $cats,
                'label_block' => true,
                'multiple' => true,
                'default' => key($cats),
                'condition' => ['show_type' => 'custom']
            ]
        );

        $stock_options = (function_exists('wc_get_product_stock_status_options')) ? wc_get_product_stock_status_options() : [];

        $this->add_control(
            'products_stock_status',
            [
                'label'   => esc_html__('Stock status of products', 'ahura'),
                'type'    => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => array_merge(['none'  => esc_html__('None', 'ahura')], $stock_options),
                'default' => 'instock'
            ]
        );

        $this->add_control(
            'count',
            [
                'label'      => __( 'Number of posts', 'ahura' ),
                'type'       => Controls_Manager::NUMBER,
                'default'    => 8
            ]
        );

        $this->add_control(
            'product_order',
            [
                'label' => __('Sort', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'default' => 'DESC',
                'options' => [
                    'ASC' => [
                        'title' => __('Ascending', 'ahura'),
                        'icon' => 'eicon-sort-up'
                    ],
                    'DESC' => [
                        'title' => __('Descending', 'ahura'),
                        'icon' => 'eicon-sort-down'
                    ],
                ],
                'toggle' => true,
                'condition' => ['show_type!' => 'random']
            ]
        );

        $this->add_control(
            'show_by_quantity',
            [
                'label' => esc_html__( 'Show by stock', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => ['show_type!' => 'random']
            ]
        );

        $this->add_control('hr1', ['type' => \Elementor\Controls_Manager::DIVIDER]);

        $this->add_control(
            'show_title',
            [
                'label' => esc_html__( 'Show Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'fully_show_title',
            [
                'label' => esc_html__( 'Fully Show Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'show_title' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'default' => 'h3',
                'options' => [
                    'h1' => 'h1',
                    'h2' => 'h2',
                    'h3' => 'h3',
                    'h4' => 'h4',
                    'h5' => 'h5',
                    'h6' => 'h6',
                ],
                'condition' => [
                    'show_title' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'price',
            [
                'label' => esc_html__( 'Show Price', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'stock_status',
            [
                'label' => esc_html__( 'Show stock status', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_product_rate',
            [
                'label' => esc_html__( 'Product Rate', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'move_product_rate_bottom',
            [
                'label' => esc_html__( 'Move rate to end', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'ahura' ),
                'label_off' => esc_html__( 'No', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => ['show_product_rate' => 'yes']
            ]
        );
        
        $this->add_control(
            'show_product_rate_stars',
            [
                'label' => esc_html__( 'Show stars', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'ahura' ),
                'label_off' => esc_html__( 'No', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => ['show_product_rate' => 'yes']
            ]
        );

        $this->add_control(
            'show_buy_btn',
            [
                'label' => esc_html__('Product Button', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'buy_button_text',
            [
                'label'      => __('Button Text', 'ahura'),
                'type'       => \Elementor\Controls_Manager::TEXT,
                'default'    => __('Buy Product', 'ahura'),
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_responsive_control(
            'object_fit',
            [
                'label' => esc_html__( 'Aspect ratio', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'fill',
                'options' => [
                    'fill' => esc_html__( 'Default', 'ahura' ),
                    'contain' => esc_html__( 'Contain', 'ahura' ),
                    'cover'  => esc_html__( 'Cover', 'ahura' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .fimage img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
			'wrap_state',
			[
				'label' => esc_html__( 'Wrap', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'box_content_section',
            [
                'label' => __( 'Box', 'ahura' ),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_header',
            [
                'label' => esc_html__( 'Show Header', 'ahura' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'box_title',
            [
                'label' => esc_html__( 'Title', 'ahura' ),
                'label_block' => true,
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Latest Products', 'ahura' ),
                'condition' => ['show_header' => 'yes']
            ]
        );

        $this->add_control(
            'show_box_btn',
            [
                'label' => esc_html__( 'Show Button', 'ahura' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => ['show_header' => 'yes']
            ]
        );

        $this->add_control(
            'box_btn_text',
            [
                'label' => esc_html__('Button Text', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'default' => __('View All', 'ahura'),
                'condition' => [
                    'show_box_btn' => 'yes',
                    'show_header' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'box_btn_link',
            [
                'label' => esc_html__('Link', 'ahura'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'is_external' => false,
                    'url' => site_url()
                ],
                'condition' => [
                    'show_box_btn' => 'yes',
                    'show_header' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

        /**
         *
         *
         *  Styles
         *
         *
         */
        $this->start_controls_section(
            'items_style_section',
            [
                'label' => __( 'Items', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'items_spacing',
            [
                'label' => esc_html__( 'Items gap', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-items' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_radius',
            [
                'label' => esc_html__( 'Item Border Radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-item' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_img_radius',
            [
                'label' => esc_html__( 'Cover Border Radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 300,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .sc-items-top img' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_bg',
                'selector' => '{{WRAPPER}} .sc-item-content',
                'exclude' => ['image'],
                'fields_options' =>
                    [
                        'background' =>
                            [
                                'default' => 'classic'
                            ],
                        'color' =>
                            [
                                'default' => '#fff'
                            ]
                    ]
            ]
        );

        $this->add_control(
            'item_border_color',
            [
                'label' => esc_html__('Border Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#f0f0f0',
                'selectors' => [
                    '{{WRAPPER}} .product-item' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#444444',
                'selectors' => [
                    '{{WRAPPER}} .sc-item-content .product-title' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_title' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'ahura'),
                'name' => 'item_title_typo',
                'selector' => '{{WRAPPER}} .sc-item-content .product-title h3, {{WRAPPER}} .sc-item-content .product-title .title-tag',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 500],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ]
                ],
                'condition' => [
                    'show_title' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'item_meta_color',
            [
                'label' => esc_html__('Meta Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sc-item-content .is-meta' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'items_border',
                'selector' => '{{WRAPPER}} .product-items div.product-item',
            ]
        );

        $this->add_responsive_control(
            'image_height',
            [
                'label' => esc_html__( 'Image height', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 100,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-item a.fimage' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'price_styles',
            [
                'label' => esc_html__('Price', 'ahura'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'selector' => '{{WRAPPER}} .reg-price-wrap',
			]
		);

        $this->add_responsive_control(
			'text_align',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .mwprprice' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_control(
            'item_price_color',
            [
                'label' => esc_html__('Product regular price color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000000',
                'selectors' => [
                    '{{WRAPPER}} .reg-price-wrap' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_dis_price_color',
            [
                'label' => esc_html__('Product sale price color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#c3c3ce',
                'selectors' => [
                    '{{WRAPPER}} .sale-price' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'buy_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs('buy_style_tabs');
        $this->start_controls_tab('buy_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_control(
            'buy_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ef3f55',
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'buy_typography',
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '400'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ]
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'buy_bg',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => [ 'classic', 'gradient' ],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
                'fields_options' => [
                    'background' =>
                        [
                            'default' => 'classic'
                        ],
                    'color' =>
                        [
                            'default' => '#fff'
                        ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'buy_border',
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
                'fields_options' => [
                    'border' => ['default' => 'solid'],
                    'width' => [
                        'default' => [
                            'unit' => 'px',
                            'top' => 1,
                            'bottom' => 1,
                            'right' => 1,
                            'left' => 1,
                        ]
                    ],
                    'color' => [
                        'default' => '#ef3f55',
                    ],
                ],
            ]
        );

        $this->add_control(
            'buy_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'buy_box_shadow',
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('buy_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_control(
            'buy_text_color_hover',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'buy_bg_hover',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => [ 'classic', 'gradient' ],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .add-to-cart-btn:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'buy_border_hover',
                'selector' => '{{WRAPPER}} .add-to-cart-btn:hover',
            ]
        );

        $this->add_control(
            'buy_border_radius_hover',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'buy_box_shadow_hover',
                'selector' => '{{WRAPPER}} .add-to-cart-btn:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'box_style_section',
            [
                'label' => __( 'Header', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'box_title_options',
            [
                'label' => esc_html__( 'Title', 'ahura' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $alignment = [
            'left' => [
                'title' => __('Left', 'ahura'),
                'icon' => 'eicon-text-align-left'
            ],
            'center' => [
                'title' => __('Center', 'ahura'),
                'icon' => 'eicon-text-align-center'
            ],
            'right' => [
                'title' => __('Right', 'ahura'),
                'icon' => 'eicon-text-align-right'
            ]
        ];

        $this->add_responsive_control(
            'box_title_alignment',
            [
                'label' => esc_html__('Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $alignment : array_reverse($alignment),
                'default' => is_rtl() ? 'right' : 'left',
                'selectors' => [
                    '{{WRAPPER}} .box-title' => 'text-align: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'box_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .box-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'ahura'),
                'name' => 'box_title_typo',
                'selector' => '{{WRAPPER}} .box-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 500],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '20',
                        ]
                    ]
                ],
            ]
        );

        $this->add_control(
            'btn_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'show_box_btn' => 'yes'
                ]
            ]
        );

        $position = [
            'left' => [
                'title' => __('Left', 'ahura'),
                'icon' => 'eicon-h-align-left'
            ],
            'right' => [
                'title' => __('Right', 'ahura'),
                'icon' => 'eicon-h-align-right'
            ]
        ];

        $this->add_responsive_control(
            'box_btn_alignment',
            [
                'label' => esc_html__('Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => is_rtl() ? $position : array_reverse($position),
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .box-btn' => '{{VALUE}}: 15px;'
                ],
                'condition' => [
                    'show_box_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'box_btn_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#19bfd3',
                'selectors' => [
                    '{{WRAPPER}} .box-btn a' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_box_btn' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'box_btn_typo',
                'selector' => '{{WRAPPER}} .box-btn a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ]
                ],
                'condition' => [
                    'show_box_btn' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();

        $this->register_additional_controls();
    }

    private function query()
    {
        $settings = $this->get_settings_for_display();
        $show_type = $settings['show_type'];
        $cats_id = $settings['catsid'];
        $order = $settings['product_order'];

        $args = [
            'post_type'		 => 'product',
            'post_status'	 => 'publish',
            'posts_per_page' => $settings['count'],
            'order' 		 => $order,
            'meta_query' => []
        ];

        if($show_type == 'latest' || $show_type == 'random') {
            $args = array_merge($args, [
                'orderby' => $show_type == 'random' ? 'rand' : $order
            ]);
        } elseif($show_type == 'discounted') {
            $args['post__in'] = wc_get_product_ids_on_sale();
        } elseif($show_type == 'custom') {
            $field_is_term = (is_array($settings['catsid']) && is_numeric($settings['catsid'][0])) || is_int($settings['catsid']);

            $args = array_merge($args, [
                'tax_query'		 => [
                    [
                        'taxonomy'   => 'product_cat',
                        'field'		 => $field_is_term ? 'term_id' : 'slug',
                        'terms'		 => $cats_id,
                    ]
                ],
            ]);
        }

        $products_stock_status = $settings['products_stock_status'];

        if ($products_stock_status && $products_stock_status !== 'none') {
            if($settings['show_by_quantity'] == 'yes'){
                $args['meta_query']['relation'] = 'AND';
            }

            $args['meta_query'][] = [
                'key' => '_stock_status',
                'value' => $products_stock_status,
                'compare' => '==',
            ];
        }

        if($settings['show_by_quantity'] == 'yes'){
            $args['orderby'] = 'meta_value_num';
            $args['order'] = $order;
            $args['meta_key'] = '_stock';
        }

        if (!empty($settings['box_btn_link']['url'])) {
            $this->add_link_attributes('box_btn_link', $settings['box_btn_link']);
        }

        return new \WP_Query($args);
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $title_tag = $settings['title_tag'];

        if ( class_exists( 'WooCommerce' ) ) {

            $current_currency_symbol = get_woocommerce_currency_symbol();

            $wc_query = $this->query();

            if ($wc_query->have_posts()) : ?>
                <div class="grid-products4-wrap">
                    <?php if ($settings['show_header'] == 'yes'): ?>
                    <div class="box-head">
                        <div class="box-title ah-has-text">
                            <?php echo $settings['box_title'] ?>
                        </div>
                        <?php if ($settings['show_box_btn'] == 'yes'): ?>
                            <div class="box-btn ah-has-text">
                                <a <?php echo $this->get_render_attribute_string('box_btn_link'); ?>>
                                    <?php echo $settings['box_btn_text'] ?>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                    <div class="product-items">
                        <?php
                        while ( $wc_query->have_posts() ) : $wc_query->the_post();
                            global $product;
                            $sale_percent = $this->get_product_sale_percent();
                            $regular_price = get_post_meta(get_the_ID(), '_regular_price', true);
                            $sale_price = get_post_meta(get_the_ID(), '_sale_price', true);
                            $sale_days_progress = $this->get_product_sale_progress_percent(get_the_ID());
                            $average_rating = $product->get_average_rating();
                            ?>
                            <div class="product-item ah-has-border">
                                <div class="sc-item-content ah-has-bg <?php echo $settings['wrap_state'] === 'yes' ? 'flex-wrap' : 'flex-nowrap'; ?>">
                                    <div class="sc-items-top">
                                        <a class="fimage" href="<?php the_permalink(); ?>"><?php the_post_thumbnail(); ?></a>
                                        <div class="product-atts">
                                            <?php woocommerce::render_product_colors($product, 3); ?>
                                        </div>
                                    </div>
                                    <div class="sc-items-bottom">
                                        <?php if($settings['show_title'] == 'yes'): ?>
                                            <a href="<?php the_permalink(); ?>" class="product-title ah-has-text">
                                                <<?php echo esc_attr($title_tag) ?> class="title-tag"><?php echo $settings['fully_show_title'] == 'yes' ? get_the_title() : wp_trim_words( get_the_title(), 6, '...' ); ?></<?php echo esc_attr($title_tag) ?>>
                                            </a>
                                        <?php endif; ?>
                                        <div class="product-more-details">
                                            <div class="product-metas">
                                                <?php if ($settings['stock_status'] == 'yes'): ?>
                                                    <div class="extra-label">
                                                        <?php if ($product->is_in_stock()): ?>
                                                            <?php if ($product->get_manage_stock() && $product->get_stock_quantity() > 0): ?>
                                                                <span class="low-stock is-meta"><?php echo sprintf(__('Only %d units left in stock', 'ahura'), $product->get_stock_quantity()) ?></span>
                                                            <?php else: ?>
                                                                <span class="is-stock is-meta"><i class="fas fa-box"></i><?php echo __('Available in stock', 'ahura') ?></span>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if ($settings['show_product_rate'] == 'yes' && $settings['move_product_rate_bottom'] !== 'yes'): ?>
                                                    <?php if($settings['show_product_rate_stars'] === 'yes'): ?>
                                                        <div class="d-flex rating m-0" title="<?php echo sprintf(__('Rated %s out of 5', 'ahura'), $average_rating); ?>">
                                                            <span>
                                                                <?php
                                                                $full_stars = floor($average_rating);

                                                                for ($i = 0; $i < $full_stars; $i++) {
                                                                    echo '<i class="fas fa-star"></i>';
                                                                }
                                                                ?>
                                                            </span>
                                                            <span class="voted">
                                                                <?php echo sprintf(_n('%d vote', '%d votes', $product->get_rating_count(), 'ahura'), $product->get_rating_count()); ?>
                                                            </span>
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="product-star is-meta">
                                                            <span class="ah-has-text"><?php echo $product->get_average_rating() ?></span>
                                                            <i class="fas fa-star"></i>
                                                        </div>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </div>
                                            <?php if ( $settings['price'] == 'yes' ) : ?>
                                                <div class="mwprprice ah-has-text">
                                                    <div class="regular_price <?php echo empty($sale_percent) ? ' without-sale' : ''?>">
                                                        <?php if (!empty($sale_percent)): ?>
                                                            <span class="sale-percent"><?php echo $sale_percent ?>%</span>
                                                        <?php endif; ?>
                                                        <div class="reg-price-wrap">
                                                            <?php echo sprintf('%s %s', mw_tools::number_format((!empty($sale_price) ? $sale_price : $this->get_price(get_the_ID()))), "<em>{$current_currency_symbol}</em>") ?>
                                                        </div>
                                                    </div>
                                                    <?php if (!empty($sale_price)): ?>
                                                        <div class="sale-price">
                                                            <del><?php echo mw_tools::number_format($regular_price) ?></del>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endif; ?>
                                            <?php if ($settings['show_product_rate'] == 'yes' && $settings['move_product_rate_bottom'] === 'yes'): ?>
                                                <?php if($settings['show_product_rate_stars'] === 'yes'): ?>
                                                    <div class="d-flex rating m-0" title="<?php echo sprintf(__('Rated %s out of 5', 'ahura'), $average_rating); ?>">
                                                        <span>
                                                            <?php
                                                            $full_stars = floor($average_rating);

                                                            for ($i = 0; $i < $full_stars; $i++) {
                                                                echo '<i class="fas fa-star"></i>';
                                                            }
                                                            ?>
                                                        </span>
                                                        <?php if($product->get_rating_count() > 0): ?>
                                                            <span class="voted">
                                                                <?php echo '(' . $product->get_rating_count() . ')'; ?>
                                                            </span>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="product-star is-meta">
                                                        <span class="ah-has-text"><?php echo $product->get_average_rating() ?></span>
                                                        <i class="fas fa-star"></i>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if ($settings['show_buy_btn'] == 'yes'): ?>
                                                <div class="item-buttons">
                                                    <a href="<?php the_permalink(); ?>?add-to-cart=<?php the_ID(); ?>" class="add-to-cart-btn ah-is-button">
                                                        <?php echo $settings['buy_button_text'] ?>
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                            <?php if($sale_days_progress): ?>
                                                <div class="sale-progress">
                                                    <div class="percent" style="width:<?php echo $sale_days_progress ?>%"></div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>
                <?php wp_reset_postdata(); ?>
            <?php
            else:
                $this->renderElementorNotice(__('Nothing found. Edit the page with Elementor and select a category for this section.','ahura'));
            endif;
            ?>
            <?php
        }
    }
}