<?php

namespace ahura\inc\widgets;

// Block direct access to the main plugin file.

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

defined('ABSPATH') or die('No script kiddies please!');

class grid_posts14 extends \ahura\app\elementor\Elementor_Widget_Base
{
    use \ahura\app\traits\mw_elementor;
    public function __register_assets()
    {
        $this->register_elementor_style('elementor_grid_posts14', mw_assets::get_css('elementor.grid_posts14'));
    }

    public function get_name()
    {
        return 'ahura_grid_posts14';
    }
    function get_title()
    {
        return esc_html__('Grid posts 14', 'ahura');
    }
    function get_categories()
    {
        return ['ahuraelements', 'ahura_posts'];
    }
    function get_keywords()
    {
        return ['ahura', 'post', 'grid posts 14', esc_html__('ahura', 'ahura'), esc_html__('Grid posts 14', 'ahura')];
    }
    protected function register_controls()
    {
        $this->start_controls_section(
            'main_content',
            [
                'label' => esc_html__('Content', 'ahura'),
            ]
        );

        $allCategories = get_categories();
        $categoryList = [];
        foreach ($allCategories as $item) {
            $categoryList[$item->term_id] = $item->name;
        }

        $this->add_control(
            'category_ids',
            [
                'label'    => __('Categories', 'ahura'),
                'type'     => \Elementor\Controls_Manager::SELECT2,
                'options'  => $categoryList,
                'label_block' => true,
                'multiple' => true,
                'default' => key($categoryList),
            ]
        );

        $allTags = get_terms([
            'taxonomy' => 'post_tag',
            'hide_empty' => false,
        ]);
        $tagsList = [];
        if ($allTags) {
            foreach ($allTags as $item) {
                $tagsList[$item->term_id] = $item->name;
            }
        }

        $this->add_control(
            'tags_ids',
            [
                'label'    => __('Taxonomy', 'ahura'),
                'type'     => \Elementor\Controls_Manager::SELECT2,
                'options'  => $tagsList,
                'label_block' => true,
                'multiple' => true,
            ]
        );
        
        
        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'posts_thumbnail',
                'exclude' => ['custom'],
                'include' => [],
                'default' => 'full',
            ]
        );
        
        $this->add_control(
            'posts_count',
            [
                'label'      => __('Number of posts', 'ahura'),
                'type'       => \Elementor\Controls_Manager::NUMBER,
                'default'    => 4
            ]
        );

        $this->add_responsive_control(
			'posts_column_number',
			[
				'label' => esc_html__( 'Column number', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'desktop_default' => '25',
				'tablet_default'  => '50',
				'mobile_default'  => '100',
				'options' => [
					'100' => '1',
					'50' => '2',
					'33.33' => '3',
					'25' => '4',
					'20' => '5',
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box-wrapper' => 'width:{{VALUE}}%',
				],
			]
		);

        $this->add_control(
            'excerpt_chars_count',
            [
                'label'   => __( 'Excerpt Characters', 'ahura' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 30,
            ]
        );

		$this->add_control(
			'show_title',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'posts_grid_title',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Newest Articles', 'ahura' ),
				'condition' => [ 'show_title' => 'yes' ]
			]
		);

		$this->add_control(
			'show_button',
			[
				'label' => esc_html__( 'Button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' => esc_html__( 'Button text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'View All', 'ahura' ),
				'condition' => [ 'show_button' => 'yes' ]
			]
		);

		$this->add_control(
			'button_url',
			[
				'label' => esc_html__( 'Button url', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'https://mihanwp.com/ahura', 'ahura' ),
				'condition' => [ 'show_button' => 'yes' ]
			]
		);

		$this->add_control(
			'show_cats',
			[
				'label' => esc_html__( 'Categories', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_desc',
			[
				'label' => esc_html__( 'Description', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_author',
			[
				'label' => esc_html__( 'Author meta', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_author_totop',
			[
				'label' => esc_html__( 'Move author to top', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [ 'show_author' => 'yes' ]
			]
		);

		$this->add_control(
			'show_author_name',
			[
				'label' => esc_html__( 'Author post name', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [ 'show_author' => 'yes' ]
			]
		);

		$this->add_control(
			'show_author_avatar',
			[
				'label' => esc_html__( 'Author post avatar', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [ 'show_author' => 'yes' ]
			]
		);

		$this->add_control(
			'show_author_post_date',
			[
				'label' => esc_html__( 'Author post date', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [ 'show_author' => 'yes' ]
			]
		);

		$this->add_control(
			'show_author_prefix',
			[
				'label' => esc_html__( 'Author meta prefix', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [ 'show_author' => 'yes' ]
			]
		);

		$this->add_control(
			'author_prefix',
			[
				'label' => esc_html__( 'Author prefix', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [ 'show_author_prefix' => 'yes', 'show_author' => 'yes' ]
			]
		);

		$this->add_control(
			'readmore_text_show',
			[
				'label' => esc_html__( 'Read more', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'readmore_link',
			[
				'label' => esc_html__( 'Read more link', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [ 'readmore_text_show' => 'yes' ]
			]
		);
		
		$this->add_control(
			'readmore_text',
			[
				'label' => esc_html__( 'Read more text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'condition' => [ 'readmore_link' => 'yes' ]
			]
		);

		$this->add_control(
			'show_title_icon',
			[
				'label' => esc_html__( 'Title icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'show_meta_stats',
			[
				'label' => esc_html__( 'Meta stats', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'post_view_stat',
			[
				'label' => esc_html__( 'Post view stat', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [ 'show_meta_stats' => 'yes' ]
			]
		);

		$this->add_control(
			'post_date_stat',
			[
				'label' => esc_html__( 'Post date stat', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [ 'show_meta_stats' => 'yes' ]
			]
		);

		$this->add_control(
			'post_video_time',
			[
				'label' => esc_html__( 'Post video time', 'ahura' ),
				'description' => esc_html__( 'Should use "video_time_duration" meta key for the post.', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [ 'show_meta_stats' => 'yes' ]
			]
		);

		$this->add_control(
			'cascade_post',
			[
				'label' => esc_html__( 'Post cascade', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'general_styles',
            [
                'label' => esc_html__('General', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

		$this->add_responsive_control(
			'alignment',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'column' => [
						'title' => esc_html__( 'Column', 'ahura' ),
						'icon' => 'eicon-arrow-up',
					],
					'column-reverse' => [
						'title' => esc_html__( 'Column Reverse', 'ahura' ),
						'icon' => 'eicon-arrow-down',
					],
					'row' => [
						'title' => esc_html__( 'Row', 'ahura' ),
						'icon' => 'eicon-arrow-left',
					],
					'row-reverse' => [
						'title' => esc_html__( 'Row Reserve', 'ahura' ),
						'icon' => 'eicon-arrow-right',
					],
				],
				'default' => 'column',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-wrapper .grid-posts14-box' => 'flex-direction: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'content_margin',
			[
				'label' => esc_html__( 'Content margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'box_wrapper_margin',
			[
				'label' => esc_html__( 'Box margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 10,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'content_width',
			[
				'label' => esc_html__( 'Content width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-content' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'title_area_margin',
			[
				'label' => esc_html__( 'Title area margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 20,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-title-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'title_options',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [ 'show_title' => 'yes' ]
			]
		);

        $this->add_control(
			'widget_title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-title-area h2' => 'color: {{VALUE}}',
				],
				'condition' => [ 'show_title' => 'yes' ]
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'widget_title_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '20'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '600'
                    ]
                ],
				'selector' => '{{WRAPPER}} .grid-posts14-title-area h2',
				'condition' => [ 'show_title' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'widget_title_margin',
			[
				'label' => esc_html__( 'Title margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-title-area h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'button_options',
			[
				'label' => esc_html__( 'Button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [ 'show_button' => 'yes' ]
			]
		);

        $this->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#444BFF',
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-title-area a' => 'color: {{VALUE}}',
				],
				'condition' => [ 'show_button' => 'yes' ]
			]
		);

        $this->add_control(
			'button_hovercolor',
			[
				'label' => esc_html__( 'Hover color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-title-area a:hover' => 'color: {{VALUE}}',
				],
				'condition' => [ 'show_button' => 'yes' ]
			]
		);

        $this->add_control(
			'button_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#444BFF1A',
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-title-area a' => 'background-color: {{VALUE}}',
				],
				'condition' => [ 'show_button' => 'yes' ]
			]
		);

        $this->add_control(
			'button_hover_backcolor',
			[
				'label' => esc_html__( 'Hover background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-title-area a:hover' => 'background-color: {{VALUE}}',
				],
				'condition' => [ 'show_button' => 'yes' ]
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '20'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '600'
                    ]
                ],
				'selector' => '{{WRAPPER}} .grid-posts14-title-area a',
				'condition' => [ 'show_button' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'button_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 15,
					'bottom' => 10,
					'left' => 15,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-title-area a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'show_button' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 5,
					'bottom' => 5,
					'left' => 5,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-title-area a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'show_button' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'button_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-title-area a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'item_styles',
            [
                'label' => esc_html__('Item', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
			'box_options',
			[
				'label' => esc_html__( 'Box', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		
        $this->add_control(
			'item_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box' => 'background-color: {{VALUE}}',
				],
			]
		);

        $item_left_margin = is_rtl() ? 15 : 0;
        $item_right_margin = is_rtl() ? 0 : 15;

        $this->add_responsive_control(
			'item_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => $item_right_margin,
					'bottom' => 0,
					'left' => $item_left_margin,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'item_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'item_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'image_options',
			[
				'label' => esc_html__( 'Image', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_responsive_control(
			'image_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 800,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 243,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .img-container' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'image_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1200,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .img-container' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'image_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 25,
					'right' => 25,
					'bottom' => 25,
					'left' => 25,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .img-container img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'category_options',
			[
				'label' => esc_html__( 'Category', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [ 'show_cats' => 'yes' ]
			]
		);

        $this->add_control(
			'category_odd_color',
			[
				'label' => esc_html__( 'Odd items color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#C11574',
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-cats a:nth-child(odd)' => 'color: {{VALUE}}',
				],
				'condition' => [ 'show_cats' => 'yes' ]
			]
		);

        $this->add_control(
			'category_odd_backcolor',
			[
				'label' => esc_html__( 'Odd items background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#C115741A',
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-cats a:nth-child(odd)' => 'background-color: {{VALUE}}',
				],
				'condition' => [ 'show_cats' => 'yes' ]
			]
		);

        $this->add_control(
			'category_even_color',
			[
				'label' => esc_html__( 'Even items color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#444BFF',
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-cats a:nth-child(even)' => 'color: {{VALUE}}',
				],
				'condition' => [ 'show_cats' => 'yes' ]
			]
		);

        $this->add_control(
			'category_even_backcolor',
			[
				'label' => esc_html__( 'Even items background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#444BFF1A',
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-cats a:nth-child(even)' => 'background-color: {{VALUE}}',
				],
				'condition' => [ 'show_cats' => 'yes' ]
			]
		);

		$this->add_control(
			'category_border_color',
			[
				'label' => esc_html__( 'Border color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-cats a' => 'border: 1px solid {{VALUE}};',
				],
				'condition' => [ 'show_cats' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'category_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 10,
					'bottom' => 5,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-cats a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'show_cats' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'category_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 7,
					'right' => 7,
					'bottom' => 7,
					'left' => 7,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-cats a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'show_cats' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'category_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 15,
					'right' => 0,
					'bottom' => 25,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'show_cats' => 'yes' ]
			]
		);

        $this->add_control(
			'widget_title_options',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-title a' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '18'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '600'
                    ]
                ],
				'selector' => '{{WRAPPER}} .grid-posts14-box .post-title a',
			]
		);
        
        $this->add_responsive_control(
			'title_height',
			[
				'label' => esc_html__( 'Title min height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-title a' => 'min-height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 15,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-title a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'desc_options',
			[
				'label' => esc_html__( 'Description', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$desc_align_default = is_rtl() ? 'right' : 'left';

		$this->add_control(
			'desc_align',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justify', 'ahura' ),
						'icon' => 'eicon-text-align-justify',
					],
				],
				'default' => $desc_align_default,
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-desc' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'desc_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#667085',
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-desc' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16'
                        ]
                    ],
                    'line_height' => [
                        'unit' => 'px',
                        'size' => '27'
                    ]
                ],
				'selector' => '{{WRAPPER}} .grid-posts14-box .post-desc',
			]
		);
        
        $this->add_responsive_control(
			'desc_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 400,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 120,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-desc' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'desc_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 20,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'readmore_options',
			[
				'label' => esc_html__( 'Read more', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'readmore_typography',
				'selector' => '{{WRAPPER}} .read-more',
			]
		);

        $this->add_control(
			'readmore_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#667085',
				'selectors' => [
					'{{WRAPPER}} .read-more' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'readmore_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .read-more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'readmore_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .read-more' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'avatar_options',
			[
				'label' => esc_html__( 'Avatar', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'avatar_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 100,
					'right' => 100,
					'bottom' => 100,
					'left' => 100,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-author .author-avatar img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'avatar_name_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .author-name' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'avatar_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '12.5'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '600'
                    ]
                ],
				'selector' => '{{WRAPPER}} .grid-posts14-box .author-name',
			]
		);

        $this->add_control(
			'meta_stat_options',
			[
				'label' => esc_html__( 'Meta stat', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'condition' => [ 'show_meta_stats' => 'yes' ]
			]
		);

		$this->add_responsive_control(
			'post_stat_margin',
			[
				'label' => esc_html__( 'Stat bar margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 15,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-stats' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'show_meta_stats' => 'yes' ]
			]
		);

		$this->add_control(
			'post_view_dot_color',
			[
				'label' => esc_html__( 'View dot color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-views .dot' => 'background-color: {{VALUE}}',
				],
				'condition' => [ 'show_meta_stats' => 'yes' ]
			]
		);

		$this->add_control(
			'post_view_color',
			[
				'label' => esc_html__( 'View color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-views span' => 'color: {{VALUE}}',
				],
				'condition' => [ 'show_meta_stats' => 'yes' ]
			]
		);

		$this->add_control(
			'post_date_dot_color',
			[
				'label' => esc_html__( 'Date dot color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-date-stat .dot' => 'background-color: {{VALUE}}',
				],
				'condition' => [ 'show_meta_stats' => 'yes' ]
			]
		);

		$this->add_control(
			'post_date_color',
			[
				'label' => esc_html__( 'Date color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-date-stat span' => 'color: {{VALUE}}',
				],
				'condition' => [ 'show_meta_stats' => 'yes' ]
			]
		);

		$this->add_control(
			'post_video_stat_color',
			[
				'label' => esc_html__( 'Video stat color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .img-container .post-video-time' => 'color: {{VALUE}}',
				],
				'condition' => [ 'show_meta_stats' => 'yes' ]
			]
		);

		$this->add_control(
			'post_video_stat_backcolor',
			[
				'label' => esc_html__( 'Video stat background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .img-container .post-video-time' => 'background-color: {{VALUE}}',
				],
				'condition' => [ 'show_meta_stats' => 'yes' ]
			]
		);

		$this->add_responsive_control(
			'post_video_stat_hposition',
			[
				'label' => esc_html__( 'Video stat horizontal position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => -300,
						'max' => 300,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .img-container .post-video-time' => 'right: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 'show_meta_stats' => 'yes' ]
			]
		);

		$this->add_responsive_control(
			'post_video_stat_vposition',
			[
				'label' => esc_html__( 'Video stat vertical position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => -300,
						'max' => 300,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .img-container .post-video-time' => 'top: {{SIZE}}{{UNIT}};',
				],
				'condition' => [ 'show_meta_stats' => 'yes' ]
			]
		);

		$this->add_responsive_control(
			'post_video_padding',
			[
				'label' => esc_html__( 'Video stat padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 10,
					'bottom' => 5,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .img-container .post-video-time' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'show_meta_stats' => 'yes' ]
			]
		);

		$this->add_responsive_control(
			'post_video_radius',
			[
				'label' => esc_html__( 'Video stat border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .img-container .post-video-time' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [ 'show_meta_stats' => 'yes' ]
			]
		);

        $this->add_control(
			'date_options',
			[
				'label' => esc_html__( 'Date', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'date_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#667085',
				'selectors' => [
					'{{WRAPPER}} .grid-posts14-box .post-date' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'date_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '12.5'
                        ]
                    ],
                ],
				'selector' => '{{WRAPPER}} .grid-posts14-box .post-date',
			]
		);

        $this->end_controls_section();

        $this->register_additional_controls();
    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
		$custom_readmore_link = $settings['readmore_link'] === 'yes' && $settings['readmore_text_show'] === 'yes' ? true : false;
		$custom_readmore_text = $settings['readmore_text_show'] === 'yes' ? '<span class="read-more">' . $settings['readmore_text'] . '</span>' : '...';
        $image_size =  $settings['posts_thumbnail_size'];
        $categoryIds = $settings['category_ids'];
        $tags_id = $settings['tags_ids'];
        $chars_num = isset($settings['excerpt_chars_count']) && intval($settings['excerpt_chars_count']) ? $settings['excerpt_chars_count'] : false;
        $taxQuery = [];
        if($categoryIds)
        {
            $taxQuery[] = [
                'taxonomy' => 'category',
                'field' => 'term_id',
                'terms' => $categoryIds,
            ];
        }
        if($tags_id)
        {
            $taxQuery[] = [
                'taxonomy' => 'post_tag',
                'field' => 'term_id',
                'terms' => $tags_id,
            ];
        }
        if(!empty($taxQuery))
        {
            $taxQuery['relation'] = 'AND';
        }
        $args = [
            'post_status' => 'publish',
            'posts_per_page' => $settings['posts_count'] ? $settings['posts_count'] : 4,
            'tax_query' => $taxQuery,
        ];
        $posts = new \WP_Query($args); ?>
        <div class="grid-posts14-wrapper grid-posts14-<?php echo $wid; ?><?php echo $settings['cascade_post'] === 'yes' ? ' cascade-post' : ''; ?>">
			<?php if($settings['show_title'] === 'yes' && $settings['show_button'] === 'yes'): ?>
				<div class="grid-posts14-title-area w-100">
					<div class="hidden-element"></div>
					<?php if($settings['show_title'] === 'yes'): ?>
						<div class="grid-posts14-title">
							<h2><?php echo $settings['posts_grid_title']; ?></h2>
						</div>
					<?php endif; ?>
					<?php if($settings['show_button'] === 'yes'): ?>
						<a href="<?php echo $settings['button_url'] ? $settings['button_url'] : '#'; ?>" class="post-grid14-button"><?php echo $settings['button_text']; ?></a>
					<?php endif; ?>
				</div>
			<?php endif; ?>
            <?php if ($posts->have_posts()) : ?>
                <?php while ($posts->have_posts()) : $posts->the_post();
				$current_time = current_time('timestamp');
				$post_date = get_the_date('Y-m-d'); ?>
                    <div class="grid-posts14-box-wrapper">
                        <div class="grid-posts14-box">
                            <div class="img-container">
								<?php if($settings['post_video_time'] === 'yes' && get_post_meta(get_the_ID(), 'video_time_duration', true)): ?>
									<span class="post-video-time">
										<?php echo get_post_meta(get_the_ID(), 'video_time_duration', true); ?>
									</span>
								<?php endif; ?>
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail($image_size);
                                } ?>
                            </div>
                            <div class="post-content">
								<?php if($settings['show_cats'] === 'yes'): ?>
									<div class="d-flex align-items-center post-meta">
										<div class="post-cats<?php $settings['show_author_totop'] === 'yes' ? ' top-element' : ''; ?>">
											<?php $categories = get_the_category();
											if ($categories) {
												foreach ($categories as $category) {
													echo '<a href="' . esc_url(get_category_link($category->term_id)) . '" class="' . (is_rtl() ? 'ml-2' : 'mr-2') . '">' . esc_html($category->name) . '</a>';
												}
											} ?>
										</div>
										<?php if($settings['show_author_totop'] === 'yes'): ?>
											<?php if($settings['show_author'] === 'yes'): ?>
												<div class="post-author top-element">
													<?php if($settings['show_author_avatar'] === 'yes'): ?>
														<div class="author-avatar">
															<?php echo get_avatar(get_the_author_meta('ID'), 32); ?>
														</div>
													<?php endif; ?>
													<div class="author-data <?php echo is_rtl() ? 'mr-2' : 'ml-2'; ?>">
														<?php if($settings['show_author_name'] === 'yes'): ?>
															<span class="author-name">
																<?php if($settings['show_author_prefix'] === 'yes' && !empty($settings['author_prefix'])): ?>
																	<?php echo sanitize_text_field($settings['author_prefix']); ?>
																<?php endif; ?>
																<?php the_author(); ?>
															</span>
														<?php endif; ?>
														<?php if($settings['show_author_post_date'] === 'yes'): ?>
															<span class="post-date"><?php the_time(get_option('date_format')); ?></span>
														<?php endif; ?>
													</div>
												</div>
											<?php endif; ?>
										<?php endif; ?>
									</div>
								<?php endif; ?>
                                <div class="post-title">
                                    <a href="<?php the_permalink(); ?>" class="d-flex justify-content-between align-items-center">
										<?php the_title(); ?>
										<?php if($settings['show_title_icon'] === 'yes'): ?>
											<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none"><path d="M28.3333 28.3334L11.6666 11.6667" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M28.3333 11.6667H11.6666V28.3334" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>
										<?php endif; ?>
									</a>
                                </div>
								<?php if($settings['post_view_stat'] === 'yes' && $settings['post_date_stat'] === 'yes'): ?>
									<div class="d-flex align-items-center post-stats">
										<?php if ($settings['post_view_stat'] === 'yes' && function_exists('ah_get_unique_views') && ah_get_unique_views(get_the_ID()) !== false): ?>
											<div class="d-flex align-items-center post-views <?php echo is_rtl() ? 'ml-4' : 'mr-4'; ?>">
												<div class="dot <?php echo is_rtl() ? 'ml-1' : 'mr-1'; ?>"></div>
												<?php
												if(ah_get_unique_views(get_the_ID()) === 0) {
													?><span class="post-view-count"><?php echo esc_html__('No views', 'ahura'); ?></span><?php
												} else {
													echo '<span class="post-view-count ' . (is_rtl() ? 'ml-1' : 'mr-1') . '">' . ah_get_unique_views(get_the_ID()) . '</span>' . (ah_get_unique_views(get_the_ID()) === 1 ? '<span class="post-view-postfix">' . esc_html__(' view', 'ahura') . '</span>' : '<span class="post-view-postfix">' . esc_html__(' views', 'ahura') . '</span>');
												}
												?>
											</div>
										<?php endif; ?>
										<?php if($settings['post_date_stat'] === 'yes'): ?>
											<div class="d-flex align-items-center post-date-stat">
												<div class="dot <?php echo is_rtl() ? 'ml-1' : 'mr-1'; ?>"></div>
												<span><?php echo sprintf('%s %s', human_time_diff( get_the_time('U'), current_time('timestamp') ), esc_html__('ago', 'ahura')); ?><span>
											</div>
										<?php endif; ?>
									</div>
								<?php endif; ?>
								<?php if($settings['show_desc'] === 'yes'): ?>
									<p class="post-desc">
										<?php
										if($custom_readmore_link) {
											$custom_readmore_text = '<a href="'.get_permalink().'">'.$custom_readmore_text.'</a>';
										}
										if($chars_num){
											echo wp_trim_words(get_the_excerpt(), $chars_num, $custom_readmore_text);
										} else {
											the_excerpt();
										}
										?>
									</p>
								<?php endif; ?>
								<?php if($settings['show_author_totop'] !== 'yes'): ?>
									<?php if($settings['show_author'] === 'yes'): ?>
										<div class="post-author">
											<?php if($settings['show_author_avatar'] === 'yes'): ?>
												<div class="author-avatar">
													<?php echo get_avatar(get_the_author_meta('ID'), 32); ?>
												</div>
											<?php endif; ?>
											<div class="author-data <?php echo is_rtl() ? 'mr-2' : 'ml-2'; ?>">
												<?php if($settings['show_author_name'] === 'yes'): ?>
													<span class="author-name">
														<?php if($settings['show_author_prefix'] === 'yes' && !empty($settings['author_prefix'])): ?>
															<?php echo sanitize_text_field($settings['author_prefix']); ?>
														<?php endif; ?>
														<?php the_author(); ?>
													</span>
												<?php endif; ?>
												<?php if($settings['show_author_post_date'] === 'yes'): ?>
													<span class="post-date"><?php the_time(get_option('date_format')); ?></span>
												<?php endif; ?>
											</div>
										</div>
									<?php endif; ?>
								<?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
            <?php else: ?>
                <p><?php _e('Sorry,no posts were found for display.', 'ahura')?></p>
            <?php endif; ?>
        </div> <?php
        wp_reset_postdata();
    }
}
