<?php
namespace ahura\inc\widgets;

// Block direct access to the main theme file.
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\mw_assets;

class grid_posts11 extends \ahura\app\elementor\Elementor_Widget_Base
{
    public function __register_assets()
    {
        $this->register_elementor_style('grid_posts11_css', mw_assets::get_css('elementor.grid_posts11'));
    }

    public function get_name()
    {
        return 'grid_posts11';
    }

    public function get_title()
    {
        return esc_html__('Grid Posts 11', 'ahura');
    }

    public function get_icon() {
        return 'eicon-posts-grid';
    }

    public function get_categories()
    {
        return ['ahuraelements', 'ahura_posts'];
    }

    public function get_keywords()
    {
        return ['ahura', 'posts', 'grid posts 11', esc_html__('ahura', 'ahura'), esc_html__('Grid Posts 11', 'ahura')];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'display_settings',
            [
                'label' => esc_html__('Layout', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $post_types = get_post_types(array('public' => true), 'objects');
        unset($post_types['attachment']);
        $types = array();
        foreach ($post_types as $post_type) {
            $types[$post_type->name] = $post_type->labels->singular_name;
        }

        $this->add_control(
            'post_type',
            [
                'label' => esc_html__('Post Type', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'default' => 'post',
                'options' => $types,
            ]
        );

        $taxonomies = get_taxonomies(['public' => true], 'objects');

        $taxs = array();
        if ($taxonomies) {
            foreach ($taxonomies as $key => $taxonomy) {
                if ($taxonomy->public) {
                    $taxs[$taxonomy->name] = $taxonomy->labels->name;
                }
            }
        }
        $default = ($taxs) ? key($taxs) : 0;
        $this->add_control(
            'tax_name',
            [
                'label' => esc_html__('Taxonomy', 'ahura'),
                'type' => Controls_Manager::SELECT2,
                'options' => $taxs,
                'label_block' => true,
            ]
        );

        $cats = array();
        if ($taxonomies) {
            foreach ($taxonomies as $key => $taxonomy) {
                if ($term_object = get_terms($key)) {
                    if($term_object){
                        foreach ($term_object as $term) {
                            $cats[$term->term_id] = "{$term->name} - {$taxonomy->labels->name}";
                        }
                    }
                }
            }
        }
        $default = ($cats) ? key($cats) : 0;
        $this->add_control(
            'cat_id',
            [
                'label' => esc_html__('Categories', 'ahura'),
                'type' => Controls_Manager::SELECT2,
                'options' => $cats,
                'label_block' => true,
                'multiple' => true,
            ]
        );

        $this->add_control(
            'per_page',
            [
                'label' => esc_html__('Number of Per Page', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'default' => 4
            ]
        );

        $this->add_control(
            'layout_col',
            [
                'label' => esc_html__('Columns', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'default' => 3,
                'options' => [
                    '12' => 1,
                    '6' => 2,
                    '4' => 3,
                    '3' => 4,
                ]
            ]
        );

        $this->add_responsive_control(
            'layout_spacing',
            [
                'label' => esc_html__('Spacing', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20
                ],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts-11 > .row' => 'row-gap: {{SIZE}}{{UNIT}}'
                ]
            ]
        );

        $this->add_control('divider1', ['type' => Controls_Manager::DIVIDER]);

        $this->add_control(
            'show_box_title',
            [
                'label' => esc_html__('Show Title', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'box_title',
            [
                'label' => esc_html__('Title', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Readings', 'ahura'),
                'condition' => [
                    'show_box_title' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'show_title_line',
            [
                'label' => esc_html__('Show title line', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_box_btn',
            [
                'label' => esc_html__('Show Button', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'box_btn_icon',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => Controls_Manager::ICONS,
                'skin' => 'inline',
                'exclude_inline_options' => ['svg'],
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'show_box_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'box_btn_text',
            [
                'label' => esc_html__('Button Text', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('More Posts', 'ahura'),
                'condition' => [
                    'show_box_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'box_btn_link',
            [
                'label' => esc_html__('Button Link', 'ahura'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => site_url(),
                ],
                'dynamic' => ['active' => true],
                'condition' => [
                    'show_box_btn' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();
        /**
         *
         * More Settings
         *
         */
        $this->start_controls_section(
            'display_more_settings',
            [
                'label' => esc_html__('More Settings', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'item_cover',
                'default' => 'full',
            ]
        );

        $this->add_responsive_control(
            'object_fit',
            [
                'label' => esc_html__( 'Aspect ratio', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill' => esc_html__( 'Default', 'ahura' ),
                    'contain' => esc_html__( 'Contain', 'ahura' ),
                    'cover'  => esc_html__( 'Cover', 'ahura' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-cover img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_control('divider', ['type' => Controls_Manager::DIVIDER]);

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__('Show Pagination', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'item_excerpt_show',
            [
                'label' => esc_html__('Excerpt', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'excerpt_chars_count',
            [
                'label'   => __( 'Excerpt Characters', 'ahura' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 30,
                'condition' => [
                    'item_excerpt_show' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'item_btn_show',
            [
                'label' => esc_html__('Button', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'post_box_button_text',
            [
                'label' => esc_html__('Button Text', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('More...', 'ahura'),
                'condition' => [
                    'item_btn_show' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'post_btn_icon',
            [
                'label' => esc_html__( 'Post button icon', 'ahura' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-angle-left',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'item_btn_show' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'show_cats',
            [
                'label' => esc_html__('Show categories', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'show_meta_bar',
            [
                'label' => esc_html__('Show meta bar', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'show_comments',
            [
                'label' => esc_html__('Show comments', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'show_meta_bar' => 'yes'
                ]
            ]
        );

        $this->add_control(
			'comments_icon',
			[
				'label' => esc_html__( 'Comment icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'far fa-comments',
					'library' => 'fa-solid',
				],
                'condition' => [
                    'show_meta_bar' => 'yes'
                ]
			]
		);

        $this->add_control(
            'meta_bar_top',
            [
                'label' => esc_html__('Move to title top', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'show_meta_bar' => 'yes'
                ]
            ]
        );
        
        $this->add_control(
            'enable_new_tag',
            [
                'label' => esc_html__('New post tag', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'new_post_text',
            [
                'label' => esc_html__('New post text', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'enable_new_tag' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'show_author',
            [
                'label' => esc_html__('Show author', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'author_prefix',
            [
                'label' => esc_html__('Author prefix', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'show_author' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();
        /**
         *
         *
         * Start styles
         *
         *
         */
        $this->start_controls_section(
            'box_style_section',
            [
                'label' => __( 'Box', 'ahura' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'box_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .box-title' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_box_title' => 'yes'
                ]
            ]
        );
        $this->add_control(
            'box_title_bg_color',
            [
                'label' => esc_html__('Title background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .box-title' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'show_box_title' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'ahura'),
                'name' => 'box_title_typo',
                'selector' => '{{WRAPPER}} .box-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 500],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '25',
                        ]
                    ]
                ],
                'condition' => [
                    'show_box_title' => 'yes'
                ]
            ]
        );

        $this->add_control(
			'title_line_color',
			[
				'label' => esc_html__( 'Title line color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .box-head hr' => 'background-color: {{VALUE}}',
				],
                'condition' => [ 'show_title_line' => 'yes' ]
			]
		);

        $this->add_control(
			'title_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'default' => [
					'unit' => 'px',
					'size' => 0,
				],
                'condition' => [
                    'show_box_title' => 'yes',
                    'box_title_bg_color!' => '',
                ],
				'selectors' => [
					'{{WRAPPER}} .box-title' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'title_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .box-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [
                    'show_box_title' => 'yes',
                    'box_title_bg_color!' => '',
                ],
                'default' => [
                    'top' => '0',
                    'bottom' => '0',
                    'right' => '0',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
			]
		);

        $this->add_control(
            'line_options',
            [
                'label' => esc_html__( 'Line button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
			'line_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 70,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts-11 .box-head hr' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'line_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 1,
				],
				'selectors' => [
					'{{WRAPPER}} .grid-posts-11 .box-head hr' => 'border-bottom-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'line_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .grid-posts-11 .box-head hr' => 'border-bottom-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
            'btn_options',
            [
                'label' => esc_html__( 'Title button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'show_box_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'box_btn_icon_size',
            [
                'label' => esc_html__('Icon Size', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10
                ],
                'selectors' => [
                    '{{WRAPPER}} .box-btns a i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .box-btns a svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_box_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'box_btn_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .box-btns a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .box-btns a svg' => 'fill: {{VALUE}}',
                ],
                'condition' => [
                    'show_box_btn' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'box_btn_bg_color',
            [
                'label' => esc_html__('Background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .box-btns a' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'show_box_btn' => 'yes'
                ],
                'default' => '#000',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'box_btn_typo',
                'selector' => '{{WRAPPER}} .box-btns a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 400],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '14',
                        ]
                    ]
                ],
                'condition' => [
                    'show_box_btn' => 'yes'
                ]
            ]
        );
        $this->add_control(
			'box_btn_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'default' => [
					'unit' => 'px',
					'size' => 10,
				],
                'condition' => [
                    'show_box_btn' => 'yes',
                    'box_btn_bg_color!' => '',
                ],
				'selectors' => [
					'{{WRAPPER}} .box-btns a' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'box_btn_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .box-btns a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [
                    'show_box_btn' => 'yes',
                    'box_btn_bg_color!' => '',
                ],
                'default' => [
                    'top' => '5',
                    'bottom' => '5',
                    'right' => '20',
                    'left' => '20',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
			]
		);

        $this->add_control(
            'cat_options',
            [
                'label' => esc_html__( 'Categories', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
			'cat_list_hr',
			[
				'label' => esc_html__( 'Categories list H position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .post-cover .post-cats' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'cat_list_vr',
			[
				'label' => esc_html__( 'Categories list V position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .post-cover .post-cats' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'cat_typography',
                'label' => esc_html__('Categories typography', 'ahura'),
                'selector' => '{{WRAPPER}} .post-cover .post-cats li a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '14',
                        ]
                    ]
                ],
                'condition' => [ 'show_meta_bar' => 'yes' ]
            ]
        );
        
        $this->add_control(
            'cat_color',
            [
                'label' => esc_html__('Categories color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-cover .post-cats li a' => 'color: {{VALUE}}',
                ],
                'default' => '#ffffff',
            ]
        );
        
        $this->add_control(
            'cat_backcolor',
            [
                'label' => esc_html__('Categories background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-cover .post-cats li a' => 'background-color: {{VALUE}}',
                ],
                'default' => '#22222233',
            ]
        );

        $cat_item_leftmargin = is_rtl() ? '5' : '0';
        $cat_item_rightmargin = is_rtl() ? '0' : '5';

        $this->add_responsive_control(
			'cat_margin',
			[
				'label' => esc_html__( 'Categories margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .post-cover .post-cats li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => '0',
                    'bottom' => '0',
                    'right' => $cat_item_rightmargin,
                    'left' => $cat_item_leftmargin,
                    'unit' => 'px',
                ],
			]
		);

        $this->add_responsive_control(
			'cat_padding',
			[
				'label' => esc_html__( 'Categories list padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .post-cover .post-cats li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => '2',
                    'bottom' => '2',
                    'right' => '5',
                    'left' => '5',
                    'unit' => 'px',
                ],
			]
		);

        $this->add_control(
			'cat_radius',
			[
				'label' => esc_html__( 'Categories list border-radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .post-cover .post-cats li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => '5',
                    'bottom' => '5',
                    'right' => '5',
                    'left' => '5',
                    'unit' => 'px',
                ],
			]
		);

        $this->add_control(
            'meta_options',
            [
                'label' => esc_html__( 'Meta bar', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [ 'show_meta_bar' => 'yes' ]
            ]
        );

        $this->add_control(
			'meta_bar_style',
			[
				'label' => esc_html__( 'Meta bar style', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'Default', 'ahura' ),
					'style1' => esc_html__( 'Style 1', 'ahura' ),
				],
                'condition' => [ 'show_meta_bar' => 'yes' ]
			]
		);
        
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'comments_num_typography',
                'label' => esc_html__('Comments number typography', 'ahura'),
                'selector' => '{{WRAPPER}} .post-meta-bar .post-meta-comments .comments-stat',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16',
                        ]
                    ]
                ],
                'condition' => [ 'show_meta_bar' => 'yes' ]
            ]
        );
        
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'date_typography',
                'label' => esc_html__('Date typography', 'ahura'),
                'selector' => '{{WRAPPER}} .post-meta-bar .post-meta-date',
                'condition' => [ 'show_meta_bar' => 'yes' ],
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16',
                        ]
                    ]
                ]
            ]
        );

        $this->add_control(
            'meta_bar_backcolor',
            [
                'label' => esc_html__('Meta bar background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-meta-bar' => 'background-color: {{VALUE}}',
                ],
                'default' => '#22222233',
                'condition' => [ 'show_meta_bar' => 'yes' ]
            ]
        );

        $this->add_control(
			'meta_bar_alignment',
			[
				'label' => esc_html__( 'Meta bar alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-align-start-h',
					],
					'center' => [
						'center' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-justify-center-h',
					],
					'space-between' => [
						'title' => esc_html__( 'Space between', 'ahura' ),
						'icon' => 'eicon-justify-space-between-h',
					],
					'end' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-align-end-h',
					],
				],
				'default' => 'space-between',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .post-meta-bar' => 'justify-content: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'meta_bar_items_padding',
			[
				'label' => esc_html__( 'Meta bar items padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .post-meta-bar > *' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [ 'show_meta_bar' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'meta_bar_padding',
			[
				'label' => esc_html__( 'Meta bar padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .post-meta-bar' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => '5',
                    'bottom' => '5',
                    'right' => '5',
                    'left' => '5',
                    'unit' => 'px',
                ],
                'condition' => [ 'show_meta_bar' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'meta_bar_margin',
			[
				'label' => esc_html__( 'Meta bar margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .post-meta-bar' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => '2',
                    'bottom' => '2',
                    'right' => '2',
                    'left' => '2',
                    'unit' => 'px',
                ],
                'condition' => [ 'show_meta_bar' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'meta_bar_radius',
			[
				'label' => esc_html__( 'Meta bar border-radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .post-meta-bar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => '5',
                    'bottom' => '5',
                    'right' => '5',
                    'left' => '5',
                    'unit' => 'px',
                ],
                'condition' => [ 'show_meta_bar' => 'yes' ]
			]
		);

        $this->add_control(
			'comments_icon_size',
			[
				'label' => esc_html__( 'Comments icon size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
				'selectors' => [
					'{{WRAPPER}} .post-meta-bar .post-meta-comments svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_meta_bar' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'comment_icon_margin',
			[
				'label' => esc_html__( 'Comment icon margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .post-meta-bar .post-meta-comments .comments-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => '2',
                    'bottom' => '2',
                    'right' => '2',
                    'left' => '2',
                    'unit' => 'px',
                ],
                'condition' => [ 'show_meta_bar' => 'yes' ]
			]
		);

        $meta_separator_border_align = is_rtl() ? 'border-right' : 'border-left';

        $this->add_control(
            'meta_bar_separator_color',
            [
                'label' => esc_html__('Meta items separator color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-meta-bar > *:not(:last-child)' => 'border-left: 1px solid {{VALUE}}',
                ],
                'default' => '#44444400',
                'condition' => [ 'show_meta_bar' => 'yes' ]
            ]
        );

        $this->add_control(
            'meta_new_tag_color',
            [
                'label' => esc_html__('New tag color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .new-post-tag' => 'color: {{VALUE}}',
                ],
                'default' => '#444444',
                'condition' => [ 'show_meta_bar' => 'yes' ]
            ]
        );

        $this->add_control(
            'meta_bar_date_color',
            [
                'label' => esc_html__('Meta bar date color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-meta-bar .post-meta-date' => 'color: {{VALUE}}',
                ],
                'default' => '#444444',
                'condition' => [ 'show_meta_bar' => 'yes' ]
            ]
        );

        $this->add_control(
            'meta_bar_comments_icon_color',
            [
                'label' => esc_html__('Meta bar comment icon color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-meta-bar .post-meta-comments' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .post-meta-bar .post-meta-comments svg' => 'fill: {{VALUE}}',
                ],
                'default' => '#777777',
                'condition' => [ 'show_meta_bar' => 'yes' ]
            ]
        );

        $this->add_control(
            'meta_bar_comments_count_color',
            [
                'label' => esc_html__('Meta bar comment count color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-meta-bar .comments-stat' => 'color: {{VALUE}}',
                ],
                'default' => '#222222',
                'condition' => [ 'show_meta_bar' => 'yes' ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'item_post_img_styles',
            [
                'label' => esc_html__('Image', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_img_min_height',
            [
                'label' => esc_html__('Min Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'default' => [
                    'size' => 170,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts-11 .post-cover' => 'height: {{SIZE}}{{UNIT}}'
                ]
            ]
        );

        $this->add_responsive_control(
			'image_margin',
			[
				'label' => esc_html__( 'Image margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .post-cover > a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => '0',
                    'bottom' => '0',
                    'right' => '0',
                    'left' => '0',
                    'unit' => 'px',
                ],
			]
		);

        $this->add_control(
			'image_radius',
			[
				'label' => esc_html__( 'Image border-radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .post-cover img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => '5',
                    'bottom' => '0',
                    'right' => '5',
                    'left' => '0',
                    'unit' => 'px',
                ],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'item_btn_styles',
            [
                'label' => esc_html__('Button', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'item_btn_show' => 'yes'
                ]
            ]
        );

        $this->start_controls_tabs('item_buttons_styles_tabs');

        $this->start_controls_tab(
            'item_buttons_styles_normal_tab',
            [
                'label' => esc_html__('Normal', 'ahura'),
            ]
        );

        $this->add_control(
            'item_button_color',
            [
                'label' => esc_html__('Button Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#0b0c40',
                'selectors' => [
                    '{{WRAPPER}} .grid-posts-11 .post-btn a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'items_btn_typography',
                'label' => esc_html__('Button Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .grid-posts-11 .post-btn a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15',
                        ]
                    ]
                ]
            ]
        );

        $this->add_control(
            'item_button_bg_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .grid-posts-11 .post-btn a' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_button_color',
            [
                'label' => esc_html__('Icon color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#0b0c40',
                'selectors' => [
                    '{{WRAPPER}} .post-btn svg' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_btn_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .grid-posts-11 .post-btn a',
                'fields_options' => [
                    'border' => ['default' => 'solid'],
                    'width' => ['default' =>
                        [
                            'unit' => 'px',
                            'top' => 1,
                            'right' => 1,
                            'bottom' => 1,
                            'left' => 1,
                        ]
                    ],
                    'color' => ['default' => '#8f8fa1']
                ]
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'item_button_styles_hover_tab',
            [
                'label' => esc_html__('Hover', 'ahura'),
            ]
        );

        $this->add_control(
            'item_button_color_hover',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .grid-posts-11 .post-btn a:hover' => 'color: {{VALUE}}',
                ],
                'default' => '#fff',
            ]
        );

        $this->add_control(
            'item_button_bg_color_hover',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .grid-posts-11 .post-btn a:hover' => 'background-color: {{VALUE}}',
                ],
                'default' => '#0b0c40',
            ]
        );

        $this->add_control(
            'icon_button_color_hover',
            [
                'label' => esc_html__('Icon color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .post-btn a:hover svg' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_btn_border_hover',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .grid-posts-11 .post-btn a:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
			'button_align',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'end' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .post-btn a' => 'justify-content: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'button_icon_size',
			[
				'label' => esc_html__( 'Post button size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
                'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .post-btn svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'button_margin',
			[
				'label' => esc_html__( 'Button margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .post-btn a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => '0',
                    'bottom' => '0',
                    'right' => '0',
                    'left' => '0',
                    'unit' => 'px',
                ],
			]
		);

        $this->add_control(
			'button_padding',
			[
				'label' => esc_html__( 'Button padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .post-btn a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'item_post_styles',
            [
                'label' => esc_html__('Items', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'post_box_hover_animation',
            [
                'label' => esc_html__('Hover Animation', 'ahura'),
                'type' => Controls_Manager::HOVER_ANIMATION,
            ]
        );
        
        $alignment = array(
            'right' => [
                'title' => esc_html__('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'left' => [
                'title' => esc_html__('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ]
        );

        $this->add_control(
            'text_align',
            [
                'label' => esc_html__('Text Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => (is_rtl()) ? $alignment : array_reverse($alignment),
                'default' => (is_rtl()) ? 'right' : 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .grid-posts-11 .grid-post-content' => 'text-align: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'item_bg',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .grid-posts-11 .grid-post-content' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#0b0c40',
                'selectors' => [
                    '{{WRAPPER}} .grid-posts-11 .post-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('Title Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .grid-posts-11 .post-title h2',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '400'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'em',
                            'size' => '0.9',
                        ]
                    ]
                ]
            ]
        );

        $this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Title margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .post-title h2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => '0',
                    'bottom' => '0',
                    'right' => '0',
                    'left' => '0',
                    'unit' => 'px',
                ],
			]
		);

        $this->add_control(
            'item_excerpt_color',
            [
                'label' => esc_html__('Excerpt Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#8d8d8d',
                'selectors' => [
                    '{{WRAPPER}} .grid-posts-11 .grid-post-content .post-excerpt, {{WRAPPER}} .grid-posts-11 .grid-post-content .post-excerpt p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'items_excerpt_typography',
                'label' => esc_html__('Excerpt Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .grid-posts-11 .grid-post-content .post-excerpt p',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '400'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '12',
                        ]
                    ]
                ]
            ]
        );

        $this->add_responsive_control(
			'excerpt_margin',
			[
				'label' => esc_html__( 'Excerpt margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .grid-post-content .post-excerpt p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'default' => [
                    'top' => '0',
                    'bottom' => '0',
                    'right' => '0',
                    'left' => '0',
                    'unit' => 'px',
                ],
			]
		);

        $this->add_control(
            'items_box_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts-11 .grid-post-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 8,
                    'right' => 8,
                    'bottom' => 8,
                    'left' => 8,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .grid-posts-11 .grid-post-content',
                'fields_options' => [
                    'border' => ['default' => 'solid'],
                    'width' => ['default' =>
                        [
                            'unit' => 'px',
                            'top' => 1,
                            'right' => 1,
                            'bottom' => 1,
                            'left' => 1,
                        ]
                    ],
                    'color' => ['default' => '#E9E9E9']
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .grid-posts-11 .grid-post-content',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'item_pagination_styles',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_pagination' => 'yes'
                ]
            ]
        );

        $this->start_controls_tabs('item_pagination_styles_tabs');

        $this->start_controls_tab(
            'item_pagination_styles_normal_tab',
            [
                'label' => esc_html__('Normal', 'ahura'),
            ]
        );

        $this->add_control(
            'item_pagination_buttons_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#4c4c4c',
                'selectors' => [
                    '{{WRAPPER}} .ahura-pagination a, {{WRAPPER}} .ahura-pagination span' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_pagination_buttons_bg_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#f0f0f0',
                'selectors' => [
                    '{{WRAPPER}} .ahura-pagination a, {{WRAPPER}} .ahura-pagination span' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_pagination_buttons_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .ahura-pagination a, {{WRAPPER}} .ahura-pagination span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ]
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'item_pagination_styles_hover_tab',
            [
                'label' => esc_html__('Hover', 'ahura'),
            ]
        );

        $this->add_control(
            'item_pagination_buttons_hover_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .ahura-pagination a:hover, {{WRAPPER}} .ahura-pagination span:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_pagination_buttons_hover_bg_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#0b0c40',
                'selectors' => [
                    '{{WRAPPER}} .ahura-pagination a:hover, {{WRAPPER}} .ahura-pagination span:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'item_pagination_styles_active_tab',
            [
                'label' => esc_html__('Active', 'ahura'),
            ]
        );

        $this->add_control(
            'item_pagination_buttons_active_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .ahura-pagination span.current' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_pagination_buttons_active_bg_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#0b0c40',
                'selectors' => [
                    '{{WRAPPER}} .ahura-pagination span.current' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->register_additional_controls();
    }

    /**
     *
     * Get posts result
     *
     * @param array $params
     * @return false
     */
    public function get_posts($params = [])
    {
        $settings = $this->get_settings_for_display();
        $args = array(
            'post_type' => $settings['post_type'],
            'posts_per_page' => $settings['per_page'],
            'post_status' => 'publish',
        );

        if ($settings['cat_id']) {
            $args['tax_query'] = array(
                'tax_query' => [
                    'relation' => 'OR',
                    [
                        'taxonomy' => $settings['tax_name'],
                        'field' => 'term_id',
                        'terms' => $settings['cat_id'],
                    ]
                ]
            );
        }

        $posts = new \WP_Query(array_merge($args, $params));
        return $posts;
    }

    /**
     *
     * Render content for display
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $is_style1 = 'style1' == $settings['meta_bar_style'] ? true : false;
        $chars_num = isset($settings['excerpt_chars_count']) && intval($settings['excerpt_chars_count']) ? $settings['excerpt_chars_count'] : false;
        $show_box_title = $settings['show_box_title'] === 'yes';
        $show_box_btn = $settings['show_box_btn'] === 'yes';
        $page = $_GET['page_num'] ?? false;
        $current_page = ($page == 0) ? 1 : $page;

        $args = [];

        if ($settings['show_pagination'] === 'yes') {
            $args['paged'] = $current_page;
        }

        $elementClass = 'element-post-content clearfix';
        if ($settings['post_box_hover_animation']) {
            $elementClass .= ' elementor-animation-' . $settings['post_box_hover_animation'];
        }

        $cls = sprintf('col-12 col-md-6 col-sm-12 col-xs-12 col-lg-%s clearfix ', $settings['layout_col']);

        $this->add_render_attribute('wrapper', 'class', $cls . $elementClass);

        if ( ! empty( $settings['box_btn_link']['url'] ) ) {
            $this->add_link_attributes( 'box_btn_link', $settings['box_btn_link'] );
        }

        $posts = $this->get_posts($args);
        if ($posts): ?>
            <div class="grid-posts-11 grid-posts-11-wrap">
                <?php if($show_box_title || $show_box_btn): ?>
                <div class="box-head">
                    <?php if($show_box_title): ?>
                        <div class="box-title ah-has-text">
                            <?php echo $settings['box_title'] ?>
                        </div>
                    <?php endif; ?>
                    <?php if($settings['show_title_line']): ?>
                        <hr />
                    <?php endif; ?>
                    <?php if($show_box_btn): ?>
                        <div class="box-btns ah-is-button-group">
                            <a <?php echo $this->get_render_attribute_string( 'box_btn_link' ); ?>>
                                <?php echo $settings['box_btn_text'] ?>
                                <?php \Elementor\Icons_Manager::render_icon( $settings['box_btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                <div class="row">
                    <?php while($posts->have_posts()) : $posts->the_post();
                        $thumb_id = get_post_thumbnail_id(); ?>
                        <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
                            <div class="grid-post-content ah-has-bg <?php echo !intval($thumb_id) ? ' without-thumb' : '' ?>">
                                <div class="post-content-top">
                                    <div class="post-cover">
                                        <?php $post_categories = wp_get_post_categories( get_the_ID(), array( 'fields' => 'all' ) );
                                        $cats = [];
                                        if( $post_categories && 'yes' == $settings['show_cats'] ): ?>
                                        <ul class="post-cats">
                                            <?php foreach($post_categories as $cat):
                                                $cats[] = [ 'name' => $cat->name ]; ?>
                                                <li><a href=" <?php echo esc_url( get_category_link( $cat->term_id )); ?>"><?php echo $cat->name; ?></a></li>
                                            <?php endforeach; ?>
                                        </ul>
                                        <?php endif; ?>             
                                        <a href="<?php echo esc_attr(get_the_permalink()) ?>">
                                            <?php echo get_the_post_thumbnail(get_the_ID(), $settings['item_cover_size']) ?>
                                        </a>
                                    </div>
                                    <div class="post-details ah-has-text">
                                        <div class="d-flex post-content-header <?php echo $settings['meta_bar_top'] === 'yes' ? 'flex-column-reverse' : 'flex-column'; ?>">
                                            <div class="post-title">
                                                <a href="<?php echo esc_attr(get_the_permalink()) ?>">
                                                    <h2><?php the_title() ?></h2>
                                                </a>
                                            </div>
                                            <?php if('yes' == $settings['show_meta_bar']): ?>
                                                <div class="post-meta-bar">
                                                    <?php if($settings['enable_new_tag'] && !empty($settings['new_post_text'])): ?>
                                                        <span class="new-post-tag"><?php echo $settings['new_post_text']; ?></span>
                                                    <?php endif; ?>
                                                    <?php if($settings['show_comments'] === 'yes'): ?>
                                                        <div class="d-flex justify-content-center align-items-center post-meta-comments">
                                                            <span class="comments-icon">
                                                                <?php \Elementor\Icons_Manager::render_icon( $settings['comments_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                            </span>
                                                            <span class="comments-stat">
                                                                <?php echo get_comments_number( get_the_ID() ); ?>
                                                            </span>
                                                        </div>
                                                    <?php endif; ?>
                                                    <div class="post-meta-date">
                                                        <?php if($is_style1): ?><h5 class="post-date-day">
                                                        <?php else: ?><span class="post-date-day"><?php endif; ?>
                                                            <?php echo get_the_time('d'); ?>
                                                        <?php if($is_style1): ?></h5>
                                                        <?php else: ?></span><?php endif; ?>
                                                        <span class="post-date-month">
                                                            <?php echo get_the_time('F'); ?>
                                                        </span>
                                                        <span class="post-date-year">
                                                            <?php echo get_the_time('Y'); ?>
                                                        </span>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <?php if ($settings['item_excerpt_show'] === 'yes'): ?>
                                            <div class="post-excerpt"><?php
                                                if($chars_num){
                                                    echo '<p>' . wp_trim_words(get_the_excerpt(), $chars_num, '...') . '</p>';
                                                } else {
                                                    the_excerpt();
                                                }
                                                ?></div>
                                        <?php endif ?>
                                    </div>
                                </div>
                                <div class="post-content-bottom<?php echo $settings['show_author'] === 'yes' ? ' d-flex justify-content-between align-items-center' : ''; ?>">
                                    <?php if($settings['show_author'] === 'yes'): ?>
                                        <div class="author-box d-flex justify-content-start align-items-center">
                                            <span class="author-avatar">
                                                <?php echo get_avatar(get_the_author_meta('ID'), 32); ?>
                                            </span>
                                            <?php if($settings['author_prefix']): ?>
                                                <span class="author-prefix <?php echo is_rtl() ? 'pl-1' : 'pr-1'; ?>">
                                                    <?php echo $settings['author_prefix']; ?>
                                                </span>
                                            <?php endif; ?>
                                            <span class="author-name">
                                                <?php echo get_the_author(); ?>
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                    <?php if ($settings['item_btn_show'] === 'yes'): ?>
                                        <div class="post-btn">
                                            <a class="d-flex align-items-center flex-row-reverse" href="<?php echo esc_attr(get_the_permalink()) ?>">
                                                <?php \Elementor\Icons_Manager::render_icon( $settings['post_btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                <span><?php echo $settings['post_box_button_text']; ?></span>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
                <?php if ($settings['show_pagination'] === 'yes'): ?>
                    <div class="ahura-pagination">
                        <?php ahura_custom_pagination($posts->found_posts, $settings['per_page'], $current_page); ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <div class="mw_element_error">
                <?php echo esc_html__('Sorry, no posts were found for display.', 'ahura'); ?>
            </div>
        <?php
        endif;
    }
}