<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\mw_assets;
use Elementor\Controls_Manager;


class colorful_title extends \ahura\app\elementor\Elementor_Widget_Base {
	use \ahura\app\traits\mw_elementor;

    public function __register_assets()
    {
        $this->register_elementor_style('colorful_title_css', mw_assets::get_css('elementor.colorful_title'));
    }

    public function get_name() {
		return 'ahura_colorful_title';
	}

	public function get_title() {
		return __( 'Colorful Title', 'ahura' );
	}

	public function get_icon() {
		return 'aicon-svg-colorful-title';
	}

	public function get_categories() {
		return [ 'ahuraelements' ];
	}
	function get_keywords()
	{
		return ['ahura', 'colorful title', 'title', esc_html__('ahura', 'ahura'), esc_html__( 'Colorful Title' , 'ahura')];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
            'colorful_title',
            [
                'label' => __("Title Colorful", 'ahura'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __("Title Colorful Here", 'ahura')
            ]
        );
		$this->add_control(
			'title_two',
			[
				'label' => __("Title Two", 'ahura'),
				'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __("Default title", 'ahura')
			]
		);

        $this->add_control(
            'text_html_tag',
            [
                'label' => esc_html__('Text Html Tag', 'ahura'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'div',
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'DIV',
                    'span' => 'SPAN',
                    'P' => 'P',
                    'a' => 'A'
                ],
            ]
        );
        $this->add_control(
			'wrapper_link',
			[
				'label' => esc_html__( 'Link', 'ahura' ),
				'type' => \Elementor\Controls_Manager::URL,
				'options' => [ 'url', 'is_external', 'nofollow' ],
				'default' => [
					'url' => '#',
					'is_external' => true,
					'nofollow' => true,
				],
				'label_block' => true,
                'condition' => [ 'text_html_tag' => 'a' ]
			]
		);

        $this->add_control(
			'show_line',
			[
				'label' => esc_html__( 'Show line', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->end_controls_section();
        
        
        $this->start_controls_section(
            'content_styles',
            [
                'label' => __( 'Content', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('style_t1_tabs');
        $this->start_controls_tab('style_t1_tab', ['label' => esc_html__( 'Text 1', 'ahura' )]);

        $this->add_control(
            'title_gradient',
            [
                'label' => esc_html__( 'Use first text gradient', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'colorful_title_color',
            [
                'label' => __("Title colorful color", 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#7918DA',
                'selectors' => [
                    '{{WRAPPER}} .colorful_title' => 'color: {{VALUE}}',
                ],
                'condition' => [ 'title_gradient!' => 'yes' ]
            ]
        );

        $this->add_control(
            'colorful_title_firstcolor',
            [
                'label' => __("Title colorful first gradient color", 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#7918DA',
                'condition' => [ 'title_gradient' => 'yes' ]
            ]
        );

        $this->add_control(
            'colorful_title_seccolor',
            [
                'label' => __("Title colorful first gradient color", 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#7918DA',
                'condition' => [ 'title_gradient' => 'yes' ]
            ]
        );

        $this->add_control(
            'title_1_rotation',
            [
                'label' => esc_html__( 'Color rotation', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'deg' ],
                'range' => [
                    'deg' => [
                        'min' => 0,
                        'max' => 360,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'deg',
                    'size' => 50,
                ],
                'condition' => [ 'title_gradient' => 'yes' ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 't1_background',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .text-wrap-1',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 't1_border',
                'selector' => '{{WRAPPER}} .text-wrap-1',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('style_t2_tab', ['label' => esc_html__( 'Text 2', 'ahura' )]);

        $this->add_control(
            'title_two_gradient',
            [
                'label' => esc_html__( 'Use second text gradient', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'colorful_title_two_color',
            [
                'label' => __("Second title Colorful Color", 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .text-wrap:nth-child(2) span' => 'color: {{VALUE}}',
                ],
                'condition' => [ 'title_two_gradient!' => 'yes' ]
            ]
        );

        $this->add_control(
            'colorful_title_two_firstcolor',
            [
                'label' => __("Title colorful first gradient color", 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#7918DA',
                'condition' => [ 'title_two_gradient' => 'yes' ]
            ]
        );

        $this->add_control(
            'colorful_title_two_seccolor',
            [
                'label' => __("Title colorful second gradient color", 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#7918DA',
                'condition' => [ 'title_two_gradient' => 'yes' ]
            ]
        );

        $this->add_control(
            'title_2_rotation',
            [
                'label' => esc_html__( 'Color rotation', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'deg' ],
                'range' => [
                    'deg' => [
                        'min' => 0,
                        'max' => 360,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'deg',
                    'size' => 50,
                ],
                'condition' => [ 'title_two_gradient' => 'yes' ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 't2_background',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .text-wrap-2',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 't2_border',
                'selector' => '{{WRAPPER}} .text-wrap-2',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control('hr1', ['type' => \Elementor\Controls_Manager::DIVIDER]);

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Typography', 'ahura'),
                'name' => 'colorful_typoghraphy',
                'selector' => "{{WRAPPER}} .colorful_element span",
                'fields_options' =>
                    [
                        'typography' => [
                            'default' => 'yes'
                        ],
                        'font_size' => [
                            'default' => [
                                'unit' => 'px',
                                'size' => '20',
                            ]
                        ],
                    ],
            ]
        );

        $alignment_options = [
            'left' => [
                'title' => __( 'Left', 'ahura' ),
                'icon' => 'eicon-text-align-left',
            ],
            'center' => [
                'title' => __( 'Center', 'ahura' ),
                'icon' => 'eicon-text-align-center',
            ],
            'right' => [
                'title' => __( 'Right', 'ahura' ),
                'icon' => 'eicon-text-align-right',
            ],
        ];

        $this->add_responsive_control(
            'colorful_title_align',
            [
                'label' => __( 'Alignment', 'ahura' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'default' => 'center',
                'options' => is_rtl() ? $alignment_options : array_reverse($alignment_options),
                'selectors' => [
                    '{{WRAPPER}} .colorful_element' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'text_box_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .text-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'text_box_margin',
            [
                'label' => esc_html__( 'Margin', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .text-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

		$this->end_controls_section();
        
        
        $this->start_controls_section(
            'line_styles',
            [
                'label' => __( 'Line', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [ 'show_line' => 'yes' ]
            ]
        );

        $this->add_responsive_control(
			'line_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 200,
				],
				'selectors' => [
					'{{WRAPPER}} .colorful_element .title-line' => 'width: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_line' => 'yes' ]
			]
		);

        $this->add_control(
			'line_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#d5d5d5',
				'selectors' => [
					'{{WRAPPER}} .colorful_element .title-line' => 'color: {{VALUE}}',
					'{{WRAPPER}} .colorful_element .title-line' => 'background-color: {{VALUE}}',
				],
                'condition' => [ 'show_line' => 'yes' ]
			]
		);

        $this->add_control(
			'line_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => is_rtl() ? 10 : 0,
					'bottom' => 0,
					'left' => is_rtl() ? 0 : 10,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .colorful_element .title-line' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [ 'show_line' => 'yes' ]
			]
		);

        $this->add_responsive_control(
			'line_height',
			[
				'label' => esc_html__( 'height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 1,
				],
				'selectors' => [
					'{{WRAPPER}} .colorful_element .title-line' => 'height: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_line' => 'yes' ]
			]
		);

        $this->end_controls_section();

        $this->register_additional_controls();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
        $html_tag = $settings['text_html_tag'];
        
        if ( ! empty( $settings['wrapper_link']['url'] ) ) {
			$this->add_link_attributes( 'wrapper_link', $settings['wrapper_link'] );
		}

        $title_gradient_general_style = 'background-size:100%;background-repeat:repeat;-webkit-background-clip:text;-webkit-text-fill-color:transparent;-moz-background-clip:text;-moz-text-fill-color:transparent;';

        $title1_gradient_style = $settings['title_gradient'] === 'yes' ? ' style="' . $title_gradient_general_style . 'background-image: linear-gradient('. $settings['title_1_rotation']['size'] .'deg, ' . $settings['colorful_title_firstcolor'] . ', ' . $settings['colorful_title_seccolor'].')"' : '';

        $title2_gradient_style = $settings['title_two_gradient'] === 'yes' ? ' style="' . $title_gradient_general_style . 'background-image: linear-gradient('. $settings['title_2_rotation']['size'] .'deg, ' . $settings['colorful_title_two_firstcolor'] . ', ' . $settings['colorful_title_two_seccolor'] .')"' : '';
		?>
		<div class="colorful_element">
			<<?php echo $html_tag ?> <?php if($html_tag == 'a') echo $this->get_render_attribute_string( 'wrapper_link' ); ?> class="colorful_element-content">
                <?php if(!empty($settings['colorful_title'])): ?>
                    <div class="text-wrap text-wrap-1">
                        <span class="colorful_title colorful-text text-1 ah-has-text<?php echo $settings['title_gradient'] === 'yes' ? ' gradient-text' : ''; ?>"<?php echo $title1_gradient_style; ?>><?php echo $settings['colorful_title'];?> </span>
                    </div>
                <?php endif; ?>
                <?php if(!empty($settings['title_two'])): ?>
                    <div class="text-wrap text-wrap-2">
                        <span class="colorful_text colorful-text text-2 ah-has-text<?php echo $settings['title_gradient'] === 'yes' ? ' gradient-text' : ''; ?>"<?php echo $title2_gradient_style; ?>><?php echo $settings['title_two'];?></span>
                    </div>
                <?php endif; ?>
            </<?php echo $html_tag ?>>
            <?php if($settings['show_line'] === 'yes'): ?>
                <div class="title-line"></div>
            <?php endif; ?>
		</div>
		<?php
	}

}
