<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\woocommerce;
use ahura\app\mw_assets;
use Elementor\Controls_Manager;


class bestseller_carousel extends \ahura\app\elementor\Elementor_Widget_Base {

    public function __register_assets()
    {
        $this->register_elementor_style('bestseller_carousel_css', mw_assets::get_css('elementor.bestseller_carousel'));
    }

    public function get_name() {
		return 'bestsellercarousel';
	}

	public function get_title() {
		return __( 'Best Seller Products', 'ahura' );
	}

	public function get_icon() {
		return 'aicon-svg-best-seller-carousel';
	}

	public function get_categories() {
		return [ 'ahuraelements', 'ahura_woocommerce' ];
	}
	function get_keywords()
	{
		return ['ahura', 'best seller carousel', 'best seller', 'carousel', esc_html__( 'ahura', 'ahura' ), esc_html__( 'Best Seller carousel', 'ahura' ),  esc_html__('Best Seller Products', 'ahura')];
	}

	public function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'ahura' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'count',
			[
				'label'      => __( 'Number of products', 'ahura' ),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'default'    => 8
			]
		);

		$this->add_control(
			'top_views',
			[
				'label'   => __( 'Top views', 'ahura' ),
                'description' => esc_html__('Should enable "Capture and enable post views" setting on theme customization panel > blog > single post', 'ahura'),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-close' ]
				],
				'default' => 'no'
			]
		);

		$this->add_control(
			'stockstatus',
			[
				'label'   => __( 'Exclude outofstock products', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-close' ]
				],
				'default' => 'yes'
			]
		);

		$this->add_control(
			'price',
			[
				'label'   => __( 'Show Price', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-close' ]
				],
				'default' => 'yes'
			]
		);

		$this->add_control(
			'custom_meta',
			[
				'label'   => __( 'Show meta', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-close' ]
				],
				'default' => 'no'
			]
		);

		$this->add_control(
			'show_post_date',
			[
				'label'   => __( 'Post date', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-close' ]
				],
                'condition' => [ 'custom_meta' => 'yes' ],
				'default' => 'no'
			]
		);

        $this->add_control(
			'custom_meta_value',
			[
				'label' => esc_html__( 'Custom meta value', 'ahura' ),
				'description' => esc_html__( 'Enter product meta that you want show it beneath the thumbnail', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'product_version', 'ahura' ),
                'condition' => [ 'custom_meta' => 'yes' ]
			]
		);

		$this->add_control(
			'excerpt',
			[
				'label'   => __( 'Excerpt', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
					'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-close' ]
				],
				'default' => 'no'
			]
		);

        $this->add_control(
			'excerpt_words',
			[
				'label' => esc_html__( 'Excerpt words', 'ahura' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 10,
				'max' => 400,
				'step' => 1,
				'default' => 44,
                'condition' => [ 'excerpt' => 'yes' ]
			]
		);

        $this->add_control(
            'show_buy_btn',
            [
                'label' => esc_html__('Product Button', 'ahura'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'buy_button_text',
            [
                'label'      => __('Button Text', 'ahura'),
                'type'       => \Elementor\Controls_Manager::TEXT,
                'default'    => __('Buy Product', 'ahura'),
                'condition' => ['show_buy_btn' => 'yes']
            ]
        );

        $this->add_control(
			'show_img',
			[
				'label' => __( 'Show Image', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
                    'yes' => [ 'title' => __( 'Yes', 'ahura' ), 'icon' => 'eicon-check' ],
                    'no'  => [ 'title' => __( 'No', 'ahura' ), 'icon' => 'eicon-close' ]
				],
				'default' => 'yes',
			]
		);

        $this->add_responsive_control(
            'object_fit',
            [
                'label' => esc_html__( 'Aspect ratio', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'contain',
                'options' => [
                    'fill' => esc_html__( 'Default', 'ahura' ),
                    'contain' => esc_html__( 'Contain', 'ahura' ),
                    'cover'  => esc_html__( 'Cover', 'ahura' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .p-item img' => 'object-fit: {{VALUE}};',
                ],
                'condition' => ['show_img' => 'yes']
            ]
        );

        $this->add_control(
			'desktop_column',
			[
				'label' => esc_html__( 'Desktop column', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '3',
				'options' => [
					'12' => esc_html__( '1', 'ahura' ),
					'6' => esc_html__( '2', 'ahura' ),
					'4' => esc_html__( '3', 'ahura' ),
					'3' => esc_html__( '4', 'ahura' ),
					'2' => esc_html__( '6', 'ahura' ),
				],
			]
		);

        $this->add_control(
			'mobile_column',
			[
				'label' => esc_html__( 'Mobile column', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '6',
				'options' => [
					'12' => esc_html__( '1', 'ahura' ),
					'6' => esc_html__( '2', 'ahura' ),
					'4' => esc_html__( '3', 'ahura' ),
					'3' => esc_html__( '4', 'ahura' ),
					'2' => esc_html__( '6', 'ahura' ),
				],
			]
		);
        $this->end_controls_section();

        $this->start_controls_section(
            'cover_styles',
            [
                'label' => __( 'Cover', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                        'show_img' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'cover_width',
            [
                'label' => esc_html__('Width', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%', 'px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 100
                ],
                'selectors' => [
                    '{{WRAPPER}} .p-item img' => 'width: {{SIZE}}{{UNIT}}'
                ]
            ]
        );

        $this->add_responsive_control(
            'cover_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%', 'px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 50,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 260
                ],
                'selectors' => [
                    '{{WRAPPER}} .p-item img' => 'height: {{SIZE}}{{UNIT}}'
                ]
            ]
        );

        $this->add_control(
            'cover_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .p-item img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 7,
                    'right' => 7,
                    'bottom' => 7,
                    'left' => 7,
                ]
            ]
        );

		$this->end_controls_section();
        $this->start_controls_section(
            'item_styles',
            [
                'label' => __( 'Item', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_background',
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .p-item',
            ]
        );

        $this->add_control(
            'title-color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .p-item h3' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'ahura'),
                'name' => 'item_title_typography',
                'selector' => '{{WRAPPER}} .p-item h3',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '19',
                        ]
                    ]
                ]
            ]
        );

        $this->add_control(
			'title_align',
			[
				'label' => esc_html__( 'Title alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .ahura-element-bestseller-carousel .p-item h3' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_control(
            'pro_box_price_color',
            [
                'label' => esc_html__('Price Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#01b369',
                'selectors' => [
                    '{{WRAPPER}} .price' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .price ins' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'price' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'pro_box_dis_price_color',
            [
                'label' => esc_html__('Price by Discount Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#cdcdcd',
                'selectors' => [
                    '{{WRAPPER}} .price del' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'price' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Price Typography', 'ahura'),
                'name' => 'item_price_typography',
                'selector' => '{{WRAPPER}} .price, {{WRAPPER}} .price span',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17',
                        ]
                    ]
                ],
                'condition' => [
                    'price' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'items_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .p-item',
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'selectors' => [
                    '{{WRAPPER}} .p-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 7,
                    'right' => 7,
                    'bottom' => 7,
                    'left' => 7,
                ]
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .p-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_tab_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .p-item',
            ]
        );

        $this->add_control(
            'meta_options',
            [
                'label' => esc_html__( 'Meta', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [ 'custom_meta' => 'yes' ]
            ]
        );

        $this->add_responsive_control(
			'custom_meta_align',
			[
				'label' => esc_html__( 'Custom meta alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .product-meta' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_control(
            'custom_meta_color',
            [
                'label' => esc_html__('Custom meta color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [ 'excerpt' => 'yes' ],
                'selectors' => [
                    '{{WRAPPER}} .product-meta' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'custom_meta_typography',
                'selector' => '{{WRAPPER}} .product-meta',
                'condition' => [ 'excerpt' => 'yes' ],
            ]
        );

        $this->add_control(
			'custom_meta_margin',
			[
				'label' => esc_html__( 'Custom meta margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .product-meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
            'date_meta_color',
            [
                'label' => esc_html__('Date color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [ 'excerpt' => 'yes' ],
                'selectors' => [
                    '{{WRAPPER}} .product-date' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'date_meta_typography',
                'selector' => '{{WRAPPER}} .product-date',
                'condition' => [ 'excerpt' => 'yes' ],
            ]
        );

        $this->add_control(
            'excerpt_options',
            [
                'label' => esc_html__( 'Excerpt', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [ 'excerpt' => 'yes' ]
            ]
        );

        $this->add_responsive_control(
			'excerpt_align',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .post-excerpt' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_control(
            'excerpt_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'condition' => [ 'excerpt' => 'yes' ],
                'selectors' => [
                    '{{WRAPPER}} .post-excerpt' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'excerpt_typography',
                'selector' => '{{WRAPPER}} .post-excerpt',
                'condition' => [ 'excerpt' => 'yes' ],
            ]
        );

        $this->add_control(
			'excerpt_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .post-excerpt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
            'buy_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs('buy_style_tabs');
        $this->start_controls_tab('buy_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_control(
            'buy_text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#505050',
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'buy_typography',
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => '400'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16',
                        ]
                    ]
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'buy_bg',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => [ 'classic', 'gradient' ],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
                'fields_options' => [
                    'background' =>
                        [
                            'default' => 'classic'
                        ],
                    'color' =>
                        [
                            'default' => '#fff'
                        ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'buy_border',
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
                'fields_options' => [
                    'border' => ['default' => 'solid'],
                    'width' => [
                        'default' => [
                            'unit' => 'px',
                            'top' => 1,
                            'bottom' => 1,
                            'right' => 1,
                            'left' => 1,
                        ]
                    ],
                    'color' => [
                        'default' => '#7e7e7e',
                    ],
                ],
            ]
        );

        $this->add_control(
            'buy_border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'unit' => 'px',
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'buy_box_shadow',
                'selector' => '{{WRAPPER}} .add-to-cart-btn',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('buy_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_control(
            'buy_text_color_hover',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'buy_bg_hover',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => [ 'classic', 'gradient' ],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .add-to-cart-btn:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'buy_border_hover',
                'selector' => '{{WRAPPER}} .add-to-cart-btn:hover',
            ]
        );

        $this->add_control(
            'buy_border_radius_hover',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .add-to-cart-btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'buy_box_shadow_hover',
                'selector' => '{{WRAPPER}} .add-to-cart-btn:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->register_additional_controls();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
        $settings['stockstatus'] == 'yes' ? $stock_status_arr = [['key' => '_stock_status', 'value' => 'instock']] : $stock_status_arr = [];
        $excerpt_words_count = $settings['excerpt_words'] ? $settings['excerpt_words'] : 44;

		if ( class_exists( 'WooCommerce' ) ) {

            $args_base = [
                'post_type'      => 'product',
                'post_status'    => 'publish',
                'posts_per_page' => $settings['count'],
                'ignore_sticky_posts' => true,
            ];
        
            if (function_exists('ah_get_unique_views') && $settings['top_views'] === 'yes') {
                $posts_with_views = [];
                $wc_query = new \WP_Query($args_base);
                while ($wc_query->have_posts()) : $wc_query->the_post();
                    $post_id = get_the_ID();
                    $views = ah_get_unique_views($post_id);
                    if ($views !== false) {
                        $posts_with_views[$post_id] = $views;
                    }
                endwhile;
                wp_reset_postdata();
        
                if (!empty($posts_with_views)) {
                    arsort($posts_with_views);
                    $args_base['post__in'] = array_keys($posts_with_views);
                    $args_base['orderby'] = 'post__in';
                }
            }

            $args_bestseller = [
                'meta_key'   => 'total_sales',
                'orderby'    => 'meta_value_num',
                'order'      => 'DESC',
                'meta_query' => $stock_status_arr
            ];

            $args = array_merge($args_base, $args_bestseller);

            $wc_query = new \WP_Query($args);

			if ( $wc_query->have_posts() ) : ?>
                <div class="ahura-element-bestseller-carousel">
                    <div class="row">
                        <?php while ( $wc_query->have_posts() ) : $wc_query->the_post(); ?>
                            <div class="col-<?php echo $settings['mobile_column'] ?> col-md-4 col-lg-<?php echo $settings['desktop_column'] ?>">
                                <div class="p-item ah-has-bg">
                                    <?php if ( $settings['show_img'] === 'yes' ): ?>
                                        <a class="fimage" href="<?php the_permalink(); ?>">
                                            <?php the_post_thumbnail( 'woocommerce_thumbnail' ); ?>
                                        </a>
                                    <?php endif;
                                    $custom_post_meta = $settings['custom_meta'] === 'yes' && !empty($settings['custom_meta_value']) ? get_post_meta( get_the_ID(), $settings['custom_meta_value'], true ) : '';
                                    if (!empty( $custom_post_meta)) : ?>
                                        <p class="product-meta"><?php echo $custom_post_meta; ?></p>
                                    <?php endif; ?>
                                    <a href="<?php the_permalink(); ?>" class="ah-has-text">
                                        <h3><?php echo wp_trim_words( get_the_title(), 6, '...' ); ?></h3>
                                    </a>
                                    <?php if(!empty(get_the_content()) && $settings['excerpt'] === 'yes'): ?>
                                        <p class="post-excerpt">
                                            <?php echo wp_trim_words( get_the_content(), $excerpt_words_count, '...' ); ?>
                                        </p>
                                    <?php endif; ?>
                                    <?php if ( $settings['price'] == 'yes' ) : ?>
                                        <div class="mwprprice ah-has-text">
                                            <?php echo woocommerce_template_single_price(); ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($settings['custom_meta'] === 'yes' && $settings['show_post_date'] === 'yes'): ?>
                                        <div class="d-flex justify-content-between align-items-center product-footer">
                                            <span class="product-date"><?php echo get_the_date('Y/m/d'); ?></span>
                                    <?php endif; ?>
                                    <?php if ($settings['show_buy_btn'] == 'yes'): ?>
                                        <div class="item-buttons">
                                            <a href="<?php the_permalink(); ?>?add-to-cart=<?php the_ID(); ?>" class="add-to-cart-btn ah-is-button">
                                                <?php echo $settings['buy_button_text'] ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                    <?php if($settings['custom_meta'] === 'yes' && $settings['show_post_date'] === 'yes'): ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                </div>
				<?php wp_reset_postdata(); ?>
			<?php else: ?>
					<div class="mw_element_error">
						<?php echo __( 'Nothing found. Edit the page with Elementor and select a category for this section.','ahura' );?>
					</div>
			<?php endif; ?>
            <div class="clear"></div>
			<?php
		} elseif( is_admin() ) {
			?>
			<div class="productcategorybox mw_elem_empty_box"><h3><?php _e( 'To use this element you must install woocommerce plugin.', 'ahura' ); ?></h3></div>
			<?php
		}
	}

}
