<?php
namespace ahura\inc\widgets;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\mw_assets;
use \ahura\app\elementor\controls\Control_Jdate_Picker;
use Elementor\Controls_Manager;

class ah_datetime extends \ahura\app\elementor\Elementor_Widget_Base {
    function __construct($data=[], $args=null)
    {
        parent::__construct($data, $args);
        mw_assets::register_script('ahura_datetime_js', mw_assets::get_js('ah_datetime'));
        mw_assets::register_script('ah_datetime_element_js', mw_assets::get_js('elementor.ah_datetime'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('ahura_datetime_css', mw_assets::get_css('elementor.ah_datetime'));
    }

    function get_script_depends()
    {
        return [ mw_assets::get_handle_name('ahura_datetime_js'), mw_assets::get_handle_name('ah_datetime_element_js') ];
    }

	public function get_name() {
		return 'mwdatetime';
	}
    
	public function get_title() {
		return __( 'Date/Time', 'ahura' );
	}

	public function get_icon() {
		return 'eicon-date';
	}

	public function get_categories() {
		return [ 'ahuraelements' ];
	}
	function get_keywords()
	{
		return ['ahura', 'date', 'time', esc_html__( 'ahura', 'ahura' ), esc_html__( 'time', 'ahura' ), esc_html__( 'Date/Time' , 'ahura')];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'ahura' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'show_dot',
			[
				'label' => esc_html__( 'Show dot', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        
        $this->add_control(
			'selected_timezone',
			[
				'label' => esc_html__( 'Timezone', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'Asia/Tehran',
				'options' => [
					'Asia/Tehran' => esc_html__( 'Iran', 'ahura' ),
					'Asia/Dubai' => esc_html__( 'UAE', 'ahura' ),
					'Europe/Istanbul' => esc_html__( 'Istanbul', 'ahura' ),
					'Europe/London'  => esc_html__( 'London', 'ahura' ),
					'Europe/Berlin' => esc_html__( 'Berlin', 'ahura' ),
				],
			]
		);

		$this->add_control(
			'use_gregorian_calendar',
			[
				'label' => esc_html__( 'Gregorian calendar', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'General', 'ahura' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'direction',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'end' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .mwdatetime' => 'justify-content: {{VALUE}};',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'selector' => '{{WRAPPER}} .mwdatetime span',
			]
		);

        $this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Text color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwdatetime' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'dot_color',
			[
				'label' => esc_html__( 'Dot color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .dot' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->end_controls_section();
	}

	protected function render() {
        $settings = $this->get_settings_for_display();
        $el_id = $this->get_id();
        $timezone = $settings['selected_timezone'];
        
        if (function_exists('ahura_jdate') && $settings['use_gregorian_calendar'] !== 'yes') {
            $current_date_p1 = ahura_jdate('l j F');
        } else {
            $current_date_p1 = current_time('l d F Y');
        }
        
        if (!empty($timezone)) {
            date_default_timezone_set($timezone);
        }

        $current_date_p2 = $settings['use_gregorian_calendar'] !== 'yes' ? date("F d") : '';
        $current_date_p3 = date("Y-m-d H:i:s");

        $data = ['id' => $el_id];
        ?>
        <div data-json='<?php echo json_encode($data) ?>' class="d-flex align-items-center flex-column datetime-element datetime-<?php echo $el_id?>" current-date-p1="<?php echo $current_date_p1; ?>" current-date-p2="<?php echo $current_date_p2; ?>" current-date-p3="<?php echo $current_date_p3; ?>" dot-status=<?php echo $settings['show_dot']; ?>>
            <?php $this->fixedEmptyContentInEditor() ?>
            <div id="mwdatetime" class="d-flex align-items-center mwdatetime w-100"></div>
        </div>
    <?php
    }
}
