<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\customization\heading_box;
use ahura\app\customization\image_radio_box;
use ahura\app\customization\simple_notice;
use ahura\app\customization\simple_range;
use ahura\app\customization\ios_checkbox;
use ahura\app\customization\simple_text;
use ahura\app\customization\simple_select_box;
use ahura\app\customization\multiple_checkbox_control;
use ahura\app\customization\tab_controls;
use ahura\app\mw_options;

$layout_dir_url = get_template_directory_uri() . '/img/customization/layout/';
$ahura_columns_items = [];

if(is_rtl()) {
    $ahura_columns_items = [
        '2cr' => [
            'label' => __( 'Right Sidebar', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_right.png',
        ],
        '2c' => [
            'label' => __( 'Left Sidebar', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_left.png',
        ],
        '3c' => [
            'label' => __( '3 Columns', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_3c.png',
        ],
        '1c' => [
            'label' => __( 'Full Width', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_full_width.png',
        ],
        '1cc' => [
            'label' => __( 'Full Width And Center Content', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_full_width_center.png',
        ],
    ];
} else {
    $ahura_columns_items = [
        '2c' => [
            'label' => __( 'Left Sidebar', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_left.png',
        ],
        '2cr' => [
            'label' => __( 'Right Sidebar', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_right.png',
        ],
        '3c' => [
            'label' => __( '3 Columns', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_3c.png',
        ],
        '1c' => [
            'label' => __( 'Full Width', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_full_width.png',
        ],
        '1cc' => [
            'label' => __( 'Full Width And Center Content', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_full_width_center.png',
        ],
    ];
}

$this->customizer->add_setting('ahura_single_product_loop_style', ['default' => 'default']);
$this->customizer->add_control(new simple_select_box($this->customizer, 'ahura_single_product_loop_style', [
    'section' => $this->current_section,
    'label' => __('Single product Style', 'ahura'),
    'choices' => [
        'default' => __('Woocommerce Default', 'ahura'),
        'digikala' => __('Style 1', 'ahura'),
        'digitalmarketplace' => __('Style 2', 'ahura'),
        'mode3' => __('Style 3', 'ahura'),
        'mode4' => __('Style 4', 'ahura'),
    ],
]));

$this->customizer->add_setting('show_digital_marketplace_metaboxes', true);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'show_digital_marketplace_metaboxes', [
    'label' => __('Use metaboxes instead of limited four fields for checklist items', 'ahura'),
    'section' => $this->current_section,
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digitalmarketplace';
    },
]));

$this->customizer->add_setting('ahura_digi_page_gallery_width', ['default' => 35]);
$this->customizer->add_control(new simple_range( $this->customizer, 'ahura_digi_page_gallery_width', [
    'label' => __('Gallery section width','ahura'),
    'section' => $this->current_section,
    'input_attrs' => [
        'min' => 0,
        'max' => 100,
    ],
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
]));

$this->customizer->add_setting('ahura_digital_metaboxes_notice');
$this->customizer->add_control( new simple_notice( $this->customizer, 'ahura_digital_metaboxes_notice',[
        'description' => __( 'In the product edit page and custom fields box, set the field name as checklist_item1, checklist_item2, ... and with your desired value or use the product checklist custom fields in the custom information tab.', 'ahura' ),
        'section' => $this->current_section,
        'active_callback' => function(){
            return mw_options::get_single_product_style() == 'digitalmarketplace' && mw_options::get_digital_marketplace_metaboxes();
        },
    ]
));

$this->customizer->add_setting('digital_product_checklist_text1', ['default' => esc_html__('Money back guarantee', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'digital_product_checklist_text1',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Checklist - item 1', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digitalmarketplace' && mw_options::get_digital_marketplace_metaboxes() == false;
    },
)));

$this->customizer->add_setting('digital_product_checklist_text2', ['default' => esc_html__('Quality guarantee', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'digital_product_checklist_text2',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Checklist - item 2', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digitalmarketplace' && mw_options::get_digital_marketplace_metaboxes() == false;
    },
)));

$this->customizer->add_setting('digital_product_checklist_text3', ['default' => esc_html__('Free professional support', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'digital_product_checklist_text3',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Checklist - item 3', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digitalmarketplace' && mw_options::get_digital_marketplace_metaboxes() == false;;
    },
)));

$this->customizer->add_setting('digital_product_checklist_text4', ['default' => esc_html__('Free update, lifetime access to the file', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'digital_product_checklist_text4',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Checklist - item 4', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digitalmarketplace' && mw_options::get_digital_marketplace_metaboxes() == false;;
    },
)));

$this->customizer->add_setting('show_digital_product_preview_btn', false);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'show_digital_product_preview_btn', [
    'label' => __('Show product preview button', 'ahura'),
    'section' => $this->current_section,
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digitalmarketplace';
    },
]));

$this->customizer->add_setting('product_preview_button_text', ['default' => esc_html__('Product preview', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'product_preview_button_text',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Product preview button text', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digitalmarketplace' && ['\ahura\app\mw_options','get_digital_product_preview_btn'];
    },
)));

$this->customizer->add_setting('ahura_product_preview_button_notice');
$this->customizer->add_control( new simple_notice( $this->customizer, 'ahura_product_preview_button_notice',[
        'description' => __( 'Product preview button url should be set as "demo_url" custom field on product edit page.', 'ahura' ),
        'section' => $this->current_section,
        'active_callback' => function(){
            return mw_options::get_single_product_style() == 'digitalmarketplace' && ['\ahura\app\mw_options','get_digital_product_preview_btn'];
        },
    ]
));

$this->customizer->add_setting('digital_total_sales_text', ['default' => esc_html__('Sales', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'digital_total_sales_text',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Sale label text', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digitalmarketplace';
    },
)));

$this->customizer->add_setting('digital_total_satisfaction_text', ['default' => esc_html__('Satisfaction', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'digital_total_satisfaction_text',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Satisfaction label text', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digitalmarketplace';
    },
)));

$this->customizer->add_setting('digital_checklist_items_icon', ['default' => 'fas fa-check']);
$this->customizer->add_control(new simple_text($this->customizer,'digital_checklist_items_icon',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Checklist icon (use FontAwesome icon class)', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digitalmarketplace';
    },
)));

$this->customizer->add_setting('ahura_product_page_columns', ['default' => '2c']);
$this->customizer->add_control(new image_radio_box($this->customizer, 'ahura_product_page_columns',array(
    'label' => __( 'Woocommerce single page columns', 'ahura' ),
    'section' => $this->current_section,
    'choices' => $ahura_columns_items,
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'default';
    },
)));

$this->customizer->add_setting('ahura_product_page_notice');
$this->customizer->add_control( new simple_notice( $this->customizer, 'ahura_product_page_notice',[
        'description' => __( 'Product page container set as full width with no column.', 'ahura' ),
        'section' => $this->current_section,
        'active_callback' => function(){
            return mw_options::get_single_product_style() == 'digikala';
        },
    ]
));

$this->customizer->add_setting('ahura_product_page_woo_tabtitle', ['default' => 0]);
$this->customizer->add_control(new simple_range( $this->customizer, 'ahura_product_page_woo_tabtitle', [
    'label' => __('Woocommerce product tabs space from top','ahura'),
    'section' => $this->current_section,
    'input_attrs' => [
        'min' => 0,
        'max' => 300,
    ],
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
]));
$this->customizer->add_setting('ahura_product_page_woo_tabtitle_tablet', ['default' => 0]);
$this->customizer->add_control(new simple_range( $this->customizer, 'ahura_product_page_woo_tabtitle_tablet', [
    'label' => __('Woocommerce product tabs space from top (tablet)','ahura'),
    'section' => $this->current_section,
    'input_attrs' => [
        'min' => 0,
        'max' => 300,
    ],
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
]));
$this->customizer->add_setting('ahura_product_page_woo_tabtitle_mobile', ['default' => 0]);
$this->customizer->add_control(new simple_range( $this->customizer, 'ahura_product_page_woo_tabtitle_mobile', [
    'label' => __('Woocommerce product tabs space from top (mobile)','ahura'),
    'section' => $this->current_section,
    'input_attrs' => [
        'min' => 0,
        'max' => 300,
    ],
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
]));

$this->customizer->add_setting('digi_product_id_notfound_text', ['default' => esc_html__('It doesn\'t exist', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'digi_product_id_notfound_text',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Product id not found text', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
)));

$this->customizer->add_setting('digi_product_attrs_notfound_text', ['default' => esc_html__('This product does not have any attributes', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'digi_product_attrs_notfound_text',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Product attributes not found text', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
)));

$this->customizer->add_setting('digi_product_rating_title_text', ['default' => esc_html__('User Rating', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'digi_product_rating_title_text',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('product rating title text', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
)));

$this->customizer->add_setting('digi_product_rating_icon', ['default' => 'fas fa-store']);
$this->customizer->add_control(new simple_text($this->customizer,'digi_product_rating_icon',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Product rating icon (FontAwesome)', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
)));

$this->customizer->add_setting('digi_product_norating_text', ['default' => esc_html__('No reviews', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'digi_product_norating_text',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Text if there is no reviews', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
)));

$this->customizer->add_setting('digi_product_availability_text', ['default' => esc_html__('Product is available', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'digi_product_availability_text',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('product availability text', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
)));

$this->customizer->add_setting('digi_product_availability_icon', ['default' => 'fas fa-shipping-fast']);
$this->customizer->add_control(new simple_text($this->customizer,'digi_product_availability_icon',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Product availability icon (FontAwesome)', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
)));

$this->customizer->add_setting('digi_product_not_available_text', ['default' => esc_html__('Product isn\'t available', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'digi_product_not_available_text',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Text if there is no reviews', 'ahura' ),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
)));

$this->customizer->add_setting('show_product_onsale_percent');
$this->customizer->add_control(new ios_checkbox($this->customizer, 'show_product_onsale_percent', [
    'label' => __('Show product on-sale percentage', 'ahura'),
    'section' => $this->current_section,
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
]));

$this->customizer->add_setting('show_single_product_breadcrumb');
$this->customizer->add_control(new ios_checkbox($this->customizer, 'show_single_product_breadcrumb', [
    'label' => __('Show single product breadcrumb', 'ahura'),
    'section' => $this->current_section
]));

$this->customizer->add_setting('ahura_sticky_addtocart_status',['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_sticky_addtocart_status',array(
    'section' => $this->current_section,
    'label' => __( 'Show sticky add to cart on phone', 'ahura' ),
)));

$this->customizer->add_setting('shop_change_add_to_cart_button_text_status', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'shop_change_add_to_cart_button_text_status',[
    'section' => $this->current_section,
    'label'   => __( 'Change add to cart button text', 'ahura' ),
]));

$this->customizer->add_setting('shop_add_to_cart_button_text', ['default' => esc_html__('Add to Cart', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'shop_add_to_cart_button_text',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Add to cart button text', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_change_add_to_cart_button_text_status'],
)));

$this->customizer->add_setting('ahura_product_buy_button_text_color', ['default' => '#ffffff']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_product_buy_button_text_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_product_buy_button_text_color',
        'label' => __( 'Add to cart button color', 'ahura' ),
    ))
);

$this->customizer->add_setting('ahura_product_bg_color');
$this->customizer->add_control(new WP_Customize_Color_Control($this->customizer,'ahura_product_bg_color',array(
        'section' => $this->current_section,
        'label' => __( 'Product box background color', 'ahura' ),
    ))
);

$this->customizer->add_setting('ahura_product_buy_button_bg_color', ['default' => '#00b0ff']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_product_buy_button_bg_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_product_buy_button_bg_color',
        'label' => __( 'Add to cart button background color', 'ahura' ),
    ))
);

$this->customizer->add_setting('ahura_shop_show_product_thumbnails_in_slider',['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_product_thumbnails_in_slider',array(
    'section' => $this->current_section,
    'label' => __( 'Show product gallery in slider', 'ahura' ),
)));

$this->customizer->add_setting('ahura_shop_show_product_slider_buttons',['default' => true]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_product_slider_buttons',array(
    'section' => $this->current_section,
    'label' => __('Show product gallery slider buttons', 'ahura'),
    'active_callback' => ['\ahura\app\mw_options','get_mod_show_product_thumbnails_in_slider'],
)));

$this->customizer->add_setting('ahura_shop_move_product_slider_buttons',['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_move_product_slider_buttons',array(
    'section' => $this->current_section,
    'label' => __('Move product gallery slider buttons', 'ahura'),
    'active_callback' => ['\ahura\app\mw_options','get_mod_show_product_slider_buttons'],
)));

$this->customizer->add_setting('ahura_move_price_after_short_description', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_move_price_after_short_description',array(
    'section' => $this->current_section,
    'label' => __('Move price after short description', 'ahura'),
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'default';
    },
)));

$places_options = [
    'telegram' 	    => __( 'Telegram', 'ahura' ),
    'whatsapp' 	    => __( 'WhatsApp', 'ahura' ),
    'facebook'      => __( 'Facebook', 'ahura' ),
    'twitter' 	    => __( 'Twitter', 'ahura' ),
    'linkedin' 	    => __( 'Linkedin', 'ahura' ),
];
$this->customizer->add_setting( 'ahura_product_page_digikala_sharings', [ 'default'   => ['all'] ] );
$this->customizer->add_control( new multiple_checkbox_control( $this->customizer, 'ahura_product_page_digikala_sharings', array(
    'label'    => __( 'Select sharing buttons', 'ahura' ),
    'section'  => $this->current_section,
    'choices'  => $places_options,
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
)));

$this->customizer->add_setting('ahura_product_page_digikala_all_attributes', ['default' => 0]);
$this->customizer->add_control(new simple_text($this->customizer, 'ahura_product_page_digikala_all_attributes', array(
    'label' => __('How many attributes need to show at all', 'ahura'),
    'section' => $this->current_section,
    'type'  =>  'number',
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
)));

$this->customizer->add_setting('ahura_product_page_digikala_attributes', ['default' => 3]);
$this->customizer->add_control(new simple_text($this->customizer, 'ahura_product_page_digikala_attributes', array(
    'label' => __('How many attributes need to show at first', 'ahura'),
    'section' => $this->current_section,
    'type'  =>  'number',
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
)));

$this->customizer->add_setting('ahura_disable_zoom_on_product_gallery',['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_disable_zoom_on_product_gallery',array(
    'section' => $this->current_section,
    'label' => __( 'Disable Zoom on Product Gallery', 'ahura' ),
)));

$this->customizer->add_setting('ahura_shop_show_product_related',['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_product_related',array(
    'section' => $this->current_section,
    'label' => __( 'Show product related', 'ahura' ),
)));

$this->customizer->add_setting('ahura_shop_show_product_related_in_slider',['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_product_related_in_slider',array(
    'section' => $this->current_section,
    'label' => __( 'Show product related in slider', 'ahura' ),
    'active_callback' => [ '\ahura\app\mw_options','get_mod_is_active_product_related' ],
)));

$this->customizer->add_setting('ahura_shop_show_related_product_slider_btns',['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_related_product_slider_btns',array(
    'section' => $this->current_section,
    'label' => __('Show related product slider buttons', 'ahura'),
    'active_callback' => ['\ahura\app\mw_options', 'get_mod_is_active_product_related_in_slider'],
)));

$this->customizer->add_setting('ahura_shop_related_product_title_height');
$this->customizer->add_control(new simple_text($this->customizer,'ahura_shop_related_product_title_height',array(
        'section' => $this->current_section,
        'type' => 'number',
        'input_attrs' => [
            'min' => 10,
            'max' => 1000
        ],
        'label' => __( 'Related product title height', 'ahura' ),
        'active_callback' => ['\ahura\app\mw_options', 'get_mod_is_active_product_related'],
    ))
);

$this->customizer->add_setting( 'ahura_related_product_column', ['default' => '3'] );
$this->customizer->add_control( 'ahura_related_product_column', [
    'type'    => 'select',
    'section' => $this->current_section,
    'label'   => __( 'Related products column', 'ahura' ),
    'choices' => [
        '2' => __( '2', 'ahura' ),
        '3' => __( '3', 'ahura' ),
        '4' => __( '4', 'ahura' ),
        '5' => __( '5', 'ahura' ),
        '6' => __( '6', 'ahura' ),
    ],
    'active_callback' => [ '\ahura\app\mw_options','get_mod_is_active_product_related' ],
] );

$this->customizer->add_setting('ahura_shop_exclude_outofstock_in_related_products',['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_exclude_outofstock_in_related_products',array(
    'section' => $this->current_section,
    'label' => __( 'Exclude out of stock items from related products', 'ahura' ),
    'active_callback' => [ '\ahura\app\mw_options','get_mod_is_active_product_related' ],
)));

$this->customizer->add_setting( 'ahura_related_product_column_mobile', ['default' => 1] );
$this->customizer->add_control( 'ahura_related_product_column_mobile', [
    'type'    => 'select',
    'section' => $this->current_section,
    'label'   => __( 'Related products column in mobile', 'ahura' ),
    'choices' => [
        '1' => __( '1', 'ahura' ),
        '2' => __( '2', 'ahura' ),
        '3' => __( '3', 'ahura' ),
        '4' => __( '4', 'ahura' ),
    ],
    'active_callback' => [ '\ahura\app\mw_options','get_mod_is_active_product_related' ],
] );

$this->customizer->add_setting( 'ahura_max_related_products_num',[ 'default' => '3' ] );
$this->customizer->add_control( new simple_text( $this->customizer,'ahura_max_related_products_num', [
    'section' => $this->current_section,
    'type'    => 'number',
    'label'   => __( 'Maximum related products', 'ahura' ),
    'active_callback' => [ '\ahura\app\mw_options','get_mod_is_active_product_related' ],
] ) );

$this->customizer->add_setting('ahura_shop_show_call_for_price_inquery', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_call_for_price_inquery',array(
    'section' => $this->current_section,
    'label' => __('Show text call for price inquery', 'ahura'),
    'description' => __('Displayed text only for products without price', 'ahura'),
)));

$this->customizer->add_setting('ahura_shop_text_call_for_price_inquery', ['default' => esc_html__('Call for price inquiry', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'ahura_shop_text_call_for_price_inquery',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Text call for price inquery', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_show_call_for_price_inquery'],
)));

$this->customizer->add_setting('ahura_shop_btn_text_call_for_price_inquery', ['default' => esc_html__('Contact us', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'ahura_shop_btn_text_call_for_price_inquery',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Call button text', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_show_call_for_price_inquery'],
)));

$this->customizer->add_setting('ahura_shop_btn_url_call_for_price_inquery', ['default' => 'tel:+989123456789']);
$this->customizer->add_control(new simple_text($this->customizer,'ahura_shop_btn_url_call_for_price_inquery',array(
    'section' => $this->current_section,
    'type' => 'url',
    'label' => __('Call button url', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_show_call_for_price_inquery'],
)));

$this->customizer->add_setting('ahura_shop_text_call_for_price_inquery_color', ['default' => '#5CE1B3']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_shop_text_call_for_price_inquery_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_shop_text_call_for_price_inquery_color',
        'label' => __( 'Inquery Text Color', 'ahura' ),
        'active_callback' => ['\ahura\app\mw_options','get_mod_show_call_for_price_inquery'],
    ))
);

$this->customizer->add_setting( 'ahura_change_mode_product_select_variation', [ 'default' => true ] );
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ahura_change_mode_product_select_variation', [
    'label' => __( 'Change mode of select variation', 'ahura' ),
    'section' => $this->current_section,
]));

$this->customizer->add_setting( 'ah_show_product_variation_title', [ 'default' => true ] );
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ah_show_product_variation_title', [
    'label' => __( 'Show Product Variation Title', 'ahura' ),
    'section' => $this->current_section,
    'active_callback' => ['\ahura\app\mw_options','is_product_single_template_mode3'],
]));

$this->customizer->add_setting( 'ahura_woo_modified_date', [ 'default' => false ] );
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ahura_woo_modified_date', [
    'label' => __( 'Show Woocommerce product modified date', 'ahura' ),
    'section' => $this->current_section,
]));

$this->customizer->add_setting( 'ahura_woo_modified_title_date_color',[ 'default' => '#181522' ] );
$this->customizer->add_control( new WP_Customize_Color_Control( $this->customizer,'ahura_woo_modified_title_date_color', [
    'section' => $this->current_section,
    'setting' => 'ahura_woo_modified_title_date_color',
    'label'   => __( 'Product modified title date color', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_is_active_woo_modified_date'],
] ) );

$this->customizer->add_setting( 'ahura_woo_modified_date_color',[ 'default' => '#181522' ] );
$this->customizer->add_control( new WP_Customize_Color_Control( $this->customizer,'ahura_woo_modified_date_color', [
    'section' => $this->current_section,
    'setting' => 'ahura_woo_modified_date_color',
    'label'   => __( 'Product modified date color', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_is_active_woo_modified_date'],
] ) );

$this->customizer->add_setting( 'product_update_date_text',[ 'default' => esc_html__('Product updated in:', 'ahura')] );
$this->customizer->add_control( new simple_text( $this->customizer, 'product_update_date_text', [
    'label' => __( 'Product update date text', 'ahura' ),
    'section' => $this->current_section,
    'active_callback' => [ '\ahura\app\mw_options', 'get_mod_is_active_woo_modified_date' ],
] ) );

$sections = [];
$section_list = null;
if (\ahura\app\mw_options::is_ahura_builder_accessible()){
    $sectionBuilder = new \ahura\app\elementor\Ahura_Elementor_Builder();
    $section_list = $sectionBuilder->getTemplates(['section_builder', 'elementor_library']);
}
if($section_list){
    foreach($section_list as $section) {
        $sections[$section->ID] = $section->post_title;
    }
    $sections[1] = esc_html__('None', 'ahura');
} else {
    $sections[1] = esc_html__('Nothing found', 'ahura');
}
$this->customizer->add_setting('ahura_product_before_price_custom_section');
$this->customizer->add_control(new simple_select_box($this->customizer, 'ahura_product_before_price_custom_section', [
    'section' => $this->current_section,
    'label' => __('Custom section before price area', 'ahura'),
    'choices' => $sections,
    'active_callback' => ['\ahura\app\mw_options','is_product_single_template_mode4'],
]));

$this->customizer->add_setting('ahura_product_after_price_custom_section');
$this->customizer->add_control(new simple_select_box($this->customizer, 'ahura_product_after_price_custom_section', [
    'section' => $this->current_section,
    'label' => __('Custom section after price area', 'ahura'),
    'choices' => $sections,
    'active_callback' => ['\ahura\app\mw_options','is_product_single_template_mode4'],
]));

$this->customizer->add_setting( 'ahura_woo_special_sale_price_date_options', [ 'default' => false ] );
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ahura_woo_special_sale_price_date_options', [
    'label' => __( 'More options on Woocommerce sale price date', 'ahura' ),
    'section' => $this->current_section,
]));

$this->customizer->add_setting( 'ahura_woo_special_sale_price_date_counter', [ 'default' => false ] );
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ahura_woo_special_sale_price_date_counter', [
    'label' => __( 'Sale price date as a counter', 'ahura' ),
    'section' => $this->current_section,
    'active_callback' => [ '\ahura\app\mw_options', 'get_mod_is_active_special_sale_price_date_options' ],
]));

$this->customizer->add_setting('ahura_woo_special_sale_price_date_color');
$this->customizer->add_control(new WP_Customize_Color_Control($this->customizer,'ahura_woo_special_sale_price_date_color',array(
        'setting' => 'ahura_woo_special_sale_price_date_color',
        'label' => __( 'Sale price date color', 'ahura' ),
        'section' => $this->current_section,
        'active_callback' => [ '\ahura\app\mw_options', 'get_mod_is_active_special_sale_price_date_options' ],
    ))
);

$this->customizer->add_setting('ahura_woo_special_sale_price_date_background_color');
$this->customizer->add_control(new WP_Customize_Color_Control($this->customizer,'ahura_woo_special_sale_price_date_background_color',array(
        'setting' => 'ahura_woo_special_sale_price_date_background_color',
        'label' => __( 'Sale price date background color', 'ahura' ),
        'section' => $this->current_section,
        'active_callback' => [ '\ahura\app\mw_options', 'get_mod_is_active_special_sale_price_date_options' ],
    ))
);

$this->customizer->add_setting('ahura_woo_special_sale_price_date_padding', ['default' => 5]);
$this->customizer->add_control(new simple_text($this->customizer, 'ahura_woo_special_sale_price_date_padding', array(
    'label' => __('Sale price date padding', 'ahura'),
    'section' => $this->current_section,
    'type'  =>  'number',
    'active_callback' => [ '\ahura\app\mw_options', 'get_mod_is_active_special_sale_price_date_options' ],
)));

$this->customizer->add_setting('ahura_woo_special_sale_price_date_radius', ['default' => 5]);
$this->customizer->add_control(new simple_text($this->customizer, 'ahura_woo_special_sale_price_date_radius', array(
    'label' => __('Sale price date border radius', 'ahura'),
    'section' => $this->current_section,
    'type'  =>  'number',
    'active_callback' => [ '\ahura\app\mw_options', 'get_mod_is_active_special_sale_price_date_options' ],
)));

$this->customizer->add_setting('shop_upsells_box_title');
$this->customizer->add_control(new simple_text($this->customizer,'shop_upsells_box_title',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Up Sells Box Title', 'ahura' ),
)));

$this->customizer->add_setting('shop_cross_sells_box_title');
$this->customizer->add_control(new simple_text($this->customizer,'shop_cross_sells_box_title',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Cross Sells Box Title', 'ahura' ),
)));

$this->customizer->add_setting('ahura_product_review_template_mode', ['default' => 'default']);
$this->customizer->add_control(new simple_select_box($this->customizer, 'ahura_product_review_template_mode', [
    'section' => $this->current_section,
    'label' => __('Single product Review Mode', 'ahura'),
    'choices' => [
        'default' => __('Woocommerce Default', 'ahura'),
        1 => __('Style 1', 'ahura'),
        2 => __('Style 2', 'ahura'),
    ],
]));

$this->customizer->add_setting( 'ahura_product_review_like_status', ['default' => true]);
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ahura_product_review_like_status', [
    'label' => __( 'Review Like Box', 'ahura' ),
    'section' => $this->current_section,
    'active_callback' => function(){
        return mw_options::get_mod_product_review_template_mode() == 1;
    }
]));

$this->customizer->add_setting( 'ahura_product_review_strength_weak_points_status', ['default' => true]);
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ahura_product_review_strength_weak_points_status', [
    'label' => __( 'Review strength & weak points Box', 'ahura' ),
    'section' => $this->current_section,
    'active_callback' => function(){
        return mw_options::get_mod_product_review_template_mode() == 1;
    }
]));

$this->customizer->add_setting( 'ahura_product_review_rules_status', ['default' => true]);
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ahura_product_review_rules_status', [
    'label' => __( 'Review Rules Box', 'ahura' ),
    'section' => $this->current_section,
    'active_callback' => function(){
        return mw_options::get_mod_product_review_template_mode() == 1;
    }
]));

$this->customizer->add_setting('ahura_product_review_rules_title', ['default' => __('Please read the summary of the following rules before posting a comment:', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'ahura_product_review_rules_title',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Review Rules Title', 'ahura' ),
    'active_callback' => [ '\ahura\app\mw_options', 'get_mod_product_review_rules_status' ]
)));

$this->customizer->add_setting('ahura_product_review_rules_text');
$this->customizer->add_control(new simple_text($this->customizer,'ahura_product_review_rules_text',array(
    'section' => $this->current_section,
    'type' => 'textarea',
    'label' => __('Review Rules Content', 'ahura' ),
    'description' => __('Separate items with enter (each item on one line).', 'ahura'),
    'active_callback' => [ '\ahura\app\mw_options', 'get_mod_product_review_rules_status' ]
)));

$this->customizer->add_setting('ah_single_product_tabs_content_color_controls');
$this->customizer->add_control(new heading_box($this->customizer, 'ah_single_product_tabs_content_color_controls', [
    'label' => __('Tabs content color', 'ahura'),
    'section' => $this->current_section,
    'active_callback' => ['\ahura\app\mw_options','is_product_single_template_mode4'],
]));

$this->customizer->add_setting('ah_single_product_tab_content_bg_color', ['default' => '#F1F1F1']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ah_single_product_tab_content_bg_color',array(
        'section' => $this->current_section,
        'setting' => 'ah_single_product_tab_content_bg_color',
        'label' => __( 'Tab content background color', 'ahura' ),
        'active_callback' => ['\ahura\app\mw_options','is_product_single_template_mode4'],
    ))
);

$this->customizer->add_setting('ah_single_product_tab_content_color');
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ah_single_product_tab_content_color',array(
        'section' => $this->current_section,
        'setting' => 'ah_single_product_tab_content_color',
        'label' => __( 'Tab content color', 'ahura' ),
        'active_callback' => ['\ahura\app\mw_options','is_product_single_template_mode4'],
    ))
);

$this->customizer->add_setting('ah_single_product_tabs_color_controls');
$this->customizer->add_control(new heading_box($this->customizer, 'ah_single_product_tabs_color_controls', [
    'label' => __('Tabs Color', 'ahura'),
    'section' => $this->current_section,
    'active_callback' => function(){
        return mw_options::get_woocommerce_product_single_template() != 'mode4';
    }
]));

$this->customizer->add_setting( 'ah_single_product_show_tab_icon', ['default' => true]);
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ah_single_product_show_tab_icon', [
    'label' => __( 'Show Tab Icon', 'ahura' ),
    'section' => $this->current_section,
    'active_callback' => function(){
        return mw_options::get_woocommerce_product_single_template() != 'mode4';
    }
]));

$this->customizer->add_setting('ah_single_product_tab_text_color', ['default' => '#333']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ah_single_product_tab_text_color',array(
        'section' => $this->current_section,
        'setting' => 'ah_single_product_tab_text_color',
        'label' => __( 'Text Color', 'ahura' ),
        'active_callback' => function(){
            return mw_options::get_woocommerce_product_single_template() != 'mode4';
        }
    ))
);

$this->customizer->add_setting('ah_single_product_tab_bg_color', ['default' => '#fff']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ah_single_product_tab_bg_color',array(
        'section' => $this->current_section,
        'setting' => 'ah_single_product_tab_bg_color',
        'label' => __( 'Background Color', 'ahura' ),
        'active_callback' => function(){
            return mw_options::get_woocommerce_product_single_template() != 'mode4';
        }
    ))
);

$this->customizer->add_setting('ah_single_product_tab_shadow_color', ['default' => '#fff']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ah_single_product_tab_shadow_color',array(
        'section' => $this->current_section,
        'setting' => 'ah_single_product_tab_shadow_color',
        'label' => __( 'Shadow Color', 'ahura' ),
        'active_callback' => function(){
            return mw_options::get_woocommerce_product_single_template() != 'mode4';
        }
    ))
);

$this->customizer->add_setting('ah_single_product_tab_text_color_hover');
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ah_single_product_tab_text_color_hover',array(
        'section' => $this->current_section,
        'setting' => 'ah_single_product_tab_text_color_hover',
        'label' => __( 'Text Color (Hover Mode)', 'ahura' ),
        'active_callback' => function(){
            return mw_options::get_woocommerce_product_single_template() != 'mode4';
        }
    ))
);

$this->customizer->add_setting('ah_single_product_tab_bg_color_hover');
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ah_single_product_tab_bg_color_hover',array(
        'section' => $this->current_section,
        'setting' => 'ah_single_product_tab_bg_color_hover',
        'label' => __( 'Background Color (Hover Mode)', 'ahura' ),
        'active_callback' => function(){
            return mw_options::get_woocommerce_product_single_template() != 'mode4';
        }
    ))
);

$this->customizer->add_setting('ah_single_product_tab_shadow_color_hover');
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ah_single_product_tab_shadow_color_hover',array(
        'section' => $this->current_section,
        'setting' => 'ah_single_product_tab_shadow_color_hover',
        'label' => __( 'Shadow Color (Hover Mode)', 'ahura' ),
        'active_callback' => function(){
            return mw_options::get_woocommerce_product_single_template() != 'mode4';
        }
    ))
);

$this->customizer->add_setting('ah_single_product_tab_text_color_active', ['default' => '#ffffff']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ah_single_product_tab_text_color_active',array(
        'section' => $this->current_section,
        'setting' => 'ah_single_product_tab_text_color_active',
        'label' => __( 'Text Color (Active Mode)', 'ahura' ),
        'active_callback' => function(){
            return mw_options::get_woocommerce_product_single_template() != 'mode4';
        }
    ))
);

$this->customizer->add_setting('ah_single_product_tab_bg_color_active', ['default' => '#684ceb']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ah_single_product_tab_bg_color_active',array(
        'section' => $this->current_section,
        'setting' => 'ah_single_product_tab_bg_color_active',
        'label' => __( 'Background Color (Active Mode)', 'ahura' ),
        'active_callback' => function(){
            return mw_options::get_woocommerce_product_single_template() != 'mode4';
        }
    ))
);

$this->customizer->add_setting('ah_single_product_tab_shadow_color_active', ['default' => '#684ceb']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ah_single_product_tab_shadow_color_active',array(
        'section' => $this->current_section,
        'setting' => 'ah_single_product_tab_shadow_color_active',
        'label' => __( 'Shadow Color (Active Mode)', 'ahura' ),
        'active_callback' => function(){
            return mw_options::get_woocommerce_product_single_template() != 'mode4';
        }
    ))
);

$this->customizer->add_setting('ah_single_product_tabs_title_controls');
$this->customizer->add_control(new heading_box($this->customizer, 'ah_single_product_tabs_title_controls', [
    'label' => __('Tabs Title', 'ahura'),
    'section' => $this->current_section,
]));

$this->customizer->add_setting( 'ah_change_single_product_tabs_title', ['default' => false]);
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ah_change_single_product_tabs_title', [
    'label' => __( 'Change Product Tabs Title', 'ahura' ),
    'section' => $this->current_section,
]));

$this->customizer->add_setting('ah_single_product_description_tab_title');
$this->customizer->add_control(new simple_text($this->customizer,'ah_single_product_description_tab_title',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Description Tab Title', 'ahura' ),
    'active_callback' => [ '\ahura\app\mw_options', 'get_mod_change_product_tabs_title' ]
)));

$this->customizer->add_setting('ah_single_product_additional_information_tab_title');
$this->customizer->add_control(new simple_text($this->customizer,'ah_single_product_additional_information_tab_title',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Additional Information Tab Title', 'ahura' ),
    'active_callback' => [ '\ahura\app\mw_options', 'get_mod_change_product_tabs_title' ]
)));

$this->customizer->add_setting('ah_single_product_reviews_tab_title');
$this->customizer->add_control(new simple_text($this->customizer,'ah_single_product_reviews_tab_title',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Reviews Tab Title', 'ahura' ),
    'active_callback' => [ '\ahura\app\mw_options', 'get_mod_change_product_tabs_title' ]
)));

$this->customizer->add_setting( 'ah_single_product_disable_wctabs_responsive', ['default' => false]);
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ah_single_product_disable_wctabs_responsive', [
    'label' => __( 'Disable tabs title on responsive', 'ahura' ),
    'section' => $this->current_section,
    'active_callback' => function(){
        return mw_options::get_single_product_style() == 'digikala';
    },
]));

$this->customizer->add_setting( 'ah_single_product_disable_wctabs_inner_title', ['default' => false]);
$this->customizer->add_control( new ios_checkbox( $this->customizer, 'ah_single_product_disable_wctabs_inner_title', [
    'label' => __( 'Disable tabs inner title', 'ahura' ),
    'section' => $this->current_section,
]));