<?php
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\customization\image_radio_box;
use ahura\app\customization\ios_checkbox;
use ahura\app\customization\simple_text;
use ahura\app\customization\simple_select_box;
use ahura\app\customization\simple_notice;

$layout_dir_url = get_template_directory_uri() . '/img/customization/layout/';
$ahura_columns_items = [];

if(is_rtl()) {
    $ahura_columns_items = [
        '2cr' => [
            'label' => __( 'Right Sidebar', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_right.png',
        ],
        '2c' => [
            'label' => __( 'Left Sidebar', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_left.png',
        ],
        '3c' => [
            'label' => __( '3 Columns', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_3c.png',
        ],
        '1c' => [
            'label' => __( 'Full Width', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_full_width.png',
        ],
        '1cc' => [
            'label' => __( 'Full Width And Center Content', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_full_width_center.png',
        ],
    ];
} else {
    $ahura_columns_items = [
        '2c' => [
            'label' => __( 'Left Sidebar', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_left.png',
        ],
        '2cr' => [
            'label' => __( 'Right Sidebar', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_right.png',
        ],
        '3c' => [
            'label' => __( '3 Columns', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_3c.png',
        ],
        '1c' => [
            'label' => __( 'Full Width', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_full_width.png',
        ],
        '1cc' => [
            'label' => __( 'Full Width And Center Content', 'ahura' ),
            'image_url' => $layout_dir_url . 'site_columns_full_width_center.png',
        ],
    ];
}

$this->customizer->add_setting('ahura_shop_product_loop_style', ['default' => 1]);
$this->customizer->add_control(new simple_select_box($this->customizer, 'ahura_shop_product_loop_style', [
    'section' => $this->current_section,
    'label' => __('Products Style', 'ahura'),
    'choices' => [
        'default' => __('Woocommerce Default', 'ahura'),
        1 => __('Style 1', 'ahura'),
        2 => __('Style 2', 'ahura'),
        3 => __('Style 3', 'ahura'),
        4 => __('Style 4', 'ahura'),
    ],
]));

$this->customizer->add_setting('ahura_shop_columns', ['default' => '2c']);
$this->customizer->add_control(new image_radio_box($this->customizer, 'ahura_shop_columns',array(
    'label' => __( 'Woocommerce pages columns', 'ahura' ),
    'type' => 'radio',
    'section' => $this->current_section,
    'choices' => $ahura_columns_items
)));

$this->customizer->add_setting('ahura_shop_style3_image_height', ['default' => '180']);
$this->customizer->add_control(new simple_text($this->customizer,'ahura_shop_style3_image_height',array(
        'section' => $this->current_section,
        'type' => 'number',
        'input_attrs' => [
            'min' => 100,
            'max' => 1000
        ],
        'label' => __( 'Product image thumbnail height', 'ahura' ),
        'active_callback' => function(){
            return \ahura\app\mw_options::get_product_item_style() == 3;
        },
    ))
);

$this->customizer->add_setting('ahura_shop_product_loop_style_notice',['default' => true]);
$this->customizer->add_control(new simple_notice($this->customizer, 'ahura_shop_product_loop_style_notice',array(
    'section' => $this->current_section,
    'description' => __( 'Suitable for using woocommerce default elements in elementor.', 'ahura' ),
    'active_callback' => function(){
        return \ahura\app\mw_options::get_product_item_style() == 'default';
    },
)));

$this->customizer->add_setting('ahura_shop_page_product_title_color', ['default' => '#000']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_shop_page_product_title_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_shop_page_product_title_color',
        'label' => __( 'Product Title Color', 'ahura' ),
    ))
);

$this->customizer->add_setting('ahura_shop_page_description_color', ['default' => '#000']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_shop_page_description_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_shop_page_description_color',
        'label' => __( 'Shop description color', 'ahura' ),
    ))
);

$this->customizer->add_setting('ahura_product_cover_hover_color', ['default' => '#00b0ff']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_product_cover_hover_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_product_cover_hover_color',
        'label' => __( 'Product cover color', 'ahura' ),
    ))
);

$this->customizer->add_setting('ahura_shop_add_to_cart_btn_color', ['default' => '#fff']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_shop_add_to_cart_btn_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_shop_add_to_cart_btn_color',
        'label' => __( 'Shop Add to cart button color', 'ahura' ),
    ))
);

$this->customizer->add_setting('ahura_shop_add_to_cart_btn_bg', ['default' => '#00b0ff']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_shop_add_to_cart_btn_bg',array(
        'section' => $this->current_section,
        'setting' => 'ahura_shop_add_to_cart_btn_bg',
        'label' => __( 'Shop Add to cart button background color', 'ahura' ),
    ))
);

$this->customizer->add_setting('ahura_shop_add_to_cart_btn_border_color', ['default' => '#00b0ff']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_shop_add_to_cart_btn_border_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_shop_add_to_cart_btn_border_color',
        'label' => __( 'Shop Add to cart button border color', 'ahura' ),
        'active_callback' => function(){
            return \ahura\app\mw_options::get_product_item_style() == 3;
        },
    ))
);

$this->customizer->add_setting('ahura_shop_style3_star_color');
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_shop_style3_star_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_shop_style3_star_color',
        'label' => __( 'Shop star color', 'ahura' ),
        'active_callback' => function(){
            return \ahura\app\mw_options::get_product_item_style() == 3;
        },
    ))
);

$this->customizer->add_setting('ahura_product_regular_price_color',['default' => '#66BB6A']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_product_regular_price_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_product_regular_price_color',
        'label' => __( 'Product regular price color', 'ahura' ),
    ))
);


$this->customizer->add_setting('ahura_product_sale_price_color',['default' => '#66BB6A']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_product_sale_price_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_product_sale_price_color',
        'label' => __( 'Product sale price color', 'ahura' ),
    ))
);

$this->customizer->add_setting('ahura_onsale_date_color',['default' => '#dd3333']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_onsale_date_color',[
        'section' => $this->current_section,
        'setting' => 'ahura_onsale_date_color',
        'label' => __( 'Onsale date price color', 'ahura' ),
    ])
);

$this->customizer->add_setting('ahura_onsale_label_color',['default' => '#ffffff']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_onsale_label_color',[
        'section' => $this->current_section,
        'setting' => 'ahura_onsale_label_color',
        'label' => __( 'Onsale label color', 'ahura' ),
    ])
);

$this->customizer->add_setting('ahura_onsale_label_backcolor',['default' => '#dd3333']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_onsale_label_backcolor',[
        'section' => $this->current_section,
        'setting' => 'ahura_onsale_label_backcolor',
        'label' => __( 'Onsale label back color', 'ahura' ),
    ])
);

$this->customizer->add_setting('ahura_shop_term_description_background', ['default' => '#EFEFEF']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_shop_term_description_background',[
        'section' => $this->current_section,
        'setting' => 'ahura_shop_term_description_background',
        'label' => __( 'Archive description background color', 'ahura' ),
        'active_callback' => function(){
            return \ahura\app\mw_options::get_product_item_style() == 3;
        },
    ])
);

$this->customizer->add_setting('ahura_shop_per_page',['default' => '9']);
$this->customizer->add_control(
    new simple_text($this->customizer,'ahura_shop_per_page',array(
        'section' => $this->current_section,
        'type' => 'number',
        'label' => __( 'Shop product per page', 'ahura' ),
    ))
);

$this->customizer->add_setting('ahura_shop_product_title_words_number');
$this->customizer->add_control( new simple_text($this->customizer,'ahura_shop_product_title_words_number', [
    'label'   => __('Maximum number of title words', 'ahura' ),
    'type'    => 'number',
    'section' => $this->current_section,
]));

$this->customizer->add_setting('ahura_shop_style3_title_height');
$this->customizer->add_control(new simple_text($this->customizer,'ahura_shop_style3_title_height',array(
        'section' => $this->current_section,
        'type' => 'number',
        'input_attrs' => [
            'min' => 10,
            'max' => 1000
        ],
        'label' => __( 'Product title height', 'ahura' ),
    ))
);

$this->customizer->add_setting('ahura_shop_style3_price_wrapper_height');
$this->customizer->add_control(new simple_text($this->customizer,'ahura_shop_style3_price_wrapper_height',array(
        'section' => $this->current_section,
        'type' => 'number',
        'input_attrs' => [
            'min' => 10,
            'max' => 1000
        ],
        'label' => __( 'Product price wrapper height', 'ahura' ),
        'active_callback' => function(){
            return \ahura\app\mw_options::get_product_item_style() == 3;
        },
    ))
);

$this->customizer->add_setting( 'ahura_product_desktop_column', ['default' => '3'] );
$this->customizer->add_control( 'ahura_product_desktop_column', [
    'type' => 'select',
    'section' => $this->current_section,
    'label' => __( 'Product shop desktop column', 'ahura' ),
    'choices' => [
        '2' => __( '2', 'ahura' ),
        '3' => __( '3', 'ahura' ),
        '4' => __( '4', 'ahura' ),
        '6' => __( '6', 'ahura' ),
    ],
] );

$this->customizer->add_setting( 'ahura_product_mobile_column', ['default' => '1'] );
$this->customizer->add_control( 'ahura_product_mobile_column', [
    'type' => 'select',
    'section' => $this->current_section,
    'label' => __( 'Product shop mobile column', 'ahura' ),
    'choices' => [
        '1' => __( '1', 'ahura' ),
        '2' => __( '2', 'ahura' ),
        '3' => __( '3', 'ahura' ),
    ],
] );

$this->customizer->add_setting('ahura_shop_style3_best_sale_slider', ['default' => true]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_style3_best_sale_slider',array(
    'label' => __( 'Show best sale slider', 'ahura' ),
    'section' => $this->current_section,
    'active_callback' => function(){
        return \ahura\app\mw_options::get_product_item_style() == 3;
    },
)));

$this->customizer->add_setting( 'ahura_best_sale_product_column', ['default' => '5'] );
$this->customizer->add_control( 'ahura_best_sale_product_column', [
    'type'    => 'select',
    'section' => $this->current_section,
    'label'   => __( 'Best sale products column', 'ahura' ),
    'choices' => [
        '2' => __( '2', 'ahura' ),
        '3' => __( '3', 'ahura' ),
        '4' => __( '4', 'ahura' ),
        '5' => __( '5', 'ahura' ),
    ],
    'active_callback' => function(){
        return \ahura\app\mw_options::get_product_item_style() == 3 && \ahura\app\mw_options::get_mod_is_active_style3_best_sale_slider();
    },
] );

$this->customizer->add_setting( 'ahura_best_sale_product_column_mobile', ['default' => '1'] );
$this->customizer->add_control( 'ahura_best_sale_product_column_mobile', [
    'type'    => 'select',
    'section' => $this->current_section,
    'label'   => __( 'Best sale products column in mobile', 'ahura' ),
    'choices' => [
        '1' => __( '1', 'ahura' ),
        '2' => __( '2', 'ahura' ),
        '3' => __( '3', 'ahura' ),
    ],
    'active_callback' => function(){
        return \ahura\app\mw_options::get_product_item_style() == 3 && \ahura\app\mw_options::get_mod_is_active_style3_best_sale_slider();
    },
] );

$this->customizer->add_setting('ahura_best_sale_product_title', ['default' => esc_html__('Best Sale products', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'ahura_best_sale_product_title',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Best sale slider title text', 'ahura' ),
    'active_callback' => function(){
        return \ahura\app\mw_options::get_product_item_style() == 3 && \ahura\app\mw_options::get_mod_is_active_style3_best_sale_slider();
    },
)));

$this->customizer->add_setting('ahura_best_sale_product_title_margin',['default' => '15']);
$this->customizer->add_control(new simple_text($this->customizer,'ahura_best_sale_product_title_margin',array(
    'section' => $this->current_section,
    'type' => 'number',
    'label' => __( 'Best sale product title margin bottom', 'ahura' ),
    'active_callback' => function(){
        return \ahura\app\mw_options::get_product_item_style() == 3 && \ahura\app\mw_options::get_mod_is_active_style3_best_sale_slider();
    },
)));

$this->customizer->add_setting('ahura_best_sale_product_margin_top',['default' => '100']);
$this->customizer->add_control(new simple_text($this->customizer,'ahura_best_sale_product_margin_top',array(
    'section' => $this->current_section,
    'type' => 'number',
    'label' => __( 'Best sale product margin top', 'ahura' ),
    'active_callback' => function(){
        return \ahura\app\mw_options::get_product_item_style() == 3 && \ahura\app\mw_options::get_mod_is_active_style3_best_sale_slider();
    },
)));

$this->customizer->add_setting('ahura_best_sale_product_margin_top_mobile',['default' => '100']);
$this->customizer->add_control(new simple_text($this->customizer,'ahura_best_sale_product_margin_top_mobile',array(
    'section' => $this->current_section,
    'type' => 'number',
    'label' => __( 'Best sale product margin top in mobile', 'ahura' ),
    'active_callback' => function(){
        return \ahura\app\mw_options::get_product_item_style() == 3 && \ahura\app\mw_options::get_mod_is_active_style3_best_sale_slider();
    },
)));

$this->customizer->add_setting('ahura_best_sale_product_margin_bottom',['default' => '50']);
$this->customizer->add_control(new simple_text($this->customizer,'ahura_best_sale_product_margin_bottom',array(
    'section' => $this->current_section,
    'type' => 'number',
    'label' => __( 'Best sale product margin bottom', 'ahura' ),
    'active_callback' => function(){
        return \ahura\app\mw_options::get_product_item_style() == 3 && \ahura\app\mw_options::get_mod_is_active_style3_best_sale_slider();
    },
)));

$this->customizer->add_setting('ahura_best_sale_product_margin_bottom_mobile',['default' => '50']);
$this->customizer->add_control(new simple_text($this->customizer,'ahura_best_sale_product_margin_bottom_mobile',array(
    'section' => $this->current_section,
    'type' => 'number',
    'label' => __( 'Best sale product margin bottom in mobile', 'ahura' ),
    'active_callback' => function(){
        return \ahura\app\mw_options::get_product_item_style() == 3 && \ahura\app\mw_options::get_mod_is_active_style3_best_sale_slider();
    },
)));

$this->customizer->add_setting('ahura_best_sale_product_title_height');
$this->customizer->add_control(new simple_text($this->customizer,'ahura_best_sale_product_title_height',array(
    'section' => $this->current_section,
    'type' => 'number',
    'label' => __( 'Best sale product title height', 'ahura' ),
    'active_callback' => function(){
        return \ahura\app\mw_options::get_product_item_style() == 3 && \ahura\app\mw_options::get_mod_is_active_style3_best_sale_slider();
    },
)));

$this->customizer->add_setting('ahura_shop_change_subcategories_mode',['default' => true]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_change_subcategories_mode',array(
    'label' => __( 'Change Sub Categories Display Mode', 'ahura' ),
    'section' => $this->current_section,
)));

$this->customizer->add_setting('ahura_shop_show_product_quick_view',['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_product_quick_view',array(
    'label' => __( 'Product quick view feature', 'ahura' ),
    'section' => $this->current_section,
)));

$this->customizer->add_setting( 'ahura_quick_view_gallery_images_size', ['default' => 'full'] );
$this->customizer->add_control( 'ahura_quick_view_gallery_images_size', [
    'type'    => 'select',
    'section' => $this->current_section,
    'label'   => __( 'Product quick view gallery images size', 'ahura' ),
    'choices' => [
        'full' => __( 'Full', 'ahura' ),
        'large' => __( 'Large', 'ahura' ),
        'medium' => __( 'Medium', 'ahura' ),
        'thumbnail' => __( 'Thumb-nail', 'ahura' ),
    ],
    'active_callback' => function(){
        return \ahura\app\mw_options::get_mod_show_product_quick_view();
    },
] );

$this->customizer->add_setting('ahura_shop_hide_price_on_outofstock_products',['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_hide_price_on_outofstock_products',array(
    'label' => __( 'Hide price on out of stock products', 'ahura' ),
    'section' => $this->current_section,
)));

$this->customizer->add_setting('ahura_shop_move_out_of_stock_products_to_end',['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_move_out_of_stock_products_to_end',array(
    'label' => __( 'Move out of stock products to end', 'ahura' ),
    'section' => $this->current_section,
    'description' => __('It is not recommended for websites that use affiliate/external products.', 'ahura')
)));

$this->customizer->add_setting('ahura_shop_show_peoduct_tags',['default' => true]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_peoduct_tags',array(
    'label' => __( 'Show product tags', 'ahura' ),
    'section' => $this->current_section,
)));

$this->customizer->add_setting('ahura_active_woocommerce_element_mini_cart', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_active_woocommerce_element_mini_cart',[
    'label'   => __( 'Active woocommerce element mini cart', 'ahura' ),
    'description' => __('Changing the content of elementor mini card element to wooCommerce main format', 'ahura'),
    'section' => $this->current_section,
]));

$this->customizer->add_setting('ahura_shop_show_boxcover', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_boxcover',[
    'section' => $this->current_section,
    'label'   => __( 'Hide products box cover', 'ahura' ),
    'active_callback' => function(){
        return \ahura\app\mw_options::get_product_item_style() == 1;
    },
]));

$this->customizer->add_setting('ahura_shop_show_boxshadow', ['default' => true]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_boxshadow',[
    'section' => $this->current_section,
    'label'   => __( 'Show product box shadow', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_isnot_active_show_boxcover_status'],
]));

$this->customizer->add_setting('ahura_shop_show_addtocartbtn_onproduct', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_addtocartbtn_onproduct',[
    'section' => $this->current_section,
    'label'   => __( 'Hide product box add to cart button', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_isnot_active_show_boxcover_status'],
]));

$this->customizer->add_setting('shop_products_change_add_to_cart_button_text_status', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'shop_products_change_add_to_cart_button_text_status',[
    'section' => $this->current_section,
    'label'   => __( 'Change add to cart button text', 'ahura' ),
]));

$this->customizer->add_setting('shop_products_add_to_cart_button_text', ['default' => esc_html__('Add to Cart', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer,'shop_products_add_to_cart_button_text',array(
    'section' => $this->current_section,
    'type' => 'text',
    'label' => __('Add to cart button text', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_change_products_add_to_cart_button_text_status'],
)));

$this->customizer->add_setting('ahura_shop_show_cat_onproduct', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_cat_onproduct',[
    'section' => $this->current_section,
    'label'   => __( 'Hide product box category', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_isnot_active_show_boxcover_status'],
]));

$this->customizer->add_setting('ahura_shop_show_product_onsale_percent',['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_product_onsale_percent',array(
    'section' => $this->current_section,
    'label' => __( 'Show product onsale percent', 'ahura' ),
)));

$this->customizer->add_setting('woocommerce_sale_text');
$this->customizer->add_control(new simple_text($this->customizer, 'woocommerce_sale_text', [
    'label' => __('Special sales text', 'ahura'),
    'section' => $this->current_section,
]));

$this->customizer->add_setting('ahura_shop_save_product_initial_stock',['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_save_product_initial_stock',array(
    'section' => $this->current_section,
    'label' => __( 'Save/Remove product stock as initial stock', 'ahura' ),
)));

$this->customizer->add_setting('ahura_shop_show_product_stock_status',['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_product_stock_status',array(
    'section' => $this->current_section,
    'label' => __( 'Show product stock status in shop', 'ahura' ),
)));
$this->customizer->add_setting('ahura_shop_show_product_stock_status_background',['default' => '#EE384E']);
$this->customizer->add_control(new WP_Customize_Color_Control($this->customizer,'ahura_shop_show_product_stock_status_background',array(
    'section' => $this->current_section,
    'setting' => 'ahura_shop_show_product_stock_status_background',
    'label' => __( 'Product stock status background in shop', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_is_active_show_product_stock_status'],
)));
$this->customizer->add_setting('ahura_shop_show_product_stock_status_color',['default' => '#fff']);
$this->customizer->add_control(new WP_Customize_Color_Control($this->customizer,'ahura_shop_show_product_stock_status_color',array(
    'section' => $this->current_section,
    'setting' => 'ahura_shop_show_product_stock_status_color',
    'label' => __( 'Product stock status color in shop', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_is_active_show_product_stock_status'],
)));
$this->customizer->add_setting('ahura_shop_product_stock_count_background');
$this->customizer->add_control(new WP_Customize_Color_Control($this->customizer,'ahura_shop_product_stock_count_background',array(
    'section' => $this->current_section,
    'setting' => 'ahura_shop_product_stock_count_background',
    'label' => __( 'Product stock count background', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_is_active_show_product_stock_status'],
)));
$this->customizer->add_setting('ahura_shop_product_stock_count_color',['default' => '#EE384E']);
$this->customizer->add_control(new WP_Customize_Color_Control($this->customizer,'ahura_shop_product_stock_count_color',array(
    'section' => $this->current_section,
    'setting' => 'ahura_shop_product_stock_count_color',
    'label' => __( 'Product stock count color', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_is_active_show_product_stock_status'],
)));
$this->customizer->add_setting('ahura_shop_show_product_stock_status_fontsize',['default' => '12']);
$this->customizer->add_control(new simple_text($this->customizer,'ahura_shop_show_product_stock_status_fontsize',array(
    'section' => $this->current_section,
    'type' => 'number',
    'label' => __( 'Product stock status font size in shop', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_is_active_show_product_stock_status'],
    'description' =>  __('Default 12px','ahura'),
)));

$this->customizer->add_setting('ahura_shop_alert_background',['default'=>'#a46497']);
$this->customizer->add_control(new WP_Customize_Color_Control($this->customizer,'ahura_shop_alert_background',array(
    'section' => 'woocommerce_store_notice',
    'label' => __( 'Background Color', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_is_active_shop_alert_settings'],
)));
$this->customizer->add_setting('ahura_shop_alert_color',['default'=>'#fff']);
$this->customizer->add_control(new WP_Customize_Color_Control($this->customizer,'ahura_shop_alert_color',array(
    'section' => 'woocommerce_store_notice',
    'label' => __( 'Color', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_is_active_shop_alert_settings'],
)));
$this->customizer->add_setting('ahura_shop_alert_fontsize',['default' => '16']);
$this->customizer->add_control(new simple_text($this->customizer,'ahura_shop_alert_fontsize',array(
    'section' => 'woocommerce_store_notice',
    'type' => 'number',
    'label' => __( 'Font size', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_is_active_shop_alert_settings'],
)));
$this->customizer->add_setting('show_woocommerce_breadcrumb');
$this->customizer->add_control(new ios_checkbox($this->customizer, 'show_woocommerce_breadcrumb', [
    'label' => __('Show Breadcrumb', 'ahura'),
    'section' => $this->current_section
]));
$this->customizer->add_setting('show_product_cat_des_to_all_pages', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'show_product_cat_des_to_all_pages', [
    'label' => __('Show product category description to all pages', 'ahura'),
    'section' => $this->current_section,
]));
$this->customizer->add_setting('move_product_catdescription');
$this->customizer->add_control(new ios_checkbox($this->customizer, 'move_product_catdescription', [
    'label' => __('Move product category description to the end', 'ahura'),
    'section' => $this->current_section
]));
$this->customizer->add_setting('move_buy_button', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'move_buy_button', [
    'label' => __('Move buy button to the end', 'ahura'),
    'section' => $this->current_section,
    'active_callback' => function(){
        return \ahura\app\mw_options::get_product_item_style() == 1;
    },
]));
$this->customizer->add_setting('shop_show_filters_button_toggle', ['default' => true]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'shop_show_filters_button_toggle', [
    'label' => __('Show Filters Button Toggle in Sidebar', 'ahura'),
    'section' => $this->current_section,
    'description' => __('For toggle the sidebar in mobile','ahura'),
]));
$this->customizer->add_setting('filters_button_toggle_text', ['default' => esc_html__('Products filter', 'ahura')]);
$this->customizer->add_control(new simple_text($this->customizer, 'filters_button_toggle_text', [
    'label' => __('Filters Button Toggle Text', 'ahura'),
    'section' => $this->current_section,
    'active_callback' => ['\ahura\app\mw_options','get_mod_shop_show_filters_button_toggle'],
]));

$this->customizer->add_setting('ahura_shop_filters_toggle_button_color', ['default' => '#181522']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_shop_filters_toggle_button_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_shop_filters_toggle_button_color',
        'label' => __( 'Filters button color', 'ahura' ),
        'active_callback' => ['\ahura\app\mw_options','get_mod_shop_show_filters_button_toggle'],
    ))
);

$this->customizer->add_setting('ahura_shop_filters_toggle_button_bg_color', ['default' => '#fed700']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_shop_filters_toggle_button_bg_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_shop_filters_toggle_button_bg_color',
        'label' => __( 'Filters button background color', 'ahura' ),
        'active_callback' => ['\ahura\app\mw_options','get_mod_shop_show_filters_button_toggle'],
    ))
);

$this->customizer->add_setting('ahura_shop_grid_status', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_grid_status',[
    'section' => $this->current_section,
    'label'   => __( 'Display mode of shop products', 'ahura' ),
    'description' => __('The ability to change the product grid by the user on the shop.', 'ahura')
]));

$this->customizer->add_setting('ahura_shop_orderby_status', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_orderby_status',[
    'section' => $this->current_section,
    'label'   => __( 'Customize shop orderby fields', 'ahura' ),
]));

$this->customizer->add_setting( 'ahura_shop_orderby_color', [ 'default' => '#555555' ] );
$this->customizer->add_control( new WP_Customize_Color_Control( $this->customizer,'ahura_shop_orderby_color',[
    'section'         => $this->current_section,
    'setting'         => 'ahura_shop_orderby_color',
    'label'           => __( 'Orderby items color', 'ahura' ),
    'active_callback' => [ '\ahura\app\mw_options','get_mod_ahura_shop_orderby_status' ],
] ) );

$this->customizer->add_setting( 'ahura_shop_orderby_backcolor', [ 'default' => '#f5f5f5' ] );
$this->customizer->add_control( new WP_Customize_Color_Control( $this->customizer,'ahura_shop_orderby_backcolor',[
    'section'         => $this->current_section,
    'setting'         => 'ahura_shop_orderby_backcolor',
    'label'           => __( 'Orderby items background color', 'ahura' ),
    'active_callback' => [ '\ahura\app\mw_options','get_mod_ahura_shop_orderby_status' ],
] ) );

$this->customizer->add_setting('ahura_shop_orderby_default_status', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_orderby_default_status',[
    'section' => $this->current_section,
    'label'   => __( 'Disable default field', 'ahura' ),
    'active_callback' => [ '\ahura\app\mw_options','get_mod_ahura_shop_orderby_status' ],
]));

$this->customizer->add_setting('ahura_shop_orderby_popularity_status', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_orderby_popularity_status',[
    'section' => $this->current_section,
    'label'   => __( 'Disable popularity field', 'ahura' ),
    'active_callback' => [ '\ahura\app\mw_options','get_mod_ahura_shop_orderby_status' ],
]));

$this->customizer->add_setting('ahura_shop_orderby_rating_status', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_orderby_rating_status',[
    'section' => $this->current_section,
    'label'   => __( 'Disable rating field', 'ahura' ),
    'active_callback' => [ '\ahura\app\mw_options','get_mod_ahura_shop_orderby_status' ],
]));

$this->customizer->add_setting('ahura_shop_orderby_price_status', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_orderby_price_status',[
    'section' => $this->current_section,
    'label'   => __( 'Disable price field', 'ahura' ),
    'active_callback' => [ '\ahura\app\mw_options','get_mod_ahura_shop_orderby_status' ],
]));

$this->customizer->add_setting('ahura_shop_orderby_pricedesc_status', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_orderby_pricedesc_status',[
    'section' => $this->current_section,
    'label'   => __( 'Disable price-desc field', 'ahura' ),
    'active_callback' => [ '\ahura\app\mw_options','get_mod_ahura_shop_orderby_status' ],
]));

$this->customizer->add_setting('ahura_shop_pagination_color', ['default' => '#333']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_shop_pagination_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_shop_pagination_color',
        'label' => __( 'Pagination Color', 'ahura' ),
    ))
);


$this->customizer->add_setting('ahura_shop_pagination_bg_color', ['default' => '#fff']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_shop_pagination_bg_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_shop_pagination_bg_color',
        'label' => __( 'Pagination Background Color', 'ahura' ),
    ))
);

$this->customizer->add_setting('ahura_shop_active_pagination_color', ['default' => '#fff']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_shop_active_pagination_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_shop_active_pagination_color',
        'label' => __( 'Pagination Active Color', 'ahura' ),
    ))
);


$this->customizer->add_setting('ahura_shop_active_pagination_bg_color', ['default' => '#0072ff']);
$this->customizer->add_control(
    new WP_Customize_Color_Control($this->customizer,'ahura_shop_active_pagination_bg_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_shop_active_pagination_bg_color',
        'label' => __( 'Pagination Active Background Color', 'ahura' ),
    ))
);

$this->customizer->add_setting('ahura_shop_show_archive_sale_countdown_counter', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_archive_sale_countdown_counter',[
    'section' => $this->current_section,
    'label'   => __( 'Show countdown counter timer on sale product with date', 'ahura' ),
]));

$this->customizer->add_setting('ahura_shop_archive_sale_counter_top_padding', ['default' => 0]);
$this->customizer->add_control(new simple_text($this->customizer,'ahura_shop_archive_sale_counter_top_padding',array(
    'section' => $this->current_section,
    'type' => 'number',
    'label' => __( 'Padding from top', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_is_active_archive_sale_countdown_counter'],
)));

$this->customizer->add_setting('ahura_shop_archive_sale_counter_background_color');
$this->customizer->add_control(new WP_Customize_Color_Control($this->customizer,'ahura_shop_archive_sale_counter_background_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_shop_archive_sale_counter_background_color',
        'label' => __( 'Background Color', 'ahura' ),
        'active_callback' => ['\ahura\app\mw_options','get_mod_is_active_archive_sale_countdown_counter'],
    ))
);

$this->customizer->add_setting('ahura_shop_archive_sale_counter_color');
$this->customizer->add_control(new WP_Customize_Color_Control($this->customizer,'ahura_shop_archive_sale_counter_color',array(
        'section' => $this->current_section,
        'setting' => 'ahura_shop_archive_sale_counter_color',
        'label' => __( 'Color', 'ahura' ),
        'active_callback' => ['\ahura\app\mw_options','get_mod_is_active_archive_sale_countdown_counter'],
    ))
);

$this->customizer->add_setting('ahura_shop_archive_sale_counter_font_size');
$this->customizer->add_control(new simple_text($this->customizer,'ahura_shop_archive_sale_counter_font_size',array(
    'section' => $this->current_section,
    'type' => 'number',
    'label' => __( 'Font size', 'ahura' ),
    'active_callback' => ['\ahura\app\mw_options','get_mod_is_active_archive_sale_countdown_counter'],
)));

$this->customizer->add_setting('ahura_shop_show_custom_box_before_loop_start', ['default' => false]);
$this->customizer->add_control(new ios_checkbox($this->customizer, 'ahura_shop_show_custom_box_before_loop_start',[
    'section' => $this->current_section,
    'label'   => __( 'Show custom Elementor section before archive loop start', 'ahura' ),
]));

$sections = [];
$section_list = null;
if (\ahura\app\mw_options::is_ahura_builder_accessible()){
    $sectionBuilder = new \ahura\app\elementor\Ahura_Elementor_Builder();
    $section_list = $sectionBuilder->getTemplates(['section_builder', 'elementor_library']);
}
if($section_list){
    foreach($section_list as $section) {
        $sections[$section->ID] = $section->post_title;
    }
} else {
    $sections[1] = esc_html__('Nothing found', 'ahura');
}
$this->customizer->add_setting('ahura_shop_archive_custom_box');
$this->customizer->add_control(new simple_select_box($this->customizer, 'ahura_shop_archive_custom_box', [
    'section' => $this->current_section,
    'label' => __('Custom section', 'ahura'),
    'choices' => $sections,
    'active_callback' => ['\ahura\app\mw_options','get_mode_custom_box_before_loop_start'],
]));