<?php
$is_custom_header = \ahura\app\mw_options::get_mod_is_active_custom_header();
$header_id = \ahura\app\mw_options::get_custom_header_id();
$data_theme = ahura_get_current_theme_mode();
$ahura_selected_custom_header_on_page = \ahura\app\mw_options::get_page_custom_header_template(get_the_ID());
$html_class = $data_theme;
?>
<!DOCTYPE html>
<html data-theme="<?php echo $data_theme ?>" <?php language_attributes(); ?> class="<?php echo $html_class ?> no-js">
    <head>
        <meta charset="UTF-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <?php
        \ahura\app\mw_options::theme_viewport_meta_html();
        wp_head();
        ?>
    </head>
<body <?php body_class() ?>>
<?php wp_body_open(); ?>
<?php
if ($ahura_selected_custom_header_on_page && \ahura\app\mw_options::is_ahura_builder_accessible()) :?>
<div id="ahura-header-main-wrap">
    <header id="topbar" class="<?php echo ahura_get_header_wrap_classes(['in_custom_header', 'header-mode-1', 'header-mode-2', 'header-mode-3']) ?>">
        <?php echo ahura_render_elementor_builder_content($ahura_selected_custom_header_on_page); ?>
    </header>
</div>
<?php
elseif($is_custom_header && !empty($header_id) && \ahura\app\mw_options::is_ahura_builder_accessible()) :?>
    <div id="ahura-header-main-wrap">
        <header id="topbar" class="<?php echo ahura_get_header_wrap_classes(['in_custom_header', 'header-mode-1', 'header-mode-2', 'header-mode-3']) ?>">
        <?php
            echo ahura_render_elementor_builder_content($header_id);
        ?>
        </header>
    </div><?php
else:
    (new \ahura\app\Header())->render_template();
endif;
