<?php
namespace ahura\app;

use ahura\app\mw_assets;
class woocommerce
{
    static function is_active()
    {
        return class_exists('WooCommerce');
    }
    static function is_woocommerce()
    {
        return self::is_active() && is_woocommerce();
    }

    public static function is_account_page()
    {
        return self::is_active() && function_exists('is_account_page') && is_account_page();
    }

    static function is_product()
    {
        return self::is_active() && is_product();
    }

    static function is_shop()
    {
        return self::is_active() && is_shop();
    }
    static function is_woocommerce_page()
    {
        return self::is_active() && (is_woocommerce() || is_cart() || is_checkout() || is_account_page());
    }
    
    public static function is_archive(){
        return woocommerce::is_woocommerce() && (is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy());
    }
    
    static function before_shop_loop_item()
    {
        $product_style = mw_options::get_product_item_style();
        if(empty($product_style) || $product_style == 1){
            $terms = wp_get_post_terms(get_the_ID(), 'product_cat', ['fields' => 'names', 'number' => 5]);
            $term_data = '<span class="mw_term_data">';
            foreach ($terms as $term_name) {
                $term_data .= '<span class="mw_term_item">'.$term_name.'</span>';
            }
            $term_data .= '</span>';
            echo '<span class="mw_overly"></span>';
            echo $term_data;
        }
    }
    static function show_product_stock_status()
    {
        global $product;
        echo get_theme_mod('ahura_shop_show_product_stock_status') ? wc_get_stock_html( $product ) : '';
    }
    static function loop_shop_columns()
    {
        return 3;
    }

    /**
     * Handle: mw_woocommerce
     *
     * @return void
     */
    public static function enqueue_woocommerce_js(){
        $version = \ahura\app\mw_tools::get_theme_version();
        $woocommerce_js = get_template_directory_uri() . '/js/woocommerce.js';
        wp_enqueue_script('mw_woocommerce', $woocommerce_js, ['jquery'], $version, true);
        wp_localize_script('mw_woocommerce', 'mw_woo_data', mw_assets::get_localize_data());
    }

    static function load_assets()
    {
        $version = \ahura\app\mw_tools::get_theme_version();

        if(self::is_active()){
            // woocommerce.css
            wp_enqueue_style('mw_woocommerce', get_template_directory_uri() . '/css/woocommerce.css', null, $version);

            if(!is_rtl()){
                wp_enqueue_style('mw_woocommerce_ltr', get_template_directory_uri() . '/css/woocommerce_ltr.css', null, $version);
            }

            mw_assets::enqueue_script('woocommerce_variations', mw_assets::get_js('woocommerce_variations'));

            self::enqueue_woocommerce_js();

            if(self::is_woocommerce_page() || is_shop())
            {
                if(is_cart() || is_checkout())
                {
                    $btn_style = '.woocommerce .button.alt{ background-color: var(--mw_primary_color); color: #222; }';
                    wp_add_inline_style('style', $btn_style);
                }
            }
        }
    }
    static function woocommerce_cart_item_thumbnail($thumbnail, $cart_item, $cart_item_key){
        $cart_image_id = $cart_item['data']->get_image_id();
        $image = wp_get_attachment_image($cart_image_id, 'thumbnail');
        return $image;
    }
    static function related_products_args($args)
    {
        $args['posts_per_page'] = 3;
        $args['columns'] = 3;
        return $args;
    }
    static function change_shop_item_count_per_page( $cols ) {
        // $cols contains the current number of products per page based on the value stored on Options –> Reading
        // Return the number of products you wanna show per page.
        $cols = get_theme_mod('ahura_shop_per_page', 9);
        return $cols;
    }
    static function change_sale_text($text){
        $text = get_theme_mod('woocommerce_sale_text') ? get_theme_mod('woocommerce_sale_text') : __('Sale!','woocommerce');
        $product_discount_percent = get_theme_mod('ahura_shop_show_product_onsale_percent') ? sprintf('%%%d', ahura_get_product_discount_percent()) . ' ' : '';
        $text = '<span class="onsale">' . sprintf('%s %s', $product_discount_percent, $text) . '</span>';
        return $text;
    }

    public static function add_to_cart_button_with_quantity($params = []){
        global $product;
        if(isset($params['product']) && is_object($params['product'])){
            $product = $params['product'];
        }
        if(is_object($product)){
            echo '<form action="' . esc_url($product->add_to_cart_url()) . '" class="d-flex align-center cart product-quantity-form crousel_addtobtn '. (isset($params['class']) ? $params['class'] : '') .'" method="post" enctype="multipart/form-data">';

            if(!isset($params['with_qty']) || isset($params['with_qty']) && $params['with_qty'] === true){
                echo woocommerce_quantity_input(['min_value' => 1, 'max_value' => (!$product->backorders_allowed() ? $product->get_stock_quantity() : '')]);
            }

            $btn_text = __('Add to Cart', 'ahura');
            if(isset($params['button_text'])){
                $btn_text = $params['button_text'];
            }

            $btn_icon = '';
            if(isset($params['has_button_icon']) && $params['has_button_icon'] === true){
                $btn_icon = '<i class="fa fa-shopping-cart"></i>';
                if(isset($params['button_icon'])){
                    $btn_icon = $params['button_icon'];
                }
            }

            echo '<button type="submit" class="button alt">'. $btn_icon . ' ' . $btn_text .'</button>';
            echo '</form>';
        }
    }

    public static function added_inquiry_text_for_without_products($price, $product){
        global $post;
        if(!empty($post) && '' === $product->get_price()) {
            $text = \ahura\app\mw_options::get_mod_text_call_for_price_inquery();
            $text = !empty($text) ? $text : esc_html__('Call for price inquiry', 'ahura');
            $btn_text = \ahura\app\mw_options::get_mod_call_for_price_inquery_button_text();
            $btn_url = \ahura\app\mw_options::get_mod_call_for_price_inquery_button_url();
            $output = "<div class='price_on_inquiry'><span>{$text}</span>";
            if(!empty($btn_url) && is_single()){
                $output .= "<a href='{$btn_url}' class='button'>{$btn_text}</a>";
            }
            $output .= "</div>";
            return $output;
        }
    
        return $price;
    }

    public static function change_single_product_add_to_cart_button_text(){
        $status = \ahura\app\mw_options::get_mod_change_add_to_cart_button_text_status();
        $text = \ahura\app\mw_options::get_mod_add_to_cart_button_text();
        if($status && !empty($text)){
            return $text;
        }
        return __('Add to Cart', 'ahura'); 
    }

    public static function before_shop_add_to_cart_button($product){
        $is_pages = is_woocommerce() && !is_single();
        if (!$is_pages || \ahura\app\mw_options::get_product_item_style() != 2)
            return false;

        self::render_product_colors($product);
    }

    public static function render_product_colors($product, $limit = false)
    {
        $colors = get_the_terms($product->get_id(), 'pa_color');
        if (!empty($colors) && !is_wp_error($colors)){
            ?>
            <div class="product-colors">
                <?php if ($limit && count($colors) > $limit): ?>
                    <span class="has-more">+</span>
                <?php endif; ?>
                <?php $i = 0;
                foreach ($colors as $color):
                    $i++;
                    $term_id = is_object($color) ? $color->term_id : (isset($color['term_id']) ? $color['term_id'] : null);
                    if (!$term_id) continue;

                    $data = get_term_meta($term_id);
                    $color_code = isset($data['_product_attribute_color'][0]) && !empty($data['_product_attribute_color'][0]) ? $data['_product_attribute_color'][0] : null;

                    if (!$color_code) continue;
                    ?>
                    <span class="product-color-item" title="<?php echo isset($color->name) ? $color->name : '' ?>" style="background-color:<?php echo $color_code ?>"></span>
                <?php
                    if ($limit && $i >= $limit)
                        break;
                endforeach;
                ?>
            </div>
        <?php }
    }

    public static function handle_add_quick_view_button_before_shop_add_to_cart($product)
    {
        ?>
        <a href="#" class="product-preview-btn" data-id="<?php echo $product->get_id() ?>" title="<?php _e('Quick View', 'ahura') ?>">
            <?php
            if(\ahura\app\mw_options::get_product_item_style() != 4) {
                echo apply_filters('ahura_product_quick_view_button_text', '<i class="fas fa-eye"></i>');
            } else {
                echo apply_filters('ahura_product_quick_view_button_text', '<svg xmlns="http://www.w3.org/2000/svg" width="1.2em" height="1.2em" viewBox="0 0 256 256"><path fill="currentColor" d="M245.48 125.57c-.34-.78-8.66-19.23-27.24-37.81C201 70.54 171.38 50 128 50S55 70.54 37.76 87.76c-18.58 18.58-26.9 37-27.24 37.81a6 6 0 0 0 0 4.88c.34.77 8.66 19.22 27.24 37.8C55 185.47 84.62 206 128 206s73-20.53 90.24-37.75c18.58-18.58 26.9-37 27.24-37.8a6 6 0 0 0 0-4.88M128 194c-31.38 0-58.78-11.42-81.45-33.93A134.8 134.8 0 0 1 22.69 128a134.6 134.6 0 0 1 23.86-32.06C69.22 73.42 96.62 62 128 62s58.78 11.42 81.45 33.94A134.6 134.6 0 0 1 233.31 128C226.94 140.21 195 194 128 194m0-112a46 46 0 1 0 46 46a46.06 46.06 0 0 0-46-46m0 80a34 34 0 1 1 34-34a34 34 0 0 1-34 34"/></svg>');
            }
            ?>
        </a>
    <?php
    }

    public static function handle_move_out_of_stock_products_to_end($posts_clauses, $wp_query)
    {
        global $wpdb;
        if (!is_admin() && self::is_archive()) {
            $posts_clauses['join'] .= " INNER JOIN $wpdb->postmeta istockstatus ON ($wpdb->posts.ID = istockstatus.post_id) ";
            $posts_clauses['orderby'] = " istockstatus.meta_value ASC, " . $posts_clauses['orderby'];
            $posts_clauses['where'] = " AND istockstatus.meta_key = '_stock_status' AND istockstatus.meta_value <> ''" . $posts_clauses['where'];
        }
        return $posts_clauses;
    }

    public static function handle_load_woocommerce_single_template($template, $product)
    {
        $template_dir = get_template_directory() . '/woocommerce/single-product/';

        $templates = [
                'digikala' => 'digi',
                'digitalmarketplace' => 'digital',
                'mode3' => 'mode3',
                'mode4' => 'mode4',
        ];

        $templates = apply_filters('ah_get_woocommerce_single_templates', $templates);

        include $template_dir . (isset($templates[$template]) ? $templates[$template] : 'default') . '-single-product.php';
    }

    public static function handle_load_woocommerce_single_review_template($product)
    {
        $template_dir = get_template_directory() . '/woocommerce/templates/review/';
        $mode = mw_options::get_mod_product_review_template_mode();

        include $template_dir . 'product-review-' . (!empty($mode) ? $mode : 'default') . '.php';
    }

    public static function handle_load_woocommerce_single_review_item_template($args)
    {
        $template_dir = get_template_directory() . '/woocommerce/templates/review/';
        $mode = mw_options::get_mod_product_review_template_mode();

        if (is_array($args) && !empty($args)){
            extract($args);
        }

        include $template_dir . 'review-item-' . (!empty($mode) ? $mode : 'default') . '.php';
    }

    public static function get_shop_views()
    {
        $shop_views = [
            'default' => ahura_get_full_path('img.icons.svg', 'grid-cols-3.svg'),
            'list' => ahura_get_full_path('img.icons.svg', 'grid-full.svg'),
        ];
        return apply_filters('ah_get_shop_views', $shop_views);
    }

    public static function get_current_shop_view()
    {
        $view = $_GET['shop_view'] ?? null;
        return mw_options::get_mod_shop_grid_status() && in_array($view, array_keys(self::get_shop_views())) ? sanitize_text_field($view) : 'default';
    }

    public static function handle_save_review_meta($comment_id)
    {
        if(mw_options::get_mod_product_review_strength_weak_points_status()){
            if (isset($_POST['plus-rate'])){
                add_comment_meta($comment_id, 'comment_plus_rate', ahura_sanitize_recursive($_POST['plus-rate']));
            }
            if (isset($_POST['negative-rate'])){
                add_comment_meta($comment_id, 'comment_negative_rate', ahura_sanitize_recursive($_POST['negative-rate']));
            }
        }
    }

    public static function handle_append_data_after_review_text($comment)
    {
        $plus_rates = get_comment_meta($comment->comment_ID, 'comment_plus_rate', true);
        $negative_rates = get_comment_meta($comment->comment_ID, 'comment_negative_rate', true);

        $comment_likes = (int) get_comment_meta($comment->comment_ID, 'comment_likes', true) ?? 0;
        $comment_dislikes = (int) get_comment_meta($comment->comment_ID, 'comment_dislikes', true) ?? 0;
        ?>
        <?php if (mw_options::get_mod_product_review_strength_weak_points_status() && (!empty($plus_rates) || !empty($negative_rates))): ?>
        <div class="comment-rate-list">
            <div class="row">
                <?php if ($plus_rates): ?>
                <div class="col-12 col-md-6">
                    <div class="ah-box-title plus-rate-title"><?php _e('Strength Points', 'ahura') ?></div>
                    <div class="comment-plus-rates">
                        <?php if (!empty($plus_rates) && is_array($plus_rates)): ?>
                            <?php
                            foreach($plus_rates as $text):
                                if (empty($text)) continue;
                                ?>
                                <div class="comment-rate-item"><?php echo $text ?></div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
                <?php if ($negative_rates): ?>
                <div class="col-12 col-md-6">
                    <div class="ah-box-title negative-rate-title"><?php _e('Weak Points', 'ahura') ?></div>
                    <div class="comment-negative-rates">
                        <?php if (!empty($negative_rates) && is_array($negative_rates)): ?>
                            <?php
                            foreach($negative_rates as $text):
                                if (empty($text)) continue;
                                ?>
                                <div class="comment-rate-item"><?php echo $text ?></div>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
        <?php if(mw_options::get_mod_product_review_like_status()):?>
        <div class="comment-actions">
            <div class="title"><?php _e('Was this comment helpful to you?','ahura'); ?></div>
            <div class="comment-like">
                <button class="comment-like-btn" data-action="like" data-id="<?php comment_ID(); ?>">
                    <?php _e('Yes', 'ahura'); ?>
                    <span class="count"><?php echo $comment_likes; ?></span>
                </button>
            </div>
            <div class="comment-like">
                <button class="comment-like-btn" data-action="dislike" data-id="<?php comment_ID(); ?>">
                    <?php _e('No', 'ahura'); ?>
                    <span class="count"><?php echo $comment_dislikes; ?></span>
                </button>
            </div>
        </div>
        <?php endif; ?>
    <?php
    }

    public static function ahura_remove_price_on_outofstock_products($price, $product) {
        global $post;
        if (!empty($post) && !$product->is_in_stock()) return false;
        return $price;
    }

    public static function remove_product_sku_on_single_page($enabled) {
        if (!is_admin() && is_product()) {
            global $product;
            if (is_object($product) && empty($product->get_sku()))
                return false;
        }

        return $enabled;
    }

    public static function handle_disable_zoom_product_gallery()
    {
        remove_theme_support('wc-product-gallery-zoom');
    }

    public static function handle_add_icon_to_product_description_tab($title, $key)
    {
        $icon = '<svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M5 10.5H7C9 10.5 10 9.5 10 7.5V5.5C10 3.5 9 2.5 7 2.5H5C3 2.5 2 3.5 2 5.5V7.5C2 9.5 3 10.5 5 10.5Z" stroke="#43454D" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> <path d="M17 10.5H19C21 10.5 22 9.5 22 7.5V5.5C22 3.5 21 2.5 19 2.5H17C15 2.5 14 3.5 14 5.5V7.5C14 9.5 15 10.5 17 10.5Z" stroke="#43454D" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> <path d="M17 22.5H19C21 22.5 22 21.5 22 19.5V17.5C22 15.5 21 14.5 19 14.5H17C15 14.5 14 15.5 14 17.5V19.5C14 21.5 15 22.5 17 22.5Z" stroke="#43454D" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> <path d="M5 22.5H7C9 22.5 10 21.5 10 19.5V17.5C10 15.5 9 14.5 7 14.5H5C3 14.5 2 15.5 2 17.5V19.5C2 21.5 3 22.5 5 22.5Z" stroke="#43454D" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> </svg>';
        return apply_filters('ah_woo_product_description_tab_icon', $icon) . apply_filters('ah_woo_description_product_tab', $title);
    }

    public static function handle_add_icon_to_product_additional_information_tab($title, $key)
    {
        $icon = '<svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M12 15.5C13.6569 15.5 15 14.1569 15 12.5C15 10.8431 13.6569 9.5 12 9.5C10.3431 9.5 9 10.8431 9 12.5C9 14.1569 10.3431 15.5 12 15.5Z" stroke="#43454D" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> <path d="M2 13.38V11.62C2 10.58 2.85 9.72 3.9 9.72C5.71 9.72 6.45 8.44 5.54 6.87C5.02 5.97 5.33 4.8 6.24 4.28L7.97 3.29C8.76 2.82 9.78 3.1 10.25 3.89L10.36 4.08C11.26 5.65 12.74 5.65 13.65 4.08L13.76 3.89C14.23 3.1 15.25 2.82 16.04 3.29L17.77 4.28C18.68 4.8 18.99 5.97 18.47 6.87C17.56 8.44 18.3 9.72 20.11 9.72C21.15 9.72 22.01 10.57 22.01 11.62V13.38C22.01 14.42 21.16 15.28 20.11 15.28C18.3 15.28 17.56 16.56 18.47 18.13C18.99 19.04 18.68 20.2 17.77 20.72L16.04 21.71C15.25 22.18 14.23 21.9 13.76 21.11L13.65 20.92C12.75 19.35 11.27 19.35 10.36 20.92L10.25 21.11C9.78 21.9 8.76 22.18 7.97 21.71L6.24 20.72C5.33 20.2 5.02 19.03 5.54 18.13C6.45 16.56 5.71 15.28 3.9 15.28C2.85 15.28 2 14.42 2 13.38Z" stroke="#43454D" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> </svg>';
        return apply_filters('ah_woo_product_additional_information_tab_icon', $icon) . apply_filters('ah_woo_additional_information_product_tab', $title);
    }

    public static function handle_add_icon_to_product_reviews_tab($title, $key)
    {
        $icon = '<svg width="24" height="25" viewBox="0 0 24 25" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M8.5 19.5H8C4 19.5 2 18.5 2 13.5V8.5C2 4.5 4 2.5 8 2.5H16C20 2.5 22 4.5 22 8.5V13.5C22 17.5 20 19.5 16 19.5H15.5C15.19 19.5 14.89 19.65 14.7 19.9L13.2 21.9C12.54 22.78 11.46 22.78 10.8 21.9L9.3 19.9C9.14 19.68 8.77 19.5 8.5 19.5Z" stroke="#43454D" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> <path d="M15.9965 11.5H16.0054" stroke="#43454D" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path d="M11.9955 11.5H12.0045" stroke="#43454D" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path d="M7.99451 11.5H8.00349" stroke="#43454D" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> </svg>';
        return apply_filters('ah_woo_product_reviews_tab_icon', $icon) . apply_filters('ah_woo_reviews_product_tab', $title);
    }

    public static function handle_change_product_description_tab_title($title)
    {
        $custom = mw_options::get_theme_option('ah_single_product_description_tab_title');
        return !empty($custom) ? $custom : $title;
    }

    public static function handle_change_product_additional_information_tab_title($title)
    {
        $custom = mw_options::get_theme_option('ah_single_product_additional_information_tab_title');
        return !empty($custom) ? $custom : $title;
    }

    public static function handle_change_product_reviews_tab_title($title)
    {
        $custom = mw_options::get_theme_option('ah_single_product_reviews_tab_title');
        return !empty($custom) ? $custom : $title;
    }

    public static function render_out_of_stock_product_template()
    {?>
       <div class="out-of-stock-product-template">
           <?php wc_print_notice(__('Sorry, this product is not available.', 'ahura'), 'error') ?>
       </div>
    <?php
    }

    public static function handle_product_edit_tab($default_tabs)
    {
        $tabs = array(
            'ah_custom_tab' => array(
                'label' => esc_html__('Custom Data', 'ahura'),
                'target' => 'ah_custom_tab',
                'priority' => 60,
                'class' => array(),
            ),
        );

        return array_merge($default_tabs, $tabs);
    }

    public static function handle_product_edit_custom_fields()
    {
        global $post;

        $subtitle = Post_Meta::get_product_subtitle($post->ID);
        $list = Post_Meta::get_product_checklist($post->ID);
        $show_checklist = Post_Meta::show_product_checklist($post->ID);
        ?>
        <div id="ah_custom_tab" class="panel woocommerce_options_panel">
            <p class="form-field">
                <label for="ah-product-subtitle"><?php esc_html_e( 'Subtitle', 'ahura' ); ?></label>
                <input type="text" name="_product_subtitle" id="ah-product-subtitle" value="<?php echo $subtitle; ?>" />
            </p>
            <p class="form-field">
                <label for="product-show-checklist"><?php esc_html_e( 'Checklist Status', 'ahura' ); ?></label>
                <input type="checkbox" name="_product_show_checklist" id="product-show-checklist" value="1" <?php checked($show_checklist, 1) ?>>
            </p>
            <p class="form-field">
                <label for="ah-product-checklist"><?php esc_html_e( 'Check List', 'ahura' ); ?></label>
            </p>
            <div class="repeater-items ahura-repeater-items" style="background-color:#fff;">
                <?php if (!empty($list)): ?>
                    <?php foreach ($list as $key => $item): ?>
                        <div class="repeater-item" data-item-id="<?php echo $key ?>">
                            <div class="repeater-action-buttons">
                                <a href="#" class="add-repeater-item">+</a>
                                <a href="#" class="remove-repeater-item">-</a>
                            </div>
                            <?php
                            mw_tools::render_icon_selector([
                                'name' => '_product_checklist['. $key .'][icon]',
                                'id' => 'field-' . $key,
                                'value' => $item['icon'] ?? '',
                                'type' => 'hidden',
                                'search' => false,
                                'inline' => true
                            ]);
                            ?>
                            <input type="text" name="_product_checklist[<?php echo $key ?>][value]" placeholder="<?php echo __('Value', 'ahura') ?>" id="field-<?php echo $key ?>" value="<?php echo $item['value'] ?>">
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="repeater-item" data-item-id="0">
                        <div class="repeater-action-buttons">
                            <a href="#" class="add-repeater-item">+</a>
                            <a href="#" class="remove-repeater-item">-</a>
                        </div>
                        <?php
                        mw_tools::render_icon_selector([
                            'name' => '_product_checklist[0][icon]',
                            'id' => 'field-0',
                            'type' => 'hidden',
                            'search' => false,
                            'inline' => true
                        ]);
                        ?>
                        <input type="text" name="_product_checklist[0][value]" placeholder="<?php echo __('Value', 'ahura') ?>">
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <?php
    }

    public static function handle_product_download_tab($default_tabs)
    {
        $tabs = array(
            'ah_woo_download_tab' => array(
                'label' => esc_html__('Download Data', 'ahura'),
                'target' => 'ah_woo_download_tab',
                'priority' => 70,
                'class' => array(),
                'icon' => 'dashicons-download'
            ),
        );

        return array_merge($default_tabs, $tabs);
    }

    public static function handle_product_download_custom_fields()
    {
        global $post;
        $product_version = Post_Meta::show_ah_product_version($post->ID);
        $ah_product_update_date = Post_Meta::show_ah_product_update_date($post->ID);
        ?>
        <div id="ah_woo_download_tab" class="panel woocommerce_options_panel">
            <p class="form-field">
                <label for="_ah_product_version"><?php esc_html_e( 'Product version', 'ahura' ); ?></label>
                <input type="text" name="_ah_product_version" id="_ah_product_version" value="<?php echo $product_version; ?>" />
            </p>
            <p class="form-field">
                <label for="_ah_product_update_date"><?php esc_html_e( 'Product update date', 'ahura' ); ?></label>
                <input type="text" class="download_datepicker" name="_ah_product_update_date" id="_ah_product_update_date" value="<?php echo esc_attr($ah_product_update_date); ?>" />
            </p>
        </div>
        <script>jQuery(document).ready(function($) {$('input.download_datepicker').datepicker({dateFormat: 'yy-mm-dd', maxDate: '0'})});</script>
        <?php
    }

    public static function handle_store_product_custom_fields($post_id, $post, $update)
    {
        if (isset($_POST['_product_subtitle'])) {
            update_post_meta($post_id, '_product_subtitle', esc_attr($_POST['_product_subtitle']));
        }

        if (isset($_POST['_product_checklist'])) {
            update_post_meta($post_id, '_product_checklist', $_POST['_product_checklist']);
        }

        update_post_meta($post_id, '_product_show_checklist', isset($_POST['_product_show_checklist']));

        if (isset($_POST['_ah_product_version'])) {
            update_post_meta($post_id, '_ah_product_version', $_POST['_ah_product_version']);
        }

        if (isset($_POST['_ah_product_update_date'])) {
            update_post_meta($post_id, '_ah_product_update_date', $_POST['_ah_product_update_date']);
        }
    }

    public static function handle_product_checklist_on_single_page()
    {
        if(!is_single() || mw_options::get_single_product_style() == 'digitalmarketplace')
           return false;

        $status = Post_Meta::show_product_checklist();
        $checklist = Post_Meta::get_product_checklist();

        if (!$status || empty($checklist))
            return false;
        ?>
        <div class="single-product-checklist">
            <ul>
                <?php foreach ($checklist as $key => $item): ?>
                <li class="ck-item ck-item-<?php echo $key ?>">
                    <?php if(isset($item['icon']) && !empty($item['icon'])): ?>
                        <i class="<?php echo $item['icon'] ?>"></i>
                    <?php endif; ?>
                    <span><?php echo $item['value'] ?></span>
                </li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php
    }

    public static function handle_shop_sub_categories_template()
    {
        $parent_id = get_queried_object_id();
        $display_type = woocommerce_get_loop_display_mode();
        $terms = woocommerce_get_product_subcategories($parent_id);

        if ($terms && (is_shop() || is_product_category()) && $display_type === 'both'){
            wc_get_template('shop-sub-categories.php', compact('terms'));
        }
    }

    public static function reset_and_render_single_product_summary()
    {
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10);
        //remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_price', 10);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40);
        remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50);
        do_action('woocommerce_single_product_summary');
    }

    public static function handle_my_account_page_template($template)
    {
        if(self::is_account_page()){
            $login_temp_mode = mw_options::get_login_my_account_mode();

            if(!is_user_logged_in() && $login_temp_mode != 1) {
                if($login_temp_mode == 2){
                    return locate_template('woocommerce/myaccount/my-account-page.php', false, false);
                } else {
                    return locate_template("woocommerce/myaccount/custom/my-account-page-$login_temp_mode.php", false, false);
                }
            }

            $page_mode = mw_options::get_my_account_mode();
            if($page_mode == 2 && self::is_account_page()){
                if(is_user_logged_in()){
                    return locate_template('woocommerce/myaccount/user-my-account-page.php', false, false);
                }
            }
        }

        return $template;
    }

    public static function handle_add_new_columns_to_admin_reviews_table($columns)
    {
        $columns['pros_cons'] = __('Strengths and weaknesses', 'ahura');
        $columns['likes'] = __('Likes/Dislikes', 'ahura');

        return $columns;
    }

    public static function handle_admin_reviews_column__pros_cons($comment)
    {
        $plus_rates = get_comment_meta($comment->comment_ID, 'comment_plus_rate', true);
        $negative_rates = get_comment_meta($comment->comment_ID, 'comment_negative_rate', true);
        ?>
        <div class="ah-review-pros-cons">
            <?php if (!empty($plus_rates) && is_array($plus_rates)): ?>
                <ul style="color:green">
                    <?php
                    foreach($plus_rates as $text):
                        if (empty($text)) continue;
                        ?>
                    <li><?php echo $text ?></li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
            <?php if (!empty($negative_rates) && is_array($negative_rates)): ?>
                <ul style="color:darkred">
                    <?php
                    foreach($negative_rates as $text):
                        if (empty($text)) continue;
                        ?>
                        <li><?php echo $text ?></li>
                    <?php endforeach; ?>
                </ul>
            <?php endif; ?>
        </div>
    <?php
    }

    public static function handle_admin_reviews_column__likes($comment)
    {
        $comment_likes = (int) get_comment_meta($comment->comment_ID, 'comment_likes', true) ?? 0;
        $comment_dislikes = (int) get_comment_meta($comment->comment_ID, 'comment_dislikes', true) ?? 0;
        ?>
        <div class="comment-like">
            <p><?php _e('Likes', 'ahura'); ?></p>
            <span class="count"><?php echo $comment_likes; ?></span>
        </div>
        <div class="comment-dislike">
            <p><?php _e('Dislikes', 'ahura'); ?></p>
            <span class="count"><?php echo $comment_dislikes; ?></span>
        </div>
    <?php
    }
}
