<?php
namespace ahura\app;
class mw_partials
{
    static function load_header()
    {
        $header_slug = 'main';
        get_template_part('partials/header', $header_slug);
    }

    public static function display_header_action_button()
    {
        if(mw_options::show_header_cta_btn()):
            $show_after_login_btn = mw_options::get_mod_show_header_after_login_cta_btn();
            $after_login_url = mw_options::get_mod_header_after_login_cta_btn_url();
            $after_login_text = mw_options::get_mod_header_after_login_cta_btn_text();
            $has_after_login = $show_after_login_btn ? is_user_logged_in() : false;
            ?>
            <?php if ($has_after_login): ?>
                <a href="<?php echo $after_login_url; ?>" class="h-btn after-login-btn" id="action_link">
                    <?php echo $after_login_text; ?>
                </a>
            <?php else: ?>
                <a href="<?php echo \ahura\app\mw_options::get_mod_header_cta_btn_url();?>" class="h-btn" id="action_link">
                    <?php echo \ahura\app\mw_options::get_mod_header_cta_btn_text();?>
                </a>
            <?php endif; ?>
        <?php
        endif;
    }

    public static function handle_change_archive_template_page($default_template){
        if (!mw_options::is_ahura_builder_accessible()) return $default_template;

        if (mw_options::get_mod_is_active_custom_archive() && !empty(mw_options::get_custom_archive_page_id())){
            if ((is_search() && !woocommerce::is_woocommerce()) || (is_archive() && (is_category() || is_tag() || is_author()))){
                $default_template = get_template_directory() . '/template-parts/archive/custom-archive.php';
            }
        }

        if (mw_options::get_mod_is_active_custom_single_post() && !empty(mw_options::get_custom_single_post_id())){
            if (is_single() && get_post_type() == 'post'){
                $default_template = get_template_directory() . '/template-parts/single/custom-single-post.php';
            }
        }

        $ahura_get_requested_custom_post_types = mw_options::ahura_get_requested_custom_post_types();

        if (is_single() && mw_options::get_mod_is_active_elementor_template_cpt() && $ahura_get_requested_custom_post_types && in_array(get_post_type(), $ahura_get_requested_custom_post_types)){
            $default_template = get_template_directory() . '/template-parts/single/cpt-single-post.php';
        }

        return $default_template;
    }

    public static function handle_download_box_in_post($content)
    {
        if(is_admin() || !is_single()){
            return $content;
        }

        $content .= mw_tools::get_executable_file_content(ahura_get_full_path('template-parts.single', 'download-box.php'));
        return $content;
    }

    public static function handle_features_box_in_post($content)
    {
        if(is_admin() || !is_single()){
            return $content;
        }

        $content .= mw_tools::get_executable_file_content(ahura_get_full_path('template-parts.single', 'estate-features-box.php'));
        return $content;
    }

    public static function load_404_template()
    {
        global $wp_query;
        if(is_object($wp_query)){
            $wp_query->set_404();
        }
        status_header(404);
        get_template_part('template-parts/errors/404');
    }

    public static function render_archive_template()
    {
        $mode = mw_options::get_archive_mode();
        $mode = empty($mode) || !intval($mode) ? 1 : $mode;

        $postClass = ['archive-post-item'];
        $postClass[] = 'col-' . (get_theme_mod('ahura_archive_column_mobile') ? get_theme_mod('ahura_archive_column_mobile') : 12);
        $postClass[] = 'col-sm-' . (get_theme_mod('ahura_archive_column_tablet') ? get_theme_mod('ahura_archive_column_tablet') : 4);
        $postClass[] = 'col-md-' . (get_theme_mod('ahura_archive_column') ? get_theme_mod('ahura_archive_column') : 3);

        $postClass = implode(' ', $postClass);

        include(locate_template('template-parts/archive/modes/archive-' . $mode .'.php', false, false));
    }
}