<?php
namespace ahura\app\elementor\woocommerce;

class Variations_Color {
    public static function getVariationColors($product) {
        global $wpdb;

        $variationListColors = [];
        $variations = $product->get_available_variations();

        foreach ($variations as $variation) {
            foreach (wc_get_product($variation['variation_id'])->get_variation_attributes() as $attributeName => $attributeValue) {
                $termId = $wpdb->get_var($wpdb->prepare("SELECT term_id FROM $wpdb->terms WHERE slug = %s", $attributeValue));
                $termMetaValue = get_term_meta($termId, '_product_attribute_color', true);

                if ($termMetaValue) {
                    array_push($variationListColors, $termMetaValue);
                }
            }
        }

        return $variationListColors;
    }
}
