<?php
namespace ahura\app\elementor\woocommerce;

class Shop_Carousel_Price_Render {

    public static function renderPrice($product, $price_prefix = '', $strikethrough = false) {
        $output = '';

        if (!empty($product)) {
            if ($product->is_on_sale()) {
                if ($product->is_type('variable')) {
                    $variations = $product->get_available_variations();
                    $regular_prices = [];
                    $sale_prices = [];

                    foreach ($variations as $variation) {
                        $variation_obj = wc_get_product($variation['variation_id']);
                        if ($variation_obj) {
                            $regular_prices[] = $variation_obj->get_regular_price();
                            $sale_prices[] = $variation_obj->get_sale_price();
                        }
                    }

                    if (!empty($regular_prices) && !empty($sale_prices)) {
                        $min_sale_price_index = array_search(min($sale_prices), $sale_prices);
                        if ($min_sale_price_index !== false && isset($regular_prices[$min_sale_price_index]) && isset($sale_prices[$min_sale_price_index])) {
                            $output .= $price_prefix . '<span class="regular-price' . ($strikethrough ? ' strikethrough' : '') . '">' . wc_price($regular_prices[$min_sale_price_index]) . '</span>' . '<br>';
                            $output .= '<span class="d-block sale-price main-price">' . wc_price($sale_prices[$min_sale_price_index]) . '</span>';
                        }
                    }
                } else {
                    $regular_price = $product->get_regular_price();
                    $sale_price = $product->get_sale_price();
                    if (!empty($regular_price) && !empty($sale_price)) { 
                        $output .= $price_prefix . '<span class="regular-price' . ($strikethrough ? ' strikethrough' : '') . '"><del>' . wc_price($regular_price) . '</del></span>' . '<br>';
                        $output .= '<span class="d-block sale-price main-price">' . wc_price($sale_price) . '</span>';
                    }
                }
            } else {
                if ($product->is_type('variable')) {
                    $variations = $product->get_available_variations();
                    $regular_prices = [];

                    foreach ($variations as $variation) {
                        $variation_obj = wc_get_product($variation['variation_id']);
                        if ($variation_obj) {
                            $regular_prices[] = $variation_obj->get_regular_price();
                        }
                    }

                    if (!empty($regular_prices)) {
                        $min_regular_price = min($regular_prices);
                        if ($min_regular_price !== false) {
                            $output .= $price_prefix . '<span class="regular-price main-price">' . wc_price($min_regular_price) . '</span>';
                        }
                    }
                } else {
                    $regular_price = $product->get_regular_price();
                    if (!empty($regular_price)) {
                        $output .= $price_prefix . '<span class="regular-price main-price">' . wc_price($regular_price) . '</span>';
                    }
                }
            }
        }

        return $output;
    }
}
