<?php
namespace ahura\app\elementor;

use ahura\app\mw_assets;
use ahura\app\mw_options;
use ahura\app\mw_tools;
use Elementor\Controls_Manager;

abstract class Elementor_Widget_Base extends \Elementor\Widget_Base
{
    protected $_element_styles = [];
    protected $_element_scripts = [];

    public function __construct($data=[], $args=[])
    {
        parent::__construct($data, $args);

        $builder = new Ahura_Elementor_Builder();
        if($builder->isPreviewMode()){
            $this->__register_assets();
            $this->__enqueue_assets();
        }
    }

    public function fixedEmptyContentInEditor(){
        if (is_admin()){
            echo "<em style='display:inline-block;opacity:0;overflow:hidden;width:0;height:0;color:transparent;' class='fixed-empty'>empty</em>";
        }
    }

    public function renderElementorNotice($title, $content = '')
    {?>
        <div class="elementor-alert elementor-alert-danger" role="alert">
            <span class="elementor-alert-title">
                <?php echo $title; ?>
            </span>
            <?php if (!empty($content)): ?>
            <span class="elementor-alert-description">
                <?php echo $content; ?>
			</span>
            <?php endif; ?>
        </div>
    <?php
    }

    public function renderPlaceholderImage()
    {
        echo '<img src="' . \Elementor\Utils::get_placeholder_image_src() . '" alt="placeholder">';
    }

    public function isEditMode()
    {
        return \Elementor\Plugin::instance()->preview->is_preview_mode() || \Elementor\Plugin::instance()->editor->is_edit_mode();
    }

    public function register_notice_control($id, $raw, $params = []){
        $this->add_control(
            $id,
            array_merge([
                'type' => Controls_Manager::RAW_HTML,
                'raw' => $raw,
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
            ], $params)
        );
    }

    public function register_additional_controls(){
        $this->start_controls_section(
            'element_dark_settings',
            [
                'tab'   => Controls_Manager::TAB_CONTENT,
                'label' => __('Dark Mode Settings', 'ahura'),
            ]
        );

        $this->register_notice_control(
            'dark_mode_notice',
            __('Dark mode only works when this feature is enabled from the Ahura theme settings (Customization > Header > Dark Mode).', 'ahura')
        );

        $this->register_notice_control(
            'dark_mode_notice2',
            __('The options of this feature have different behaviors in each element and changes are applied according to the content of the element.', 'ahura')
        );

        $this->add_control(
            'element_dark_mode',
            [
                'label'          => __('Enable Dark Mode', 'ahura'),
                'type'           => Controls_Manager::SWITCHER,
                'label_on'       => __( 'Yes', 'ahura' ),
                'label_off'      => __( 'No', 'ahura' ),
                'default'        => 'no',
                'return_value'   => 'yes',
                'prefix_class'   => 'ahura-element-dark-mode-',
            ]
        );

        $this->add_control(
            'has_text_dark',
            [
                'label'          => __('Filter Text', 'ahura'),
                'type'           => Controls_Manager::SWITCHER,
                'label_on'       => __( 'Yes', 'ahura' ),
                'label_off'      => __( 'No', 'ahura' ),
                'default'        => 'yes',
                'return_value'   => 'yes',
                'prefix_class'   => 'ahura-dark-mode-text-',
                'condition' => ['element_dark_mode' => 'yes']
            ]
        );

        $this->add_control(
            'has_bg_dark',
            [
                'label'          => __('Filter Background', 'ahura'),
                'type'           => Controls_Manager::SWITCHER,
                'label_on'       => __( 'Yes', 'ahura' ),
                'label_off'      => __( 'No', 'ahura' ),
                'default'        => 'yes',
                'return_value'   => 'yes',
                'prefix_class'   => 'ahura-dark-mode-bg-',
                'condition' => ['element_dark_mode' => 'yes']
            ]
        );

        $this->add_control(
            'has_button_dark',
            [
                'label'          => __('Filter Button', 'ahura'),
                'type'           => Controls_Manager::SWITCHER,
                'label_on'       => __( 'Yes', 'ahura' ),
                'label_off'      => __( 'No', 'ahura' ),
                'default'        => 'yes',
                'return_value'   => 'yes',
                'prefix_class'   => 'ahura-dark-mode-button-',
                'condition' => ['element_dark_mode' => 'yes']
            ]
        );

        $this->end_controls_section();
    }

    /**
     *
     * Register with _ah_elementor_ prefix
     *
     * @return void
     */
    protected function register_elementor_style($name, $src, $deps = [])
    {
        $this->_element_styles[] = [
            'handle' => $this->get_asset_handle_name($name),
            'src' => $src,
            'deps' => $deps,
            'ver' => mw_tools::get_theme_version()
        ];
        wp_register_style($this->get_asset_handle_name($name), $src, $deps, mw_tools::get_theme_version());
    }

    /**
     *
     * Register with ah_elementor_ prefix
     *
     * @return void
     */
    protected function register_elementor_script($name, $src, $deps = ['jquery'], $in_footer = true)
    {
        $this->_element_scripts[] = [
            'handle' => $this->get_asset_handle_name($name),
            'src' => $src,
            'deps' => $deps,
            'ver' => mw_tools::get_theme_version(),
            'args' => $in_footer
        ];
        wp_register_script($this->get_asset_handle_name($name), $src, $deps, mw_tools::get_theme_version(), $in_footer);
    }

    protected function get_asset_handle_name($name)
    {
        return 'ah_elementor_' . $name;
    }

    public function __register_assets(){}

    public function __enqueue_assets()
    {
        $styles = $this->_element_styles;
        if (empty($styles))
            return false;

        foreach ($styles as $style){
            wp_enqueue_style($style['handle'], $style['src'], $style['deps'], $style['ver']);
        }
    }

    public function array_to_style($styles)
    {
        if (empty($styles) || !is_array($styles))
            return false;

        $str = '';

        foreach ($styles as $selector => $value){
            $str .= "{$selector}:$value;";
        }

        return $str;
    }
}