<?php
namespace ahura\app;
class child_theme
{
    static function admin_menu_callback()
    {
        $fileName = 'template-parts.admin.pages.child-theme';
        $fileName = str_replace('.', DIRECTORY_SEPARATOR, $fileName) . '.php';
        include_once get_template_directory() . DIRECTORY_SEPARATOR . $fileName;
    }
    static function load_admin_menu_assets()
    {
        $childMenuCss = mw_assets::get_css('admin-child-menu');
        $childMenuJs = mw_assets::get_js('admin.child-menu');

        mw_assets::enqueue_style('admin_child_menu', $childMenuCss);
        mw_assets::enqueue_script('admin-child-menu', $childMenuJs);

        $data = [
            'ajax_url' => admin_url('admin-ajax.php'),
            'msg' => [
                'on_process' => __('Processing', 'ahura'),
            ],
        ];
        mw_assets::localize('admin-child-menu', 'ahura_child_data', $data);
    }
    private static function generate_style_file_content()
    {
        $parent = 'Ahura';
        $slug = 'ahura';
        $author = 'MihanWP';
        $output = "
			/**
			* Theme Name: {$parent} Child
			* Description: This is a child theme of {$parent}, generated by MihanWP.
			* Author: {$author}
			* Template: {$slug}
			*/\n
		";
		$output = trim( preg_replace( '/\t+/', '', $output ) );
        return apply_filters('ahura_generate_child_style_css', $output, $slug);
    }
    private static function generate_functions_file_content()
    {
        $slug = 'ahura';
		$slug_no_hyphens = strtolower( preg_replace( '#[^a-zA-Z]#', '', $slug ) );

        $output = "
			<?php
			/**
			 * Theme functions and definitions.
			 * This child theme was generated by MihanWP.
			 *
			 * @link https://developer.wordpress.org/themes/basics/theme-functions/
			 */

			/*
			 * If your child theme has more than one .css file (eg. ie.css, style.css, main.css) then
			 * you will have to make sure to maintain all of the parent theme dependencies.
			 *
			 * Make sure you're using the correct handle for loading the parent theme's styles.
			 * Failure to use the proper tag will result in a CSS file needlessly being loaded twice.
			 * This will usually not affect the site appearance, but it's inefficient and extends your page's loading time.
			 *
			 * @link https://codex.wordpress.org/Child_Themes
			 */
			function {$slug_no_hyphens}_child_enqueue_styles() {
			    wp_enqueue_style( '{$slug}-style' , get_template_directory_uri() . '/style.css' );
			    if(!is_rtl())
			    {
			        wp_enqueue_style('{$slug}-ltr', get_template_directory_uri() . '/ltr.css');
			    }
			}

			add_action(  'wp_enqueue_scripts', '{$slug_no_hyphens}_child_enqueue_styles' );\n
		";
		$output = trim( preg_replace( '/\t+/', '', $output ) );
        return apply_filters('ahura_generate_child_functions_php', $output, $slug);
    }
    private static function generate_child_screenshot()
    {
        $screenshot = apply_filters('ahura_child_theme_generate_screenshot', '');

        $mainThemeRoot = get_theme_root() . DIRECTORY_SEPARATOR . 'ahura';
        $childThemeRoot = get_theme_root() . DIRECTORY_SEPARATOR . 'ahura-child';
        if(file_exists($mainThemeRoot . DIRECTORY_SEPARATOR . 'screenshot.png'))
        {
            $screenshot = $mainThemeRoot . DIRECTORY_SEPARATOR . 'screenshot.png';
            $screenshotExt = 'png';
        }elseif(file_exists($mainThemeRoot . DIRECTORY_SEPARATOR . 'screenshot.jpg'))
        {
            $screenshot = $mainThemeRoot . DIRECTORY_SEPARATOR . 'screenshot.jpg';
            $screenshotExt = 'jpg';
        }
        if(!empty($screenshot) && file_exists($screenshot))
        {
            copy($screenshot, $childThemeRoot . DIRECTORY_SEPARATOR . 'screenshot.' . $screenshotExt);
        }
    }
    static function createChildTheme()
    {
        $slug = 'ahura-child';
        $childThemePath = get_theme_root() . DIRECTORY_SEPARATOR . $slug;

        if(!file_exists($childThemePath))
        {
            // create child theme directory
            mkdir($childThemePath);
            file_put_contents($childThemePath . DIRECTORY_SEPARATOR . 'style.css', self::generate_style_file_content());
            file_put_contents($childThemePath . DIRECTORY_SEPARATOR . 'functions.php', self::generate_functions_file_content());

            self::generate_child_screenshot();
        }

        // check is child theme not active
        if(wp_get_theme()->get_stylesheet() !== $slug)
        {
            switch_theme($slug);
        }
        return true;
    }
}