<?php
namespace ahura\app;

class WP_Comment_Form_Handler
{
    private $args;
    private $key;
    private $filterKey;
    private $isField;
    private $fields;

    public function __construct($filter_key)
    {
        $this->filterKey = $filter_key;
    }

    public function start_section($key): WP_Comment_Form_Handler
    {
        ob_start();
        $this->key = $key;
        return $this;
    }

    public function is_field(){
        $this->isField = true;
    }

    public function end_section()
    {
        $content = ob_get_clean();
        if ($this->isField){
            $this->set_field($content);
        } else {
            $this->args[$this->key] = $content;
        }
        $this->isField = false;
    }

    public function get_args()
    {
        if(!isset($this->args['comment_notes_before'])){
            $this->args['comment_notes_before'] = '';
        }

        return $this->args;
    }

    public function set_param($key, $value)
    {
        $this->args[$key] = $value;
    }

    public function set_field($field)
    {
        $this->fields[] = $field;
    }

    public function render_pagination()
    {
        echo '<div class="ah-pagination">';
        paginate_comments_links(array(
            'screen_reader_text'=> __('Pagination','ahura'),
            'prev_text'=> __('Previous','ahura'),
            'next_text'=> __('Next','ahura'),
        ));
        echo '</div>';
    }

    public function render_comment_form()
    {
        if (!empty($this->fields)){
            $this->args['comment_field'] = implode('', $this->fields);
        }

        comment_form(apply_filters($this->filterKey, $this->get_args()));
    }
}