<?php
namespace ahura\app;

class Post_Meta
{
    public static function get_post_id($post_id = 0){
        global $post;
        $post_id = !$post_id && function_exists('get_post_ID') ? get_post_ID() : $post_id;
        return !$post_id && is_object($post) ? $post->ID : $post_id;
    }

    public static function get_post_meta($post_id, $key, $single = false){
        return get_post_meta(self::get_post_id($post_id), $key, $single);
    }

    public static function get_section_type($post_id = 0){
        return self::get_post_meta($post_id, 'section_builder_type', true);
    }

    public static function get_template_type($post_id = 0){
        return self::get_post_meta($post_id, 'section_builder_template_page', true);
    }

    public static function get_post_large_cover($post_id = 0)
    {
        return self::get_post_meta($post_id, '_large_cover', true);
    }

    public static function get_post_subtitle($post_id = 0)
    {
        return self::get_post_meta($post_id, '_subtitle', true);
    }

    public static function get_download_items($post_id = 0)
    {
        return self::get_post_meta($post_id, '_download_items', true);
    }

    public static function is_active_download_box($post_id = 0)
    {
        return self::get_post_meta($post_id, '_download_box_status', true);
    }

    public static function get_files_password($post_id = 0)
    {
        return self::get_post_meta($post_id, '_files_password', true);
    }

    public static function get_item_address($post_id = 0)
    {
        return self::get_post_meta($post_id, '_item_address', true);
    }

    public static function get_item_price($post_id = 0)
    {
        return self::get_post_meta($post_id, '_item_price', true);
    }

    public static function get_item_monthly_price($post_id = 0)
    {
        return self::get_post_meta($post_id, '_item_monthly_price', true);
    }

    public static function get_bedrooms($post_id = 0)
    {
        return self::get_post_meta($post_id, '_item_bedrooms', true);
    }

    public static function has_elevator($post_id = 0)
    {
        return self::get_post_meta($post_id, '_has_elevator', true);
    }

    public static function is_active_features_box($post_id = 0)
    {
        return self::get_post_meta($post_id, '_features_box_status', true);
    }

    public static function get_features_list($post_id = 0)
    {
        return self::get_post_meta($post_id, '_features_list', true);
    }

    public static function get_estate_type($post_id = 0)
    {
        return self::get_post_meta($post_id, '_item_estate_type', true);
    }

    public static function is_estate_for_sale($post_id = 0){
        return self::get_estate_type($post_id) == 'sale';
    }

    public static function is_estate_for_rent($post_id = 0){
        return self::get_estate_type($post_id) == 'rent';
    }

    public static function get_category_list($post_id = 0){
        $categories = wp_get_post_categories(self::get_post_id($post_id));
        if (empty($categories))
            return false;

        $list = [];
        foreach ($categories as $category){
            $cat = get_category($category);
            if (is_wp_error($cat))
                continue;
            $list[] = $cat;
        }

        return $list;
    }

    public static function get_category_names($post_id = 0, $string = false){
        $categories = self::get_category_list($post_id);
        if (empty($categories))
            return false;

        $names = [];
        foreach ($categories as $category){
            $names[] = $category->name;
        }

        return $string === true ? implode((is_rtl() ? '،' : ','), $names) : $names;
    }

    public static function get_human_time_diff($post_id = 0){
        return sprintf(__('%s ago', 'ahura'), human_time_diff(get_the_time('U', self::get_post_id($post_id)), current_time('timestamp')));
    }

    public static function get_portfolio_customer_name($post_id = 0)
    {
        return get_post_meta(self::get_post_id($post_id), '_portfolio_customer_name', true);
    }

    public static function get_product_subtitle($post_id = 0)
    {
        return get_post_meta(self::get_post_id($post_id), '_product_subtitle', true);
    }

    public static function get_product_checklist($post_id = 0)
    {
        return get_post_meta(self::get_post_id($post_id), '_product_checklist', true);
    }

    public static function show_product_checklist($post_id = 0)
    {
        return self::get_post_meta($post_id, '_product_show_checklist', true);
    }

    public static function show_ah_product_version($post_id = 0)
    {
        return self::get_post_meta($post_id, '_ah_product_version', true);
    }

    public static function show_ah_product_update_date($post_id = 0)
    {
        return self::get_post_meta($post_id, '_ah_product_update_date', true);
    }

    public static function show_ah_downloaded_product_count($post_id = 0)
    {
        return self::get_post_meta($post_id, 'ah_downloaded_product_count', true);
    }

    public static function get_team_subtitle($post_id = 0)
    {
        return get_post_meta(self::get_post_id($post_id), '_team_subtitle', true);
    }

    public static function get_team_options($post_id)
    {
        return get_post_meta(self::get_post_id($post_id), '_team_options', true);
    }

    public static function get_team_socials($post_id)
    {
        return get_post_meta(self::get_post_id($post_id), '_team_socials', true);
    }
}