<?php

// File generated from our OpenAPI spec
namespace WPForms\Vendor\Stripe\Events;

/**
 * @property \Stripe\RelatedObject $related_object Object containing the reference to API resource relevant to the event
 * @property \Stripe\EventData\V1BillingMeterErrorReportTriggeredEventData $data data associated with the event
 */
class V1BillingMeterErrorReportTriggeredEvent extends \WPForms\Vendor\Stripe\V2\Event
{
    const LOOKUP_TYPE = 'v1.billing.meter.error_report_triggered';
    /**
     * Retrieves the related object from the API. Make an API request on every call.
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     *
     * @return \Stripe\Billing\Meter
     */
    public function fetchRelatedObject()
    {
        list($object, $options) = $this->_request('get', $this->related_object->url, [], ['stripe_account' => $this->context], [], 'v2');
        return \WPForms\Vendor\Stripe\Util\Util::convertToStripeObject($object, $options, 'v2');
    }
}
